from z3 import *

def IndependentSetSolver(input_sample, **kwargs):
    N = input_sample['number_of_nodes']
    edges = input_sample['edges']
    K = input_sample['k']
    
    solver = Solver()
    variables = [Int(f"x_{i}") for i in range(N)]
    
    ### initial constraint
    for i in range(N):
        solver.add(Or(variables[i] == 0, variables[i] == 1))

    ### constraint from K
    solver.add(Sum(*variables) >= K)
    
    ### constraints for covering each edge
    for edge in edges:
        x, y = edge
        solver.add(Sum(variables[x], variables[y]) <= 1)
    
    if solver.check() == sat:
        return ["YES"] ### returns one of multiple solutions
    else:
        return ["NO"]

def MySolver():
    return IndependentSetSolver

if __name__ == "__main__":
    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 1
    } ## YES
    print(IndependentSetSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 3
    } ## YES
    print(IndependentSetSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 4
    } ## NO
    print(IndependentSetSolver(input_sample=input_sample))
    
    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (1,2), (1, 3), (3, 4)],
        'k': 3
    } ## NO
    print(IndependentSetSolver(input_sample=input_sample))

    
    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (1,2), (1, 3), (3, 4)],
        'k': 2
    } ## YES
    print(IndependentSetSolver(input_sample=input_sample))
    
    input_sample = {
        'number_of_nodes': 1,
        'edges' : [],
        'k': 1
    } ## YES
    print(IndependentSetSolver(input_sample=input_sample))