from solver import IndependentSetSolver

def IndependentSetVerifier(input_sample, output_sample, **kwargs):
    answer = IndependentSetSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The generated answer is not correct"
    }

def MyVerifier():
    return IndependentSetVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 1
    } ## YES
    output_sample = "YES"
    print(IndependentSetVerifier(input_sample=input_sample, output_sample=output_sample)) ## True

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 4
    }
    output_sample = "YES"
    print(IndependentSetVerifier(input_sample=input_sample, output_sample=output_sample)) ## False