import re

SEPERATOR_STRING = '--------'
def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    seperator_idx = input_text.index(SEPERATOR_STRING)
    board_text = input_text[:seperator_idx]
    rooms_text = input_text[seperator_idx+1:]
    input_board = [list(map(int, row.strip().split())) for row in board_text]
    rooms = [list(map(int, row.strip().split()[:-1])) for row in rooms_text]
    room_products = [int(row.strip().split()[-1]) for row in rooms_text]
    return {
        "input_board": input_board,
        "rooms": rooms,
        "room_products": room_products
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        output_board = []
        for row in output_text:
            if len(row.strip().split()) != num_lines:
                return {
                "OUTPUT": None,
                "ERROR": f"Each Output line should have {num_lines} space seperated integers"
            }
            output_board.append(list(map(int, row.strip().split())))
        return {
            "OUTPUT": output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }
        
def input_to_text_string(input_sample, **kwargs):
    input_board = input_sample['input_board']
    rooms = input_sample['rooms']
    room_products = input_sample['room_products']
    input_board_string = "\n".join(" ".join(map(str, row)) for row in input_board)
    rooms_string = "\n".join(" ".join(map(str, room + [product])) for room, product in zip(rooms, room_products))
    return f"{input_board_string}\n{rooms_string}"

def output_to_text_string(output_sample, **kwargs):
    return "\n".join(" ".join(map(str, row)) for row in output_sample)