from solver import JobShopSolver

def JobShopVerifier(input_sample, output_sample, **kwargs):
    answer = JobShopSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return JobShopVerifier

if __name__ == '__main__':
    # Input data
    num_machines = 2
    num_jobs = 2
    order_of_processing = [
        [1, 2],
        [2, 1]
    ]
    processing_times = [
        [10, 5],
        [11, 4]
    ]
    T = 15  # maximum makespan we are checking against
    
    input_sample = {
        'num_machines': num_machines,
        'num_jobs': num_jobs,
        'T': T,
        'order_of_processing': order_of_processing,
        'processing_times': processing_times
    }
    output_sample = "YES"
    print(JobShopVerifier(input_sample, output_sample)) ## False

    output_sample = "NO"
    print(JobShopVerifier(input_sample, output_sample)) ## True