from z3 import *

def KCliqueSolver(input_sample, **kwargs):
    N = input_sample['number_of_nodes']
    edges = input_sample['edges']
    K = input_sample['k']
    
    solver = Solver()
    variables = [Int(f"x_{i}") for i in range(N)]
    
    ### initial constraint
    for i in range(N):
        solver.add(Or(variables[i] == 0, variables[i] == 1))

    ### constraint from K
    solver.add(Sum(*variables) == K)
    
    ### constraints for covering each edge
    for i in range(N):
        for j in range(i+1,N):
            if (i, j) not in edges and (j, i) not in edges:
                solver.add(Or(variables[i] == 0, variables[j] == 0))
    
    if solver.check() == sat:
        return ["YES"] ### returns one of multiple solutions
    else:
        return ["NO"]

def MySolver():
    return KCliqueSolver

if __name__ == "__main__":
    
    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (1,2), (0,3)],
        'k': 1
    } ## YES
    print(KCliqueSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (1,2), (0,3)],
        'k': 3
    } ## YES
    print(KCliqueSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (1,2), (0,3)],
        'k': 4
    } ## NO
    print(KCliqueSolver(input_sample=input_sample))
    
    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (0, 3), (1,2), (1,3), (2, 3), (1, 4), (2, 4)],
        'k': 4
    } ## YES
    print(KCliqueSolver(input_sample=input_sample))

    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (0, 3), (1,2), (1,3), (2, 3), (1, 4), (2, 4)],
        'k': 5
    } ## NO
    print(KCliqueSolver(input_sample=input_sample))
    