from solver import KCliqueSolver

def KCliqueVerifier(input_sample, output_sample, **kwargs):
    answer = KCliqueSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is incorrect"
    }

def MyVerifier():
    return KCliqueVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (0, 3), (1,2), (1,3), (2, 3), (1, 4), (2, 4)],
        'k': 4
    } ## YES
    output_sample = "YES"
    print(KCliqueVerifier(input_sample=input_sample, output_sample=output_sample)) ## True

    input_sample = {
        'number_of_nodes': 5,
        'edges' : [(0,1), (0,2), (0, 3), (1,2), (1,3), (2, 3), (1, 4), (2, 4)],
        'k': 4
    } ## YES
    output_sample = "NO"
    print(KCliqueVerifier(input_sample=input_sample, output_sample=output_sample)) ## False