from z3 import *


def KMetricCenterSolver(input_sample, **kwargs):
    
    N, adj_matrix, target_distance = input_sample['num_vertices'], input_sample['adjacency_matrix'], input_sample['target-distance']
    num_vertices = N

    # Create a function that maps a pair of vertices to their distance
    Graph = Function('Graph', IntSort(), IntSort(), IntSort())
    s = Solver()

    # Populate the function with the adjacency matrix
    for i in range(num_vertices):
        for j in range(num_vertices):
            s.add(Graph(i, j) == adj_matrix[i][j])


    x, y = Ints('x y')  # centers

    # Constraint: Both centers must be different vertices and within valid range
    s.add(And(x != y, 0 <= x, x < num_vertices, 0 <= y, y < num_vertices))

    # Constraint: The max distance from a vertex to the nearest center should be minimized
    for vertex in range(num_vertices):
        s.add(Or(Graph(vertex, x) <= target_distance, Graph(vertex, y) <= target_distance))

    if s.check() == sat:
        z = s.model()
        y = [z[x].as_long(), z[y].as_long()]
        return [y]
    else:
        return [None]
    
def MySolver():
    return KMetricCenterSolver

if __name__== '__main__':

    input_sample = {
        'num_vertices': 5,
        'adjacency_matrix': [[0, 7, 0, 3, 0],
                            [7, 0, 6, 0, 1],
                            [0, 6, 0, 9, 4],
                            [3, 0, 9, 0, 2],
                            [0, 1, 4, 2, 0]],
        'target-distance': 0
    }

    print(KMetricCenterSolver(input_sample))


