import re

## TODO: change prompt to decision variant
def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    N, target_distance = tuple(map(int, input_text[0].strip().split()))
    adjacency_matrix_text = input_text[1:]
    adjacency_matrix = [list(map(int, line.strip().split())) for line in adjacency_matrix_text]
    return {
            'num_vertices': N, 
            'adjacency_matrix': adjacency_matrix,
            'target-distance': target_distance
        }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                'ERROR': "Output should contain a single line with space seperated integers representing the elements chosen as the centers"
            }
        return {
            "OUTPUT": list(map(int, output_text[0].split())),
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    num_vertices = input_sample['num_vertices']
    adjacency_matrix = input_sample['adjacency_matrix']
    target_distance = input_sample['target-distance']
    num_vertices_str = str(num_vertices)
    target_distance_str = str(target_distance)
    adjacency_matrix_str = "\n".join(" ".join(map(str, row)) for row in adjacency_matrix)
    return "\n".join([f"{num_vertices_str} {target_distance_str}", adjacency_matrix_str])


def output_to_text_string(output_sample, **kwargs) -> str:
    return " ".join(map(str, output_sample))