import numpy as np

def KMetricCenterVerifier(input_sample, output_sample, **kwargs):
    num_vertices, adj_matrix = input_sample['num_vertices'], input_sample['adjacency_matrix']
    target_distance = input_sample['target-distance']

    if len(output_sample) != 2:
        return {
            'result': False,
            'reason': 'The output should have two space seperated integers'
        }
    
    try:
        output_sample = [int(ele) for ele in output_sample]
        for ele in output_sample:
            if ele < 0 or ele >= num_vertices:
                return {
                    'result': False,
                    'reason': f'Output elements must be from 0-{num_vertices-1}'
                }
    except Exception as e:
        return {
            'result': False,
            'reason': 'Output file should have two space seperated integers'
        }

    x_out, y_out = output_sample
    if x_out == y_out:
        return {
            'result': False,
            'reason': 'Both the chosen elements must be distinct'
        }
    output_max_dist = max([min([adj_matrix[x_out][i], adj_matrix[y_out][i]]) for i in range(num_vertices)] )
    if output_max_dist > target_distance:
        return {
            'result': False,
            'reason': f'There exists a center which is at a distance greater than {target_distance} from both the selected warehouses'
        }
    return {
        'result': True,
        'reason': None
    }
    
def MyVerifier():
    return KMetricCenterVerifier

if __name__ == "__main__":
    input_sample = {
        'num_vertices': 4,
        'adjacency_matrix': [[0, 2, 6, 3],
                            [2, 0, 4, 1],
                            [6, 4, 0, 11],
                            [3, 1, 11, 0]],
        'target-distance': 2
    }
    answer = [1, 2]
    print(KMetricCenterVerifier(input_sample, answer))