import re


def get_numbers(board, direction):
    m, n = len(board), len(board[0])
    assert direction == "across" or direction == "down"
    numbers = set()
    for i in range(m):
        for j in range(n):
            if str(board[i][j]) != '-':
                digits = []
                for idx in range(m-i if direction == "down" else n-j):
                    current_cell= str(board[i+idx][j] if direction == "down" else board[i][j+idx])
                    if(current_cell) == '-':
                        break
                    digits.append(current_cell)
                for sub_idx in range(1, len(digits)+1):
                    numbers.add(int("".join(digits[:sub_idx])))
    return numbers

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    input_board = []
    for row in input_text[:-2]:
        board_row = list(row.split())
        board_row = [int(ele) if ele != '-' else ele for ele in board_row]
        input_board.append(board_row)
    across_nums = list(map(int, input_text[-2].split()))
    down_nums = list(map(int, input_text[-1].split()))
    input_sample = {
        'input_board': input_board,
        'across_numbers': across_nums,
        'down_numbers': down_nums
    }
    return input_sample

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        output_board = [list(map(str, line.strip().split())) for line in output_text]
        for row in output_board:
            if len(row) != num_lines:
                return {
                    "OUTPUT": None,
                    "ERROR": f"Each non empty row in output.txt must have {num_lines} numbers"
                }
        return {
            'OUTPUT': output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    input_board = input_sample['input_board']
    across_nums = input_sample['across_numbers']
    down_nums = input_sample['down_numbers']
    board_str =  "\n".join(" ".join(map(str, row)) for row in input_board)
    across_nums_str = " ".join(map(str, across_nums))
    down_nums_str = " ".join(map(str, down_nums))
    return "\n".join([board_str, across_nums_str, down_nums_str])

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)