from utils import get_numbers

def KeisukeVerifier(input_sample, output_sample, **kwargs):
    input_board, across_nums, down_nums = input_sample['input_board'], input_sample['across_numbers'], input_sample['down_numbers']
    output_board = output_sample
    M_in, N_in = len(input_board), len(input_board[0])
    M_out, N_out = len(output_board), len(output_board[0])
    if N_in != N_out or M_in != M_out:
        return {
            "result": False,
            "reason": "Input and Output Board Sizes Don't Match!"
        }
        
    for i in range(N_in):
        for j in range(N_out):
            if (str(input_board[i][j]) == '-'):
                if (str(output_board[i][j]) != str(input_board[i][j])):
                    return {
                        "result": False,
                        "reason": f"Black Cells Removed From Input Board at Cell ({i+1}, {j+1}) (1-indexed)"
                    }
            elif (int(input_board[i][j]) != 0):
                if (str(input_board[i][j]) != str(output_board[i][j])):
                    return {
                        "result": False,
                        "reason": f"Original Numbers on Non-Empty Cells Removed From Input Board at Cell ({i+1}, {j+1}) (1-indexed)"
                    }
            if str(output_board[i][j]) not in "0123456789-":
                return {
                    "result": False,
                    "reason": f"Invalid Element at Cell ({i+1}, {j+1}) (1-indexed)"
                }
                
    across_nums_output = get_numbers(output_board, "across")
    down_nums_output = get_numbers(output_board, "down")
    for num in across_nums:
        if num not in across_nums_output:
            return {
                "result": False,
                "reason": f"{num} not found on the board horizontally (across)"
            }
    for num in down_nums:
        if num not in down_nums_output:
            return {
                "result": False,
                "reason": f"{num} not found on the board vertically (down)"
            }
    return {
        "result": True,
        "reason": None
    }

def MyVerifier():
    return KeisukeVerifier

if __name__ == "__main__":
    
    input_sample = {
        'input_board': [[0,0,'-',0,0], 
                        ['-',0,0,0,0], 
                        [0,0,0,'-',0], 
                        [0,0,0,0,0], 
                        ['-',0,'-',0,'-']],
        'across_numbers': [13, 23, 233, 3221, 21222],
        'down_numbers' : [12, 21, 22, 232, 3132, 33313]
    }
    solved_board = [[2,3,'-',1,3], 
                   ['-',3,2,2,1], 
                   [2,3,3,'-',3], 
                   [2,1,2,2,2], 
                   ['-',3,'-',1,'-']]
    verification_result = KeisukeVerifier(input_sample, solved_board)
    print(verification_result)