from z3 import *

def KnapsackSolver(input_sample, **kwargs):

    values, weights = input_sample['values'], input_sample['weights']
    max_capacity, target_value=  input_sample['capacity'], input_sample['min-value']
    
    N = len(values)
    solver = Solver()
    vars = [Int(f'x{i}') for i in range(N)]
    for i in range(len(vars)):
        solver.add(Or(vars[i]==1, vars[i]==0))
    sum_expression = Sum([vars[i]*values[i] for i in range((N))])
    weight_expression = Sum([vars[i]*weights[i] for i in range((N))])
    solver.add(weight_expression<=max_capacity)
    solver.add(sum_expression >= target_value)

    if solver.check() == sat:
        z = solver.model()
        for i in range(N):
            vars[i] = z[vars[i]].as_long()
        
        return [vars]
    else:
        return [None]
    
def MySolver():
    return KnapsackSolver

if __name__ == "__main__":
    input_sample = {
        'values': [5, 6, 7, 8],
        'weights': [5, 6, 7, 8],
        'capacity' : 10,
        'min-value': 8
    }
    print(KnapsackSolver(input_sample))
    
    
    input_sample = {
    'values': [1, 2, 1, 3, 5],
    'weights': [10, 40, 20, 20, 60],
    'capacity': 100,
    'min-value': 9
    }
    print(KnapsackSolver(input_sample))










