import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    assert len(input_text) == 4 ### values, weights, max knapsack capacity, min value needed
    return {
     'values':  list(map(int, input_text[0].split())),
     'weights': list(map(int, input_text[1].split())),
     'capacity': int(input_text[2]),
     'min-value': int(input_text[3])
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                'ERROR': "Output should contain a single line with space seperated integers representing the elements chosen using 0/1"
            }
        return {
            "OUTPUT": list(map(int, output_text[0].split())),
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    values = input_sample['values']
    weights = input_sample['weights']
    capacity = input_sample['capacity']
    min_value = input_sample['min-value']
    values_str = " ".join(map(str, values))
    weights_str = " ".join(map(str, weights))
    return "\n".join([values_str, weights_str, str(capacity), str(min_value)])

def output_to_text_string(output_sample, **kwargs) -> str:
    return " ".join(map(str, output_sample))