def KnapsackVerifier(input_sample, output_sample, **kwargs):
    values, weights, capacity = input_sample['values'], input_sample['weights'], input_sample['capacity']
    target_value = input_sample['min-value']
    answer = output_sample
    

    if len(answer) != len(values):
        return {
            'result': False,
            'reason': 'The output should have as many elements as given in the input, with each element being 0/1 to denote if that item was chosen or not'
        }
    
    for value in answer:
        if value not in [0, 1]:
            return {
                'result': False,
                'reason': 'Each element in the output should be 0/1'
            }
    
    capacity_used = sum([answer[i] * weights[i] for i in range(len(values))])
    if capacity_used > capacity:
        return {
            'result': False,
            'reason': 'The elements chosen exceed the capacity of the knapsack'
        }
    value_chosen = sum([answer[i] * values[i] for i in range(len(values))])
    if value_chosen < target_value:
        return {
            'result': False,
            'reason': 'The items chosen do not have the minimum value needed'
        }
    
    return {
           "result": True,
           "reason": None
        }

def MyVerifier():
    return KnapsackVerifier

if __name__ == '__main__':
    
    input_sample = {
        'values': [8,10,6,3],
        'weights': [4,6,3,2],
        'capacity': 10,
        'min-value': 17
    }
    answer = [1, 0, 1, 1]
    print(KnapsackVerifier(input_sample, answer)) ## True

    input_sample = {
        'values': [8,10,6,3],
        'weights': [4,6,3,2],
        'capacity': 10,
        'min-value': 19
    }
    answer = [1, 1, 0, 0]
    print(KnapsackVerifier(input_sample, answer)) ## False

    input_sample = {
        'values': [8,10,6,3],
        'weights': [4,6,3,2],
        'capacity': 10,
        'min-value': 27
    }
    answer = [1, 1, 1, 1]
    print(KnapsackVerifier(input_sample, answer)) ## False
    
    input_sample = {
        'values': [1, 2, 1, 3, 5],
        'weights': [10, 40, 20, 20, 60],
        'capacity': 100,
        'min-value': 6
    }
    answer1 = [1, 0, 0, 0, 1]
    print(KnapsackVerifier(input_sample, answer1)) ### True

    input_sample = {
        'values': [1, 2, 1, 3, 5],
        'weights': [10, 40, 20, 20, 60],
        'capacity': 100,
        'min-value': 9
    }
    answer1 = [1, 0, 0, 1, 1]
    print(KnapsackVerifier(input_sample, answer1)) ## True

    input_sample = {
    'values': [1, 2, 1, 3, 5],
    'weights': [10, 40, 20, 20, 60],
    'capacity': 100,
    'min-value': 10
    }
    answer = [0,0,1,1,1]
    print(KnapsackVerifier(input_sample, answer)) ## False
