import numpy as np


def LatinSquareVerifier(input_board, output_board, **kwargs):
    input_board = np.array(input_board)
    output_board = np.array(output_board)
    num_rows,  num_cols = len(output_board), len(output_board[0])
    assert num_rows == num_cols
    N = num_rows

    if (input_board.shape)!=(output_board.shape):
        return {
               'result': False,
               'reason': 'Input and Output Boards do not have the same shape'
            }

    for i in range(len(input_board)):
        for j in range(len(input_board[0])):
            if str(input_board[i][j]) != '0':
                if str(input_board[i][j]) !=  str(output_board[i][j]):
                    return {
                            'result': False,
                            'reason': f'Original numbers on Non-Empty Cells of the Input have been removed from the Output. Eg Cell ({i}, {j}) (0-indexed)'
                        }
    
    for idx, row in enumerate(output_board):
        if len(row) != len(set(row)):
            return {
                    'result': False,
                    'reason': f'Unique elements in row constraint violated for Row: {idx} (0-indexed) of the output board'
                }

    # Check columns
    for j in range(num_cols):
        column = [output_board[i][j] for i in range(num_rows)]
        if len(column) != len(set(column)):
            return {
                    'result': False,
                   'reason': f'Unique elements in column constraint violated for Column: {j} (0-indexed) of the output board'
                }

    ### check all elements are from 1 to N
    for i in range(num_rows):
        for j in range(num_cols):
            try:
                element = int(output_board[i][j])
                if element <= 0 or element > N:
                    return {
                        'result': False,
                        'reason': f'Elements in Output board should be from 1 to {N}. Violated for Cell ({i}, {j}) (0-indexed) of the output board'
                    }
            except Exception as e:
                return {
                    'result': False,
                    'reason': f'Output Board should have Integer Elements. Violated for Cell ({i}, {j}) (0-indexed) of the output board'
                }
            
    
    return {
            'result':True,
            'reason':None
        }

def MyVerifier():
    return LatinSquareVerifier

if __name__ == '__main__':

    input_board = [[0, 0, 0, 0, 2, 0],
              [0, 0, 0, 0, 0, 0],
              [0, 0, 1, 0, 0, 0],
              [0, 0, 0, 0, 0, 0],
              [0, 0, 5, 3, 6, 0],
              [0, 0, 0, 0, 0, 0]]
    
    output_board = [[4, 6, 3, 1, 2, 5], 
                    [3, 2, 4, 6, 5, 1], 
                    [6, 3, 1, 5, 4, 2], 
                    [5, 4, 6, 2, 1, 3], 
                    [2, 1, 5, 3, 6, 4], 
                    [1, 5, 2, 4, 3, 6]]

    print(LatinSquareVerifier(input_board,output_board)) 
