from solver import LongestPathSolver

def LongestPathVerifier(input_sample, output_sample, **kwargs):
    answer = LongestPathSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is incorrect."
    }

def MyVerifier():
    return LongestPathVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 2
    }
    output_sample = "YES"
    print(LongestPathVerifier(input_sample=input_sample, output_sample=output_sample)) ## True

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 2
    }
    output_sample = "NO"
    print(LongestPathVerifier(input_sample=input_sample, output_sample=output_sample)) ## False