from z3 import *

def MinimumDominatingSetSolver(input_sample, **kwargs):
    N = input_sample['N']
    k = input_sample['k']
    graph = input_sample['graph']
    s = Solver()

    nodes = [Bool(f'node_{i}') for i in range(len(graph))]

    s.add(Sum([If(n, 1, 0) for n in nodes]) <= k)

    for i in range(len(graph)):
        s.add(Or(nodes[i], *[nodes[j] for j in graph[i]]))


    if s.check() == sat:
        return ["YES"]
    else:
        return ["NO"]
    
def MySolver():
    return MinimumDominatingSetSolver

if __name__ == "__main__":
    
    graph = [
        [1, 2],  
        [0, 2],  
        [0, 1, 3], 
        [2]  
    ]
    input_sample = {'N':4, 'k':1, 'graph':graph }
    solution = MinimumDominatingSetSolver(input_sample)
    print(solution)
 