import re
import numpy as np

def convert_string(string):
    if string == '0':
        return 0
    if string  == 'Q':
        return 1
    raise ValueError

def load_data(data_path, n):
    with open(data_path, 'r') as f:
        boards = []
        lines = [line.strip() for line in f.readlines()]
        total_lines = len(lines)
        for i in range(0, total_lines, n+1):
             board = np.array([list(map(convert_string, line.split())) for line in lines[i:i+n]])
             boards.append(board)
    return boards

def convert_board_to_string(board):
    return "\n".join(" ".join(('0' if ele == 0 else 'Q') for ele in row) for row in board)

def convert_answer_to_board(answer):
    try:
        board = []
        for line in answer.split("\n"):
            line = line.strip()
            if len(line) > 0:
                if line[0] == "0" or line[0].lower() == "q":
                    board.append([convert_string(ele) for ele in line.split()])
        return np.array(board)
    except ValueError:
        return None


def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    k = int(input_text[0])
    input_board = [list(map(int, row.split())) for row in input_text[1:]]
    return {
        'k': k,
        'board': input_board
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        output_board = [list(map(int, line.strip().split())) for line in output_text]
        for row in output_board:
            if len(row) != num_lines:
                return {
                    "OUTPUT": None,
                    "ERROR": f"Each non empty row in output.txt must have {num_lines} numbers"
                }
        return {
            'OUTPUT': output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    k = input_sample['k']
    board = input_sample['board']
    board_str = "\n".join(" ".join(map(str, row)) for row in board)
    return f"{k}\n{board_str}"

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)
