import numpy as np

def check_board(input_board):
    N = input_board.shape[0]

    #Ensure any row can have only 1 queen at most
    for x in range(N):
        qsum = 0
        for y in range(N):
            qsum += input_board[x][y]
        if qsum > 1:
            return (False, f"Mutliple Queens in Row: {x} (0 indexed) of the Output Board")

    #Ensure any column can have only 1 queen at most
    for y in range(N):
        qsum = 0
        for x in range(N):
            qsum += input_board[x][y]
        if qsum > 1:
            return (False, f"Mutliple Queens in Column: {y} (0 indexed) of the Output Board")

    #Ensure any diagonal can have only 1 queen at most
    
    for i in range(N):
        ### diagonals in one direction
        qsum1 = 0
        for j in range(N-i):
            qsum1 += input_board[j][i+j]
        if(qsum1 > 1):
            return (False, f"Queens attack each diagonally along the following diagonal (0-indexed) (({0}, {i})), ({1}, {i+1}) .... ({N-i-1}, {N-1}))") 
        
        if i != 0:
            qsum2 = 0
            for j in range(N-i):
                qsum2 += input_board[i+j][j]
            if( qsum2 > 1):
                return (False, f"Queens attack each diagonally along the following diagonal (0-indexed) (({i}, {0})), ({i+1}, {1}) .... ({N-1}, {N-1-i}))")
            
            
        ### diagonals in the other direction
        qsum3 = 0
        for j in range(i+1):
            qsum3 += input_board[j][i-j]
        if(qsum3 > 1):
            return (False, f"Queens attack each diagonally along the following diagonal (0-indexed) (({0}, {i})), ({1}, {i-1}) .... ({i}, {0}))")
        
        if i != 0:
            qsum4 = 0
            for j in range(N-i):
                qsum4 += input_board[i+j][N-1-j]
            if( qsum4 > 1):
                return (False, f"Queens attack each diagonally  along the following diagonal (0-indexed) (({i}, {N-1})), ({i+1}, {N-2}) .... ({N-1}, {i}))")
        
    return (True, None)        


def NQueensVerifier(input_sample, output_sample, **kwargs):
    k = input_sample['k']
    input = np.array(input_sample['board'])
    output = np.array(output_sample)
    N_in, N_out = input.shape[0], output.shape[0]
    if N_in != N_out:
        return {
            "result": False,
            "reason": "Boards Size of Input and Output Don't Match!"
        }
    if output.shape[0] != output.shape[1]:
        return {
           "result": False,
           "reason": "Output Board is not a Square"
        }
    

    output_cnt = 0
    for i in range(N_in):
        for j in range(N_in):
            if(input[i][j] == 1 and output[i][j] == 0):
                return {
                    "result": False,
                    "reason": f"Original Queens are removed from the board at Cell Index ({i}, {j})"
                }
            if (output[i][j] == 1):
                output_cnt += 1
    
    
    is_board_correct, invalidity_reason = check_board(output) ### checks for attacking queens
    if is_board_correct:
        if (output_cnt < k):
            return {
                "result": False,
                "reason": f"Output Board should have atleast {k} queens"
            }
        return {
            "result": True,
            "reason": None
        }
    else:
        ### queens attack
        return{
            "result": False,
            "reason": invalidity_reason
        }

def MyVerifier():
    return NQueensVerifier


if __name__ == "__main__":

    input_sample = {
            'k': 3,
            'board' : [
                [1, 0, 0, 0],
                [0, 0, 0, 0],
                [0, 0, 0, 0],
                [0, 0, 0, 0]
            ]
    }

    output =[
                [1, 0, 0, 0],
                [0, 0, 1, 0],
                [0, 0, 0, 0],
                [0, 1, 0, 0]
            ]

        
    print(NQueensVerifier(input_sample, output))