import numpy as np

def SinglePathSearch(current_position, board, visited, parent, number):
    N, M = len(board), len(board[0])
    x, y = current_position
    visited[x][y] = number
    steps = ((0,-1), (0,+1), (-1,0), (+1, 0))
    for step in steps:
        dx, dy = step
        newx, newy = x + dx, y + dy
        if 0 <= newx < N and 0 <= newy < M:
            if board[x][y] == board[newx][newy] and (newx, newy) != parent and not visited[newx][newy]:
                SinglePathSearch((newx, newy), board, visited, (x, y), number)
                return ### since this is a single path search we only explore one unvisited neighbour which is not the parent
    

def NumberLinkVerifier(input_board, output_board, **kwargs):
    input_board = np.array(input_board)
    output_board = np.array(output_board)
    if input_board.shape != output_board.shape:
        return {
            'result': False,
            'reason': 'Input and Output board must be of the same shape'
        }

    assert input_board.shape[0] == input_board.shape[1]
    N = input_board.shape[0]
    
    initial_numbers = dict()
    ### initial number constraints
    for i in range(N):
        for j in range(N):
            if input_board[i, j] != 0 and output_board[i, j] != input_board[i, j]:
                return {
                    'result': False,
                    'reason': f'Original Numbers on Non-Zero cells from the Input cannot be removed in the Output. Violated at ({i}, {j}) (0-indexed) of the output'
                }
            if input_board[i, j] != 0:
                number = input_board[i, j]
                if number not in initial_numbers:
                    initial_numbers[number] = list()
                initial_numbers[number].append((i, j))
    
    visited = [[False for j in range(N)] for i in range(N)]
    for number, starting_points in initial_numbers.items():
        src_x, src_y = starting_points[0]
        dst_x, dst_y = starting_points[1]
        SinglePathSearch((src_x, src_y), output_board, visited, (-1,-1), number)
        if visited[dst_x][dst_y] != number:
            return {
                'result': False,
                'reason': f"the two {number}s presented are not connected or the line joining them branches off somewhere else"
            }
    
    for i in range(N):
        for j in range(N):
            if output_board[i, j] != 0 and visited[i][j] != output_board[i, j]:
                return {
                    'result': False,
                    'reason': f"The line joining the two {output_board[i, j]}s branches off somewhere else also in the middle"
                }
                
    
    return {
        'result': True,
        'reason': None
    }
    

def MyVerifier():
    return NumberLinkVerifier
            

if __name__ == '__main__':
    print(NumberLinkVerifier(
        input_board=[
            [0, 0, 0, 3, 0],
            [0, 4, 0, 1, 0],
            [0, 0, 2, 0, 0],
            [0, 4, 0, 3, 2],
            [0, 1, 0, 0, 0],
        ],
        output_board=[
            [1, 1, 1, 3, 3],
            [1, 4, 1, 1, 3],
            [1, 4, 2, 3, 3],
            [1, 4, 2, 3, 2],
            [1, 1, 2, 2, 2],
        ]
    ))
    print(NumberLinkVerifier(
        input_board=[
            [0, 0, 0, 3, 0],
            [0, 4, 0, 1, 0],
            [0, 0, 2, 0, 0],
            [0, 4, 0, 3, 2],
            [0, 1, 0, 0, 0],
        ],
        output_board=[
            [1, 1, 1, 3, 3],
            [1, 4, 1, 1, 3],
            [1, 0, 2, 3, 3],
            [1, 4, 2, 3, 2],
            [1, 1, 2, 2, 2],
        ]
    ))
    print(NumberLinkVerifier(
        input_board=[
            [0, 0, 0, 3, 0],
            [0, 0, 0, 1, 0],
            [0, 0, 2, 0, 0],
            [0, 0, 0, 3, 2],
            [0, 1, 0, 0, 0],
        ],
        output_board=[
            [1, 1, 1, 3, 3],
            [1, 1, 1, 1, 3],
            [1, 1, 2, 3, 3],
            [1, 1, 2, 3, 2],
            [1, 1, 2, 2, 2],
        ]
    ))
                
    