from z3 import * 
def min(vs):
  m = vs[0]
  for v in vs[1:]:
    m = If(v < m, v, m)
  return m

def PRP_SOLVER(input_sample, **kwargs):
    units = input_sample['units']
    k = input_sample['k']
    num_days = input_sample['days']
    m = input_sample['m']
    solver = Solver()
    p = [[Int(f"p_{d}_{i}") for i in range(units)] for d in range(num_days)]

    for i in range(num_days):
        for j in range(units):
            solver.add(And(0<=p[i][j], p[i][j] <= m))

    for d in range(num_days):
        solver.add(Sum([p[d][i] for i in range(units)]) >= (units * k))

    for day in range(num_days-1):
        solver.add(min(p[day])<  min(p[day+1]))

    for d in range(num_days-1):
        solver.add(Sum([p[d+1][i] for i in range(units)]) > Sum([p[d][i] for i in range(units)]))

    if solver.check() == sat:
        return ['YES']
    else:
        return ['NO']
    
def MySolver():
    return PRP_SOLVER

if __name__ == '__main__':
    num_days = 4
    u = 5
    input_sample_1 = {'units': 5, 'k':2, 'days':5, 'm':5}
    # 6 1 15 13
    input_sample_2 = {'units': 5, 'k':800, 'days':1, 'm':2}
    # 6 3 37 17
    input_sample_3 = {'units': 6, 'k':3, 'days':37, 'm':17}
    # 4 4 30 20
    input_sample_4 = {'units': 4, 'k':40, 'days':300, 'm':20}
    # 12 1 31 11
    input_sample_5 = {'units'}
    print(PRP_SOLVER(input_sample_1))
    print(PRP_SOLVER(input_sample_2))
    print(PRP_SOLVER(input_sample_3))
    print(PRP_SOLVER(input_sample_4))