from z3 import *
from solver import PRP_SOLVER

def PRP_verifier(input_sample, output_sample, **kwargs):
    answer = PRP_SOLVER(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return PRP_verifier

if __name__ == '__main__':
    num_days = 4
    u = 5
    input_sample_1 = {'units': 5, 'k':2, 'days':5, 'm':5}
    output = PRP_SOLVER(input_sample_1)[0]
    print(PRP_verifier(input_sample_1, output))
    