from z3 import *

def PartitionProblemSolver(input_sample, **kwargs):
    multiset = input_sample
    N = len(multiset)
    ### indicates the partition to which each problem belongs
    variables = [Int(f"x_{i}") for i in range(N)] 
    solver = Solver()
    partition_sum = sum(multiset)//2
    
    ### initial constraints
    for i in range(N):
        solver.add(variables[i] >= 0, variables[i] <= 1)
        
    ### each partition must sum to the target
    solver.add(Sum(*[If(variables[i] == 0, multiset[i], 0) for i in range(N)]) == partition_sum)
    solver.add(Sum(*[If(variables[i] == 1, multiset[i], 0) for i in range(N)]) == partition_sum)

    if solver.check() == sat:
        return ["YES"] ### returns one of multiple solutions
    else:
        return ["NO"]

def MySolver():
    return PartitionProblemSolver

if __name__ == "__main__":
    input_sample = [2, 5]
    print(PartitionProblemSolver(input_sample)) ## NO

    input_sample = [4, 4, 4, 6, 6, 6]
    print(PartitionProblemSolver(input_sample)) ## NO

    input_sample = [3, 1, 1, 2, 2, 1]
    print(PartitionProblemSolver(input_sample)) ## YES
    
    input_sample = [1, 2, 3]
    print(PartitionProblemSolver(input_sample)) ## YES
    
        