import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    assert len(input_text) == 1
    return list(map(int, input_text[0].split()))

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
        if "YES" in output_text[0].upper() and "NO" not in output_text[0].upper():
            return {
                "OUTPUT": "YES",
                "ERROR": None
            }
        
        if "NO" in output_text[0].upper() and "YES" not in output_text[0].upper():
            return {
                "OUTPUT": "NO",
                "ERROR": None
            }
    
        return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    return " ".join(map(str, input_sample))

def output_to_text_string(output_sample, **kwargs):
    return output_sample