Each folder contains data and related scripts for a problem in FCoReBench. The structure of which is as follows:

Problem-Name
    |
    |-- data/
    |   |- train.txt
    |   |- test.txt
    |
    |-- rules.txt
    |-- input-format.txt
    |-- output-format.txt
    |-- dataset.py
    |-- utils.py
    |-- solver.py
    |-- verifier.py


- train.txt: contains input instances used for training seperated by empty lines
- test.txt: contains input instances used for testing seperated by empty lines
- rules.txt: describe the rules of the problem
- input-format.txt: describe how input instances are serialized to text
- output-format.txt: describe how output instances are serialized to text
- dataset.py: dataset class for loading data from text files into an internal representation in python (numpy arrays, lists etc.)
- utils.py: helper functions to load data from text files and write data to text files
- solver.py: generates the solution for any input instance
- verifier.py: verifies a candidate solution for any input instance