import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    board_text = input_text[:-2]
    row_counts_text = input_text[-2]
    col_counts_text = input_text[-1]
    input_board = []
    directions = {'N', 'S', 'E', 'W', 'NE', 'NW', 'SE', 'SW'}
    for row in board_text:
        row_list = []
        for item in row.split():
            if item in directions :
                row_list.append(item)
            else:
                row_list.append(int(item))  # Convert other items to integers
        input_board.append(row_list)
    row_counts = list(map(int, row_counts_text.split()))
    col_counts = list(map(int, col_counts_text.split()))
    return {
            'input_board': input_board,
            'row_counts': row_counts,
            'column_counts': col_counts
        }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        output_board = [list(map(str, line.strip().split())) for line in output_text] ### intergers and characters both in the output
        for row in output_board:
            if len(row) != num_lines:
                return {
                    "OUTPUT": None,
                    "ERROR": f"Each non empty row in output.txt must have {num_lines} numbers"
                }
        return {
            'OUTPUT': output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    input_board = input_sample['input_board']
    row_counts = input_sample['row_counts']
    column_counts = input_sample['column_counts']
    board_string = "\n".join(" ".join(map(str, row)) for row in input_board)
    row_counts_string = " ".join(map(str, row_counts))
    col_counts_string = " ".join(map(str, column_counts))
    return f"{board_string}\n{row_counts_string}\n{col_counts_string}"

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)