def ShinroVerifier(input_sample, output_sample, **kwargs):
    
    input_board = input_sample['input_board']
    row_counts = input_sample['row_counts']
    column_counts = input_sample['column_counts']
    output_board = output_sample
    
    M_in, N_in = len(input_board), len(input_board[0])
    M_out, N_out = len(output_board), len(output_board[0])
    if N_in != N_out or M_in != M_out:
        return {
            "result": False,
            "reason": "Input and Output Board Sizes Don't Match!"
        }
        
    for i in range(N_in):
        for j in range(N_out):
            if(str(input_board[i][j]) in ('N', 'S', 'E', 'W', 'NE', 'NW', 'SE', 'SW', "1")):
                if(str(input_board[i][j]) != str(output_board[i][j])):
                    return {
                        "result": False,
                        "reason": f"{input_board[i][j]} removed from cell ({i+1}, {j+1}) (1-indexed) from the input board"
                    }
    
    for i in range(N_in):
        row_count = 0
        for j in range(N_out):
            if(str(output_board[i][j]) == '1'):
                row_count += 1
        if row_count != row_counts[i]:
            return {
                "result": False,
                "reason": f"Row Count for Row: {i+1} Not Satisfied!"
            }

    for j in range(N_out):
        col_count = 0
        for i in range(N_in):
            if(str(output_board[i][j]) == '1'):
                col_count += 1
        if col_count != column_counts[j]:
            return {
                "result": False,
                "reason": f"Column Count for Column: {j+1} Not Satisfied!"
            }
            
    directions = {
        'N': (-1, 0), 'S': (1, 0), 'E': (0, 1), 'W': (0, -1),
        'NE': (-1, 1), 'NW': (-1, -1), 'SE': (1, 1), 'SW': (1, -1)
    }
    for i in range(N_in):
        for j in range(N_out):
            if str(input_board[i][j]) in directions:
                dx, dy = directions[str(input_board[i][j])]
                x, y = i + dx, j + dy
                found = False
                while 0 <= x < N_in and 0 <= y < N_out:
                    if str(output_board[x][y]) == '1':
                        found = True
                        break
                    x += dx
                    y += dy
                if not found:
                    return {
                        'result': False,
                        'reason': f"Arrow Constraint for {input_board[i][j]} Not Satisifed for Arrow at ({i+1}, {j+1})"
                    }
    return {
        'result': True,
        'reason': None
    }

def MyVerifier():
    return ShinroVerifier
    
if __name__ == '__main__':
    
    input_sample = {
        'column_counts' : [2, 2, 1, 2, 1, 1, 1, 2],
        'row_counts' : [1, 1, 2, 1, 2, 2, 2, 1],
        'input_board' : [
                        [0, 0, 0, 'E', 0, 0, 0, 0],
                        [0, 0, 0, 0, 'W', 0, 0, 0],
                        [0, 0, 0, 0, 0, 'SW', 0, 'NW'],
                        [0, 0, 'S', 0, 'NW', 0, 0, 0],
                        ['NE', 0, 0, 'S', 'W', 'N', 0, 0],
                        [0, 0, 0, 0, 0, 0, 0, 0],
                        [0, 0, 0, 'NE', 0, 0, 'NW', 0],
                        [0, 0, 0, 0, 0, 0, 0, 0],
                    ]
    }
    solved_board = [
                    [0, 0, 0, 'E', 0, 1, 0, 0],
                    [0, 1, 0, 0, 'W', 0, 0, 0],
                    [0, 0, 0, 1, 0, 'SW', 1, 'NW'],
                    [0, 1, 'S', 0, 'NW', 0, 0, 0],
                    ['NE', 0, 1, 'S', 'W', 'N', 0, 1],
                    [0, 0, 0, 1, 1, 0, 0, 0],
                    [1, 0, 0, 'NE', 0, 0, 'NW', 1],
                    [1, 0, 0, 0, 0, 0, 0, 0],
                   ]
    print(ShinroVerifier(input_sample, solved_board))