import re
import subprocess

SEPERATOR_STRING = '--------'

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    seperator_idx = input_text.index(SEPERATOR_STRING)
    k = int(input_text[0])
    initial_board_text = input_text[1:seperator_idx]
    final_board_text = input_text[seperator_idx+1:]
    initial_board = [list(map(int, row.strip().split())) for row in initial_board_text]
    final_board = [list(map(int, row.strip().split())) for row in final_board_text]
    return {
            'initial_board': initial_board,
            'final_board': final_board,
            'k': k
    }
    


def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
        if "YES" in output_text[0].upper() and "NO" not in output_text[0].upper():
            return {
                "OUTPUT": "YES",
                "ERROR": None
            }
        
        if "NO" in output_text[0].upper() and "YES" not in output_text[0].upper():
            return {
                "OUTPUT": "NO",
                "ERROR": None
            }
    
        return {
                "OUTPUT": None,
                "ERROR": "Output file should have a single line containing 'YES' or 'NO'"
            }
        
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    initial_board = input_sample['initial_board']
    final_board = input_sample['final_board']
    k = input_sample['k']
    initial_board_string = "\n".join(" ".join(map(str, row)) for row in initial_board)
    final_board_string = "\n".join(" ".join(map(str, row)) for row in final_board)
    return f"{k}\n{initial_board_string}\n{SEPERATOR_STRING}\n{final_board_string}"

def output_to_text_string(output_sample, **kwargs):
    return output_sample