from solver import SlidingTileSolver

def SlidingTileVerifier(input_sample, output_sample, **kwargs):
    answer = SlidingTileSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer generated is not correct"
    }

def MyVerifier():
    return SlidingTileVerifier

if __name__ == '__main__':
    initBoard = [[8,7,6],[5,4,3],[2,1,0]]
    easyBoard = [[0,8,7],[5,4,6],[2,1,3]]

    finalBoard = easyBoard
    input_sample={
        'initial_board': initBoard,
        'final_board': finalBoard,
        'k': 5
    }
    output_sample = 'NO'
    print(SlidingTileVerifier(input_sample, output_sample)) ## False
    
    
    output_sample = "YES"
    print(SlidingTileVerifier(input_sample, output_sample)) ## True