from z3 import *

def SubsetSumSolver(input_sample, **kwargs):
    numbers = input_sample['numbers']
    target_sum = input_sample['target']
    solver  = Solver()
    
    N = len(numbers)
    
    choosen_variables = [Bool(f'choose_{i}') for i in range(N)]
    
    ### sum constraints
    sum_expr = Sum(*[choosen_variables[i] * numbers[i] for i in range(N)])
    solver.add(sum_expr == target_sum)

    # Check for a solution
    if solver.check() == sat:
        model = solver.model()
        selected_elements = [numbers[i] for i in range(N) if model[choosen_variables[i]]]
        return [selected_elements] ### return one of the possible solution
    else:
        return ['None']

def MySolver():
    return SubsetSumSolver

if __name__ == "__main__":
    print(SubsetSumSolver(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 9
    }))
    print(SubsetSumSolver(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 7
    }))
    print(SubsetSumSolver(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 6
    }))
    print(SubsetSumSolver(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 12
    }))
    
    