import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    return {
        'numbers': list(map(int, input_text[0].split())),
        'target': int(input_text[1])
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines != 1:
            return {
                "OUTPUT": None,
                'ERROR': "Output should contain a single line with space seperated integers representing the elements chosen or a single word None if no such solution is possible"
            }
        if 'none' in output_text[0].lower():
            return {
                "OUTPUT": 'None',
                "ERROR": None,
            }

        return {
            "OUTPUT": list(map(int, output_text[0].split())),
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs):
    numbers = input_sample['numbers']
    target = input_sample['target']
    numbers_string = " ".join(map(str, numbers))
    return f"{numbers_string}\n{target}"

def output_to_text_string(output_sample, **kwargs):
    if 'None' in output_sample:
        return 'None'

    return " ".join(map(str, output_sample))