from collections import Counter
from solver import SubsetSumSolver

def SubsetSumSVerifier(input_sample, output_sample, **kwargs):
    numbers = input_sample['numbers']
    target_sum = input_sample['target']
    choosen_numbers = output_sample
    
    if SubsetSumSolver(input_sample)[0] == 'None':
        if choosen_numbers != 'None':
            return {
                'result': False,
                'reason': "No solution is possible and the output should be None"
            }
        else:
            return {
                'result': True,
                'reason': None
            }
    if choosen_numbers == 'None':
        return {
            'result': False,
            'reason': 'Output is None whereas a solution is possible'
        }
    
    if sum(choosen_numbers) != target_sum:
        return {
            'result': False,
            'reason': "Choosen Numbers do not sum to target"
        }

    input_counter = Counter(numbers)
    output_counter = Counter(choosen_numbers)
    
    for num, cnt in output_counter.items():
        if num not in input_counter or cnt > input_counter[num]:
            return {
                'result': False,
                'reason': f'One of the chosen numbers ({num}) is not in the input array'
            }

    return {
        'result': True,
        'reason': None
    }

def MyVerifier():
    return SubsetSumSVerifier

    
if __name__ == '__main__':
    print(SubsetSumSVerifier(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 9
    },
        output_sample=[5,1,3]))

    print(SubsetSumSVerifier(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 9
    },
        output_sample=[9]))

    print(SubsetSumSVerifier(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 9
    },
        output_sample=[3,3,3]))

    print(SubsetSumSVerifier(input_sample={
        'numbers': [5, 2, 1, 3],
        'target': 12
    },
        output_sample="None"))