import re


def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    board_text = input_text[:-1]
    quadrant_sums_text = input_text[-1]
    board = [list(map(int, row_text.split())) for row_text in board_text]
    quadrant_sums = list(map(int, quadrant_sums_text.split()))
    return {
        'board': board,
        'quadrant_sums': quadrant_sums
    }
    
def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        n = num_lines
        output_board = []
        for idx, line in enumerate(output_text):
            row = list(map(int, line.split()))
            if(len(row) != n):
                return {
                    "OUTPUT": None,
                    "ERROR": f"Each line in the Output File should have {n} space seperated integers"
                }
            output_board.append(row)
        return {
            "OUTPUT": output_board,
            "ERROR": None
        }

    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    board = input_sample['board']
    quadrant_sums = input_sample['quadrant_sums']
    board_str = "\n".join(" ".join(map(str, row)) for row in board)
    quadrant_sums_str = " ".join(map(str, quadrant_sums))
    return "\n".join([board_str, quadrant_sums_str])

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)