import numpy as np

def has_all_elements(board, m, n):
    expected_values = set(range(1, m * n + 1))
    flattened_list = [ele for row in board for ele in row]
    actual_values = set(flattened_list)
    return actual_values == expected_values

def check_board(solved_board, quadrant_sums):
    M, N = len(solved_board), len(solved_board[0])
    idx = 0
    for i in range(M-1):
        for j in range(N-1):
            if (solved_board[i][j] + solved_board[i+1][j] + solved_board[i][j+1] +solved_board[i+1][j+1] != quadrant_sums[idx]):
                return {
                    "result": False,
                    "reason": f"Quardant ({i}, {j}), ({i+1}, {j}), ({i}, {j+1}), ({i+1}, {j+1}), (0-indexed) does not have sum {quadrant_sums[idx]}"
                }
            idx += 1
    if has_all_elements(solved_board, M, N):
        return {
            "result": True,
            "reason": None,
        }
    else:
        return {
            "result": False,
            "reason": f"Output Board does not have all elements from 1 to {M*N} exactly once"
        }
    

def SujikoVerifier(input_sample, output_sample, **kwargs):
    input_board, quadrant_sums = input_sample['board'], input_sample['quadrant_sums']
    output_board = output_sample

    M_in, N_in = len(input_board), len(input_board[0])
    M_out, N_out = len(output_board), len(output_board[0])
    if N_in != N_out or M_in != M_out:
        return {
            "result": False,
            "reason": "Input and Output Board Sizes Don't Match!"
        }
        
    for i in range(N_in):
        for j in range(N_out):
            if (input_board[i][j] != 0):
                if (output_board[i][j] != input_board[i][j]):
                    return {
                        "result": False,
                        "reason": "Originial Pieces Removed from the Board"
                    }
                
    return  check_board(output_board, quadrant_sums)
    

def MyVerifier():
    return SujikoVerifier

if __name__ == "__main__":
    input_sample = {
        'board': [[4,0,0], 
                    [0,0,0],
                    [0,0,9]],
        'quadrant_sums': [17, 18, 15, 15]
    }
    output_board = [[4,7,8], 
                   [5,1,2],
                   [6,3,9]] 
    solution_result = SujikoVerifier(input_sample, output_board)
    print(solution_result)