import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    n, target = tuple(map(int, input_text[0].split()))
    numbers = list(map(int, input_text[1].split()))
    operators = list(input_text[2].split())
    return {
        'numbers': numbers,
        'operators': operators,
        'n': n,
        'target': target
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        pattern = re.compile(r'^(-?\d+)\s*([+*/-])\s*(-?\d+)\s*=\s*(-?\d+)$')
        for equation in output_text:
            match = pattern.match(equation)
            if not match:
                return {
                    "OUTPUT": None,
                    "ERROR": "Each equation in the output must be of the form OPERAND1 OPERATOR OPERAND2 = RESULT"
                }
        return {
            "OUTPUT": output_text,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    n = input_sample["n"] ## number of equations
    operators = input_sample["operators"] ## operators to be used
    target = input_sample["target"] ## final target, last result
    numbers  = input_sample["numbers"] ## numbers to be used
    first_line = f"{n} {target}"
    second_line = " ".join(map(str, numbers))
    third_line = " ".join(operators)
    return "\n".join([first_line, second_line, third_line])
    

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(output_sample)