import re

def clean_lines(lines: list[str]) -> list[str]:
    return [line.strip() for line in lines if line.strip()]

def input_from_text(input_text: list[str], **kwargs):
    input_text = clean_lines(input_text)
    board_rows_text = input_text[:-1]
    column_sums_text = input_text[-1]
    board_with_row_sums = [list(map(int, row.split())) for row in board_rows_text]
    input_board = [row[:-1] for row in board_with_row_sums]
    row_sums= [row[-1] for row in board_with_row_sums]
    column_sums = list(map(int, column_sums_text.split()))
    return {
        'input_board': input_board,
        'row_sums': row_sums,
        'column_sums': column_sums
    }

def output_from_text(output_text: list[str], **kwargs):
    try:
        output_text = clean_lines(output_text)
        num_lines = len(output_text)
        if num_lines == 0:
            return {
                    "OUTPUT": None,
                    "ERROR": "Output is Empty"
            }
        output_board = [list(map(int, line.strip().split())) for line in output_text]
        for row in output_board:
            if len(row) != len(output_board[0]):
                return {
                    "OUTPUT": None,
                    "ERROR": "Output board is not a rectangle"
                }
        return {
            'OUTPUT': output_board,
            "ERROR": None
        }
    except Exception as e:
        return {
            "OUTPUT": None,
            "ERROR": f"Could not parse output.txt, output format should match description, when my script tried to parse output.txt the following exception was generated:\n{e}"
        }

def input_to_text_string(input_sample, **kwargs) -> str:
    input_board = input_sample['input_board']
    row_sums = input_sample['row_sums']
    column_sums = input_sample['column_sums']
    board_row_text = "\n".join( " ".join(map(str, row + [row_sum])) for row, row_sum in zip(input_board, row_sums))
    column_sums_text = " ".join(map(str, column_sums))
    return f"{board_row_text}\n{column_sums_text}"
    

def output_to_text_string(output_sample, **kwargs) -> str:
    return "\n".join(" ".join(map(str, row)) for row in output_sample)
