from z3 import *
import math

def SymmetricSudokuSolver(board, **kwargs):
    n = len(board)
    subgrid_size = int(math.sqrt(n))
    
    X = [ [ Int('X_%s_%s' % (i+1, j+1)) for j in range(n) ] for i in range(n) ]

    
    cells_c = [ And(1 <= X[i][j], X[i][j] <= n) for i in range(n) for j in range(n) ]

   
    row_c = [ Distinct(X[i]) for i in range(n) ]

    
    col_c = [ Distinct([X[i][j] for i in range(n)]) for j in range(n) ]

    subgrids_c = [ X[i][j] == X[subgrid_size*(i//subgrid_size)+j%subgrid_size][subgrid_size*(j//subgrid_size)+i%subgrid_size] 
                                                                                                for i in range(n) for j in range(n)]

   
    given_c = [ If(board[i][j] != 0, X[i][j] == board[i][j], True) for i in range(n) for j in range(n) ]

    
    s = Solver()
    s.add(cells_c + row_c + col_c + subgrids_c + given_c)

    
    if s.check() == sat:
        m = s.model()
        solution = [ [m.evaluate(X[i][j]) for j in range(n)] for i in range(n) ]
        return [solution]
    else:
        return [None]
    
def MySolver():
    return SymmetricSudokuSolver


if __name__ == '__main__':
    input_board = [[4, 0, 0, 2],
                   [0, 0, 0, 0],
                   [0, 0, 0, 4],
                   [3, 2, 4, 1]]
    
    for row in SymmetricSudokuSolver(input_board)[0]:
        print(row)
    