from solver import VertexCoverSolver

def VertexCoverVerifier(input_sample, output_sample, **kwargs):
    answer = VertexCoverSolver(input_sample, **kwargs)[0]
    answer_correct = answer == output_sample
    return {
        'result': answer_correct,
        'reason': None if answer_correct else "The answer is incorrect"
    }

def MyVerifier():
    return VertexCoverVerifier

if __name__ == '__main__':
    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 1
    }
    output_sample = "YES"
    print(VertexCoverVerifier(input_sample=input_sample, output_sample=output_sample)) ## True

    input_sample = {
        'number_of_nodes': 4,
        'edges' : [(0,1), (0,2), (0,3)],
        'k': 1
    }
    output_sample = "NO"
    print(VertexCoverVerifier(input_sample=input_sample, output_sample=output_sample)) ## False