#!/bin/bash

exec > master-log.txt 2>&1   # Redirect stdout and stderr to master log file


# Get current timestamp and create a folder with its name
TIMESTAMP=$(date +"%d-%b-%Y_%H:%M:%S")

## number of feedback rounds is fixed at 4

while [[ "$#" -gt 0 ]]; do
    case $1 in
        -m|--value-m) m="$2"; shift ;; ## number of runs
        --train-dir) train_dir="$2"; shift ;;
        --test-dir) test_dir="$2"; shift ;;
        --val-dir) val_dir="$2"; shift ;;
        *) echo "Unknown parameter passed: $1"; exit 1 ;;
    esac
    shift
done


# Check if m is a valid positive integer
if ! [[ "$m" =~ ^[1-9][0-9]*$ ]]; then
    echo "Error: Please provide a valid positive integer for m."
    exit 1
fi

# Check if train_dir points to a valid existing file
if [ ! -f "$train_dir" ]; then
    echo "Error: $train_dir is not a valid file or does not exist."
    exit 1
fi

# Check if test_dir points to a valid existing file
if [ ! -f "$test_dir" ]; then
    echo "Error: $test_dir is not a valid file or does not exist."
    exit 1
fi

# Check if test_dir points to a valid existing file
if [ ! -f "$val_dir" ]; then
    echo "Error: $val_dir is not a valid file or does not exist."
    exit 1
fi


script_name="sympro-lm.py"

# Create the directory if it does not exist
mkdir -p ./Final-Experiments/SYMPRO-LM

mkdir -p ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP

# Run the python3 puzzle-lm.py command m times
for ((i=1; i<=m; i++))
do
    echo "Running Iteration No: $i"

    # Run the python script
    python3 "$script_name" -i "$train_dir"

    echo "Iteration: ${i} Done Programs Generated"

    sleep 1

    # Create a directory for the current run
    mkdir -p ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i

    # Move the generated code files and log files to the run directory
    mv code-* ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i/
    mv log-* ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i/
    
    echo "Scoring Run $i (Test)"
    # Run the score.py with the path to the timestamp folder as an argument
    python3 score.py --program_dir ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i --dataset "$test_dir" --type test
    
    echo "Scoring Run $i (Val)"
    # Run the score.py with the path to the timestamp folder as an argument
    python3 score.py --program_dir ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i --dataset "$val_dir" --type validation

    # Move the generated score file to the timestamp folder
    mv scores-* ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP/run-$i
done

rm temp.py
mv master-log.txt ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP
python3 results.py -e ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP -d 5
mv results.txt *.png ./Final-Experiments/SYMPRO-LM/Experiment-$TIMESTAMP
