import numpy as np
import pickle
import os
import csv

from data_utils import *


if __name__ == "__main__":
    path = "total/"
    file_list = os.listdir(path)
    dataset = []
    opts = []
    for file in file_list:
        with open(path + file, 'rb') as f:
            instance = pickle.load(f)
            optimal = instance[1]
            points = (instance[0] - np.min(instance[0])) / (np.max(instance[0]) - np.min(instance[0]))
            optimal /= np.max(instance[0]) - np.min(instance[0])
            dataset.append(torch.tensor(points, dtype=torch.float)[None, :, :])
            opts.append(optimal)
    
    save_dataset(dataset, "dataset.pkl")
    save_dir_name = "results/result_opt.txt"
    with open(save_dir_name, 'w') as f:
        csv_writer = csv.writer(f)
        for i, opt in enumerate(opts):
            csv_writer.writerow([i, opt])