9      (}((mbedtls_error_addb/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/error.hKNt(b/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/error.hKKKKXQ  static inline int mbedtls_error_add( int high, int low,
                                     const char *file, int line )
{
#if defined(MBEDTLS_TEST_HOOKS)
    if( *mbedtls_test_hook_error_add != NULL )
        ( *mbedtls_test_hook_error_add )( high, low, file, line );
#endif
    (void)file;
    (void)line;

    return( high + low );
}t(mbedtls_entropy_init\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cK<Nt(hK<KKsKXU  void mbedtls_entropy_init( mbedtls_entropy_context *ctx )
{
    ctx->source_count = 0;
    memset( ctx->source, 0, sizeof( ctx->source ) );

#if defined(MBEDTLS_THREADING_C)
    mbedtls_mutex_init( &ctx->mutex );
#endif

    ctx->accumulator_started = 0;
#if defined(MBEDTLS_ENTROPY_SHA512_ACCUMULATOR)
    mbedtls_sha512_init( &ctx->accumulator );
#else
    mbedtls_sha256_init( &ctx->accumulator );
#endif
#if defined(MBEDTLS_HAVEGE_C)
    mbedtls_havege_init( &ctx->havege_data );
#endif

    /* Reminder: Update ENTROPY_HAVE_STRONG in the test files
     *           when adding more strong entropy sources here. */

#if defined(MBEDTLS_TEST_NULL_ENTROPY)
    mbedtls_entropy_add_source( ctx, mbedtls_null_entropy_poll, NULL,
                                1, MBEDTLS_ENTROPY_SOURCE_STRONG );
#endif

#if !defined(MBEDTLS_NO_DEFAULT_ENTROPY_SOURCES)
#if !defined(MBEDTLS_NO_PLATFORM_ENTROPY)
    mbedtls_entropy_add_source( ctx, mbedtls_platform_entropy_poll, NULL,
                                MBEDTLS_ENTROPY_MIN_PLATFORM,
                                MBEDTLS_ENTROPY_SOURCE_STRONG );
#endif
#if defined(MBEDTLS_TIMING_C)
    mbedtls_entropy_add_source( ctx, mbedtls_hardclock_poll, NULL,
                                MBEDTLS_ENTROPY_MIN_HARDCLOCK,
                                MBEDTLS_ENTROPY_SOURCE_WEAK );
#endif
#if defined(MBEDTLS_HAVEGE_C)
    mbedtls_entropy_add_source( ctx, mbedtls_havege_poll, &ctx->havege_data,
                                MBEDTLS_ENTROPY_MIN_HAVEGE,
                                MBEDTLS_ENTROPY_SOURCE_STRONG );
#endif
#if defined(MBEDTLS_ENTROPY_HARDWARE_ALT)
    mbedtls_entropy_add_source( ctx, mbedtls_hardware_poll, NULL,
                                MBEDTLS_ENTROPY_MIN_HARDWARE,
                                MBEDTLS_ENTROPY_SOURCE_STRONG );
#endif
#if defined(MBEDTLS_ENTROPY_NV_SEED)
    mbedtls_entropy_add_source( ctx, mbedtls_nv_seed_poll, NULL,
                                MBEDTLS_ENTROPY_BLOCK_SIZE,
                                MBEDTLS_ENTROPY_SOURCE_STRONG );
    ctx->initial_entropy_run = 0;
#endif
#endif /* MBEDTLS_NO_DEFAULT_ENTROPY_SOURCES */
}t(mbedtls_entropy_free\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cKuNt(h
KuKKKX
  void mbedtls_entropy_free( mbedtls_entropy_context *ctx )
{
    /* If the context was already free, don't call free() again.
     * This is important for mutexes which don't allow double-free. */
    if( ctx->accumulator_started == -1 )
        return;

#if defined(MBEDTLS_HAVEGE_C)
    mbedtls_havege_free( &ctx->havege_data );
#endif
#if defined(MBEDTLS_THREADING_C)
    mbedtls_mutex_free( &ctx->mutex );
#endif
#if defined(MBEDTLS_ENTROPY_SHA512_ACCUMULATOR)
    mbedtls_sha512_free( &ctx->accumulator );
#else
    mbedtls_sha256_free( &ctx->accumulator );
#endif
#if defined(MBEDTLS_ENTROPY_NV_SEED)
    ctx->initial_entropy_run = 0;
#endif
    ctx->source_count = 0;
    mbedtls_platform_zeroize( ctx->source, sizeof( ctx->source ) );
    ctx->accumulator_started = -1;
}t(mbedtls_entropy_add_source\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cKNt(hKKKKXb  int mbedtls_entropy_add_source( mbedtls_entropy_context *ctx,
                        mbedtls_entropy_f_source_ptr f_source, void *p_source,
                        size_t threshold, int strong )
{
    int idx, ret = 0;

#if defined(MBEDTLS_THREADING_C)
    if( ( ret = mbedtls_mutex_lock( &ctx->mutex ) ) != 0 )
        return( ret );
#endif

    idx = ctx->source_count;
    if( idx >= MBEDTLS_ENTROPY_MAX_SOURCES )
    {
        ret = MBEDTLS_ERR_ENTROPY_MAX_SOURCES;
        goto exit;
    }

    ctx->source[idx].f_source  = f_source;
    ctx->source[idx].p_source  = p_source;
    ctx->source[idx].threshold = threshold;
    ctx->source[idx].strong    = strong;

    ctx->source_count++;

exit:
#if defined(MBEDTLS_THREADING_C)
    if( mbedtls_mutex_unlock( &ctx->mutex ) != 0 )
        return( MBEDTLS_ERR_THREADING_MUTEX_ERROR );
#endif

    return( ret );
}t(entropy_update\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cKNt(hKKKKX$  static int entropy_update( mbedtls_entropy_context *ctx, unsigned char source_id,
                           const unsigned char *data, size_t len )
{
    unsigned char header[2];
    unsigned char tmp[MBEDTLS_ENTROPY_BLOCK_SIZE];
    size_t use_len = len;
    const unsigned char *p = data;
    int ret = 0;

    if( use_len > MBEDTLS_ENTROPY_BLOCK_SIZE )
    {
#if defined(MBEDTLS_ENTROPY_SHA512_ACCUMULATOR)
        if( ( ret = mbedtls_sha512_ret( data, len, tmp, 0 ) ) != 0 )
            goto cleanup;
#else
        if( ( ret = mbedtls_sha256_ret( data, len, tmp, 0 ) ) != 0 )
            goto cleanup;
#endif
        p = tmp;
        use_len = MBEDTLS_ENTROPY_BLOCK_SIZE;
    }

    header[0] = source_id;
    header[1] = use_len & 0xFF;

    /*
     * Start the accumulator if this has not already happened. Note that
     * it is sufficient to start the accumulator here only because all calls to
     * gather entropy eventually execute this code.
     */
#if defined(MBEDTLS_ENTROPY_SHA512_ACCUMULATOR)
    if( ctx->accumulator_started == 0 &&
        ( ret = mbedtls_sha512_starts_ret( &ctx->accumulator, 0 ) ) != 0 )
        goto cleanup;
    else
        ctx->accumulator_started = 1;
    if( ( ret = mbedtls_sha512_update_ret( &ctx->accumulator, header, 2 ) ) != 0 )
        goto cleanup;
    ret = mbedtls_sha512_update_ret( &ctx->accumulator, p, use_len );
#else
    if( ctx->accumulator_started == 0 &&
        ( ret = mbedtls_sha256_starts_ret( &ctx->accumulator, 0 ) ) != 0 )
        goto cleanup;
    else
        ctx->accumulator_started = 1;
    if( ( ret = mbedtls_sha256_update_ret( &ctx->accumulator, header, 2 ) ) != 0 )
        goto cleanup;
    ret = mbedtls_sha256_update_ret( &ctx->accumulator, p, use_len );
#endif

cleanup:
    mbedtls_platform_zeroize( tmp, sizeof( tmp ) );

    return( ret );
}t(mbedtls_entropy_update_manual\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cKNt(hKKKKX(  int mbedtls_entropy_update_manual( mbedtls_entropy_context *ctx,
                           const unsigned char *data, size_t len )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;

#if defined(MBEDTLS_THREADING_C)
    if( ( ret = mbedtls_mutex_lock( &ctx->mutex ) ) != 0 )
        return( ret );
#endif

    ret = entropy_update( ctx, MBEDTLS_ENTROPY_SOURCE_MANUAL, data, len );

#if defined(MBEDTLS_THREADING_C)
    if( mbedtls_mutex_unlock( &ctx->mutex ) != 0 )
        return( MBEDTLS_ERR_THREADING_MUTEX_ERROR );
#endif

    return( ret );
}t(entropy_gather_internal\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cMNt(h!MKM0KX  static int entropy_gather_internal( mbedtls_entropy_context *ctx )
{
    int ret = MBEDTLS_ERR_ENTROPY_SOURCE_FAILED;
    int i;
    int have_one_strong = 0;
    unsigned char buf[MBEDTLS_ENTROPY_MAX_GATHER];
    size_t olen;

    if( ctx->source_count == 0 )
        return( MBEDTLS_ERR_ENTROPY_NO_SOURCES_DEFINED );

    /*
     * Run through our entropy sources
     */
    for( i = 0; i < ctx->source_count; i++ )
    {
        if( ctx->source[i].strong == MBEDTLS_ENTROPY_SOURCE_STRONG )
            have_one_strong = 1;

        olen = 0;
        if( ( ret = ctx->source[i].f_source( ctx->source[i].p_source,
                        buf, MBEDTLS_ENTROPY_MAX_GATHER, &olen ) ) != 0 )
        {
            goto cleanup;
        }

        /*
         * Add if we actually gathered something
         */
        if( olen > 0 )
        {
            if( ( ret = entropy_update( ctx, (unsigned char) i,
                                        buf, olen ) ) != 0 )
                return( ret );
            ctx->source[i].size += olen;
        }
    }

    if( have_one_strong == 0 )
        ret = MBEDTLS_ERR_ENTROPY_NO_STRONG_SOURCE;

cleanup:
    mbedtls_platform_zeroize( buf, sizeof( buf ) );

    return( ret );
}t(mbedtls_entropy_gather\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cM5Nt(h&M5KMFKX  int mbedtls_entropy_gather( mbedtls_entropy_context *ctx )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;

#if defined(MBEDTLS_THREADING_C)
    if( ( ret = mbedtls_mutex_lock( &ctx->mutex ) ) != 0 )
        return( ret );
#endif

    ret = entropy_gather_internal( ctx );

#if defined(MBEDTLS_THREADING_C)
    if( mbedtls_mutex_unlock( &ctx->mutex ) != 0 )
        return( MBEDTLS_ERR_THREADING_MUTEX_ERROR );
#endif

    return( ret );
}t(mbedtls_entropy_func\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/entropy.cMHNt(h+MHKMKX  int mbedtls_entropy_func( void *data, unsigned char *output, size_t len )
{
    int ret, count = 0, i, thresholds_reached;
    size_t strong_size;
    mbedtls_entropy_context *ctx = (mbedtls_entropy_context *) data;
    unsigned char buf[MBEDTLS_ENTROPY_BLOCK_SIZE];

    if( len > MBEDTLS_ENTROPY_BLOCK_SIZE )
        return( MBEDTLS_ERR_ENTROPY_SOURCE_FAILED );

#if defined(MBEDTLS_ENTROPY_NV_SEED)
    /* Update the NV entropy seed before generating any entropy for outside
     * use.
     */
    if( ctx->initial_entropy_run == 0 )
    {
        ctx->initial_entropy_run = 1;
        if( ( ret = mbedtls_entropy_update_nv_seed( ctx ) ) != 0 )
            return( ret );
    }
#endif

#if defined(MBEDTLS_THREADING_C)
    if( ( ret = mbedtls_mutex_lock( &ctx->mutex ) ) != 0 )
        return( ret );
#endif

    /*
     * Always gather extra entropy before a call
     */
    do
    {
        if( count++ > ENTROPY_MAX_LOOP )
        {
            ret = MBEDTLS_ERR_ENTROPY_SOURCE_FAILED;
            goto exit;
        }

        if( ( ret = entropy_gather_internal( ctx ) ) != 0 )
            goto exit;

        thresholds_reached = 1;
        strong_size = 0;
        for( i = 0; i < ctx->source_count; i++ )
        {
            if( ctx->source[i].size < ctx->source[i].threshold )
                thresholds_reached = 0;
            if( ctx->source[i].strong == MBEDTLS_ENTROPY_SOURCE_STRONG )
                strong_size += ctx->source[i].size;
        }
    }
    while( ! thresholds_reached || strong_size < MBEDTLS_ENTROPY_BLOCK_SIZE );

    memset( buf, 0, MBEDTLS_ENTROPY_BLOCK_SIZE );

#if defined(MBEDTLS_ENTROPY_SHA512_ACCUMULATOR)
    /*
     * Note that at this stage it is assumed that the accumulator was started
     * in a previous call to entropy_update(). If this is not guaranteed, the
     * code below will fail.
     */
    if( ( ret = mbedtls_sha512_finish_ret( &ctx->accumulator, buf ) ) != 0 )
        goto exit;

    /*
     * Reset accumulator and counters and recycle existing entropy
     */
    mbedtls_sha512_free( &ctx->accumulator );
    mbedtls_sha512_init( &ctx->accumulator );
    if( ( ret = mbedtls_sha512_starts_ret( &ctx->accumulator, 0 ) ) != 0 )
        goto exit;
    if( ( ret = mbedtls_sha512_update_ret( &ctx->accumulator, buf,
                                           MBEDTLS_ENTROPY_BLOCK_SIZE ) ) != 0 )
        goto exit;

    /*
     * Perform second SHA-512 on entropy
     */
    if( ( ret = mbedtls_sha512_ret( buf, MBEDTLS_ENTROPY_BLOCK_SIZE,
                                    buf, 0 ) ) != 0 )
        goto exit;
#else /* MBEDTLS_ENTROPY_SHA512_ACCUMULATOR */
    if( ( ret = mbedtls_sha256_finish_ret( &ctx->accumulator, buf ) ) != 0 )
        goto exit;

    /*
     * Reset accumulator and counters and recycle existing entropy
     */
    mbedtls_sha256_free( &ctx->accumulator );
    mbedtls_sha256_init( &ctx->accumulator );
    if( ( ret = mbedtls_sha256_starts_ret( &ctx->accumulator, 0 ) ) != 0 )
        goto exit;
    if( ( ret = mbedtls_sha256_update_ret( &ctx->accumulator, buf,
                                           MBEDTLS_ENTROPY_BLOCK_SIZE ) ) != 0 )
        goto exit;

    /*
     * Perform second SHA-256 on entropy
     */
    if( ( ret = mbedtls_sha256_ret( buf, MBEDTLS_ENTROPY_BLOCK_SIZE,
                                    buf, 0 ) ) != 0 )
        goto exit;
#endif /* MBEDTLS_ENTROPY_SHA512_ACCUMULATOR */

    for( i = 0; i < ctx->source_count; i++ )
        ctx->source[i].size = 0;

    memcpy( output, buf, len );

    ret = 0;

exit:
    mbedtls_platform_zeroize( buf, sizeof( buf ) );

#if defined(MBEDTLS_THREADING_C)
    if( mbedtls_mutex_unlock( &ctx->mutex ) != 0 )
        return( MBEDTLS_ERR_THREADING_MUTEX_ERROR );
#endif

    return( ret );
}t(
AsCoreTypeR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKBNt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKBKKGKtemplate <typename Type> typename CoreType<Type>::Type &AsCoreType(Type *aObject)
{
    AssertPointerIsNotNull(aObject);

    return *static_cast<typename CoreType<Type>::Type *>(aObject);
}t(
AsCoreTypeR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKSNt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKSKKXKtemplate <typename Type> const typename CoreType<Type>::Type &AsCoreType(const Type *aObject)
{
    AssertPointerIsNotNull(aObject);

    return *static_cast<const typename CoreType<Type>::Type *>(aObject);
}t(
AsCoreTypePtrR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKdNt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKdKKgKtemplate <typename Type> typename CoreType<Type>::Type *AsCoreTypePtr(Type *aObject)
{
    return static_cast<typename CoreType<Type>::Type *>(aObject);
}t(
AsCoreTypePtrR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKsNt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKsKKvKtemplate <typename Type> const typename CoreType<Type>::Type *AsCoreTypePtr(const Type *aObject)
{
    return static_cast<const typename CoreType<Type>::Type *>(aObject);
}t(MapEnumR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKNt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/as_core_type.hppKKKKtemplate <typename EnumType> const typename MappedEnum<EnumType>::Type MapEnum(EnumType aValue)
{
    return static_cast<typename MappedEnum<EnumType>::Type>(aValue);
}t(AsConstP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppK3Nt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppK3KK3Kjitemplate <typename Type> const Type &AsConst(Type &aObject) { return const_cast<const Type &>(aObject); }t(AsConstP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppK?Nt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppK?KK?Klktemplate <typename Type> const Type *AsConst(Type *aPointer) { return const_cast<const Type *>(aPointer); }t(
AsNonConstP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppKKNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppKKKKKKgftemplate <typename Type> Type &AsNonConst(const Type &aObject) { return const_cast<Type &>(aObject); }t(
AsNonConstP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppKWNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/const_cast.hppKWKKWKihtemplate <typename Type> Type *AsNonConst(const Type *aPointer) { return const_cast<Type *>(aPointer); }t(NonCopyableR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/non_copyable.hppK2NonCopyablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/non_copyable.hppK2KK2K      NonCopyable(void) = default;t(Swap16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK6Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK6KK6Kqpinline uint16_t Swap16(uint16_t v) { return (((v & 0x00ffU) << 8) & 0xff00) | (((v & 0xff00U) >> 8) & 0x00ff); }t(Swap32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK8Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK8KK<KX	  inline uint32_t Swap32(uint32_t v)
{
    return ((v & static_cast<uint32_t>(0x000000ffUL)) << 24) | ((v & static_cast<uint32_t>(0x0000ff00UL)) << 8) |
           ((v & static_cast<uint32_t>(0x00ff0000UL)) >> 8) | ((v & static_cast<uint32_t>(0xff000000UL)) >> 24);
}t(Swap64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK>Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppK>KKHKXc  inline uint64_t Swap64(uint64_t v)
{
    return ((v & static_cast<uint64_t>(0x00000000000000ffULL)) << 56) |
           ((v & static_cast<uint64_t>(0x000000000000ff00ULL)) << 40) |
           ((v & static_cast<uint64_t>(0x0000000000ff0000ULL)) << 24) |
           ((v & static_cast<uint64_t>(0x00000000ff000000ULL)) << 8) |
           ((v & static_cast<uint64_t>(0x000000ff00000000ULL)) >> 8) |
           ((v & static_cast<uint64_t>(0x0000ff0000000000ULL)) >> 24) |
           ((v & static_cast<uint64_t>(0x00ff000000000000ULL)) >> 40) |
           ((v & static_cast<uint64_t>(0xff00000000000000ULL)) >> 56);
}t(	Reverse32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKJNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKJKKSKXa  inline uint32_t Reverse32(uint32_t v)
{
    v = ((v & 0x55555555) << 1) | ((v & 0xaaaaaaaa) >> 1);
    v = ((v & 0x33333333) << 2) | ((v & 0xcccccccc) >> 2);
    v = ((v & 0x0f0f0f0f) << 4) | ((v & 0xf0f0f0f0) >> 4);
    v = ((v & 0x00ff00ff) << 8) | ((v & 0xff00ff00) >> 8);
    v = ((v & 0x0000ffff) << 16) | ((v & 0xffff0000) >> 16);

    return v;
}t(
HostSwap16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKaNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKaKKaK=<inline uint16_t HostSwap16(uint16_t v) { return Swap16(v); }t(
HostSwap32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKbNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKbKKbK=<inline uint32_t HostSwap32(uint32_t v) { return Swap32(v); }t(
HostSwap64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKcNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKcKKcK=<inline uint64_t HostSwap64(uint64_t v) { return Swap64(v); }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKsNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKsKKsKHGtemplate <> inline uint8_t  HostSwap(uint8_t aValue) { return aValue; }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKtNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKtKKtKUTtemplate <> inline uint16_t HostSwap(uint16_t aValue) { return HostSwap16(aValue); }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKuNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKuKKuKUTtemplate <> inline uint32_t HostSwap(uint32_t aValue) { return HostSwap32(aValue); }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKvNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKvKKvKUTtemplate <> inline uint64_t HostSwap(uint64_t aValue) { return HostSwap64(aValue); }t(
ReadUint16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKutinline uint16_t ReadUint16(const uint8_t *aBuffer) { return static_cast<uint16_t>((aBuffer[0] << 8) | aBuffer[1]); }t(
ReadUint32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKinline uint32_t ReadUint32(const uint8_t *aBuffer)
{
    return ((static_cast<uint32_t>(aBuffer[0]) << 24) | (static_cast<uint32_t>(aBuffer[1]) << 16) |
            (static_cast<uint32_t>(aBuffer[2]) << 8) | (static_cast<uint32_t>(aBuffer[3]) << 0));
}t(
ReadUint24N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKinline uint32_t ReadUint24(const uint8_t *aBuffer)
{
    return ((static_cast<uint32_t>(aBuffer[0]) << 16) | (static_cast<uint32_t>(aBuffer[1]) << 8) |
            (static_cast<uint32_t>(aBuffer[2]) << 0));
}t(
ReadUint64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKX  inline uint64_t ReadUint64(const uint8_t *aBuffer)
{
    return ((static_cast<uint64_t>(aBuffer[0]) << 56) | (static_cast<uint64_t>(aBuffer[1]) << 48) |
            (static_cast<uint64_t>(aBuffer[2]) << 40) | (static_cast<uint64_t>(aBuffer[3]) << 32) |
            (static_cast<uint64_t>(aBuffer[4]) << 24) | (static_cast<uint64_t>(aBuffer[5]) << 16) |
            (static_cast<uint64_t>(aBuffer[6]) << 8) | (static_cast<uint64_t>(aBuffer[7]) << 0));
}t(WriteUint16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKinline void WriteUint16(uint16_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 8) & 0xff;
    aBuffer[1] = (aValue >> 0) & 0xff;
}t(WriteUint24N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKinline void WriteUint24(uint32_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 16) & 0xff;
    aBuffer[1] = (aValue >> 8) & 0xff;
    aBuffer[2] = (aValue >> 0) & 0xff;
}t(WriteUint32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKinline void WriteUint32(uint32_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 24) & 0xff;
    aBuffer[1] = (aValue >> 16) & 0xff;
    aBuffer[2] = (aValue >> 8) & 0xff;
    aBuffer[3] = (aValue >> 0) & 0xff;
}t(WriteUint64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKKX|  inline void WriteUint64(uint64_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 56) & 0xff;
    aBuffer[1] = (aValue >> 48) & 0xff;
    aBuffer[2] = (aValue >> 40) & 0xff;
    aBuffer[3] = (aValue >> 32) & 0xff;
    aBuffer[4] = (aValue >> 24) & 0xff;
    aBuffer[5] = (aValue >> 16) & 0xff;
    aBuffer[6] = (aValue >> 8) & 0xff;
    aBuffer[7] = (aValue >> 0) & 0xff;
}t(
HostSwap16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKK54inline uint16_t HostSwap16(uint16_t v) { return v; }t(
HostSwap32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKK54inline uint32_t HostSwap32(uint32_t v) { return v; }t(
HostSwap64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppKKKK54inline uint64_t HostSwap64(uint64_t v) { return v; }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM	Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM	KM	KHGtemplate <> inline uint8_t  HostSwap(uint8_t aValue) { return aValue; }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM
Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM
KM
KUTtemplate <> inline uint16_t HostSwap(uint16_t aValue) { return HostSwap16(aValue); }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMKMKUTtemplate <> inline uint32_t HostSwap(uint32_t aValue) { return HostSwap32(aValue); }t(HostSwapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMKMKUTtemplate <> inline uint64_t HostSwap(uint64_t aValue) { return HostSwap64(aValue); }t(
ReadUint16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMKMKutinline uint16_t ReadUint16(const uint8_t *aBuffer) { return static_cast<uint16_t>(aBuffer[0] | (aBuffer[1] << 8)); }t(
ReadUint24N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM KM$Kinline uint32_t ReadUint24(const uint8_t *aBuffer)
{
    return ((static_cast<uint32_t>(aBuffer[0]) << 0) | (static_cast<uint32_t>(aBuffer[1]) << 8) |
            (static_cast<uint32_t>(aBuffer[2]) << 16));
}t(
ReadUint32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM.Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM.KM2Kinline uint32_t ReadUint32(const uint8_t *aBuffer)
{
    return ((static_cast<uint32_t>(aBuffer[0]) << 0) | (static_cast<uint32_t>(aBuffer[1]) << 8) |
            (static_cast<uint32_t>(aBuffer[2]) << 16) | (static_cast<uint32_t>(aBuffer[3]) << 24));
}t(
ReadUint64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM<Nt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppM<KMBKX  inline uint64_t ReadUint64(const uint8_t *aBuffer)
{
    return ((static_cast<uint64_t>(aBuffer[0]) << 0) | (static_cast<uint64_t>(aBuffer[1]) << 8) |
            (static_cast<uint64_t>(aBuffer[2]) << 16) | (static_cast<uint64_t>(aBuffer[3]) << 24) |
            (static_cast<uint64_t>(aBuffer[4]) << 32) | (static_cast<uint64_t>(aBuffer[5]) << 40) |
            (static_cast<uint64_t>(aBuffer[6]) << 48) | (static_cast<uint64_t>(aBuffer[7]) << 56));
}t(WriteUint16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMKKMOKinline void WriteUint16(uint16_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 0) & 0xff;
    aBuffer[1] = (aValue >> 8) & 0xff;
}t(WriteUint24N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMXNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMXKM]Kinline void WriteUint24(uint32_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 0) & 0xff;
    aBuffer[1] = (aValue >> 8) & 0xff;
    aBuffer[2] = (aValue >> 16) & 0xff;
}t(WriteUint32N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMfNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMfKMlKinline void WriteUint32(uint32_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 0) & 0xff;
    aBuffer[1] = (aValue >> 8) & 0xff;
    aBuffer[2] = (aValue >> 16) & 0xff;
    aBuffer[3] = (aValue >> 24) & 0xff;
}t(WriteUint64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMuNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/encoding.hppMuKMKX|  inline void WriteUint64(uint64_t aValue, uint8_t *aBuffer)
{
    aBuffer[0] = (aValue >> 0) & 0xff;
    aBuffer[1] = (aValue >> 8) & 0xff;
    aBuffer[2] = (aValue >> 16) & 0xff;
    aBuffer[3] = (aValue >> 24) & 0xff;
    aBuffer[4] = (aValue >> 32) & 0xff;
    aBuffer[5] = (aValue >> 40) & 0xff;
    aBuffer[6] = (aValue >> 48) & 0xff;
    aBuffer[7] = (aValue >> 56) & 0xff;
}t(ClearO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/clearable.hppK7	Clearablet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/clearable.hppK7KK7Kgf    void Clear(void) { memset(reinterpret_cast<void *>(static_cast<Type *>(this)), 0, sizeof(Type)); }t(IgnoreErrorP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/code_utils.hppKNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/code_utils.hppKKKKONstatic inline void IgnoreError(otError aError) { OT_UNUSED_VARIABLE(aError); }t(
operator!=O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/equatable.hppKBUnequatablet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/equatable.hppKBKKBKhg    bool operator!=(const Type &aOther) const { return !(*static_cast<const Type *>(this) == aOther); }t(
operator==O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/equatable.hppKZ	Equatablet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/equatable.hppKZKK]K    bool operator==(const Type &aOther) const
    {
        return memcmp(static_cast<const Type *>(this), &aOther, sizeof(Type)) == 0;
    }t(MinO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppK7Nt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppK7KK7Kontemplate <typename Type> Type Min(Type aFirst, Type aSecond) { return (aFirst < aSecond) ? aFirst : aSecond; }t(MaxO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKFNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKFKKFKontemplate <typename Type> Type Max(Type aFirst, Type aSecond) { return (aFirst < aSecond) ? aSecond : aFirst; }t(ClampO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKVNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKVKK[Ktemplate <typename Type> Type Clamp(Type aValue, Type aMin, Type aMax)
{
    Type value = Max(aValue, aMin);

    return Min(value, aMax);
}t(ClampToUint8O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKiNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKiKKpKX  template <typename UintType> uint8_t ClampToUint8(UintType aValue)
{
    static_assert(TypeTraits::IsSame<UintType, uint16_t>::kValue || TypeTraits::IsSame<UintType, uint32_t>::kValue ||
                      TypeTraits::IsSame<UintType, uint64_t>::kValue,
                  "UintType must be `uint16_t, `uint32_t`, or `uint64_t`");

    return static_cast<uint8_t>(Min(aValue, static_cast<UintType>(NumericLimits<uint8_t>::kMax)));
}t(
ClampToUint16O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppK~Nt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppK~KKKXb  template <typename UintType> uint16_t ClampToUint16(UintType aValue)
{
    static_assert(TypeTraits::IsSame<UintType, uint32_t>::kValue || TypeTraits::IsSame<UintType, uint64_t>::kValue,
                  "UintType must be `uint32_t` or `uint64_t`");

    return static_cast<uint16_t>(Min(aValue, static_cast<UintType>(NumericLimits<uint16_t>::kMax)));
}t(ThreeWayCompareO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKKKKtemplate <typename Type> int ThreeWayCompare(Type aFirst, Type aSecond)
{
    return (aFirst == aSecond) ? 0 : ((aFirst > aSecond) ? 1 : -1);
}t(ThreeWayCompareO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKKKK}template <> inline int ThreeWayCompare(bool aFirst, bool aSecond)
{
    return (aFirst == aSecond) ? 0 : (aFirst ? 1 : -1);
}t(DivideAndRoundToClosestO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKKKKtemplate <typename IntType> inline IntType DivideAndRoundToClosest(IntType aDividend, IntType aDivisor)
{
    return (aDividend + (aDivisor / 2)) / aDivisor;
}t(ToUlongO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKKKK_^inline unsigned long ToUlong(uint32_t aUint32) { return static_cast<unsigned long>(aUint32); }t(CountBitsInMaskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/num_utils.hppKKKKX	  template <typename UintType> uint8_t CountBitsInMask(UintType aMask)
{
    static_assert(TypeTraits::IsSame<UintType, uint8_t>::kValue || TypeTraits::IsSame<UintType, uint16_t>::kValue ||
                      TypeTraits::IsSame<UintType, uint32_t>::kValue || TypeTraits::IsSame<UintType, uint64_t>::kValue,
                  "UintType must be `uint8_t`, `uint16_t`, `uint32_t`, or `uint64_t`");

    uint8_t count = 0;

    while (aMask != 0)
    {
        aMask &= aMask - 1;
        count++;
    }

    return count;
}t(	DataUtilsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKU	DataUtilst(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKUKKUK    DataUtils(void) = default;t(InitJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    void Init(const void *aBuffer, LengthType aLength)
    {
        mBuffer = static_cast<const uint8_t *>(aBuffer);
        mLength = aLength;
    }t(
InitFromRangeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    void InitFromRange(const uint8_t *aStart, const uint8_t *aEnd)
    {
        Init(aStart, static_cast<LengthType>(aEnd - aStart));
    }t(InitFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    template <typename ObjectType> void InitFrom(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType MUST not be a pointer");
        Init(&aObject, sizeof(aObject));
    }t(GetBytesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK<;    const uint8_t *GetBytes(void) const { return mBuffer; }t(	GetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK98    LengthType GetLength(void) const { return mLength; }t(	SetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK>=    void SetLength(LengthType aLength) { mLength = aLength; }t(CopyBytesToJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKKQP    void CopyBytesTo(void *aBuffer) const { memcpy(aBuffer, mBuffer, mLength); }t(MatchesBytesInJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKόDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKKfe    bool MatchesBytesIn(const void *aBuffer) const { return memcmp(mBuffer, aBuffer, mLength) == 0; }t(MatchesBytesInJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppK݌Datat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    bool MatchesBytesIn(const void *aBuffer, ByteMatcher aMatcher)
    {
        return MatchBytes(mBuffer, static_cast<const uint8_t *>(aBuffer), mLength, aMatcher);
    }t(
operator==J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    bool operator==(const Data &aOtherData) const
    {
        return (mLength == aOtherData.mLength) && MatchesBytesIn(aOtherData.mBuffer);
    }t(
StartsWithJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppKKKK    bool StartsWith(const Data &aOtherData) const
    {
        return (mLength >= aOtherData.mLength) && aOtherData.MatchesBytesIn(mBuffer);
    }t(InitJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM&MutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM&KM&KSR    void Init(void *aBuffer, LengthType aLength) { Base::Init(aBuffer, aLength); }t(
InitFormRangeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM2MutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM2KM2K^]    void InitFormRange(uint8_t *aStart, uint8_t *aEnd) { Base::InitFormRange(aStart, aEnd); }t(InitFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM<MutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppM<KM@K    template <typename ObjectType> void InitFrom(ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType MUST not be a pointer");
        Init(&aObject, sizeof(aObject));
    }t(GetBytesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMHMutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMHKMHKED    uint8_t *GetBytes(void) { return AsNonConst(Base::GetBytes()); }t(GetBytesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMPMutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMPKMPKED    const uint8_t *GetBytes(void) const { return Base::GetBytes(); }t(
ClearBytesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMVMutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMVKMVK>=    void ClearBytes(void) { memset(GetBytes(), 0, mLength); }t(
CopyBytesFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMhMutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMhKMpKX      Error CopyBytesFrom(const uint8_t *aBuffer, LengthType aLength)
    {
        Error error = (mLength >= aLength) ? kErrorNone : kErrorNoBufs;

        mLength = Min(mLength, aLength);
        memcpy(AsNonConst(mBuffer), aBuffer, mLength);

        return error;
    }t(
CopyBytesFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMMutableDatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/data.hppMKMK    Error CopyBytesFrom(const Data<kDataLengthType> &aData)
    {
        return CopyBytesFrom(aData.GetBytes(), aData.GetLength());
    }t(FindS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKHBinarySearcht(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKHKKMKX'      template <typename Key, typename Entry, uint16_t kLength>
    static const Entry *Find(const Key &aKey, const Entry (&aTable)[kLength])
    {
        return static_cast<const Entry *>(
            Find(&aKey, &aTable[0], kLength, sizeof(aTable[0]), BinarySearch::Compare<Key, Entry>));
    }t(IsSortedS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKdBinarySearcht(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKdKKgK    template <typename Entry, uint16_t kLength> static constexpr bool IsSorted(const Entry (&aTable)[kLength])
    {
        return IsSorted(&aTable[0], kLength);
    }t(IsSortedS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKlBinarySearcht(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKlKKoK    template <typename Entry> static constexpr bool IsSorted(const Entry *aTable, uint16_t aLength)
    {
        return (aLength <= 1) ? true : Entry::AreInOrder(aTable[0], aTable[1]) && IsSorted(aTable + 1, aLength - 1);
    }t(CompareS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKqBinarySearcht(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/binary_search.hppKqKKtK    template <typename Key, typename Entry> static int Compare(const void *aKey, const void *aEntry)
    {
        return static_cast<const Entry *>(aEntry)->Compare(*static_cast<const Key *>(aKey));
    }t(AreStringsInOrderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppKNt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppKKKKinline constexpr bool AreStringsInOrder(const char *aFirst, const char *aSecond)
{
    return (*aFirst < *aSecond)
               ? true
               : ((*aFirst > *aSecond) || (*aFirst == '\0') ? false : AreStringsInOrder(aFirst + 1, aSecond + 1));
}t(IsTruncatedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMStringWritert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMKMK>=    bool IsTruncated(void) const { return mLength >= mSize; }t(	GetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM)StringWritert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM)KM)K76    uint16_t GetLength(void) const { return mLength; }t(GetSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM1StringWritert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM1KM1K32    uint16_t GetSize(void) const { return mSize; }t(ConvertToLowercaseL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMXStringWritert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMXKMXKIH    void ConvertToLowercase(void) { StringConvertToLowercase(mBuffer); }t(ConvertToUppercaseL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM^StringWritert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM^KM^KIH    void ConvertToUppercase(void) { StringConvertToUppercase(mBuffer); }t(
String<kSize>L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMsStringt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMsKMvKM    String(void)
        : StringWriter(mBuffer, sizeof(mBuffer))
    {
    }t(	AsCStringL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM~Stringt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM~KM~K:9    const char *AsCString(void) const { return mBuffer; }t(CompareL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMEntryt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMK	MKQP        int Compare(uint16_t aKey) const { return ThreeWayCompare(aKey, mKey); }t(
AreInOrderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMEntryt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMK	MK
        constexpr static bool AreInOrder(const Entry &aFirst, const Entry &aSecond)
        {
            return aFirst.mKey < aSecond.mKey;
        }t(LookupL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppM	Stringifyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/string.hppMKMKX      template <uint16_t kLength>
    static const char *Lookup(uint16_t aKey, const Entry (&aTable)[kLength], const char *aNotFound = "unknown")
    {
        const Entry *entry = BinarySearch::Find(aKey, aTable);

        return (entry != nullptr) ? entry->mString : aNotFound;
    }t(SetM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKҌKeyt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKKKK    void Set(const uint8_t *aKeyBytes, uint16_t aKeyLength)
    {
        mKey       = aKeyBytes;
        mKeyLength = aKeyLength;
    }t(GetBytesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKKeyt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKKKK98    const uint8_t *GetBytes(void) const { return mKey; }t(	GetLengthM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKKeyt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppKKKK:9    uint16_t GetLength(void) const { return mKeyLength; }t(GetBytesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppM;
LiteralKeyt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppM;KM;K98    const uint8_t *GetBytes(void) const { return mKey; }t(	GetLengthM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppMC
LiteralKeyt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/storage.hppMCKMCK76    uint16_t GetLength(void) const { return mLength; }t(FillL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKw
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKwKKwKED    void Fill(uint8_t aByte) { memset(this, aByte, sizeof(*this)); }t(SetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK    void Set(const uint8_t *aBuffer, CopyByteOrder aByteOrder = kNormalByteOrder)
    {
        CopyAddress(m8, aBuffer, aByteOrder);
    }t(IsGroupL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKKCB    bool IsGroup(void) const { return (m8[0] & kGroupFlag) != 0; }t(SetGroupL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK    void SetGroup(bool aGroup)
    {
        if (aGroup)
        {
            m8[0] |= kGroupFlag;
        }
        else
        {
            m8[0] &= ~kGroupFlag;
        }
    }t(ToggleGroupL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK43    void ToggleGroup(void) { m8[0] ^= kGroupFlag; }t(IsLocalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKKCB    bool IsLocal(void) const { return (m8[0] & kLocalFlag) != 0; }t(SetLocalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppK
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK    void SetLocal(bool aLocal)
    {
        if (aLocal)
        {
            m8[0] |= kLocalFlag;
        }
        else
        {
            m8[0] &= ~kLocalFlag;
        }
    }t(ToggleLocalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppǨ
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK43    void ToggleLocal(void) { m8[0] ^= kLocalFlag; }t(CopyToL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKՌ
ExtAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppKKKK    void CopyTo(uint8_t *aBuffer, CopyByteOrder aByteOrder = kNormalByteOrder) const
    {
        CopyAddress(aBuffer, m8, aByteOrder);
    }t(AddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK8    Address(void)
        : mType(kTypeNone)
    {
    }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK/.    Type GetType(void) const { return mType; }t(IsNoneL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK=<    bool IsNone(void) const { return (mType == kTypeNone); }t(IsShortL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM Addresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM KM K?>    bool IsShort(void) const { return (mType == kTypeShort); }t(
IsExtendedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM(Addresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM(KM(KED    bool IsExtended(void) const { return (mType == kTypeExtended); }t(GetShortL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM2Addresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM2KM2KHG    ShortAddress GetShort(void) const { return mShared.mShortAddress; }t(GetExtendedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM<Addresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM<KM<KNM    const ExtAddress &GetExtended(void) const { return mShared.mExtAddress; }t(GetExtendedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMFAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMFKMFKBA    ExtAddress &GetExtended(void) { return mShared.mExtAddress; }t(SetNoneL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMNAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMNKMNK.-    void SetNone(void) { mType = kTypeNone; }t(SetShortL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMXAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMXKM\K    void SetShort(ShortAddress aShortAddress)
    {
        mShared.mShortAddress = aShortAddress;
        mType                 = kTypeShort;
    }t(SetExtendedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMfAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMfKMjK    void SetExtended(const ExtAddress &aExtAddress)
    {
        mShared.mExtAddress = aExtAddress;
        mType               = kTypeExtended;
    }t(SetExtendedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMvAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMvKMzK    void SetExtended(const uint8_t *aBuffer, ExtAddress::CopyByteOrder aByteOrder = ExtAddress::kNormalByteOrder)
    {
        mShared.mExtAddress.Set(aBuffer, aByteOrder);
        mType = kTypeExtended;
    }t(IsBroadcastL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKlk    bool IsBroadcast(void) const { return ((mType == kTypeShort) && (GetShort() == kShortAddrBroadcast)); }t(IsShortAddrInvalidL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKqp    bool IsShortAddrInvalid(void) const { return ((mType == kTypeShort) && (GetShort() == kShortAddrInvalid)); }t(GetBytesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKeyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK76    const uint8_t *GetBytes(void) const { return m8; }t(KeyMaterialL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKeyMaterialt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK    KeyMaterial(void)
    {
        GetKey().Clear();
#if OPENTHREAD_CONFIG_PLATFORM_KEY_REFERENCES_ENABLE
        SetKeyRef(kInvalidKeyRef);
#endif
    }t(GetKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM KeyMaterialt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM KM KZY    const Key &GetKey(void) const { return static_cast<const Key &>(mKeyMaterial.mKey); }t(GetKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM;KeyMaterialt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM;KM;KHG    Key &GetKey(void) { return static_cast<Key &>(mKeyMaterial.mKey); }t(SetKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM<KeyMaterialt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM<KM<K?>    void SetKey(const Key &aKey) { mKeyMaterial.mKey = aKey; }t(ResetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMLinkFrameCounterst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK$#    void Reset(void) { SetAll(0); }t(GetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMLinkFrameCounterst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKz    uint32_t Get(void) const
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
    {
        return m154Counter;
    }t(SetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM'LinkFrameCounterst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM'KM+K    void Set(uint32_t aCounter)
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
    {
        m154Counter = aCounter;
    }t(Get154L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM;LinkFrameCounterst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM;KM;K87    uint32_t Get154(void) const { return m154Counter; }t(Set154L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCLinkFrameCounterst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCKMCK?>    void Set154(uint32_t aCounter) { m154Counter = aCounter; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM}CslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppM}KMKy    void Init(void)
    {
        mClockAccuracy = kWorstClockAccuracy;
        mUncertainty   = kWorstUncertainty;
    }t(GetClockAccuracyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKDC    uint8_t GetClockAccuracy(void) const { return mClockAccuracy; }t(SetClockAccuracyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKWV    void SetClockAccuracy(uint8_t aClockAccuracy) { mClockAccuracy = aClockAccuracy; }t(GetUncertaintyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMK@?    uint8_t GetUncertainty(void) const { return mUncertainty; }t(GetUncertaintyInMicrosecL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKut    uint16_t GetUncertaintyInMicrosec(void) const { return static_cast<uint16_t>(mUncertainty) * kUsPerUncertUnit; }t(SetUncertaintyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMCslAccuracyt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_types.hppMKMKON    void SetUncertainty(uint8_t aUncertainty) { mUncertainty = aUncertainty; }t(GetInstanceM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKvInstanceLocatort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKvKKvK_^    Instance &GetInstance(void) const { return *reinterpret_cast<Instance *>(&gInstanceRaw); }t(InstanceLocatorM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKInstanceLocatort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKKKK    explicit InstanceLocator(Instance &aInstance)
#if OPENTHREAD_CONFIG_MULTIPLE_INSTANCE_ENABLE
        : mInstance(&aInstance)
#endif
    {
        OT_UNUSED_VARIABLE(aInstance);
    }t(InstanceLocatorInitM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKInstanceLocatorInitt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKKKKE    InstanceLocatorInit(void)
        : InstanceLocator()
    {
    }t(InitM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKInstanceLocatorInitt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator.hppKKKK    void Init(Instance &aInstance)
    {
#if OPENTHREAD_CONFIG_MULTIPLE_INSTANCE_ENABLE
        mInstance = &aInstance;
#endif
        OT_UNUSED_VARIABLE(aInstance);
    }t(NameDataS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKFNameDatat(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKFKKFKON    NameData(const char *aBuffer, uint8_t aLength) { Init(aBuffer, aLength); }t(	GetBufferS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKNNameDatat(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKNKKNK]\    const char *GetBuffer(void) const { return reinterpret_cast<const char *>(GetBytes()); }t(	GetLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKVNameDatat(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKVKKVKRQ    uint8_t GetLength(void) const { return Data<kWithUint8Length>::GetLength(); }t(NetworkNameS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKxNetworkNamet(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKxKKxK('    NetworkName(void) { m8[0] = '\0'; }t(GetAsCStringS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKNetworkNamet(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKKKK87    const char *GetAsCString(void) const { return m8; }t(GetNetworkNameS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKΌNetworkNameManagert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKKKKKJ    const NetworkName &GetNetworkName(void) const { return mNetworkName; }t(
GetDomainNameS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKNetworkNameManagert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/network_name.hppKKKKHG    const DomainName &GetDomainName(void) const { return mDomainName; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKKHeaderIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKKKKKK)(    void Init(void) { mFields.m16 = 0; }t(GetIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppK\HeaderIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppK\KK\K\[    uint16_t GetId(void) const { return (HostSwap16(mFields.m16) & kIdMask) >> kIdOffset; }t(SetIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKdHeaderIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKdKKgK    void SetId(uint16_t aId)
    {
        mFields.m16 = HostSwap16((HostSwap16(mFields.m16) & ~kIdMask) | ((aId << kIdOffset) & kIdMask));
    }t(	GetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKoHeaderIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKoKKoKJI    uint8_t GetLength(void) const { return mFields.m8[0] & kLengthMask; }t(	SetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKwHeaderIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppKwKKwKrq    void SetLength(uint8_t aLength) { mFields.m8[0] = (mFields.m8[0] & ~kLengthMask) | (aLength & kLengthMask); }t(IsEmptyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMqFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMqKMqK87    bool IsEmpty(void) const { return (mLength == 0); }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKML    uint8_t GetType(void) const { return GetPsdu()[0] & kFcfFrameTypeMask; }t(IsAckL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK=<    bool IsAck(void) const { return GetType() == kTypeAck; }t(
GetVersionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK^]    uint16_t GetVersion(void) const { return GetFrameControlField() & kFcfFrameVersionMask; }t(
IsVersion2015L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hpp      MKMKUT    bool IsVersion2015(void) const { return IsVersion2015(GetFrameControlField()); }t(GetSecurityEnabledL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK^]    bool GetSecurityEnabled(void) const { return (GetPsdu()[0] & kFcfSecurityEnabled) != 0; }t(GetFramePendingL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKXW    bool GetFramePending(void) const { return (GetPsdu()[0] & kFcfFramePending) != 0; }t(
GetAckRequestL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKTS    bool GetAckRequest(void) const { return (GetPsdu()[0] & kFcfAckRequest) != 0; }t(IsPanIdCompressedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKhg    bool IsPanIdCompressed(void) const { return (GetFrameControlField() & kFcfPanidCompression) != 0; }t(IsIePresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK[Z    bool IsIePresent(void) const { return (GetFrameControlField() & kFcfIePresent) != 0; }t(GetSequenceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKJI    uint8_t GetSequence(void) const { return GetPsdu()[kSequenceIndex]; }t(SetSequenceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM Framet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM KM KSR    void SetSequence(uint8_t aSequence) { GetPsdu()[kSequenceIndex] = aSequence; }t(IsDstPanIdPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK]\    bool IsDstPanIdPresent(void) const { return IsDstPanIdPresent(GetFrameControlField()); }t(IsDstAddrPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM$Framet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM$KM$KWV    bool IsDstAddrPresent() const { return IsDstAddrPresent(GetFrameControlField()); }t(IsSrcPanIdPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMOFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMOKMOK]\    bool IsSrcPanIdPresent(void) const { return IsSrcPanIdPresent(GetFrameControlField()); }t(IsSrcAddrPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMlFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMlKMlK[Z    bool IsSrcAddrPresent(void) const { return IsSrcAddrPresent(GetFrameControlField()); }t(	GetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK76    uint16_t GetLength(void) const { return mLength; }t(	SetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK<;    void SetLength(uint16_t aLength) { mLength = aLength; }t(
GetChannelL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMEFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMEKMEK87    uint8_t GetChannel(void) const { return mChannel; }t(
SetChannelL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMMKMMK?>    void SetChannel(uint8_t aChannel) { mChannel = aChannel; }t(
GetPsduLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMUFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMUKMUK;:    uint16_t GetPsduLength(void) const { return mLength; }t(GetPsduL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM]Framet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM]KM]K-,    uint8_t *GetPsdu(void) { return mPsdu; }t(GetPsduL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMeFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMeKMeK98    const uint8_t *GetPsdu(void) const { return mPsdu; }t(	GetHeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMmFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMmKMmK32    uint8_t *GetHeader(void) { return GetPsdu(); }t(	GetHeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMuFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMuKMuK?>    const uint8_t *GetHeader(void) const { return GetPsdu(); }t(
GetPayloadL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM}Framet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM}KM}KRQ    uint8_t *GetPayload(void) { return AsNonConst(AsConst(this)->GetPayload()); }t(	GetFooterL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKPO    uint8_t *GetFooter(void) { return AsNonConst(AsConst(this)->GetFooter()); }t(GetHeaderIeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKba    uint8_t *GetHeaderIe(uint8_t aIeId) { return AsNonConst(AsConst(this)->GetHeaderIe(aIeId)); }t(GetThreadIeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKhg    uint8_t *GetThreadIe(uint8_t aSubType) { return AsNonConst(AsConst(this)->GetThreadIe(aSubType)); }t(GetMtuL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK    uint16_t GetMtu(void) const
#if !OPENTHREAD_CONFIG_MULTI_RADIO && OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
    {
        return OT_RADIO_FRAME_MAX_SIZE;
    }t(
GetFcsSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM*Framet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM*KM.K    uint8_t GetFcsSize(void) const
#if !OPENTHREAD_CONFIG_MULTI_RADIO && OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
    {
        return k154FcsSize;
    }t(IsDstAddrPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKhg    static bool IsDstAddrPresent(uint16_t aFcf) { return (aFcf & kFcfDstAddrMask) != kFcfDstAddrNone; }t(IsSrcAddrPresentL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKhg    static bool IsSrcAddrPresent(uint16_t aFcf) { return (aFcf & kFcfSrcAddrMask) != kFcfSrcAddrNone; }t(
IsVersion2015L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKgf    static bool IsVersion2015(uint16_t aFcf) { return (aFcf & kFcfFrameVersionMask) == kVersion2015; }t(GetRssiL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK?>    int8_t GetRssi(void) const { return mInfo.mRxInfo.mRssi; }t(SetRssiL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK@?    void SetRssi(int8_t aRssi) { mInfo.mRxInfo.mRssi = aRssi; }t(GetLqiL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK>=    uint8_t GetLqi(void) const { return mInfo.mRxInfo.mLqi; }t(SetLqiL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK=<    void SetLqi(uint8_t aLqi) { mInfo.mRxInfo.mLqi = aLqi; }t(IsAckedWithFramePendingL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK^]    bool IsAckedWithFramePending(void) const { return mInfo.mRxInfo.mAckedWithFramePending; }t(GetTimestampL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKRQ    const uint64_t &GetTimestamp(void) const { return mInfo.mRxInfo.mTimestamp; }t(GetMaxCsmaBackoffsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKVU    uint8_t GetMaxCsmaBackoffs(void) const { return mInfo.mTxInfo.mMaxCsmaBackoffs; }t(SetMaxCsmaBackoffsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKml    void SetMaxCsmaBackoffs(uint8_t aMaxCsmaBackoffs) { mInfo.mTxInfo.mMaxCsmaBackoffs = aMaxCsmaBackoffs; }t(GetMaxFrameRetriesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKVU    uint8_t GetMaxFrameRetries(void) const { return mInfo.mTxInfo.mMaxFrameRetries; }t(SetMaxFrameRetriesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKml    void SetMaxFrameRetries(uint8_t aMaxFrameRetries) { mInfo.mTxInfo.mMaxFrameRetries = aMaxFrameRetries; }t(IsARetransmissionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM$TxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM$KM$KJI    bool IsARetransmission(void) const { return mInfo.mTxInfo.mIsARetx; }t(SetIsARetransmissionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM,TxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM,KM,KTS    void SetIsARetransmission(bool aIsARetx) { mInfo.mTxInfo.mIsARetx = aIsARetx; }t(IsCsmaCaEnabledL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM5TxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM5KM5KNM    bool IsCsmaCaEnabled(void) const { return mInfo.mTxInfo.mCsmaCaEnabled; }t(SetCsmaCaEnabledL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM=TxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM=KM=Kba    void SetCsmaCaEnabled(bool aCsmaCaEnabled) { mInfo.mTxInfo.mCsmaCaEnabled = aCsmaCaEnabled; }t(	GetAesKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMETxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMEKMHK    const Mac::KeyMaterial &GetAesKey(void) const
    {
        return *static_cast<const Mac::KeyMaterial *>(mInfo.mTxInfo.mAesKey);
    }t(	SetAesKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMPTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMPKMPKZY    void SetAesKey(const Mac::KeyMaterial &aAesKey) { mInfo.mTxInfo.mAesKey = &aAesKey; }t(IsSecurityProcessedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMmTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMmKMmKXW    bool IsSecurityProcessed(void) const { return mInfo.mTxInfo.mIsSecurityProcessed; }t(SetIsSecurityProcessedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMuTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMuKMxK    void SetIsSecurityProcessed(bool aIsSecurityProcessed)
    {
        mInfo.mTxInfo.mIsSecurityProcessed = aIsSecurityProcessed;
    }t(IsHeaderUpdatedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKPO    bool IsHeaderUpdated(void) const { return mInfo.mTxInfo.mIsHeaderUpdated; }t(SetIsHeaderUpdatedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKji    void SetIsHeaderUpdated(bool aIsHeaderUpdated) { mInfo.mTxInfo.mIsHeaderUpdated = aIsHeaderUpdated; }t(
SetTxDelayL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKNM    void SetTxDelay(uint32_t aTxDelay) { mInfo.mTxInfo.mTxDelay = aTxDelay; }t(SetTxDelayBaseTimeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMTxFramet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKnm    void SetTxDelayBaseTime(uint32_t aTxDelayBaseTime) { mInfo.mTxInfo.mTxDelayBaseTime = aTxDelayBaseTime; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMBeacont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK    void Init(void)
    {
        mSuperframeSpec     = HostSwap16(kSuperFrameSpec);
        mGtsSpec            = 0;
        mPendingAddressSpec = 0;
    }t(IsValidL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMBeacont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK    bool IsValid(void) const
    {
        return (mSuperframeSpec == HostSwap16(kSuperFrameSpec)) && (mGtsSpec == 0) && (mPendingAddressSpec == 0);
    }t(
GetPayloadL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMBeacont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK\[    uint8_t *GetPayload(void) { return reinterpret_cast<uint8_t *>(this) + sizeof(*this); }t(
GetPayloadL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMBeacont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKnm    const uint8_t *GetPayload(void) const { return reinterpret_cast<const uint8_t *>(this) + sizeof(*this); }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM 
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM KM$K|    void Init(void)
    {
        mProtocolId = kProtocolId;
        mFlags      = kProtocolVersion << kVersionOffset;
    }t(IsValidL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM-
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM-KM-KFE    bool IsValid(void) const { return (mProtocolId == kProtocolId); }t(
GetProtocolIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM5
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM5KM5K>=    uint8_t GetProtocolId(void) const { return mProtocolId; }t(GetProtocolVersionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM=
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM=KM=KPO    uint8_t GetProtocolVersion(void) const { return mFlags >> kVersionOffset; }t(IsNativeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMF
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMFKMFKFE    bool IsNative(void) const { return (mFlags & kNativeFlag) != 0; }t(ClearNativeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppML
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMLKMLK76    void ClearNative(void) { mFlags &= ~kNativeFlag; }t(	SetNativeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMR
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMRKMRK43    void SetNative(void) { mFlags |= kNativeFlag; }t(IsJoiningPermittedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM[
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM[KM[KQP    bool IsJoiningPermitted(void) const { return (mFlags & kJoiningFlag) != 0; }t(ClearJoiningPermittedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMa
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMaKMaKBA    void ClearJoiningPermitted(void) { mFlags &= ~kJoiningFlag; }t(SetJoiningPermittedL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMg
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMgKMoKX      void SetJoiningPermitted(void)
    {
        mFlags |= kJoiningFlag;

#if OPENTHREAD_CONFIG_MAC_JOIN_BEACON_VERSION != 2 // check against kProtocolVersion
        mFlags &= ~kVersionMask;
        mFlags |= OPENTHREAD_CONFIG_MAC_JOIN_BEACON_VERSION << kVersionOffset;
#endif
    }t(GetNetworkNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMw
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMwKMwKsr    MeshCoP::NameData GetNetworkName(void) const { return MeshCoP::NameData(mNetworkName, sizeof(mNetworkName)); }t(SetNetworkNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKvu    void SetNetworkName(const MeshCoP::NameData &aNameData) { aNameData.CopyTo(mNetworkName, sizeof(mNetworkName)); }t(GetExtendedPanIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKSR    const otExtendedPanId &GetExtendedPanId(void) const { return mExtendedPanId; }t(SetExtendedPanIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppM
BeaconPayloadt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMK\[    void SetExtendedPanId(const otExtendedPanId &aExtPanId) { mExtendedPanId = aExtPanId; }t(	GetPeriodL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMCslIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKCB    uint16_t GetPeriod(void) const { return HostSwap16(mPeriod); }t(	SetPeriodL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMCslIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKHG    void SetPeriod(uint16_t aPeriod) { mPeriod = HostSwap16(aPeriod); }t(GetPhaseL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMCslIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKA@    uint16_t GetPhase(void) const { return HostSwap16(mPhase); }t(SetPhaseL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMCslIet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_frame.hppMKMKDC    void SetPhase(uint16_t aPhase) { mPhase = HostSwap16(aPhase); }t(GetModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKkFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKkKKkK/.    Mode GetMode(void) const { return mMode; }t(SetModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKsFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKsKKsK0/    void SetMode(Mode aMode) { mMode = aMode; }t(SetDefaultRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKKKK@?    void SetDefaultRssIn(int8_t aRss) { mDefaultRssIn = aRss; }t(ClearDefaultRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKKKKHG    void ClearDefaultRssIn(void) { mDefaultRssIn = kFixedRssDisabled; }t(IsInUseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKFilterEntryt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppKK	KKXW        bool IsInUse(void) const { return mFiltered || (mRssIn != kFixedRssDisabled); }t(	FindEntryM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppMFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.hppMKMKxw    FilterEntry *FindEntry(const ExtAddress &aExtAddress) { return AsNonConst(AsConst(this)->FindEntry(aExtAddress)); }t(GetArrayLengthK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppK<Nt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppK<KK?Ktemplate <typename Type, uint16_t kArrayLength> constexpr inline uint16_t GetArrayLength(const Type (&)[kArrayLength])
{
    return kArrayLength;
}t(GetArrayEndK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKONt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKOKKRKtemplate <typename Type, uint16_t kArrayLength> inline Type *GetArrayEnd(Type (&aArray)[kArrayLength])
{
    return &aArray[kArrayLength];
}t(GetArrayEndK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKbNt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKbKKeKtemplate <typename Type, uint16_t kArrayLength> inline const Type *GetArrayEnd(const Type (&aArray)[kArrayLength])
{
    return &aArray[kArrayLength];
}t(Array<Type, kMaxSize, SizeType>K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK0    Array(void)
        : mLength(0)
    {
    }t(Array<Type, kMaxSize, SizeType>K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK=<    Array(const Array &aOtherArray) { *this = aOtherArray; }t(Array<Type, kMaxSize, SizeType>K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK    explicit Array(Instance &aInstance)
        : mLength(0)
    {
        for (Type &element : mElements)
        {
            element.Init(aInstance);
        }
    }t(ClearK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK&%    void Clear(void) { mLength = 0; }t(IsEmptyK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK87    bool IsEmpty(void) const { return (mLength == 0); }t(IsFullK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKKBA    bool IsFull(void) const { return (mLength == GetMaxSize()); }t(
GetMaxSizeK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKƌArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKKRQ    IndexType GetMaxSize(void) const { return static_cast<IndexType>(kMaxSize); }t(	GetLengthK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKΌArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK87    IndexType GetLength(void) const { return mLength; }t(	SetLengthK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppK֌Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK=<    void SetLength(IndexType aLength) { mLength = aLength; }t(GetArrayBufferK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKތArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKK54    Type *GetArrayBuffer(void) { return mElements; }t(GetArrayBufferK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKKA@    const Type *GetArrayBuffer(void) const { return mElements; }t(
operator[]K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKKED    Type &operator[](IndexType aIndex) { return mElements[aIndex]; }t(
operator[]K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppKKKKQP    const Type &operator[](IndexType aIndex) const { return mElements[aIndex]; }t(AtK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM
Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM
KM
K]\    Type *At(IndexType aIndex) { return (aIndex < mLength) ? &mElements[aIndex] : nullptr; }t(AtK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMKih    const Type *At(IndexType aIndex) const { return (aIndex < mLength) ? &mElements[aIndex] : nullptr; }t(FrontK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMK('    Type *Front(void) { return At(0); }t(FrontK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM&Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM&KM&K43    const Type *Front(void) const { return At(0); }t(BackK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM.Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM.KM.K10    Type *Back(void) { return At(mLength - 1); }t(BackK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM6Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM6KM6K=<    const Type *Back(void) const { return At(mLength - 1); }t(PushBackK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMCArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMCKMCKyx    Error PushBack(const Type &aEntry) { return IsFull() ? kErrorNoBufs : (mElements[mLength++] = aEntry, kErrorNone); }t(PushBackK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMNArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMNKMNKPO    Type *PushBack(void) { return IsFull() ? nullptr : &mElements[mLength++]; }t(PopBackK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMVArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMVKMVKPO    Type *PopBack(void) { return IsEmpty() ? nullptr : &mElements[--mLength]; }t(IndexOfK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMbArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMbKMbKpo    IndexType IndexOf(const Type &aElement) const { return static_cast<IndexType>(&aElement - &mElements[0]); }t(RemoveK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMoArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMoKMwK    void Remove(Type &aElement)
    {
        Type *lastElement = PopBack();

        if (lastElement != &aElement)
        {
            aElement = *lastElement;
        }
    }t(FindK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMKWV    Type *Find(const Type &aEntry) { return AsNonConst(AsConst(this)->Find(aEntry)); }t(FindK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMKX3      const Type *Find(const Type &aEntry) const
    {
        const Type *matched = nullptr;

        for (const Type &element : *this)
        {
            if (element == aEntry)
            {
                matched = &element;
                break;
            }
        }

        return matched;
    }t(ContainsK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMKPO    bool Contains(const Type &aEntry) const { return Find(aEntry) != nullptr; }t(FindMatchingK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMK    template <typename Indicator> Type *FindMatching(const Indicator &aIndicator)
    {
        return AsNonConst(AsConst(this)->FindMatching(aIndicator));
    }t(FindMatchingK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMKXl      template <typename Indicator> const Type *FindMatching(const Indicator &aIndicator) const
    {
        const Type *matched = nullptr;

        for (const Type &element : *this)
        {
            if (element.Matches(aIndicator))
            {
                matched = &element;
                break;
            }
        }

        return matched;
    }t(ContainsMatchingK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKMK    template <typename Indicator> bool ContainsMatching(const Indicator &aIndicator) const
    {
        return FindMatching(aIndicator) != nullptr;
    }t(RemoveMatchingK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKM	K    template <typename Indicator> void RemoveMatching(const Indicator &aIndicator)
    {
        Type *entry = FindMatching(aIndicator);

        if (entry != nullptr)
        {
            Remove(*entry);
        }
    }t(RemoveAllMatchingK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMKM-KX:      template <typename Indicator> void RemoveAllMatching(const Indicator &aIndicator)
    {
        for (IndexType index = 0; index < GetLength();)
        {
            Type &entry = mElements[index];

            if (entry.Matches(aIndicator))
            {
                Remove(entry);

                // When the entry is removed from the array it is
                // replaced with the last element. In this case, we do
                // not increment `index`.
            }
            else
            {
                index++;
            }
        }
    }t(	operator=K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM8Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM8KMBK    Array &operator=(const Array &aOtherArray)
    {
        Clear();

        for (const Type &otherElement : aOtherArray)
        {
            IgnoreError(PushBack(otherElement));
        }

        return *this;
    }t(IsInArrayBufferK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMPArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMPKMSK    bool IsInArrayBuffer(const Type *aEntry) const
    {
        return (&mElements[0] <= aEntry) && (aEntry < GetArrayEnd(mElements));
    }t(beginK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMYArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMYKMYK65    Type       *begin(void) { return &mElements[0]; }t(endK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMZArrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppMZKMZK:9    Type       *end(void) { return &mElements[mLength]; }t(beginK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM[Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM[KM[K<;    const Type *begin(void) const { return &mElements[0]; }t(endK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM\Arrayt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/array.hppM\KM\K@?    const Type *end(void) const { return &mElements[mLength]; }t(IsDoneT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKJItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKJKKJK98    bool IsDone(void) const { return mItem == nullptr; }t(
operator++T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKTItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKTKKTKLK    void operator++(void) { static_cast<IteratorType *>(this)->Advance(); }t(
operator++T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppK^ItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppK^KK^KKJ    void operator++(int) { static_cast<IteratorType *>(this)->Advance(); }t(	operator*T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKiItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKiKKiK10    ItemType &operator*(void) { return *mItem; }t(
operator->T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKrItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKrKKrK10    ItemType *operator->(void) { return mItem; }t(
operator==T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppK~ItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppK~KK~KXW    bool operator==(const IteratorType &aOther) const { return mItem == aOther.mItem; }t(
operator!=T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKKKKXW    bool operator!=(const IteratorType &aOther) const { return mItem != aOther.mItem; }t('ItemPtrIterator<ItemType, IteratorType>T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKKKK>    ItemPtrIterator(void)
        : mItem(nullptr)
    {
    }t('ItemPtrIterator<ItemType, IteratorType>T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKItemPtrIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/iterator_utils.hppKKKKN    explicit ItemPtrIterator(ItemType *item)
        : mItem(item)
    {
    }t(GetNextQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKNLinkedListEntryt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKNKKNKrq    const Type *GetNext(void) const { return static_cast<const Type *>(static_cast<const Type *>(this)->mNext); }t(GetNextQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKVLinkedListEntryt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKVKKVKZY    Type *GetNext(void) { return static_cast<Type *>(static_cast<Type *>(this)->mNext); }t(SetNextQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK^LinkedListEntryt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK^KK^KLK    void SetNext(Type *aNext) { static_cast<Type *>(this)->mNext = aNext; }t(LinkedList<Type>Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKr
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKrKKuK9    LinkedList(void)
        : mHead(nullptr)
    {
    }t(GetHeadQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK}
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK}KK}K*)    Type *GetHead(void) { return mHead; }t(GetHeadQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK65    const Type *GetHead(void) const { return mHead; }t(SetHeadQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK10    void SetHead(Type *aHead) { mHead = aHead; }t(ClearQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK*)    void Clear(void) { mHead = nullptr; }t(IsEmptyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK<;    bool IsEmpty(void) const { return (mHead == nullptr); }t(PushQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK_    void Push(Type &aEntry)
    {
        aEntry.SetNext(mHead);
        mHead = &aEntry;
    }t(	PushAfterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK    void PushAfter(Type &aEntry, Type &aPrevEntry)
    {
        aEntry.SetNext(aPrevEntry.GetNext());
        aPrevEntry.SetNext(&aEntry);
    }t(PopQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK    Type *Pop(void)
    {
        Type *entry = mHead;

        if (mHead != nullptr)
        {
            mHead = mHead->GetNext();
        }

        return entry;
    }t(PopAfterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK֌
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKKXq      Type *PopAfter(Type *aPrevEntry)
    {
        Type *entry;

        if (aPrevEntry == nullptr)
        {
            entry = Pop();
        }
        else
        {
            entry = aPrevEntry->GetNext();

            if (entry != nullptr)
            {
                aPrevEntry->SetNext(entry->GetNext());
            }
        }

        return entry;
    }t(ContainsQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppK
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppKKKK    bool Contains(const Type &aEntry) const
    {
        const Type *prev;

        return Find(aEntry, prev) == kErrorNone;
    }t(ContainsMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM

LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
KM
K    template <typename Indicator> bool ContainsMatching(const Indicator &aIndicator) const
    {
        return FindMatching(aIndicator) != nullptr;
    }t(AddQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKM&K    Error Add(Type &aEntry)
    {
        Error error = kErrorNone;

        if (Contains(aEntry))
        {
            error = kErrorAlready;
        }
        else
        {
            Push(aEntry);
        }

        return error;
    }t(RemoveQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM4
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM4KM?K    Error Remove(const Type &aEntry)
    {
        Type *prev;
        Error error = Find(aEntry, prev);

        if (error == kErrorNone)
        {
            PopAfter(prev);
        }

        return error;
    }t(RemoveMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMT
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMTKM_KX      template <typename Indicator> Type *RemoveMatching(const Indicator &aIndicator)
    {
        Type *prev;
        Type *entry = FindMatching(aIndicator, prev);

        if (entry != nullptr)
        {
            PopAfter(prev);
        }

        return entry;
    }t(RemoveAllMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMo
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMoKMKX      template <typename Indicator> void RemoveAllMatching(const Indicator &aIndicator, LinkedList &aRemovedList)
    {
        Type *entry;
        Type *prev;
        Type *next;

        for (prev = nullptr, entry = GetHead(); entry != nullptr; entry = next)
        {
            next = entry->GetNext();

            if (entry->Matches(aIndicator))
            {
                PopAfter(prev);
                aRemovedList.Push(*entry);

                // When the entry is removed from the list
                // we keep the `prev` pointer same as before.
            }
            else
            {
                prev = entry;
            }
        }
    }t(FindQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKMKX      Error Find(const Type &aEntry, const Type *&aPrevEntry) const
    {
        Error error = kErrorNotFound;

        aPrevEntry = nullptr;

        for (const Type *entry = mHead; entry != nullptr; aPrevEntry = entry, entry = entry->GetNext())
        {
            if (entry == &aEntry)
            {
                error = kErrorNone;
                break;
            }
        }

        return error;
    }t(FindQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKMK    Error Find(const Type &aEntry, Type *&aPrevEntry)
    {
        return AsConst(this)->Find(aEntry, const_cast<const Type *&>(aPrevEntry));
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKMKX0      template <typename Indicator>
    const Type *FindMatching(const Type      *aBegin,
                             const Type      *aEnd,
                             const Indicator &aIndicator,
                             const Type     *&aPrevEntry) const
    {
        const Type *entry;

        aPrevEntry = nullptr;

        for (entry = aBegin; entry != aEnd; aPrevEntry = entry, entry = entry->GetNext())
        {
            if (entry->Matches(aIndicator))
            {
                break;
            }
        }

        return entry;
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKMKX      template <typename Indicator>
    Type *FindMatching(const Type *aBegin, const Type *aEnd, const Indicator &aIndicator, Type *&aPrevEntry)
    {
        return AsNonConst(FindMatching(aBegin, aEnd, aIndicator, const_cast<const Type *&>(aPrevEntry)));
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMKMK    template <typename Indicator> const Type *FindMatching(const Indicator &aIndicator, const Type *&aPrevEntry) const
    {
        return FindMatching(mHead, nullptr, aIndicator, aPrevEntry);
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM&
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM&KM)K    template <typename Indicator> Type *FindMatching(const Indicator &aIndicator, Type *&aPrevEntry)
    {
        return AsNonConst(AsConst(this)->FindMatching(aIndicator, const_cast<const Type *&>(aPrevEntry)));
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM9
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM9KM>K    template <typename Indicator> const Type *FindMatching(const Indicator &aIndicator) const
    {
        const Type *prev;

        return FindMatching(aIndicator, prev);
    }t(FindMatchingQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMN
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMNKMQK    template <typename Indicator> Type *FindMatching(const Indicator &aIndicator)
    {
        return AsNonConst(AsConst(this)->FindMatching(aIndicator));
    }t(GetTailQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMY
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMYKMfKX      const Type *GetTail(void) const
    {
        const Type *tail = mHead;

        if (tail != nullptr)
        {
            while (tail->GetNext() != nullptr)
            {
                tail = tail->GetNext();
            }
        }

        return tail;
    }t(GetTailQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMn
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMnKMnKIH    Type *GetTail(void) { return AsNonConst(AsConst(this)->GetTail()); }t(beginQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMt
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMtKMtK98    Iterator begin(void) { return Iterator(GetHead()); }t(endQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMu
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMuKMuK54    Iterator end(void) { return Iterator(nullptr); }t(beginQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMw
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMwKMwKIH    ConstIterator begin(void) const { return ConstIterator(GetHead()); }t(endQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMx
LinkedListt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMxKMxKED    ConstIterator end(void) const { return ConstIterator(nullptr); }t(IteratorQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMIteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMK	MK
o        explicit Iterator(Type *aItem)
            : ItemPtrIterator<Type, Iterator>(aItem)
        {
        }t(AdvanceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMIteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMK	MK98        void Advance(void) { mItem = mItem->GetNext(); }t(
ConstIteratorQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
ConstIteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMK	MK
        explicit ConstIterator(const Type *aItem)
            : ItemPtrIterator<const Type, ConstIterator>(aItem)
        {
        }t(AdvanceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppM
ConstIteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/linked_list.hppMK	MK98        void Advance(void) { mItem = mItem->GetNext(); }t(Pool<Type, kPoolSize>J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKHPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKHKKOK    Pool(void)
        : mFreeList()
    {
        for (Type &entry : mPool)
        {
            mFreeList.Push(entry);
        }
    }t(Pool<Type, kPoolSize>J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKZPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKZKKbK    explicit Pool(Instance &aInstance)
        : mFreeList()
    {
        for (Type &entry : mPool)
        {
            entry.Init(aInstance);
            mFreeList.Push(entry);
        }
    }t(AllocateJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKkPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKkKKkK54    Type *Allocate(void) { return mFreeList.Pop(); }t(FreeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKvPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKvKKvK87    void Free(Type &aEntry) { mFreeList.Push(aEntry); }t(FreeAllJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppK|Poolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppK|KKK    void FreeAll(void)
    {
        mFreeList.Clear();

        for (Type &entry : mPool)
        {
            mFreeList.Push(entry);
        }
    }t(GetSizeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKKKK76    uint16_t GetSize(void) const { return kPoolSize; }t(IsPoolEntryJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKKKKwv    bool IsPoolEntry(const Type &aObject) const { return (&mPool[0] <= &aObject) && (&aObject < GetArrayEnd(mPool)); }t(
GetIndexOfJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKKKKed    uint16_t GetIndexOf(const Type &aEntry) const { return static_cast<uint16_t>(&aEntry - mPool); }t(
GetEntryAtJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKKKK@?    Type &GetEntryAt(uint16_t aIndex) { return mPool[aIndex]; }t(
GetEntryAtJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKPoolt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/pool.hppKKKKLK    const Type &GetEntryAt(uint16_t aIndex) const { return mPool[aIndex]; }t(	SchedulerM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKP	Schedulert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKPK	KSK
H        Scheduler(void)
            : mTail(nullptr)
        {
        }t(AreTaskletsPendingM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppK\	Schedulert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppK\K	K\KIH        bool AreTaskletsPending(void) const { return mTail != nullptr; }t(TaskletM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKyTasklett(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKyKK~K    Tasklet(Instance &aInstance, Handler aHandler)
        : InstanceLocator(aInstance)
        , mHandler(aHandler)
        , mNext(nullptr)
    {
    }t(IsPostedM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKTasklett(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKKKK=<    bool IsPosted(void) const { return (mNext != nullptr); }t(RunTaskM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKTasklett(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKKKK,+    void RunTask(void) { mHandler(*this); }t("TaskletIn<Owner, HandleTaskletPtr>M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppK	TaskletInt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKKKKc    explicit TaskletIn(Instance &aInstance)
        : Tasklet(aInstance, HandleTasklet)
    {
    }t(TaskletContextM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKǌTaskletContextt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKKKK    TaskletContext(Instance &aInstance, Handler aHandler, void *aContext)
        : Tasklet(aInstance, aHandler)
        , mContext(aContext)
    {
    }t(
GetContextM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKӌTaskletContextt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tasklet.hppKKKK0/    void *GetContext(void) { return mContext; }t(IsLessS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/serial_number.hppK@SerialNumbert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/serial_number.hppK@KKJKXX      template <typename UintType> static bool IsLess(UintType aFirst, UintType aSecond)
    {
        static_assert(TypeTraits::IsSame<UintType, uint8_t>::kValue || TypeTraits::IsSame<UintType, uint16_t>::kValue ||
                          TypeTraits::IsSame<UintType, uint32_t>::kValue ||
                          TypeTraits::IsSame<UintType, uint64_t>::kValue,
                      "UintType MUST be an 8, 16, 32, or 64 bit `uint` type");

        static constexpr UintType kNegativeMask = (NumericLimits<UintType>::kMax >> 1) + 1;

        return ((aFirst - aSecond) & kNegativeMask) != 0;
    }t(	IsGreaterS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/serial_number.hppK\SerialNumbert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/serial_number.hppK\KK_K    template <typename UintType> static bool IsGreater(UintType aFirst, UintType aSecond)
    {
        return IsLess(aSecond, aFirst);
    }t(TimeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKOTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKOKKOK    Time(void) = default;t(TimeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKWTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKWKKWK98    explicit Time(uint32_t aValue) { SetValue(aValue); }t(GetValueJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppK_Timet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppK_KK_K54    uint32_t GetValue(void) const { return mValue; }t(SetValueJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKgTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKgKKgK87    void SetValue(uint32_t aValue) { mValue = aValue; }t(	operator-J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKvTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKvKKvKTS    uint32_t operator-(const Time &aOther) const { return mValue - aOther.mValue; }t(	operator+J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKRQ    Time operator+(uint32_t aDuration) const { return Time(mValue + aDuration); }t(	operator-J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKRQ    Time operator-(uint32_t aDuration) const { return Time(mValue - aDuration); }t(
operator+=J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKA@    void operator+=(uint32_t aDuration) { mValue += aDuration; }t(
operator-=J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKA@    void operator-=(uint32_t aDuration) { mValue -= aDuration; }t(
operator==J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKRQ    bool operator==(const Time &aOther) const { return mValue == aOther.mValue; }t(	operator<J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKed    bool operator<(const Time &aOther) const { return SerialNumber::IsLess(mValue, aOther.mValue); }t(
operator>=J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKLK    bool operator>=(const Time &aOther) const { return !(*this < aOther); }t(
operator<=J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppǨTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKLK    bool operator<=(const Time &aOther) const { return (aOther >= *this); }t(	operator>J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppK׌Timet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKJI    bool operator>(const Time &aOther) const { return (aOther < *this); }t(GetDistantFutureJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKPO    Time GetDistantFuture(void) const { return Time(mValue + kDistantFuture); }t(GetDistantPastJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKNM    Time GetDistantPast(void) const { return Time(mValue - kDistantFuture); }t(	SecToMsecJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppKKKKXW    static uint32_t constexpr SecToMsec(uint32_t aSeconds) { return aSeconds * 1000u; }t(	MsecToSecJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppMTimet(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time.hppMKMKba    static uint32_t constexpr MsecToSec(uint32_t aMilliseconds) { return aMilliseconds / 1000u; }t(GetFireTimeK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK]Timert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK]KK]K76    Time GetFireTime(void) const { return mFireTime; }t(	IsRunningK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKfTimert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKfKKfK;:    bool IsRunning(void) const { return (mNext != this); }t(	SchedulerK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKu	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKuK	KxK
l        explicit Scheduler(Instance &aInstance)
            : InstanceLocator(aInstance)
        {
        }t(TimerK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKTimert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKKKK    Timer(Instance &aInstance, Handler aHandler)
        : InstanceLocator(aInstance)
        , mHandler(aHandler)
        , mNext(this)
    {
    }t(FiredK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKTimert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hpp      KKKK*)    void Fired(void) { mHandler(*this); }t(	SchedulerK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKK	KK
m        explicit Scheduler(Instance &aInstance)
            : Timer::Scheduler(aInstance)
        {
        }t(AddK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKK	KKXW        void Add(TimerMilli &aTimer) { Timer::Scheduler::Add(aTimer, sAlarmMilliApi); }t(RemoveK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKK	KK^]        void Remove(TimerMilli &aTimer) { Timer::Scheduler::Remove(aTimer, sAlarmMilliApi); }t(	RemoveAllK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKK	KKNM        void RemoveAll(void) { Timer::Scheduler::RemoveAll(sAlarmMilliApi); }t(
ProcessTimersK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK	Schedulert(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKK	KKVU        void ProcessTimers(void) { Timer::Scheduler::ProcessTimers(sAlarmMilliApi); }t(
TimerMilliK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK
TimerMillit(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKKKKf    TimerMilli(Instance &aInstance, Handler aHandler)
        : Timer(aInstance, aHandler)
    {
    }t(GetNowK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppK
TimerMillit(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppKKKKRQ    static TimeMilli GetNow(void) { return TimeMilli(otPlatAlarmMilliGetNow()); }t(#TimerMilliIn<Owner, HandleTimerPtr>K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppMTimerMilliInt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppMKMKg    explicit TimerMilliIn(Instance &aInstance)
        : TimerMilli(aInstance, HandleTimer)
    {
    }t(TimerMilliContextK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppM(TimerMilliContextt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppM(KM,K    TimerMilliContext(Instance &aInstance, Handler aHandler, void *aContext)
        : TimerMilli(aInstance, aHandler)
        , mContext(aContext)
    {
    }t(
GetContextK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppM4TimerMilliContextt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/timer.hppM4KM4K0/    void *GetContext(void) { return mContext; }t(GetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKJ	BitVectort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKJKKNK    bool Get(uint16_t aIndex) const
    {
        OT_ASSERT(aIndex < N);
        return (mMask[aIndex / 8] & (0x80 >> (aIndex % 8))) != 0;
    }t(SetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKW	BitVectort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKWKKcKX      void Set(uint16_t aIndex, bool aValue)
    {
        OT_ASSERT(aIndex < N);

        if (aValue)
        {
            mMask[aIndex / 8] |= 0x80 >> (aIndex % 8);
        }
        else
        {
            mMask[aIndex / 8] &= ~(0x80 >> (aIndex % 8));
        };
    }t(HasAnyP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKl	BitVectort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/bit_vector.hppKlKKzK    bool HasAny(void) const
    {
        bool rval = false;

        for (uint8_t b : mMask)
        {
            if (b != 0)
            {
                ExitNow(rval = true);
            }
        }

    exit:
        return rval;
    }t(GetExtPanIdU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/extended_panid.hppK_ExtendedPanIdManagert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/extended_panid.hppK_KK_KLK    const ExtendedPanId &GetExtPanId(void) const { return mExtendedPanId; }t(GetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKtPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKtKKtKGF    const uint8_t *GetBytes(void) const { return mPrefix.mFields.m8; }t(GetSubnetIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppK|Prefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppK|KK|KTS    uint16_t GetSubnetId(void) const { return HostSwap16(mPrefix.mFields.m16[3]); }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKK65    uint8_t GetLength(void) const { return mLength; }t(GetBytesSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKKHG    uint8_t GetBytesSize(void) const { return SizeForLength(mLength); }t(SetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKKfe    void Set(const NetworkPrefix &aNetworkPrefix) { Set(aNetworkPrefix.m8, NetworkPrefix::kLength); }t(SetSubnetIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKK]\    void SetSubnetId(uint16_t aSubnetId) { mPrefix.mFields.m16[3] = HostSwap16(aSubnetId); }t(	SetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppKKKKA@    bool IsValid(void) const { return (mLength <= kMaxLength); }t(
SizeForLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMPrefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKVU    static uint8_t SizeForLength(uint8_t aLength) { return BitVectorBytes(aLength); }t(IsValidNat64N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM<Prefixt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM<KM<KPO    bool IsValidNat64(void) const { return IsValidNat64PrefixLength(mLength); }t(GetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMInterfaceIdentifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMK?>    const uint8_t *GetBytes(void) const { return mFields.m8; }t(
GetLocatorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMInterfaceIdentifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKKJ    uint16_t GetLocator(void) const { return HostSwap16(mFields.m16[3]); }t(
SetLocatorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM
InterfaceIdentifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM
KM
KRQ    void SetLocator(uint16_t aLocator) { mFields.m16[3] = HostSwap16(aLocator); }t(GetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM[Addresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM[KM[K?>    const uint8_t *GetBytes(void) const { return mFields.m8; }t(SetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMdAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMdKMdKRQ    void SetBytes(const uint8_t *aBuffer) { memcpy(mFields.m8, aBuffer, kSize); }t(IsMulticastN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKCB    bool IsMulticast(void) const { return mFields.m8[0] == 0xff; }t(SetToRoutingLocatorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM	Addresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM	KMK    void SetToRoutingLocator(const NetworkPrefix &aNetworkPrefix, uint16_t aRloc16)
    {
        SetToLocator(aNetworkPrefix, aRloc16);
    }t(SetToAnycastLocatorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMK    void SetToAnycastLocator(const NetworkPrefix &aNetworkPrefix, uint16_t aAloc16)
    {
        SetToLocator(aNetworkPrefix, aAloc16);
    }t(	GetPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM!Addresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM!KM$K    const NetworkPrefix &GetPrefix(void) const
    {
        return static_cast<const NetworkPrefix &>(mFields.mComponents.mNetworkPrefix);
    }t(	GetPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM-Addresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppM-KM-Ka`    void GetPrefix(uint8_t aLength, Prefix &aPrefix) const { aPrefix.Set(mFields.m8, aLength); }t(	SetPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMPAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMPKMPKts    void SetPrefix(const uint8_t *aPrefix, uint8_t aPrefixLength) { CopyBits(mFields.m8, aPrefix, aPrefixLength); }t(SetMulticastNetworkPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMtAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMtKMwK    void SetMulticastNetworkPrefix(const NetworkPrefix &aNetworkPrefix)
    {
        SetMulticastNetworkPrefix(aNetworkPrefix.m8, NetworkPrefix::kLength);
    }t(SetMulticastNetworkPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMK    void SetMulticastNetworkPrefix(const Prefix &aPrefix)
    {
        SetMulticastNetworkPrefix(aPrefix.GetBytes(), aPrefix.GetLength());
    }t(GetIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMK    const InterfaceIdentifier &GetIid(void) const
    {
        return static_cast<const InterfaceIdentifier &>(mFields.mComponents.mIid);
    }t(GetIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKon    InterfaceIdentifier &GetIid(void) { return static_cast<InterfaceIdentifier &>(mFields.mComponents.mIid); }t(SetIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKFE    void SetIid(const InterfaceIdentifier &aIid) { GetIid() = aIid; }t(	operator<N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMAddresst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_address.hppMKMKwv    bool operator<(const Address &aOther) const { return memcmp(mFields.m8, aOther.mFields.m8, sizeof(Address)) < 0; }t(IsRoutePreferenceValidX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKrNt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKrKKuKinline bool IsRoutePreferenceValid(int8_t aPref)
{
    return (aPref == kRoutePreferenceLow) || (aPref == kRoutePreferenceMedium) || (aPref == kRoutePreferenceHigh);
}t(RoutePreferenceToValueX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKNt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKX$  inline uint8_t RoutePreferenceToValue(int8_t aPref)
{
    constexpr uint8_t kHigh   = 1; // 01
    constexpr uint8_t kMedium = 0; // 00
    constexpr uint8_t kLow    = 3; // 11

    OT_ASSERT(IsRoutePreferenceValid(aPref));

    return (aPref == 0) ? kMedium : ((aPref > 0) ? kHigh : kLow);
}t(RoutePreferenceFromValueX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKNt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKX  inline RoutePreference RoutePreferenceFromValue(uint8_t aValue)
{
    constexpr uint8_t kMask = 3; // First two bits.

    static const RoutePreference kRoutePreferences[] = {
        /* 0 (00)  -> */ kRoutePreferenceMedium,
        /* 1 (01)  -> */ kRoutePreferenceHigh,
        /* 2 (10)  -> */ kRoutePreferenceMedium, // Per RFC-4191, the reserved value (10) MUST be treated as (00)
        /* 3 (11)  -> */ kRoutePreferenceLow,
    };

    return kRoutePreferences[aValue & kMask];
}t(	GetPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKOnMeshPrefixConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKNM    const Ip6::Prefix &GetPrefix(void) const { return AsCoreType(&mPrefix); }t(	GetPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKɌOnMeshPrefixConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKBA    Ip6::Prefix &GetPrefix(void) { return AsCoreType(&mPrefix); }t(
GetPreferenceX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKьOnMeshPrefixConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKxw    RoutePreference GetPreference(void) const { return RoutePreferenceFromValue(RoutePreferenceToValue(mPreference)); }t(	GetPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKExternalRouteConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppKKKKNM    const Ip6::Prefix &GetPrefix(void) const { return AsCoreType(&mPrefix); }t(	GetPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMExternalRouteConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMKMKBA    Ip6::Prefix &GetPrefix(void) { return AsCoreType(&mPrefix); }t(	SetPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppM
ExternalRouteConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppM
KM
KFE    void SetPrefix(const Ip6::Prefix &aPrefix) { mPrefix = aPrefix; }t(
GetServerDataX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMOServerConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMOK	MOKpo        void GetServerData(ServerData &aServerData) const { aServerData.Init(mServerData, mServerDataLength); }t(GetServiceDataX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMf
ServiceConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMfKMfKrq    void GetServiceData(ServiceData &aServiceData) const { aServiceData.Init(mServiceData, mServiceDataLength); }t(GetServerConfigX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMn
ServiceConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMnKMnKqp    const ServerConfig &GetServerConfig(void) const { return static_cast<const ServerConfig &>(mServerConfig); }t(GetServerConfigX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMv
ServiceConfigt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_types.hppMvKMvK_^    ServerConfig &GetServerConfig(void) { return static_cast<ServerConfig &>(mServerConfig); }t(
DeviceModeO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMD
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMDKMDK76    explicit DeviceMode(uint8_t aMode) { Set(aMode); }t(
DeviceModeO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppML
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMLKMLKFE    explicit DeviceMode(ModeConfig aModeConfig) { Set(aModeConfig); }t(GetO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMT
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMTKMTK.-    uint8_t Get(void) const { return mMode; }t(SetO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM\
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM\KM\K?>    void Set(uint8_t aMode) { mMode = aMode | kModeReserved; }t(IsRxOnWhenIdleO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMu
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMuKMuKQP    bool IsRxOnWhenIdle(void) const { return (mMode & kModeRxOnWhenIdle) != 0; }t(IsFullThreadDeviceO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM~
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM~KM~KYX    bool IsFullThreadDevice(void) const { return (mMode & kModeFullThreadDevice) != 0; }t(GetNetworkDataTypeO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMK    NetworkData::Type GetNetworkDataType(void) const
    {
        return (mMode & kModeFullNetworkData) ? NetworkData::kFullSet : NetworkData::kStableSubset;
    }t(IsMinimalEndDeviceO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMK    bool IsMinimalEndDevice(void) const
    {
        return (mMode & (kModeFullThreadDevice | kModeRxOnWhenIdle)) != (kModeFullThreadDevice | kModeRxOnWhenIdle);
    }t(IsValidO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
DeviceModet(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKSR    bool IsValid(void) const { return !IsFullThreadDevice() || IsRxOnWhenIdle(); }t(GetPartitionIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKA@    uint32_t GetPartitionId(void) const { return mPartitionId; }t(SetPartitionIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKPO    void SetPartitionId(uint32_t aPartitionId) { mPartitionId = aPartitionId; }t(GetWeightingO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMK<;    uint8_t GetWeighting(void) const { return mWeighting; }t(SetWeightingO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKGF    void SetWeighting(uint8_t aWeighting) { mWeighting = aWeighting; }t(GetDataVersionO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMK    uint8_t GetDataVersion(NetworkData::Type aType) const
    {
        return (aType == NetworkData::kFullSet) ? mDataVersion : mStableDataVersion;
    }t(SetDataVersionO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKGF    void SetDataVersion(uint8_t aVersion) { mDataVersion = aVersion; }t(SetStableDataVersionO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKSR    void SetStableDataVersion(uint8_t aVersion) { mStableDataVersion = aVersion; }t(GetLeaderRouterIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKFE    uint8_t GetLeaderRouterId(void) const { return mLeaderRouterId; }t(SetLeaderRouterIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM
LeaderDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKON    void SetLeaderRouterId(uint8_t aRouterId) { mLeaderRouterId = aRouterId; }t(ClearO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMRouterIdSett(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKHG    void Clear(void) { memset(mRouterIdSet, 0, sizeof(mRouterIdSet)); }t(ContainsO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMRouterIdSett(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKon    bool Contains(uint8_t aRouterId) const { return (mRouterIdSet[aRouterId / 8] & MaskFor(aRouterId)) != 0; }t(AddO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMRouterIdSett(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKWV    void Add(uint8_t aRouterId) { mRouterIdSet[aRouterId / 8] |= MaskFor(aRouterId); }t(RemoveO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM'RouterIdSett(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM'KM'K[Z    void Remove(uint8_t aRouterId) { mRouterIdSet[aRouterId / 8] &= ~MaskFor(aRouterId); }t(MaskForO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM2RouterIdSett(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM2KM2KTS    static uint8_t MaskFor(uint8_t aRouterId) { return (0x80 >> (aRouterId % 8)); }t(ChildIdFromRloc16O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKKMKKVUinline uint16_t ChildIdFromRloc16(uint16_t aRloc16) { return aRloc16 & kMaxChildId; }t(RouterIdFromRloc16O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMUNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMUKMUK[Zinline uint8_t RouterIdFromRloc16(uint16_t aRloc16) { return aRloc16 >> kRouterIdOffset; }t(
RouterIdMatchO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM`Nt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppM`KMcKinline bool RouterIdMatch(uint16_t aRloc16A, uint16_t aRloc16B)
{
    return RouterIdFromRloc16(aRloc16A) == RouterIdFromRloc16(aRloc16B);
}t(ServiceIdFromAlocO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMmNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMmKMmKsrinline uint8_t ServiceIdFromAloc(uint16_t aAloc16) { return static_cast<uint8_t>(aAloc16 - kAloc16ServiceStart); }t(ServiceAlocFromIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMwNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMwKMzK}inline uint16_t ServiceAlocFromId(uint8_t aServiceId)
{
    return static_cast<uint16_t>(aServiceId + kAloc16ServiceStart);
}t(CommissionerAloc16FromIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKinline uint16_t CommissionerAloc16FromId(uint16_t aSessionId)
{
    return static_cast<uint16_t>((aSessionId & kAloc16CommissionerMask) + kAloc16CommissionerStart);
}t(Rloc16FromRouterIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKvuinline uint16_t Rloc16FromRouterId(uint8_t aRouterId) { return static_cast<uint16_t>(aRouterId << kRouterIdOffset); }t(IsActiveRouterO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMNt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_types.hppMKMKYXinline bool IsActiveRouter(uint16_t aRloc16) { return ChildIdFromRloc16(aRloc16) == 0; }t(GetFailureRateR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKTSuccessRateTrackert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKTKKTKA@    uint16_t GetFailureRate(void) const { return mFailureRate; }t(GetSuccessRateR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppK\SuccessRateTrackert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppK\KK\KQP    uint16_t GetSuccessRate(void) const { return kMaxRateValue - mFailureRate; }t(
HasAverageR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppK|RssAveragert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppK|KK|K:9    bool HasAverage(void) const { return (mCount != 0); }t(GetRawR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKRssAveragert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKKKK54    uint16_t GetRaw(void) const { return mAverage; }t(
GetAverageR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKՌLqiAveragert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKKKK87    uint8_t GetAverage(void) const { return mAverage; }t(GetCountR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppK݌LqiAveragert(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppKKKK43    uint8_t GetCount(void) const { return mCount; }t(InitR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppM=LinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppM=KM=KML    void Init(Instance &aInstance) { InstanceLocatorInit::Init(aInstance); }t(CleaAverageRssR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMILinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMIKMIK87    void CleaAverageRss(void) { mRssAverager.Clear(); }t(
GetAverageRssR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMYLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMYKMYKKJ    int8_t GetAverageRss(void) const { return mRssAverager.GetAverage(); }t(GetAverageRssRawR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMbLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMbKMbKLK    uint16_t GetAverageRssRaw(void) const { return mRssAverager.GetRaw(); }t(GetLinkQualityR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMKDC    LinkQuality GetLinkQuality(void) const { return mLinkQuality; }t(
GetLastRssR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMK76    int8_t GetLastRss(void) const { return mLastRss; }t(AddFrameTxStatusR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMK    void AddFrameTxStatus(bool aTxStatus)
    {
        mFrameErrorRate.AddSample(aTxStatus, OPENTHREAD_CONFIG_FRAME_TX_ERR_RATE_AVERAGING_WINDOW);
    }t(AddMessageTxStatusR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMK    void AddMessageTxStatus(bool aTxStatus)
    {
        mMessageErrorRate.AddSample(aTxStatus, OPENTHREAD_CONFIG_IPV6_TX_ERR_RATE_AVERAGING_WINDOW);
    }t(GetFrameErrorRateR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMKXW    uint16_t GetFrameErrorRate(void) const { return mFrameErrorRate.GetFailureRate(); }t(GetMessageErrorRateR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMK\[    uint16_t GetMessageErrorRate(void) const { return mMessageErrorRate.GetFailureRate(); }t(SetLinkQualityR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMLinkQualityInfot(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/link_quality.hppMKMKSR    void SetLinkQuality(LinkQuality aLinkQuality) { mLinkQuality = aLinkQuality; }t(
GetNextBufferM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKK65    Buffer *GetNextBuffer(void) { return GetNext(); }t(
GetNextBufferM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKBA    const Buffer *GetNextBuffer(void) const { return GetNext(); }t(
SetNextBufferM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKK:9    void SetNextBuffer(Buffer *aNext) { SetNext(aNext); }t(GetMetadataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKJI    Metadata       &GetMetadata(void) { return mBuffer.mHead.mMetadata; }t(GetMetadataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKPO    const Metadata &GetMetadata(void) const { return mBuffer.mHead.mMetadata; }t(GetFirstDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKFE    uint8_t       *GetFirstData(void) { return mBuffer.mHead.mData; }t(GetFirstDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKLK    const uint8_t *GetFirstData(void) const { return mBuffer.mHead.mData; }t(GetDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKK;:    uint8_t       *GetData(void) { return mBuffer.mData; }t(GetDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKBuffert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppKKKKA@    const uint8_t *GetData(void) const { return mBuffer.mData; }t(SettingsM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMtSettingst(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMtK	MwK
v        explicit Settings(Priority aPriority)
            : Settings(kWithLinkSecurity, aPriority)
        {
        }t(GetPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMSettingst(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MKVU        Priority GetPriority(void) const { return static_cast<Priority>(mPriority); }t(IsLinkSecurityEnabledM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMSettingst(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MKPO        bool IsLinkSecurityEnabled(void) const { return mLinkSecurityEnabled; }t(
GetDefaultM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMSettingst(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MKdc        static const Settings &GetDefault(void) { return static_cast<const Settings &>(kDefault); }t(	GetLengthM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKED    uint16_t GetLength(void) const { return GetMetadata().mLength; }t(	GetOffsetM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKED    uint16_t GetOffset(void) const { return GetMetadata().mOffset; }t(GetTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKPO    Type GetType(void) const { return static_cast<Type>(GetMetadata().mType); }t(SetTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK>=    void SetType(Type aType) { GetMetadata().mType = aType; }t(
GetSubTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK\[    SubType GetSubType(void) const { return static_cast<SubType>(GetMetadata().mSubType); }t(
SetSubTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKML    void SetSubType(SubType aSubType) { GetMetadata().mSubType = aSubType; }t(GetMulticastLoopM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKON    bool GetMulticastLoop(void) const { return GetMetadata().mMulticastLoop; }t(SetMulticastLoopM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKba    void SetMulticastLoop(bool aMulticastLoop) { GetMetadata().mMulticastLoop = aMulticastLoop; }t(GetPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM'Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM'KM'K`_    Priority GetPriority(void) const { return static_cast<Priority>(GetMetadata().mPriority); }t(PrependM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM[Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM[KM`K    template <typename ObjectType> Error Prepend(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return PrependBytes(&aObject, sizeof(ObjectType));
    }t(AppendM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK    template <typename ObjectType> Error Append(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return AppendBytes(&aObject, sizeof(ObjectType));
    }t(
AppendDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK    template <DataLengthType kDataLengthType> Error AppendData(const Data<kDataLengthType> &aData)
    {
        return AppendBytes(aData.GetBytes(), aData.GetLength());
    }t(ReadM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKX
      template <typename ObjectType> Error Read(uint16_t aOffset, ObjectType &aObject) const
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return Read(aOffset, &aObject, sizeof(ObjectType));
    }t(CompareM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKX      template <typename ObjectType> bool Compare(uint16_t aOffset, const ObjectType &aObject) const
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return CompareBytes(aOffset, &aObject, sizeof(ObjectType));
    }t(WriteM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8KM=KX	      template <typename ObjectType> void Write(uint16_t aOffset, const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        WriteBytes(aOffset, &aObject, sizeof(ObjectType));
    }t(	WriteDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKKMNK    template <DataLengthType kDataLengthType> void WriteData(uint16_t aOffset, const Data<kDataLengthType> &aData)
    {
        WriteBytes(aOffset, aData.GetBytes(), aData.GetLength());
    }t(CloneM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMyMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMyKMyK>=    Message *Clone(void) const { return Clone(GetLength()); }t(GetDatagramTagM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKON    uint32_t GetDatagramTag(void) const { return GetMetadata().mDatagramTag; }t(SetDatagramTagM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKNM    void SetDatagramTag(uint32_t aTag) { GetMetadata().mDatagramTag = aTag; }t(GetMeshDestM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKIH    uint16_t GetMeshDest(void) const { return GetMetadata().mMeshDest; }t(SetMeshDestM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKRQ    void SetMeshDest(uint16_t aMeshDest) { GetMetadata().mMeshDest = aMeshDest; }t(GetPanIdM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKCB    uint16_t GetPanId(void) const { return GetMetadata().mPanId; }t(SetPanIdM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKFE    void SetPanId(uint16_t aPanId) { GetMetadata().mPanId = aPanId; }t(
GetChannelM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKFE    uint8_t GetChannel(void) const { return GetMetadata().mChannel; }t(
SetChannelM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKML    void SetChannel(uint8_t aChannel) { GetMetadata().mChannel = aChannel; }t(GetTimestampM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKLK    TimeMilli GetTimestamp(void) const { return GetMetadata().mTimestamp; }t(SetTimestampM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKWV    void SetTimestamp(TimeMilli aTimestamp) { GetMetadata().mTimestamp = aTimestamp; }t(SetTimestampToNowM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM KM KIH    void SetTimestampToNow(void) { SetTimestamp(TimerMilli::GetNow()); }t(IsDirectTransmissionM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM	Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM	KM	KNM    bool IsDirectTransmission(void) const { return GetMetadata().mDirectTx; }t(ClearDirectTransmissionM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKLK    void ClearDirectTransmission(void) { GetMetadata().mDirectTx = false; }t(SetDirectTransmissionM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKIH    void SetDirectTransmission(void) { GetMetadata().mDirectTx = true; }t(GetTxSuccessM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKGF    bool GetTxSuccess(void) const { return GetMetadata().mTxSuccess; }t(SetTxSuccessM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM'Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM'KM'KRQ    void SetTxSuccess(bool aTxSuccess) { GetMetadata().mTxSuccess = aTxSuccess; }t(
GetDoNotEvictM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM0Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM0KM0KIH    bool GetDoNotEvict(void) const { return GetMetadata().mDoNotEvict; }t(
SetDoNotEvictM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8KM8KVU    void SetDoNotEvict(bool aDoNotEvict) { GetMetadata().mDoNotEvict = aDoNotEvict; }t(IsResolvingAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMAMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMAKMAKTS    bool IsResolvingAddress(void) const { return GetMetadata().mResolvingAddress; }t(SetResolvingAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMIMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMIKMIKnm    void SetResolvingAddress(bool aResolvingAddress) { GetMetadata().mResolvingAddress = aResolvingAddress; }t(IsLinkSecurityEnabledM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMRMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMRKMRKSR    bool IsLinkSecurityEnabled(void) const { return GetMetadata().mLinkSecurity; }t(SetLinkSecurityEnabledM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZKMZK[Z    void SetLinkSecurityEnabled(bool aEnabled) { GetMetadata().mLinkSecurity = aEnabled; }t(AddRssM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMdMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMdKMdKTS    void AddRss(int8_t aRss) { IgnoreError(GetMetadata().mRssAverager.Add(aRss)); }t(
GetAverageRssM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMlMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMlKMlKYX    int8_t GetAverageRss(void) const { return GetMetadata().mRssAverager.GetAverage(); }t(GetRssAveragerM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMtMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMtKMtKYX    const RssAverager &GetRssAverager(void) const { return GetMetadata().mRssAverager; }t(GetMessageQueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK    MessageQueue *GetMessageQueue(void) const
    {
        return !GetMetadata().mInPriorityQ ? static_cast<MessageQueue *>(GetMetadata().mQueue) : nullptr;
    }t(GetPriorityQueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK    PriorityQueue *GetPriorityQueue(void) const
    {
        return GetMetadata().mInPriorityQ ? static_cast<PriorityQueue *>(GetMetadata().mQueue) : nullptr;
    }t(
ConstIteratorM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM
ConstIteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MK&&        ConstIterator(void) = default;t(
ConstIteratorM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM
ConstIteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MK
s        explicit ConstIterator(const Message *aMessage)
            : ItemPtrIterator(aMessage)
        {
        }t(AdvanceM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM
ConstIteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMK	MK98        void Advance(void) { mItem = mItem->GetNext(); }t(IteratorM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM&Iteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM&K	M)K
G        Iterator(void)
            : mNext(nullptr)
        {
        }t(IteratorM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM+Iteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM+K	M/K
        explicit Iterator(Message *aMessage)
            : ItemPtrIterator(aMessage)
            , mNext(NextMessage(aMessage))
        {
        }t(NextMessageM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM3Iteratort(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM3K	M3Kyx        static Message *NextMessage(Message *aMessage) { return (aMessage != nullptr) ? aMessage->GetNext() : nullptr; }t(GetReservedM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM8KM8KIH    uint16_t GetReserved(void) const { return GetMetadata().mReserved; }t(SetReservedM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM9Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM9KM9Kba    void     SetReserved(uint16_t aReservedHeader) { GetMetadata().mReserved = aReservedHeader; }t(	GetBufferM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM?Chunkt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM?K	M?K@?        const Buffer *GetBuffer(void) const { return mBuffer; }t(	SetBufferM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM@Chunkt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM@K	M@KNM        void          SetBuffer(const Buffer *aBuffer) { mBuffer = aBuffer; }t(GetBytesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMIMutableChunkt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMIK	MIKJI        uint8_t *GetBytes(void) { return AsNonConst(Chunk::GetBytes()); }t(
GetFirstChunkM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMOMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMOKMRK    void GetFirstChunk(uint16_t aOffset, uint16_t &aLength, MutableChunk &aChunk)
    {
        AsConst(this)->GetFirstChunk(aOffset, aLength, static_cast<Chunk &>(aChunk));
    }t(GetNextChunkM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMTMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMTKMWK    void GetNextChunk(uint16_t &aLength, MutableChunk &aChunk)
    {
        AsConst(this)->GetNextChunk(aLength, static_cast<Chunk &>(aChunk));
    }t(GetMessagePoolM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMYMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMYKMYKSR    MessagePool *GetMessagePool(void) const { return GetMetadata().mMessagePool; }t(SetMessagePoolM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZKMZKji    void         SetMessagePool(MessagePool *aMessagePool) { GetMetadata().mMessagePool = aMessagePool; }t(
IsInAQueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM\Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM\KM\KNM    bool IsInAQueue(void) const { return (GetMetadata().mQueue != nullptr); }t(NextM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM`Messaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM`KM`K?>    Message       *&Next(void) { return GetMetadata().mNext; }t(NextM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMaMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMaKMaKED    Message *const &Next(void) const { return GetMetadata().mNext; }t(PrevM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMbMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMbKMbK?>    Message       *&Prev(void) { return GetMetadata().mPrev; }t(NextOfM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMdMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMdKMdKsr    static Message       *NextOf(Message *aMessage) { return (aMessage != nullptr) ? aMessage->Next() : nullptr; }t(NextOfM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMeMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMeKMeKyx    static const Message *NextOf(const Message *aMessage) { return (aMessage != nullptr) ? aMessage->Next() : nullptr; }t(MessageQueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK-,    MessageQueue(void) { SetTail(nullptr); }t(GetHeadM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKBA    Message *GetHead(void) { return Message::NextOf(GetTail()); }t(GetHeadM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKNM    const Message *GetHead(void) const { return Message::NextOf(GetTail()); }t(EnqueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKON    void Enqueue(Message &aMessage) { Enqueue(aMessage, kQueuePositionTail); }t(endM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK@?    Message::Iterator end(void) { return Message::Iterator(); }t(endM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKPO    Message::ConstIterator end(void) const { return Message::ConstIterator(); }t(GetTailM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKKJ    Message       *GetTail(void) { return static_cast<Message *>(mData); }t(GetTailM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKWV    const Message *GetTail(void) const { return static_cast<const Message *>(mData); }t(SetTailM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessageQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKDC    void           SetTail(Message *aMessage) { mData = aMessage; }t(
PriorityQueueM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK%$    PriorityQueue(void) { Clear(); }t(GetHeadM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMKLK    Message *GetHead(void) { return AsNonConst(AsConst(this)->GetHead()); }t(GetHeadForPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM	
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM	KMK    Message *GetHeadForPriority(Message::Priority aPriority)
    {
        return AsNonConst(AsConst(this)->GetHeadForPriority(aPriority));
    }t(GetTailM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM=
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM=KM=KLK    Message *GetTail(void) { return AsNonConst(AsConst(this)->GetTail()); }t(endM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZ
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMZKMZK@?    Message::Iterator end(void) { return Message::Iterator(); }t(endM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM]
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM]KM]KPO    Message::ConstIterator end(void) const { return Message::ConstIterator(); }t(PrevPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM`
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppM`KMcK    uint8_t PrevPriority(uint8_t aPriority) const
    {
        return (aPriority == Message::kNumPriorities - 1) ? 0 : (aPriority + 1);
    }t(FindFirstNonNullTailM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMg
PriorityQueuet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMgKMjK    Message *FindFirstNonNullTail(Message::Priority aStartPriorityLevel)
    {
        return AsNonConst(AsConst(this)->FindFirstNonNullTail(aStartPriorityLevel));
    }t(GetInstanceM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMMessaget(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/message.hppMKMK^]inline Instance &Message::GetInstance(void) const { return GetMessagePool()->GetInstance(); }t(CryptoFillBufferL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKWManagert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKWKKWKvu    static Error CryptoFillBuffer(uint8_t *aBuffer, uint16_t aSize) { return otPlatCryptoRandomGet(aBuffer, aSize); }t(	GetUint32L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKqNt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKqKKqKJIinline uint32_t GetUint32(void) { return Manager::NonCryptoGetUint32(); }t(GetUint8L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKyNt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKyKKyKSRinline uint8_t GetUint8(void) { return static_cast<uint8_t>(GetUint32() & 0xff); }t(	GetUint16L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKNt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKKKKXWinline uint16_t GetUint16(void) { return static_cast<uint16_t>(GetUint32() & 0xffff); }t(
FillBufferL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKNt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/random.hppKKKKpoinline Error FillBuffer(uint8_t *aBuffer, uint16_t aSize) { return Manager::CryptoFillBuffer(aBuffer, aSize); }t(ClearN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKDCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKDKKDK-,    void Clear(void) { mHandler = nullptr; }t(SetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKMCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKMKKQKx    void Set(HandlerType aHandler, void *aContext)
    {
        mHandler = aHandler;
        mContext = aContext;
    }t(IsSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKZCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKZKKZK=<    bool IsSet(void) const { return (mHandler != nullptr); }t(
GetHandlerN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKbCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKbKKbK<;    HandlerType GetHandler(void) const { return mHandler; }t(
GetContextN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKjCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKjKKjK65    void *GetContext(void) const { return mContext; }t(MatchesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKvCallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKvKKyK    bool Matches(HandlerType aHandler, void *aContext) const
    {
        return (mHandler == aHandler) && (mContext == aContext);
    }t(CallbackBase<HandlerType>N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppK|CallbackBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppK|KKKZ    CallbackBase(void)
        : mHandler(nullptr)
        , mContext(nullptr)
    {
    }t(InvokeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKKKK    template <typename... Args> ReturnType Invoke(Args &&...aArgs) const
    {
        return mHandler(static_cast<Args &&>(aArgs)..., mContext);
    }t(InvokeIfSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKKKKXT      template <typename... Args> void InvokeIfSet(Args &&...aArgs) const
    {
        static_assert(TypeTraits::IsSame<ReturnType, void>::kValue,
                      "InvokeIfSet() MUST be used with `void` returning handler");

        if (mHandler != nullptr)
        {
            Invoke(static_cast<Args &&>(aArgs)...);
        }
    }t7      (InvokeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKKKK    template <typename... Args> ReturnType Invoke(Args &&...aArgs) const
    {
        return mHandler(mContext, static_cast<Args &&>(aArgs)...);
    }t(InvokeIfSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/callback.hppKKKKXT      template <typename... Args> void InvokeIfSet(Args &&...aArgs) const
    {
        static_assert(TypeTraits::IsSame<ReturnType, void>::kValue,
                      "InvokeIfSet() MUST be used with `void` returning handler");

        if (mHandler != nullptr)
        {
            Invoke(static_cast<Args &&>(aArgs)...);
        }
    }t(CanReadP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_data.hppK@	FrameDatat(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_data.hppK@KK@KLK    bool CanRead(uint16_t aLength) const { return GetLength() >= aLength; }t(ReadP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_data.hppK	FrameDatat(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_data.hppKKKK    template <typename ObjectType> Error Read(ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return ReadBytes(&aObject, sizeof(ObjectType));
    }t(DumpI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/log.hppMALoggert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/log.hppMAKMEK    template <LogLevel kLogLevel, const char *kModuleName>
    static void Dump(const char *aText, const void *aData, uint16_t aDataLength)
    {
        DumpAtLevel<kLogLevel>(kModuleName, aText, aData, aDataLength);
    }t(IsReceiverRegisteredQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.hppKo
TimeTickert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.hppKoKKoKhg    bool IsReceiverRegistered(Receiver aReceiver) const { return (mReceivers & Mask(aReceiver)) != 0; }t(MaskQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.hppKu
TimeTickert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.hppKuKKuKji    constexpr static uint32_t Mask(Receiver aReceiver) { return static_cast<uint32_t>(1U) << aReceiver; }t(MessageInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKDMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKDKKDK#"    MessageInfo(void) { Clear(); }t(GetSockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKLMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKLKKLKBA    Address &GetSockAddr(void) { return AsCoreType(&mSockAddr); }t(GetSockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKTMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKTKKTKNM    const Address &GetSockAddr(void) const { return AsCoreType(&mSockAddr); }t(SetSockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK\MessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK\KK\KHG    void SetSockAddr(const Address &aAddress) { mSockAddr = aAddress; }t(GetSockPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKdMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKdKKdK;:    uint16_t GetSockPort(void) const { return mSockPort; }t(SetSockPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKlMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKlKKlK<;    void SetSockPort(uint16_t aPort) { mSockPort = aPort; }t(GetPeerAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKtMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKtKKtKBA    Address &GetPeerAddr(void) { return AsCoreType(&mPeerAddr); }t(GetPeerAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK|MessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK|KK|KNM    const Address &GetPeerAddr(void) const { return AsCoreType(&mPeerAddr); }t(SetPeerAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKHG    void SetPeerAddr(const Address &aAddress) { mPeerAddr = aAddress; }t(GetPeerPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK;:    uint16_t GetPeerPort(void) const { return mPeerPort; }t(SetPeerPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK<;    void SetPeerPort(uint16_t aPort) { mPeerPort = aPort; }t(GetHopLimitI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK:9    uint8_t GetHopLimit(void) const { return mHopLimit; }t(SetHopLimitI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKCB    void SetHopLimit(uint8_t aHopLimit) { mHopLimit = aHopLimit; }t(GetMulticastLoopI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKA@    bool GetMulticastLoop(void) const { return mMulticastLoop; }t(SetMulticastLoopI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKTS    void SetMulticastLoop(bool aMulticastLoop) { mMulticastLoop = aMulticastLoop; }t(GetLinkInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK>=    const void *GetLinkInfo(void) const { return mLinkInfo; }t(SetLinkInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKŌMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKGF    void SetLinkInfo(const void *aLinkInfo) { mLinkInfo = aLinkInfo; }t(GetThreadLinkInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK͌MessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKxw    const ThreadLinkInfo *GetThreadLinkInfo(void) const { return reinterpret_cast<const ThreadLinkInfo *>(mLinkInfo); }t(GetEcnI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKՌMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK>=    Ecn GetEcn(void) const { return static_cast<Ecn>(mEcn); }t(SetEcnI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppK݌MessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKK+*    void SetEcn(Ecn aEcn) { mEcn = aEcn; }t(IsHostInterfaceI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKBA    bool IsHostInterface(void) const { return mIsHostInterface; }t(ShouldAllowZeroHopLimitI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKLK    bool ShouldAllowZeroHopLimit(void) const { return mAllowZeroHopLimit; }t(SetIsHostInterfaceI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppKKKKJI    void SetIsHostInterface(bool aIsHost) { mIsHostInterface = aIsHost; }t(SockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM
SockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM
KM
K     SockAddr(void) { Clear(); }t(SockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMSockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMKMKf    explicit SockAddr(uint16_t aPort)
    {
        mPort = aPort;
        GetAddress().Clear();
    }t(SockAddrI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM"SockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM"KM&Kx    SockAddr(const Address &aAddress, uint16_t aPort)
    {
        mAddress = aAddress;
        mPort    = aPort;
    }t(
GetAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM.SockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM.KM.K@?    Address &GetAddress(void) { return AsCoreType(&mAddress); }t(
GetAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM6SockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM6KM6KLK    const Address &GetAddress(void) const { return AsCoreType(&mAddress); }t(
SetAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM>SockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppM>KM>KFE    void SetAddress(const Address &aAddress) { mAddress = aAddress; }t(GetPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMFSockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMFKMFK32    uint16_t GetPort(void) const { return mPort; }t(SetPortI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMNSockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMNKMNK43    void SetPort(uint16_t aPort) { mPort = aPort; }t(
operator==I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMZSockAddrt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/socket.hppMZKM]K    bool operator==(const SockAddr &aOther) const
    {
        return (GetPort() == aOther.GetPort()) && (GetAddress() == aOther.GetAddress());
    }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKPO        const Address &GetAddress(void) const { return AsCoreType(&mAddress); }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKDC        Address &GetAddress(void) { return AsCoreType(&mAddress); }t(GetPrefixLengthH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKFE        uint8_t GetPrefixLength(void) const { return mPrefixLength; }t(	HasPrefixH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KK
        bool HasPrefix(const Prefix &aPrefix) const
        {
            return (mPrefixLength == aPrefix.GetLength()) && GetAddress().MatchesPrefix(aPrefix);
        }t(GetScopeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KK
        uint8_t GetScope(void) const
        {
            return mScopeOverrideValid ? static_cast<uint8_t>(mScopeOverride) : GetAddress().GetScope();
        }t(SetScopeOverrideH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppǨUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KK
        void SetScopeOverride(uint8_t aScope)
        {
            mScopeOverride      = aScope;
            mScopeOverrideValid = true;
        }t(	GetOriginH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppK،UnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKcb        AddressOrigin GetOrigin(void) const { return static_cast<AddressOrigin>(mAddressOrigin); }t(MatchesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKیUnicastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKYX        bool Matches(const Address &aAddress) const { return GetAddress() == aAddress; }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKMulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKPO        const Address &GetAddress(void) const { return AsCoreType(&mAddress); }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKMulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKDC        Address &GetAddress(void) { return AsCoreType(&mAddress); }t(GetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKMulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppKK	KKml        const MulticastAddress *GetNext(void) const { return static_cast<const MulticastAddress *>(mNext); }t(GetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMMulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMK	MKgf        MulticastAddress *GetNext(void) { return static_cast<MulticastAddress *>(AsNonConst(mNext)); }t(MatchesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM
MulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM
K	M
KYX        bool Matches(const Address &aAddress) const { return GetAddress() == aAddress; }t(BuilderH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM+Buildert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM+KM/K                Builder(const Netif &aNetif, Address::TypeFilter aFilter)
                    : mNetif(aNetif)
                    , mFilter(aFilter)
                {
                }t(beginH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM1Buildert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM1KM1KKJ                Iterator begin(void) { return Iterator(mNetif, mFilter); }t(endH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM2Buildert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM2KM2KXW                Iterator end(void) { return Iterator(mNetif, Iterator::kEndIterator); }t(IteratorH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM>Iteratort(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM>K
MAKt            Iterator(const Netif &aNetif, IteratorType)
                : mNetif(aNetif)
            {
            }t(AdvanceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMDIteratort(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMDK
MDKBA            void Advance(void) { AdvanceFrom(mItem->GetNext()); }t(GetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM]ExternalMulticastAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM]K	M]Kwv        ExternalMulticastAddress *GetNext(void) { return static_cast<ExternalMulticastAddress *>(AsNonConst(mNext)); }t(SetAddressCallbackH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMsNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMsKMvK    void SetAddressCallback(otIp6AddressCallback aCallback, void *aCallbackContext)
    {
        mAddressCallback.Set(aCallback, aCallbackContext);
    }t(GetUnicastAddressesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM~Netift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppM~KM~Kdc    const LinkedList<UnicastAddress> &GetUnicastAddresses(void) const { return mUnicastAddresses; }t(HasUnicastAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMKMKrq    bool HasUnicastAddress(const UnicastAddress &aAddress) const { return mUnicastAddresses.Contains(aAddress); }t(GetMulticastAddressesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMKMKji    const LinkedList<MulticastAddress> &GetMulticastAddresses(void) const { return mMulticastAddresses; }t(IsMulticastPromiscuousEnabledH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMLNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMLKMLKUT    bool IsMulticastPromiscuousEnabled(void) const { return mMulticastPromiscuous; }t(SetMulticastPromiscuousH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMTNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMTKMTKVU    void SetMulticastPromiscuous(bool aEnabled) { mMulticastPromiscuous = aEnabled; }t(!IterateExternalMulticastAddressesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMjNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMjKMnK    ExternalMulticastAddress::Iterator::Builder IterateExternalMulticastAddresses(
        Address::TypeFilter aFilter = Address::kTypeAny)
    {
        return ExternalMulticastAddress::Iterator::Builder(*this, aFilter);
    }t(HasAnyExternalMulticastAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMwNetift(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/netif.hppMwKMwKts    bool HasAnyExternalMulticastAddress(void) const { return !ExternalMulticastAddress::Iterator(*this).IsDone(); }t(InitVersionTrafficClassFlowN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKnHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKnKKnK[Z    void InitVersionTrafficClassFlow(void) { SetVerionTrafficClassFlow(kVersTcFlowInit); }t(
IsVersion6N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK[Z    bool IsVersion6(void) const { return (mVerTcFlow.m8[0] & kVersionMask) == kVersion6; }t(GetVerionTrafficClassFlowN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKZY    uint32_t GetVerionTrafficClassFlow(void) const { return HostSwap32(mVerTcFlow.m32); }t(SetVerionTrafficClassFlowN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKed    void SetVerionTrafficClassFlow(uint32_t aVerTcFlow) { mVerTcFlow.m32 = HostSwap32(aVerTcFlow); }t(GetTrafficClassN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK    uint8_t GetTrafficClass(void) const
    {
        return static_cast<uint8_t>((HostSwap16(mVerTcFlow.m16[0]) & kTrafficClassMask) >> kTrafficClassOffset);
    }t(SetTrafficClassN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKX      void SetTrafficClass(uint8_t aTc)
    {
        mVerTcFlow.m16[0] = HostSwap16((HostSwap16(mVerTcFlow.m16[0]) & ~kTrafficClassMask) |
                                       ((static_cast<uint16_t>(aTc) << kTrafficClassOffset) & kTrafficClassMask));
    }t(GetDscpN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK    uint8_t GetDscp(void) const
    {
        return static_cast<uint8_t>((HostSwap16(mVerTcFlow.m16[0]) & kDscpMask) >> kDscpOffset);
    }t(SetDscpN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK    void SetDscp(uint8_t aDscp)
    {
        mVerTcFlow.m16[0] = HostSwap16((HostSwap16(mVerTcFlow.m16[0]) & ~kDscpMask) |
                                       ((static_cast<uint16_t>(aDscp) << kDscpOffset) & kDscpMask));
    }t(GetEcnN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKƌHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKed    Ecn GetEcn(void) const { return static_cast<Ecn>((mVerTcFlow.m8[1] & kEcnMask) >> kEcnOffset); }t(SetEcnN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKΌHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKut    void SetEcn(Ecn aEcn) { mVerTcFlow.m8[1] = (mVerTcFlow.m8[1] & ~kEcnMask) | ((aEcn << kEcnOffset) & kEcnMask); }t(GetFlowN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppK֌Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKTS    uint32_t GetFlow(void) const { return HostSwap32(mVerTcFlow.m32) & kFlowMask; }t(SetFlowN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKތHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK    void SetFlow(uint32_t aFlow)
    {
        mVerTcFlow.m32 = HostSwap32((HostSwap32(mVerTcFlow.m32) & ~kFlowMask) | (aFlow & kFlowMask));
    }t(GetPayloadLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKQP    uint16_t GetPayloadLength(void) const { return HostSwap16(mPayloadLength); }t(SetPayloadLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKKVU    void SetPayloadLength(uint16_t aLength) { mPayloadLength = HostSwap16(aLength); }t(
GetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppKKKK>=    uint8_t GetNextHeader(void) const { return mNextHeader; }t(
SetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKKJ    void SetNextHeader(uint8_t aNextHeader) { mNextHeader = aNextHeader; }t(GetHopLimitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM	Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM	KM	K:9    uint8_t GetHopLimit(void) const { return mHopLimit; }t(SetHopLimitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKCB    void SetHopLimit(uint8_t aHopLimit) { mHopLimit = aHopLimit; }t(	GetSourceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK10    Address &GetSource(void) { return mSource; }t(	GetSourceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM!Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM!KM!K=<    const Address &GetSource(void) const { return mSource; }t(	SetSourceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM)Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM)KM)KBA    void SetSource(const Address &aSource) { mSource = aSource; }t(GetDestinationN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM1Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM1KM1K;:    Address &GetDestination(void) { return mDestination; }t(GetDestinationN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM9Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM9KM9KGF    const Address &GetDestination(void) const { return mDestination; }t(SetDestinationN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMAHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMAKMAKVU    void SetDestination(const Address &aDestination) { mDestination = aDestination; }t(
GetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMExtensionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK>=    uint8_t GetNextHeader(void) const { return mNextHeader; }t(
SetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMExtensionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKKJ    void SetNextHeader(uint8_t aNextHeader) { mNextHeader = aNextHeader; }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMExtensionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK65    uint8_t GetLength(void) const { return mLength; }t(	SetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMExtensionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(GetSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMExtensionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKPO    uint16_t GetSize(void) const { return kLengthUnitInBytes * (mLength + 1); }t(OptionHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKJ    OptionHeader(void)
        : mType(0)
        , mLength(0)
    {
    }t(GetTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK21    uint8_t GetType(void) const { return mType; }t(SetTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK32    void SetType(uint8_t aType) { mType = aType; }t(	GetActionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKVU    Action GetAction(void) const { return static_cast<Action>(mType & kActionMask); }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK65    uint8_t GetLength(void) const { return mLength; }t(	SetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(GetSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM	OptionHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM	KM	Kcb    uint16_t GetSize(void) const { return static_cast<uint16_t>(mLength) + sizeof(OptionHeader); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM$
OptionPadNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM$KM)K    void Init(uint8_t aPadLength)
    {
        SetType(kType);
        SetLength(aPadLength - sizeof(OptionHeader));
        memset(mPad, kData, aPadLength - sizeof(OptionHeader));
    }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM=
OptionPad1t(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM=KM=K'&    void Init(void) { mType = kType; }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMOKMTKv    void Init(void)
    {
        mReserved       = 0;
        mOffsetMore     = 0;
        mIdentification = 0;
    }t(
GetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM\FragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppM\KM\K>=    uint8_t GetNextHeader(void) const { return mNextHeader; }t(
SetNextHeaderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMdFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMdKMdKKJ    void SetNextHeader(uint8_t aNextHeader) { mNextHeader = aNextHeader; }t(	GetOffsetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMlFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMlKMlKhg    uint16_t GetOffset(void) const { return (HostSwap16(mOffsetMore) & kOffsetMask) >> kOffsetOffset; }t(	SetOffsetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMsFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMsKMxK    void SetOffset(uint16_t aOffset)
    {
        uint16_t tmp = HostSwap16(mOffsetMore);
        tmp          = (tmp & ~kOffsetMask) | ((aOffset << kOffsetOffset) & kOffsetMask);
        mOffsetMore  = HostSwap16(tmp);
    }t(
IsMoreFlagSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKSR    bool IsMoreFlagSet(void) const { return HostSwap16(mOffsetMore) & kMoreFlag; }t(
ClearMoreFlagN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKa`    void ClearMoreFlag(void) { mOffsetMore = HostSwap16(HostSwap16(mOffsetMore) & ~kMoreFlag); }t(SetMoreFlagN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK^]    void SetMoreFlag(void) { mOffsetMore = HostSwap16(HostSwap16(mOffsetMore) | kMoreFlag); }t(GetIdentificationN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKGF    uint32_t GetIdentification(void) const { return mIdentification; }t(SetIdentificationN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK\[    void SetIdentification(uint32_t aIdentification) { mIdentification = aIdentification; }t(MakeDivisibleByEightN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK_^    static inline uint16_t MakeDivisibleByEight(uint16_t aLength) { return aLength & 0xfff8; }t(FragmentOffsetToBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMKsr    static inline uint16_t FragmentOffsetToBytes(uint16_t aOffset) { return static_cast<uint16_t>(aOffset << 3); }t(BytesToFragmentOffsetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMFragmentHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_headers.hppMKMK\[    static inline uint16_t BytesToFragmentOffset(uint16_t aOffset) { return aOffset >> 3; }t(IsErrorH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKyHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKyK	KyKPO        bool IsError(void) const { return mType < OT_ICMP6_TYPE_ECHO_REQUEST; }t(GetTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKFE        Type GetType(void) const { return static_cast<Type>(mType); }t(SetTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKJI        void SetType(Type aType) { mType = static_cast<uint8_t>(aType); }t(GetCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKFE        Code GetCode(void) const { return static_cast<Code>(mCode); }t(SetCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKJI        void SetCode(Code aCode) { mCode = static_cast<uint8_t>(aCode); }t(GetChecksumH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKKJ        uint16_t GetChecksum(void) const { return HostSwap16(mChecksum); }t(SetChecksumH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKTS        void SetChecksum(uint16_t aChecksum) { mChecksum = HostSwap16(aChecksum); }t(GetIdH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKHG        uint16_t GetId(void) const { return HostSwap16(mData.m16[0]); }t(SetIdH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKED        void SetId(uint16_t aId) { mData.m16[0] = HostSwap16(aId); }t(GetSequenceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKNM        uint16_t GetSequence(void) const { return HostSwap16(mData.m16[1]); }t(SetSequenceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKɌHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KKWV        void SetSequence(uint16_t aSequence) { mData.m16[1] = HostSwap16(aSequence); }t(HandlerH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppK܌Handlert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KK
        Handler(otIcmp6ReceiveCallback aCallback, void *aContext)
        {
            mReceiveCallback = aCallback;
            mContext         = aContext;
            mNext            = nullptr;
        }t(HandleReceiveMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKHandlert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppKK	KK
        void HandleReceiveMessage(Message &aMessage, const MessageInfo &aMessageInfo, const Header &aIcmp6Header)
        {
            mReceiveCallback(mContext, &aMessage, &aMessageInfo, &aIcmp6Header);
        }t(GetEchoModeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppMEIcmpt(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppMEKMEKBA    otIcmp6EchoMode GetEchoMode(void) const { return mEchoMode; }t(SetEchoModeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppMMIcmpt(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppMMKMMKCB    void SetEchoMode(otIcmp6EchoMode aMode) { mEchoMode = aMode; }t(GetEchoSequenceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppM^Icmpt(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/icmp6.hppM^KM^KCB    uint16_t GetEchoSequence(void) const { return mEchoSequence; }t(InitJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKJ	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKJKKOK    void Init(void)
    {
        SetType(kType);
        SetLength(sizeof(*this) - sizeof(OptionHeader));
        mControl = 0;
    }t(GetSeedIdLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKc	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKcKKcKqp    SeedIdLength GetSeedIdLength(void) const { return static_cast<SeedIdLength>(mControl & kSeedIdLengthMask); }t(SetSeedIdLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKk	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKkKKnK    void SetSeedIdLength(SeedIdLength aSeedIdLength)
    {
        mControl = static_cast<uint8_t>((mControl & ~kSeedIdLengthMask) | aSeedIdLength);
    }t(IsMaxFlagSetJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKw	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKwKKwKIH    bool IsMaxFlagSet(void) const { return (mControl & kMaxFlag) != 0; }t(ClearMaxFlagJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK}	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK}KK}K76    void ClearMaxFlag(void) { mControl &= ~kMaxFlag; }t(
SetMaxFlagJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKK43    void SetMaxFlag(void) { mControl |= kMaxFlag; }t(GetSequenceJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKK:9    uint8_t GetSequence(void) const { return mSequence; }t(SetSequenceJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKKCB    void SetSequence(uint8_t aSequence) { mSequence = aSequence; }t(	GetSeedIdJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKKCB    uint16_t GetSeedId(void) const { return HostSwap16(mSeedId); }t(	SetSeedIdJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppK	OptionMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKKHG    void SetSeedId(uint16_t aSeedId) { mSeedId = HostSwap16(aSeedId); }t(GetBufferedMessageSetJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKMplt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKKKKZY    const MessageQueue &GetBufferedMessageSet(void) const { return mBufferedMessageSet; }t(AppendToJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKMetadatat(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.hppKK	KKSR        Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(
GetContextG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppKEndpointt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppKK	KK43        void *GetContext(void) { return mContext; }t(FromTcbG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMgEndpointt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMgK	MgKfe        static Endpoint &FromTcb(struct tcpcb &aTcb) { return *reinterpret_cast<Endpoint *>(&aTcb); }t(GetTcbG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMlEndpointt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMlK	MlKXW        struct tcpcb &GetTcb(void) { return *reinterpret_cast<struct tcpcb *>(&mTcb); }t(GetTcbG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMqEndpointt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMqK	MqKji        const struct tcpcb &GetTcb(void) const { return *reinterpret_cast<const struct tcpcb *>(&mTcb); }t(
GetContextG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMListenert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMK	MK43        void *GetContext(void) { return mContext; }t(
FromTcbListenG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMListenert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMK	MK
        static Listener &FromTcbListen(struct tcpcb_listen &aTcbListen)
        {
            return *reinterpret_cast<Listener *>(&aTcbListen);
        }t(GetTcbListenG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMListenert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMK	MKrq        struct tcpcb_listen &GetTcbListen(void) { return *reinterpret_cast<struct tcpcb_listen *>(&mTcbListen); }t(GetTcbListenG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM	Listenert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM	K	MK
        const struct tcpcb_listen &GetTcbListen(void) const
        {
            return *reinterpret_cast<const struct tcpcb_listen *>(&mTcbListen);
        }t(
GetSourcePortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM)Headert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM)K	M)KKJ        uint16_t GetSourcePort(void) const { return HostSwap16(mSource); }t(GetDestinationPortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM1Headert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM1K	M1KUT        uint16_t GetDestinationPort(void) const { return HostSwap16(mDestination); }t(GetSequenceNumberG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM9Headert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppM9K	M9KWV        uint32_t GetSequenceNumber(void) const { return HostSwap32(mSequenceNumber); }t(GetAcknowledgmentNumberG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMAHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMAK	MAKXW        uint32_t GetAcknowledgmentNumber(void) const { return HostSwap32(mAckNumber); }t(GetFlagsG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMIHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMIK	MIKED        uint16_t GetFlags(void) const { return HostSwap16(mFlags); }t(	GetWindowG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMQHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMQK	MQKGF        uint16_t GetWindow(void) const { return HostSwap16(mWindow); }t(GetChecksumG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMYHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMYK	MYKKJ        uint16_t GetChecksum(void) const { return HostSwap16(mChecksum); }t(GetUrgentPointerG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMaHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMaK	MaKUT        uint16_t GetUrgentPointer(void) const { return HostSwap16(mUrgentPointer); }t(
IsInitializedG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMTcpt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMKMKcb    bool IsInitialized(const Endpoint &aEndpoint) const { return mEndpoints.Contains(aEndpoint); }t(
IsInitializedG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMTcpt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/tcp6.hppMKMKcb    bool IsInitialized(const Listener &aListener) const { return mListeners.Contains(aListener); }t(IsBoundG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKhSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKhK	KhKBA        bool IsBound(void) const { return mSockName.mPort != 0; }t(GetSockNameG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKpSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKpK	KpKGF        SockAddr &GetSockName(void) { return AsCoreType(&mSockName); }t(GetSockNameG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKxSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKxK	KxKSR        const SockAddr &GetSockName(void) const { return AsCoreType(&mSockName); }t(GetPeerNameG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKK	KKGF        SockAddr &GetPeerName(void) { return AsCoreType(&mPeerName); }t(GetPeerNameG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKK	KKSR        const SockAddr &GetPeerName(void) const { return AsCoreType(&mPeerName); }t(HandleUdpReceiveG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKSocketHandlet(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKK	KK
        void HandleUdpReceive(Message &aMessage, const MessageInfo &aMessageInfo)
        {
            mHandler(mContext, &aMessage, &aMessageInfo);
        }t(BindG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKSockett(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppKK	KK-,        Error Bind(void) { return Bind(0); }t(ConnectG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMSockett(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMK	MK32        Error Connect(void) { return Connect(0); }t(ReceiverG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMEReceivert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMEK	MJK
        Receiver(otUdpHandler aHandler, void *aContext)
        {
            mNext    = nullptr;
            mHandler = aHandler;
            mContext = aContext;
        }t(
HandleMessageG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMMReceivert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMMK	MPK
        bool HandleMessage(Message &aMessage, const MessageInfo &aMessageInfo)
        {
            return mHandler(mContext, &aMessage, &aMessageInfo);
        }t(
GetSourcePortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMfHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMfK	MfKON        uint16_t GetSourcePort(void) const { return HostSwap16(mSourcePort); }t(
SetSourcePortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMnHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMnK	MnKPO        void SetSourcePort(uint16_t aPort) { mSourcePort = HostSwap16(aPort); }t(GetDestinationPortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMvHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMvK	MvKYX        uint16_t GetDestinationPort(void) const { return HostSwap16(mDestinationPort); }t(SetDestinationPortG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppM~Headert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppM~K	M~KZY        void SetDestinationPort(uint16_t aPort) { mDestinationPort = HostSwap16(aPort); }t(	GetLengthG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMK	MKGF        uint16_t GetLength(void) const { return HostSwap16(mLength); }t(	SetLengthG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMK	MKLK        void SetLength(uint16_t aLength) { mLength = HostSwap16(aLength); }t(GetChecksumG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMK	MKKJ        uint16_t GetChecksum(void) const { return HostSwap16(mChecksum); }t(SetChecksumG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMHeadert(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMK	MKTS        void SetChecksum(uint16_t aChecksum) { mChecksum = HostSwap16(aChecksum); }t(IsOpenG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMUdpt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMKMKZY    bool IsOpen(const SocketHandle &aSocket) const { return mSockets.Contains(aSocket); }t(
GetUdpSocketsG/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMKUdpt(G/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/udp6.hppMKKMKKED    SocketHandle *GetUdpSockets(void) { return mSockets.GetHead(); }t(SetReceiveDatagramCallbackF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppKIp6t(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppKKKK    void SetReceiveDatagramCallback(otIp6ReceiveCallback aCallback, void *aCallbackContext)
    {
        mReceiveIp6DatagramCallback.Set(aCallback, aCallbackContext);
    }t(IsReceiveIp6FilterEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMIp6t(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMKVU    bool IsReceiveIp6FilterEnabled(void) const { return mIsReceiveIp6FilterEnabled; }t(SetReceiveIp6FilterEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM&Ip6t(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM&KM&K^]    void SetReceiveIp6FilterEnabled(bool aEnabled) { mIsReceiveIp6FilterEnabled = aEnabled; }t(GetSendQueueF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMCIp6t(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMCKMCKIH    const PriorityQueue &GetSendQueue(void) const { return mSendQueue; }t(GetIp6HeaderF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMKBA    const Header &GetIp6Header(void) const { return mIp6Header; }t(
GetIpProtoF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMKJI    uint8_t GetIpProto(void) const { return mIp6Header.GetNextHeader(); }t(GetEcnF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMK;:    Ecn GetEcn(void) const { return mIp6Header.GetEcn(); }t(IsUdpF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMKA@    bool IsUdp(void) const { return GetIpProto() == kProtoUdp; }t(IsTcpF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMKMKA@    bool IsTcp(void) const { return GetIpProto() == kProtoTcp; }t(IsIcmp6F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM Headerst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM KM KED    bool IsIcmp6(void) const { return GetIpProto() == kProtoIcmp6; }t(GetSourceAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM(Headerst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM(KM(KSR    const Address &GetSourceAddress(void) const { return mIp6Header.GetSource(); }t(GetDestinationAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM0Headerst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM0KM0K]\    const Address &GetDestinationAddress(void) const { return mIp6Header.GetDestination(); }t(GetUdpHeaderF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM:Headerst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppM:KM:KIH    const Udp::Header &GetUdpHeader(void) const { return mHeader.mUdp; }t(GetTcpHeaderF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMDHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMDKMDKIH    const Tcp::Header &GetTcpHeader(void) const { return mHeader.mTcp; }t(
GetIcmpHeaderF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMNHeaderst(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6.hppMNKMNKLK    const Icmp::Header &GetIcmpHeader(void) const { return mHeader.mIcmp; }t(	CallbacksJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppKÌ	Callbackst(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppKK	KK
l        explicit Callbacks(Instance &aInstance)
            : InstanceLocator(aInstance)
        {
        }t(RadioJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppKόRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppKKKKx    explicit Radio(Instance &aInstance)
        : InstanceLocator(aInstance)
        , mCallbacks(aInstance)
    {
    }t(SetMacFrameCounterJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM+Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM+KM.K    void SetMacFrameCounter(uint32_t aMacFrameCounter)
    {
        otPlatRadioSetMacFrameCounter(GetInstancePtr(), aMacFrameCounter);
    }t(SetMacFrameCounterIfLargerJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM7Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM7KM:K    void SetMacFrameCounterIfLarger(uint32_t aMacFrameCounter)
    {
        otPlatRadioSetMacFrameCounterIfLarger(GetInstancePtr(), aMacFrameCounter);
    }t(IsCslChannelValidJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMK    static bool IsCslChannelValid(uint8_t aCslChannel)
    {
        return ((aCslChannel == 0) ||
                ((kChannelMin == aCslChannel) || ((kChannelMin < aCslChannel) && (aCslChannel <= kChannelMax))));
    }t(GetInstancePtrJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKwv    otInstance *GetInstancePtr(void) const { return reinterpret_cast<otInstance *>(&InstanceLocator::GetInstance()); }t(GetVersionStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKkjinline const char *Radio::GetVersionString(void) { return otPlatRadioGetVersionString(GetInstancePtr()); }t(GetIeeeEui64J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMK~inline void Radio::GetIeeeEui64(Mac::ExtAddress &aIeeeEui64)
{
    otPlatRadioGetIeeeEui64(GetInstancePtr(), aIeeeEui64.m8);
}t(GetSupportedChannelMaskJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKvuinline uint32_t Radio::GetSupportedChannelMask(void) { return otPlatRadioGetSupportedChannelMask(GetInstancePtr()); }t(GetPreferredChannelMaskJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKvuinline uint32_t Radio::GetPreferredChannelMask(void) { return otPlatRadioGetPreferredChannelMask(GetInstancePtr()); }t(GetCapsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKYXinline otRadioCaps Radio::GetCaps(void) { return otPlatRadioGetCaps(GetInstancePtr()); }t(GetReceiveSensitivityJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKvuinline int8_t Radio::GetReceiveSensitivity(void) const { return otPlatRadioGetReceiveSensitivity(GetInstancePtr()); }t(SetPanIdJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKbainline void Radio::SetPanId(Mac::PanId aPanId) { otPlatRadioSetPanId(GetInstancePtr(), aPanId); }t(	SetMacKeyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKXV  inline void Radio::SetMacKey(uint8_t                 aKeyIdMode,
                             uint8_t                 aKeyId,
                             const Mac::KeyMaterial &aPrevKey,
                             const Mac::KeyMaterial &aCurrKey,
                             const Mac::KeyMaterial &aNextKey)
{
    otRadioKeyType aKeyType;

#if OPENTHREAD_CONFIG_PLATFORM_KEY_REFERENCES_ENABLE
    aKeyType = OT_KEY_TYPE_KEY_REF;
#else
    aKeyType = OT_KEY_TYPE_LITERAL_KEY;
#endif

    otPlatRadioSetMacKey(GetInstancePtr(), aKeyIdMode, aKeyId, &aPrevKey, &aCurrKey, &aNextKey, aKeyType);
}t(GetTransmitPowerJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKxwinline Error Radio::GetTransmitPower(int8_t &aPower) { return otPlatRadioGetTransmitPower(GetInstancePtr(), &aPower); }t(SetTransmitPowerJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKvuinline Error Radio::SetTransmitPower(int8_t aPower) { return otPlatRadioSetTransmitPower(GetInstancePtr(), aPower); }t(GetCcaEnergyDetectThresholdJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKinline Error Radio::GetCcaEnergyDetectThreshold(int8_t &aThreshold)
{
    return otPlatRadioGetCcaEnergyDetectThreshold(GetInstancePtr(), &aThreshold);
}t(SetCcaEnergyDetectThresholdJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKinline Error Radio::SetCcaEnergyDetectThreshold(int8_t aThreshold)
{
    return otPlatRadioSetCcaEnergyDetectThreshold(GetInstancePtr(), aThreshold);
}t(GetPromiscuousJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMK`_inline bool Radio::GetPromiscuous(void) { return otPlatRadioGetPromiscuous(GetInstancePtr()); }t(SetPromiscuousJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKjiinline void Radio::SetPromiscuous(bool aEnable) { otPlatRadioSetPromiscuous(GetInstancePtr(), aEnable); }t(GetStateJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMK\[inline otRadioState Radio::GetState(void) { return otPlatRadioGetState(GetInstancePtr()); }t(EnableJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKQPinline Error Radio::Enable(void) { return otPlatRadioEnable(GetInstancePtr()); }t(DisableJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hpp      MRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKSRinline Error Radio::Disable(void) { return otPlatRadioDisable(GetInstancePtr()); }t(	IsEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKVUinline bool Radio::IsEnabled(void) { return otPlatRadioIsEnabled(GetInstancePtr()); }t(SleepJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKONinline Error Radio::Sleep(void) { return otPlatRadioSleep(GetInstancePtr()); }t(ReceiveJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKihinline Error Radio::Receive(uint8_t aChannel) { return otPlatRadioReceive(GetInstancePtr(), aChannel); }t(GetCslAccuracyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKcbinline uint8_t Radio::GetCslAccuracy(void) { return otPlatRadioGetCslAccuracy(GetInstancePtr()); }t(GetCslUncertaintyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKihinline uint8_t Radio::GetCslUncertainty(void) { return otPlatRadioGetCslUncertainty(GetInstancePtr()); }t(GetTransmitBufferJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM
Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM
KM
Kinline Mac::TxFrame &Radio::GetTransmitBuffer(void)
{
    return *static_cast<Mac::TxFrame *>(otPlatRadioGetTransmitBuffer(GetInstancePtr()));
}t(GetRssiJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKTSinline int8_t Radio::GetRssi(void) { return otPlatRadioGetRssi(GetInstancePtr()); }t(
EnergyScanJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKinline Error Radio::EnergyScan(uint8_t aScanChannel, uint16_t aScanDuration)
{
    return otPlatRadioEnergyScan(GetInstancePtr(), aScanChannel, aScanDuration);
}t(EnableSrcMatchJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKjiinline void Radio::EnableSrcMatch(bool aEnable) { otPlatRadioEnableSrcMatch(GetInstancePtr(), aEnable); }t(AddSrcMatchShortEntryJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKMKinline Error Radio::AddSrcMatchShortEntry(Mac::ShortAddress aShortAddress)
{
    return otPlatRadioAddSrcMatchShortEntry(GetInstancePtr(), aShortAddress);
}t(AddSrcMatchExtEntryJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMRadiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppMKM Kinline Error Radio::AddSrcMatchExtEntry(const Mac::ExtAddress &aExtAddress)
{
    return otPlatRadioAddSrcMatchExtEntry(GetInstancePtr(), &aExtAddress);
}t(ClearSrcMatchShortEntryJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM"Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM"KM%Kinline Error Radio::ClearSrcMatchShortEntry(Mac::ShortAddress aShortAddress)
{
    return otPlatRadioClearSrcMatchShortEntry(GetInstancePtr(), aShortAddress);
}t(ClearSrcMatchExtEntryJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM'Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM'KM*Kinline Error Radio::ClearSrcMatchExtEntry(const Mac::ExtAddress &aExtAddress)
{
    return otPlatRadioClearSrcMatchExtEntry(GetInstancePtr(), &aExtAddress);
}t(ClearSrcMatchShortEntriesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM,Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM,KM,Koninline void Radio::ClearSrcMatchShortEntries(void) { otPlatRadioClearSrcMatchShortEntries(GetInstancePtr()); }t(ClearSrcMatchExtEntriesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM.Radiot(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/radio/radio.hppM.KM.Kkjinline void Radio::ClearSrcMatchExtEntries(void) { otPlatRadioClearSrcMatchExtEntries(GetInstancePtr()); }t(ChannelMaskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKVChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKVKKYK4    ChannelMask(void)
        : mMask(0)
    {
    }t(ChannelMaskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKaChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKaKKdKK    explicit ChannelMask(uint32_t aMask)
        : mMask(aMask)
    {
    }t(ClearO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKjChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKjKKjK$#    void Clear(void) { mMask = 0; }t(GetMaskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKrChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKrKKrK32    uint32_t GetMask(void) const { return mMask; }t(SetMaskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKzChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKzKKzK43    void SetMask(uint32_t aMask) { mMask = aMask; }t(IsEmptyO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK65    bool IsEmpty(void) const { return (mMask == 0); }t(IsSingleChannelO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK`_    bool IsSingleChannel(void) const { return ((mMask != 0) && ((mMask & (mMask - 1)) == 0)); }t(ContainsChannelO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK    bool ContainsChannel(uint8_t aChannel) const
    {
        return (aChannel < sizeof(mMask) * CHAR_BIT) ? ((1UL << aChannel) & mMask) != 0 : false;
    }t(
AddChannelO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK    void AddChannel(uint8_t aChannel)
    {
        if (aChannel < sizeof(mMask) * CHAR_BIT)
        {
            mMask |= (1UL << aChannel);
        }
    }t(
RemoveChannelO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK    void RemoveChannel(uint8_t aChannel)
    {
        if (aChannel < sizeof(mMask) * CHAR_BIT)
        {
            mMask &= ~(1UL << aChannel);
        }
    }t(	IntersectO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKKQP    void Intersect(const ChannelMask &aOtherMask) { mMask &= aOtherMask.mMask; }t(
operator==O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKChannelMaskt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/channel_mask.hppKKKK]\    bool operator==(const ChannelMask &aAnother) const { return (mMask == aAnother.mMask); }t(GetRadioCapsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppKތSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppKKKK@?    otRadioCaps GetRadioCaps(void) const { return mRadioCaps; }t(GetShortAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppKSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppKKKKGF    ShortAddress GetShortAddress(void) const { return mShortAddress; }t(
GetExtAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKHG    const ExtAddress &GetExtAddress(void) const { return mExtAddress; }t(SetPcapCallbackJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMK    void SetPcapCallback(otLinkPcapCallback aPcapCallback, void *aCallbackContext)
    {
        mPcapCallback.Set(aPcapCallback, aCallbackContext);
    }t(SetRxOnWhenBackoffJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppM#SubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppM#KM#K\[    void SetRxOnWhenBackoff(bool aRxOnWhenBackoff) { mRxOnWhenBackoff = aRxOnWhenBackoff; }t(IsTransmittingOrScanningJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMGSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMGKMGKut    bool IsTransmittingOrScanning(void) const { return (mState == kStateTransmit) || (mState == kStateEnergyScan); }t(GetTransmitFrameJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMZSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMZKMZK?>    TxFrame &GetTransmitFrame(void) { return mTransmitFrame; }t(GetTransmitRetriesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMoSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMoKMoKHG    uint8_t GetTransmitRetries(void) const { return mTransmitRetries; }t(GetCurrentMacKeyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKIH    const KeyMaterial &GetCurrentMacKey(void) const { return mCurrKey; }t(GetPreviousMacKeyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKJI    const KeyMaterial &GetPreviousMacKey(void) const { return mPrevKey; }t(
GetNextMacKeyJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKFE    const KeyMaterial &GetNextMacKey(void) const { return mNextKey; }t(GetFrameCounterJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKCB    uint32_t GetFrameCounter(void) const { return mFrameCounter; }t(SetRadioFilterEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMK^]    void SetRadioFilterEnabled(bool aFilterEnabled) { mRadioFilterEnabled = aFilterEnabled; }t(IsRadioFilterEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKMKJI    bool IsRadioFilterEnabled(void) const { return mRadioFilterEnabled; }t(RadioSupportsCsmaBackoffJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMDSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMDKMGK    bool RadioSupportsCsmaBackoff(void) const
    {
        return ((mRadioCaps & (OT_RADIO_CAPS_CSMA_BACKOFF | OT_RADIO_CAPS_TRANSMIT_RETRIES)) != 0);
    }t(RadioSupportsTransmitSecurityJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMISubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMIKMIKpo    bool RadioSupportsTransmitSecurity(void) const { return ((mRadioCaps & OT_RADIO_CAPS_TRANSMIT_SEC) != 0); }t(RadioSupportsRetriesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMJSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMJKMJKkj    bool RadioSupportsRetries(void) const { return ((mRadioCaps & OT_RADIO_CAPS_TRANSMIT_RETRIES) != 0); }t(RadioSupportsAckTimeoutJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMKKMKKih    bool RadioSupportsAckTimeout(void) const { return ((mRadioCaps & OT_RADIO_CAPS_ACK_TIMEOUT) != 0); }t(RadioSupportsEnergyScanJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMLSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMLKMLKih    bool RadioSupportsEnergyScan(void) const { return ((mRadioCaps & OT_RADIO_CAPS_ENERGY_SCAN) != 0); }t(RadioSupportsTransmitTimingJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMMSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMMKMMKqp    bool RadioSupportsTransmitTiming(void) const { return ((mRadioCaps & OT_RADIO_CAPS_TRANSMIT_TIMING) != 0); }t(RadioSupportsReceiveTimingJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMNSubMact(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/sub_mac.hppMNKMNKon    bool RadioSupportsReceiveTiming(void) const { return ((mRadioCaps & OT_RADIO_CAPS_RECEIVE_TIMING) != 0); }t(
GetTxFrameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKK98    TxFrame &GetTxFrame(void) { return mTxFrame802154; }t(GetBroadcastTxFrameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKK@?    TxFrame &GetBroadcastTxFrame(void) { return GetTxFrame(); }t(ClearL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKKX      void Clear(void)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mTxFrame802154.SetLength(0);
        mTxFrame802154.SetIsARetransmission(false);
        mTxFrame802154.SetIsSecurityProcessed(false);
        mTxFrame802154.SetCsmaCaEnabled(true); // Set to true by default, only set to `false` for CSL transmission
        mTxFrame802154.SetIsHeaderUpdated(false);
#if OPENTHREAD_FTD && OPENTHREAD_CONFIG_MAC_CSL_TRANSMITTER_ENABLE
        mTxFrame802154.SetTxDelay(0);
        mTxFrame802154.SetTxDelayBaseTime(0);
#endif
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTxFrameTrel.SetLength(0);
        mTxFrameTrel.SetIsARetransmission(false);
        mTxFrameTrel.SetIsSecurityProcessed(false);
        mTxFrameTrel.SetCsmaCaEnabled(true);
        mTxFrameTrel.SetIsHeaderUpdated(false);
#endif

#if OPENTHREAD_CONFIG_MULTI_RADIO
        mSelectedRadioTypes.Clear();
        mRequiredRadioTypes.Clear();
#endif
    }t(
SetChannelL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKҌTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKK    void SetChannel(uint8_t aChannel)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mTxFrame802154.SetChannel(aChannel);
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTxFrameTrel.SetChannel(aChannel);
#endif
    }t(SetSequenceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKKX       void SetSequence(uint8_t aSequence)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mTxFrame802154.SetSequence(aSequence);
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTxFrameTrel.SetSequence(aSequence);
#endif
    }t(SetMaxCsmaBackoffsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppKKKKX*      void SetMaxCsmaBackoffs(uint8_t aMaxCsmaBackoffs)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mTxFrame802154.SetMaxCsmaBackoffs(aMaxCsmaBackoffs);
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTxFrameTrel.SetMaxCsmaBackoffs(aMaxCsmaBackoffs);
#endif
    }t(SetMaxFrameRetriesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMTxFramest(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMKX*      void SetMaxFrameRetries(uint8_t aMaxFrameRetries)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mTxFrame802154.SetMaxFrameRetries(aMaxFrameRetries);
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTxFrameTrel.SetMaxFrameRetries(aMaxFrameRetries);
#endif
    }t(SetPanIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM5Linkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM5KM=K    void SetPanId(PanId aPanId)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mSubMac.SetPanId(aPanId);
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.SetPanId(aPanId);
#endif
    }t(GetShortAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMELinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMEKMMK    ShortAddress GetShortAddress(void) const
    {
        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.GetShortAddress();
#else
            mShortAddress;
#endif
    }t(SetShortAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMULinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMUKM\K    void SetShortAddress(ShortAddress aShortAddress)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mSubMac.SetShortAddress(aShortAddress);
#else
        mShortAddress = aShortAddress;
#endif
    }t(
GetExtAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMdLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMdKMlK    const ExtAddress &GetExtAddress(void) const
    {
        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.GetExtAddress();
#else
            mExtAddress;
#endif
    }t(
SetExtAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMtLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMtKM~KX/      void SetExtAddress(const ExtAddress &aExtAddress)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mSubMac.SetExtAddress(aExtAddress);
#else
        mExtAddress = aExtAddress;
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.HandleExtAddressChange();
#endif
    }t(SetPcapCallbackL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMKX6      void SetPcapCallback(otLinkPcapCallback aPcapCallback, void *aCallbackContext)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mSubMac.SetPcapCallback(aPcapCallback, aCallbackContext);
#endif
        OT_UNUSED_VARIABLE(aPcapCallback);
        OT_UNUSED_VARIABLE(aCallbackContext);
    }t(SetRxOnWhenBackoffL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void SetRxOnWhenBackoff(bool aRxOnWhenBackoff)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        mSubMac.SetRxOnWhenBackoff(aRxOnWhenBackoff);
#endif
        OT_UNUSED_VARIABLE(aRxOnWhenBackoff);
    }t(EnableL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void Enable(void)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        IgnoreError(mSubMac.Enable());
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.Enable();
#endif
    }t(DisableL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void Disable(void)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        IgnoreError(mSubMac.Disable());
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.Disable();
#endif
    }t(SleepL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void Sleep(void)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        IgnoreError(mSubMac.Sleep());
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.Sleep();
#endif
    }t(ReceiveL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void Receive(uint8_t aChannel)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        IgnoreError(mSubMac.Receive(aChannel));
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.Receive(aChannel);
#endif
    }t(GetTxFramesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK65    TxFrames &GetTxFrames(void) { return mTxFrames; }t(SendL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK    void Send(void)
    {
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
        SuccessOrAssert(mSubMac.Send());
#endif
#if OPENTHREAD_CONFIG_RADIO_LINK_TREL_ENABLE
        mTrel.Send();
#endif
    }t(GetTransmitRetriesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM5Linkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM5KM=K    uint8_t GetTransmitRetries(void) const
    {
        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.GetTransmitRetries();
#else
            0;
#endif
    }t(GetRssiL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMELinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMEKMMK    int8_t GetRssi(void) const
    {
        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.GetRssi();
#else
            Radio::kInvalidRssi;
#endif
    }t(
EnergyScanL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM[Linkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM[KMfKXU      Error EnergyScan(uint8_t aScanChannel, uint16_t aScanDuration)
    {
        OT_UNUSED_VARIABLE(aScanChannel);
        OT_UNUSED_VARIABLE(aScanDuration);

        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.EnergyScan(aScanChannel, aScanDuration);
#else
            kErrorNotImplemented;
#endif
    }t(
GetNoiseFloorL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMnLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMnKMvK    int8_t GetNoiseFloor(void) const
    {
        return
#if OPENTHREAD_CONFIG_RADIO_LINK_IEEE_802_15_4_ENABLE
            mSubMac.GetNoiseFloor();
#else
            kDefaultNoiseFloor;
#endif
    }t(	GetSubMacL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM~Linkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppM~KM~K0/    SubMac &GetSubMac(void) { return mSubMac; }t(	GetSubMacL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMLinkst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_links.hppMKMK<;    const SubMac &GetSubMac(void) const { return mSubMac; }t(GetBytesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/sha256.hppKVHasht(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/sha256.hppKVK	KVK;:        const uint8_t *GetBytes(void) const { return m8; }t(UpdateL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/sha256.hppK|Sha256t(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/sha256.hppK|KKK    template <typename ObjectType> void Update(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");
        return Update(&aObject, sizeof(ObjectType));
    }t(UpdateQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/hmac_sha256.hppKo
HmacSha256t(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/hmac_sha256.hppKoKKsK    template <typename ObjectType> void Update(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");
        return Update(&aObject, sizeof(ObjectType));
    }t(SecurityPolicyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppKXSecurityPolicyt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppKXKKXK-,    SecurityPolicy(void) { SetToDefault(); }t(GenerateRandomQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppK
NetworkKeyt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppKKKKVU    Error GenerateRandom(void) { return Random::Crypto::FillBuffer(m8, sizeof(m8)); }t(GenerateRandomQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppKPskct(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppKKKKVU    Error GenerateRandom(void) { return Random::Crypto::FillBuffer(m8, sizeof(m8)); }t(	IsPskcSetQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK65    bool IsPskcSet(void) const { return mIsPskcSet; }t(GetCurrentKeySequenceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM?
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM?KM?KHG    uint32_t GetCurrentKeySequence(void) const { return mKeySequence; }t(GetCurrentMleKeyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMc
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMcKMcKML    const Mle::KeyMaterial &GetCurrentMleKey(void) const { return mMleKey; }t(Get154MacFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMv
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMvKMvKVU    uint32_t Get154MacFrameCounter(void) const { return mMacFrameCounters.Get154(); }t(GetMaximumMacFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK^]    uint32_t GetMaximumMacFrameCounter(void) const { return mMacFrameCounters.GetMaximum(); }t(SetStoredMacFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKxw    void SetStoredMacFrameCounter(uint32_t aStoredMacFrameCounter) { mStoredMacFrameCounter = aStoredMacFrameCounter; }t(GetMleFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKIH    uint32_t GetMleFrameCounter(void) const { return mMleFrameCounter; }t(SetMleFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK`_    void SetMleFrameCounter(uint32_t aMleFrameCounter) { mMleFrameCounter = aMleFrameCounter; }t(SetStoredMleFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKxw    void SetStoredMleFrameCounter(uint32_t aStoredMleFrameCounter) { mStoredMleFrameCounter = aStoredMleFrameCounter; }t(GetKekQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK>=    const KekKeyMaterial &GetKek(void) const { return mKek; }t(
ExtractKekQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK:9    void ExtractKek(Kek &aKek) { mKek.ExtractKey(aKek); }t(SetKekQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKa`    void SetKek(const uint8_t *aKekBytes) { SetKek(*reinterpret_cast<const Kek *>(aKekBytes)); }t(GetKekFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKIH    uint32_t GetKekFrameCounter(void) const { return mKekFrameCounter; }t(IncrementKekFrameCounterQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMK@?    void IncrementKekFrameCounter(void) { mKekFrameCounter++; }t(GetKeySwitchGuardTimeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKON    uint32_t GetKeySwitchGuardTime(void) const { return mKeySwitchGuardTime; }t(SetKeySwitchGuardTimeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKlk    void SetKeySwitchGuardTime(uint32_t aKeySwitchGuardTime) { mKeySwitchGuardTime = aKeySwitchGuardTime; }t(GetSecurityPolicyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppMKMKTS    const SecurityPolicy &GetSecurityPolicy(void) const { return mSecurityPolicy; }t(	GetMleKeyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM:
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM:K	M:KHG        const Mle::Key &GetMleKey(void) const { return mKeys.mMleKey; }t(	GetMacKeyQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM;
KeyManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/key_manager.hppM;K	M;KHG        const Mac::Key &GetMacKey(void) const { return mKeys.mMacKey; }t(IsBeaconEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKKKKA@    bool IsBeaconEnabled(void) const { return mBeaconsEnabled; }t(SetBeaconEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKKKKIH    void SetBeaconEnabled(bool aEnabled) { mBeaconsEnabled = aEnabled; }t(GetRxOnWhenIdleF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKKKK?>    bool GetRxOnWhenIdle(void) const { return mRxOnWhenIdle; }t(
GetExtAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKKKKSR    const ExtAddress &GetExtAddress(void) const { return mLinks.GetExtAddress(); }t(
SetExtAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppKKKK]\    void SetExtAddress(const ExtAddress &aExtAddress) { mLinks.SetExtAddress(aExtAddress); }t(GetShortAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMKRQ    ShortAddress GetShortAddress(void) const { return mLinks.GetShortAddress(); }t(SetShortAddressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM
Mact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM
KM
K`_    void SetShortAddress(ShortAddress aShortAddress) { mLinks.SetShortAddress(aShortAddress); }t(
GetPanChannelF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK>=    uint8_t GetPanChannel(void) const { return mPanChannel; }t(GetSupportedChannelMaskF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM;Mact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM;KM;K]\    const ChannelMask &GetSupportedChannelMask(void) const { return mSupportedChannelMask; }t(GetPanIdF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKKMKK21    PanId GetPanId(void) const { return mPanId; }t(GetMaxFrameRetriesDirectF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM[Mact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM[KM[KTS    uint8_t GetMaxFrameRetriesDirect(void) const { return mMaxFrameRetriesDirect; }t(SetMaxFrameRetriesDirectF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMcMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMcKMcKwv    void SetMaxFrameRetriesDirect(uint8_t aMaxFrameRetriesDirect) { mMaxFrameRetriesDirect = aMaxFrameRetriesDirect; }t(GetMaxFrameRetriesIndirectF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMlMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMlKMlKXW    uint8_t GetMaxFrameRetriesIndirect(void) const { return mMaxFrameRetriesIndirect; }t(SetMaxFrameRetriesIndirectF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMtMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMtKMwK    void SetMaxFrameRetriesIndirect(uint8_t aMaxFrameRetriesIndirect)
    {
        mMaxFrameRetriesIndirect = aMaxFrameRetriesIndirect;
    }t(IsActiveScanInProgressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK`_    bool IsActiveScanInProgress(void) const { return IsActiveOrPending(kOperationActiveScan); }t(IsEnergyScanInProgressF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK`_    bool IsEnergyScanInProgress(void) const { return IsActiveOrPending(kOperationEnergyScan); }t(IsPerformingIndirectTransmitF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMKml    bool IsPerformingIndirectTransmit(void) const { return (mOperation == kOperationTransmitDataIndirect); }t(SetPcapCallbackF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK    void SetPcapCallback(otLinkPcapCallback aPcapCallback, void *aCallbackContext)
    {
        mLinks.SetPcapCallback(aPcapCallback, aCallbackContext);
    }t(
IsPromiscuousF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK<;    bool IsPromiscuous(void) const { return mPromiscuous; }t(
ResetCountersF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMKKJ    void ResetCounters(void) { memset(&mCounters, 0, sizeof(mCounters)); }t(GetCountersF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK;:    otMacCounters &GetCounters(void) { return mCounters; }t(
GetNoiseFloorF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM%Mact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM%KM%KHG    int8_t GetNoiseFloor(void) const { return mLinks.GetNoiseFloor(); }t(GetCcaFailureRateF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM:Mact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppM:KM:K_^    uint16_t GetCcaFailureRate(void) const { return mCcaSuccessRateTracker.GetFailureRate(); }t(
SetEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMBMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMBKMBK:9    void SetEnabled(bool aEnable) { mEnabled = aEnable; }t(	IsEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKKMKK43    bool IsEnabled(void) const { return mEnabled; }t(IsRadioFilterEnabledF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK`_    bool IsRadioFilterEnabled(void) const { return mLinks.GetSubMac().IsRadioFilterEnabled(); }t(	IsPendingF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMKgf    bool     IsPending(Operation aOperation) const { return mPendingOperations & (1U << aOperation); }t(
SetPendingF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK\[    void     SetPending(Operation aOperation) { mPendingOperations |= (1U << aOperation); }t(ClearPendingF/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMMact(F/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac.hppMKMK_^    void     ClearPending(Operation aOperation) { mPendingOperations &= ~(1U << aOperation); }t(GetCslTxAttemptsV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKN	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKNK	KNKHG        uint8_t GetCslTxAttempts(void) const { return mCslTxAttempts; }t(IncrementCslTxAttemptsV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKO	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKOK	KOKCB        void    IncrementCslTxAttempts(void) { mCslTxAttempts++; }t(ResetCslTxAttemptsV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKP	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKPK	KPKA@        void    ResetCslTxAttempts(void) { mCslTxAttempts = 0; }t(IsCslSynchronizedV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKR	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKRK	KRKZY        bool IsCslSynchronized(void) const { return mCslSynchronized && mCslPeriod > 0; }t(SetCslSynchronizedV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKS	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKSK	KSK`_        void SetCslSynchronized(bool aCslSynchronized) { mCslSynchronized = aCslSynchronized; }t(
GetCslChannelV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKU	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKUK	KUKBA        uint8_t GetCslChannel(void) const { return mCslChannel; }t(
SetCslChannelV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKV	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKVK	KVKLK        void    SetCslChannel(uint8_t aChannel) { mCslChannel = aChannel; }t(
GetCslTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKX	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKXK	KXKCB        uint32_t GetCslTimeout(void) const { return mCslTimeout; }t(
SetCslTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKY	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKYK	KYKNM        void     SetCslTimeout(uint32_t aTimeout) { mCslTimeout = aTimeout; }t(GetCslPeriodV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK[	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK[K	K[KA@        uint16_t GetCslPeriod(void) const { return mCslPeriod; }t(SetCslPeriodV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK\	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK\K	K\KJI        void     SetCslPeriod(uint16_t aPeriod) { mCslPeriod = aPeriod; }t(GetCslPhaseV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK^	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK^K	K^K?>        uint16_t GetCslPhase(void) const { return mCslPhase; }t(SetCslPhaseV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK_	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppK_K	K_KFE        void     SetCslPhase(uint16_t aPhase) { mCslPhase = aPhase; }t(GetCslLastHeardV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKa	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKaK	KaKHG        TimeMilli GetCslLastHeard(void) const { return mCslLastHeard; }t(SetCslLastHeardV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKb	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKbK	KbK^]        void      SetCslLastHeard(TimeMilli aCslLastHeard) { mCslLastHeard = aCslLastHeard; }t(GetLastRxTimestampV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKd	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKdK	KdKLK        uint64_t GetLastRxTimestamp(void) const { return mLastRxTimstamp; }t(SetLastRxTimestampV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKe	ChildInfot(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/csl_tx_scheduler.hppKeK	KeKgf        void     SetLastRxTimestamp(uint64_t aLastRxTimestamp) { mLastRxTimstamp = aLastRxTimestamp; }t(IsDataPollPendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKa	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKaK	KaKHG        bool IsDataPollPending(void) const { return mDataPollPending; }t(SetDataPollPendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKb	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKbK	KbKPO        void SetDataPollPending(bool aPending) { mDataPollPending = aPending; }t(GetIndirectFrameCounterT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKd	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKdK	KdKWV        uint32_t GetIndirectFrameCounter(void) const { return mIndirectFrameCounter; }t(SetIndirectFrameCounterT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKe	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKeK	KeKlk        void     SetIndirectFrameCounter(uint32_t aFrameCounter) { mIndirectFrameCounter = aFrameCounter; }t(GetIndirectKeyIdT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKg	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKgK	KgKHG        uint8_t GetIndirectKeyId(void) const { return mIndirectKeyId; }t(SetIndirectKeyIdT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKh	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKhK	KhKNM        void    SetIndirectKeyId(uint8_t aKeyId) { mIndirectKeyId = aKeyId; }t(GetIndirectTxAttemptsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKj	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKjK	KjKRQ        uint8_t GetIndirectTxAttempts(void) const { return mIndirectTxAttempts; }t(ResetIndirectTxAttemptsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKk	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKkK	KkKKJ        void    ResetIndirectTxAttempts(void) { mIndirectTxAttempts = 0; }t(IncrementIndirectTxAttemptsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKl	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKlK	KlKML        void    IncrementIndirectTxAttempts(void) { mIndirectTxAttempts++; }t(GetIndirectDataSequenceNumberT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKn	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKnK	KnKSR        uint8_t GetIndirectDataSequenceNumber(void) const { return mIndirectDsn; }t(SetIndirectDataSequenceNumberT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKo	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKoK	KoKUT        void    SetIndirectDataSequenceNumber(uint8_t aDsn) { mIndirectDsn = aDsn; }t(IsFramePurgePendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKq	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKqK	KqKLK        bool IsFramePurgePending(void) const { return mFramePurgePending; }t(SetFramePurgePendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKr	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKrK	KrK^]        void SetFramePurgePending(bool aPurgePending) { mFramePurgePending = aPurgePending; }t(IsFrameReplacePendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKt	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKtK	KtKPO        bool IsFrameReplacePending(void) const { return mFrameReplacePending; }t(SetFrameReplacePendingT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKu	ChildInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_handler.hppKuK	KuKfe        void SetFrameReplacePending(bool aReplacePending) { mFrameReplacePending = aReplacePending; }t(	IsEnabledZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/src_match_controller.hppKXSourceMatchControllert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/src_match_controller.hppKXKKXK43    bool IsEnabled(void) const { return mEnabled; }t(GetIndirectMessageCountU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKa	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKaK	KaKUT        uint16_t GetIndirectMessageCount(void) const { return mQueuedMessageCount; }t(GetIndirectMessageU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKd	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKdK	KdKGF        Message *GetIndirectMessage(void) { return mIndirectMessage; }t(SetIndirectMessageU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKe	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKeK	KeKXW        void     SetIndirectMessage(Message *aMessage) { mIndirectMessage = aMessage; }t(GetIndirectFragmentOffsetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKg	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKgK	KgK[Z        uint16_t GetIndirectFragmentOffset(void) const { return mIndirectFragmentOffset; }t(SetIndirectFragmentOffsetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKh	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKhK	KhKts        void     SetIndirectFragmentOffset(uint16_t aFragmentOffset) { mIndirectFragmentOffset = aFragmentOffset; }t(GetIndirectTxSuccessU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKj	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKjK	KjKML        bool GetIndirectTxSuccess(void) const { return mIndirectTxSuccess; }t(SetIndirectTxSuccessU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKk	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKkK	KkKVU        void SetIndirectTxSuccess(bool aTxStatus) { mIndirectTxSuccess = aTxStatus; }t(IsIndirectSourceMatchShortU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKm	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKmK	KmKQP        bool IsIndirectSourceMatchShort(void) const { return mUseShortAddress; }t(SetIndirectSourceMatchShortU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKn	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKnK	KnKUT        void SetIndirectSourceMatchShort(bool aShort) { mUseShortAddress = aShort; }t(IsIndirectSourceMatchPendingU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKp	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKpK	KpKVU        bool IsIndirectSourceMatchPending(void) const { return mSourceMatchPending; }t(SetIndirectSourceMatchPendingU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKq	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKqK	KqK^]        void SetIndirectSourceMatchPending(bool aPending) { mSourceMatchPending = aPending; }t(IncrementIndirectMessageCountU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKs	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKsK	KsKLK        void IncrementIndirectMessageCount(void) { mQueuedMessageCount++; }t(DecrementIndirectMessageCountU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKt	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKtK	KtKLK        void DecrementIndirectMessageCount(void) { mQueuedMessageCount--; }t(ResetIndirectMessageCountU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKu	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKuK	KuKJI        void ResetIndirectMessageCount(void) { mQueuedMessageCount = 0; }t(IsWaitingForMessageUpdateU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKw	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKwK	KwKXW        bool IsWaitingForMessageUpdate(void) const { return mWaitingForMessageUpdate; }t(SetWaitingForMessageUpdateU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKx	ChildInfot(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKxK	KxKhg        void SetWaitingForMessageUpdate(bool aNeedsUpdate) { mWaitingForMessageUpdate = aNeedsUpdate; }t(StartU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKIndirectSendert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/indirect_sender.hppKKKK*)    void Start(void) { mEnabled = true; }t(GetTypeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKHTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKHKKHK21    uint8_t GetType(void) const { return mType; }t(SetTypeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKPTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKPKKPK32    void SetType(uint8_t aType) { mType = aType; }t(
IsExtendedJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKYTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKYKKYKIH    bool IsExtended(void) const { return (mLength == kExtendedLength); }t(	GetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKeTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKeKKeK65    uint8_t GetLength(void) const { return mLength; }t(	SetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKmTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKmKKmK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(GetNextJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKKKKji    Tlv *GetNext(void) { return reinterpret_cast<Tlv *>(reinterpret_cast<uint8_t *>(this) + GetSize()); }t(GetNextJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKKKK    const Tlv *GetNext(void) const
    {
        return reinterpret_cast<const Tlv *>(reinterpret_cast<const uint8_t *>(this) + GetSize());
    }t(ReadJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKΌTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKKKK    template <typename SimpleTlvType>
    static Error Read(const Message &aMessage, uint16_t aOffset, typename SimpleTlvType::ValueType &aValue)
    {
        return ReadTlvValue(aMessage, aOffset, &aValue, sizeof(aValue));
    }t(ReadJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKKKK    template <typename UintTlvType>
    static Error Read(const Message &aMessage, uint16_t aOffset, typename UintTlvType::UintValueType &aValue)
    {
        return ReadUintTlv(aMessage, aOffset, aValue);
    }t(ReadJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppKKKK    template <typename StringTlvType>
    static Error Read(const Message &aMessage, uint16_t aOffset, typename StringTlvType::StringType &aValue)
    {
        return ReadStringTlv(aMessage, aOffset, StringTlvType::kMaxStringLength, aValue);
    }t(FindTlvJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename TlvType> static Error FindTlv(const Message &aMessage, TlvType &aTlv)
    {
        return FindTlv(aMessage, TlvType::kType, sizeof(TlvType), aTlv);
    }t(FindJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMQTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMQKMTK    template <typename TlvType> static Error Find(const Message &aMessage, void *aValue, uint8_t aLength)
    {
        return FindTlv(aMessage, TlvType::kType, aValue, aLength);
    }t(FindJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMjTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMjKMnK    template <typename SimpleTlvType>
    static Error Find(const Message &aMessage, typename SimpleTlvType::ValueType &aValue)
    {
        return FindTlv(aMessage, SimpleTlvType::kType, &aValue, sizeof(aValue));
    }tu((FindJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename UintTlvType>
    static Error Find(const Message &aMessage, typename UintTlvType::UintValueType &aValue)
    {
        return FindUintTlv(aMessage, UintTlvType::kType, aValue);
    }t(FindJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename StringTlvType>
    static Error Find(const Message &aMessage, typename StringTlvType::StringType &aValue)
    {
        return FindStringTlv(aMessage, StringTlvType::kType, StringTlvType::kMaxStringLength, aValue);
    }t(AppendJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename TlvType> static Error Append(Message &aMessage, const void *aValue, uint8_t aLength)
    {
        return AppendTlv(aMessage, TlvType::kType, aValue, aLength);
    }t(AppendJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename SimpleTlvType>
    static Error Append(Message &aMessage, const typename SimpleTlvType::ValueType &aValue)
    {
        return AppendTlv(aMessage, SimpleTlvType::kType, &aValue, sizeof(aValue));
    }t(AppendJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename UintTlvType> static Error Append(Message &aMessage, typename UintTlvType::UintValueType aValue)
    {
        return AppendUintTlv(aMessage, UintTlvType::kType, aValue);
    }t(AppendJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMK    template <typename StringTlvType> static Error Append(Message &aMessage, const char *aValue)
    {
        return AppendStringTlv(aMessage, StringTlvType::kType, StringTlvType::kMaxStringLength, aValue);
    }t(	GetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMExtendedTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMKMKCB    uint16_t GetLength(void) const { return HostSwap16(mLength); }t(	SetLengthJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppM!ExtendedTlvt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppM!KM%K    void SetLength(uint16_t aLength)
    {
        Tlv::SetLength(kExtendedLength);
        mLength = HostSwap16(aLength);
    }t(AsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppM5Nt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppM5KM5KYXtemplate <class TlvType> TlvType *As(Tlv *aTlv) { return static_cast<TlvType *>(aTlv); }t(AsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMANt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMAKMAKkjtemplate <class TlvType> const TlvType *As(const Tlv *aTlv) { return static_cast<const TlvType *>(aTlv); }t(AsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMMNt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMMA      KMMKYXtemplate <class TlvType> TlvType &As(Tlv &aTlv) { return static_cast<TlvType &>(aTlv); }t(AsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMYNt(J/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/tlvs.hppMYKMYKkjtemplate <class TlvType> const TlvType &As(const Tlv &aTlv) { return static_cast<const TlvType &>(aTlv); }t(
GetSecondsP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKQ	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKQKKTK    uint64_t GetSeconds(void) const
    {
        return (static_cast<uint64_t>(HostSwap16(mSeconds16)) << 32) + HostSwap32(mSeconds32);
    }t(
SetSecondsP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK\	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK\KK`K    void SetSeconds(uint64_t aSeconds)
    {
        mSeconds16 = HostSwap16(static_cast<uint16_t>(aSeconds >> 32));
        mSeconds32 = HostSwap32(static_cast<uint32_t>(aSeconds & 0xffffffff));
    }t(GetTicksP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKh	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKhKKhKQP    uint16_t GetTicks(void) const { return HostSwap16(mTicks) >> kTicksOffset; }t(SetTicksP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKp	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKpKKsK    void SetTicks(uint16_t aTicks)
    {
        mTicks = HostSwap16((HostSwap16(mTicks) & ~kTicksMask) | ((aTicks << kTicksOffset) & kTicksMask));
    }t(GetAuthoritativeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK{	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK{KK{Ka`    bool GetAuthoritative(void) const { return (HostSwap16(mTicks) & kAuthoritativeMask) != 0; }t(SetAuthoritativeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKKKK    void SetAuthoritative(bool aAuthoritative)
    {
        mTicks = HostSwap16((HostSwap16(mTicks) & kTicksMask) |
                            ((aAuthoritative << kAuthoritativeOffset) & kAuthoritativeMask));
    }t(IsOrphanTimestampP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppK	Timestampt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/timestamp.hppKKKKnm    bool IsOrphanTimestamp(void) const { return GetSeconds() == 0 && GetTicks() == 0 && GetAuthoritative(); }t(GetTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppKTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppKKKKON    Type GetType(void) const { return static_cast<Type>(ot::Tlv::GetType()); }t(SetTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppKTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppKKKKPO    void SetType(Type aType) { ot::Tlv::SetType(static_cast<uint8_t>(aType)); }t(GetRouterIdSequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKJI    uint8_t GetRouterIdSequence(void) const { return mRouterIdSequence; }t(SetRouterIdSequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKSR    void SetRouterIdSequence(uint8_t aSequence) { mRouterIdSequence = aSequence; }t(GetRouterIdMaskN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM"RouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM"KM"KML    const RouterIdSet &GetRouterIdMask(void) const { return mRouterIdMask; }t(SetRouterIdMaskN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM*RouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM*KM*K\[    void SetRouterIdMask(const RouterIdSet &aRouterIdSet) { mRouterIdMask = aRouterIdSet; }t(
IsRouterIdSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM5RouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM5KM5K^]    bool IsRouterIdSet(uint8_t aRouterId) const { return mRouterIdMask.Contains(aRouterId); }t(IsSingletonN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM>RouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM>KM>Kih    bool IsSingleton(void) const { return IsValid() && (mRouterIdMask.GetNumberOfAllocatedIds() <= 1); }t(GetRouteDataLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMFRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMFKMFKwv    uint8_t GetRouteDataLength(void) const { return GetLength() - sizeof(mRouterIdSequence) - sizeof(mRouterIdMask); }t(SetRouteDataLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMNRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMNKMNKyx    void SetRouteDataLength(uint8_t aLength) { SetLength(sizeof(mRouterIdSequence) + sizeof(mRouterIdMask) + aLength); }t(GetRouteCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMXRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMXKMXKkj    uint8_t GetRouteCost(uint8_t aRouterIndex) const { return mRouteData[aRouterIndex] & kRouteCostMask; }t(GetLinkQualityInN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMbRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMbKMeK    LinkQuality GetLinkQualityIn(uint8_t aRouterIndex) const
    {
        return static_cast<LinkQuality>((mRouteData[aRouterIndex] & kLinkQualityInMask) >> kLinkQualityInOffset);
    }t(GetLinkQualityOutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMoRouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMoKMrK    LinkQuality GetLinkQualityOut(uint8_t aRouterIndex) const
    {
        return static_cast<LinkQuality>((mRouteData[aRouterIndex] & kLinkQualityOutMask) >> kLinkQualityOutOffset);
    }t(SetRouteDataN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM}RouteTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM}KMKX      void SetRouteData(uint8_t aRouterIndex, LinkQuality aLinkQualityIn, LinkQuality aLinkQualityOut, uint8_t aRouteCost)
    {
        mRouteData[aRouterIndex] = (((aLinkQualityIn << kLinkQualityInOffset) & kLinkQualityInMask) |
                                    ((aLinkQualityOut << kLinkQualityOutOffset) & kLinkQualityOutMask) |
                                    ((aRouteCost << kRouteCostOffset) & kRouteCostMask));
    }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
LeaderDataTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKm    void Init(void)
    {
        SetType(kLeaderData);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
LeaderDataTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
LeaderDataTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKXK      void Get(LeaderData &aLeaderData) const
    {
        aLeaderData.SetPartitionId(HostSwap32(mPartitionId));
        aLeaderData.SetWeighting(mWeighting);
        aLeaderData.SetDataVersion(mDataVersion);
        aLeaderData.SetStableDataVersion(mStableDataVersion);
        aLeaderData.SetLeaderRouterId(mLeaderRouterId);
    }t(SetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
LeaderDataTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKX      void Set(const LeaderData &aLeaderData)
    {
        mPartitionId       = HostSwap32(aLeaderData.GetPartitionId());
        mWeighting         = aLeaderData.GetWeighting();
        mDataVersion       = aLeaderData.GetDataVersion(NetworkData::kFullSet);
        mStableDataVersion = aLeaderData.GetDataVersion(NetworkData::kStableSubset);
        mLeaderRouterId    = aLeaderData.GetLeaderRouterId();
    }t(IsRouterFlagSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMScanMaskTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKVU    static bool IsRouterFlagSet(uint8_t aMask) { return (aMask & kRouterFlag) != 0; }t(IsEndDeviceFlagSetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMScanMaskTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK\[    static bool IsEndDeviceFlagSet(uint8_t aMask) { return (aMask & kEndDeviceFlag) != 0; }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKo    void Init(void)
    {
        SetType(kConnectivity);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK    bool IsValid(void) const
    {
        return IsSedBufferingIncluded() ||
               (GetLength() == sizeof(*this) - sizeof(Tlv) - sizeof(mSedBufferSize) - sizeof(mSedDatagramCount));
    }t(IsSedBufferingIncludedN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKcb    bool IsSedBufferingIncluded(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetParentPriorityN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK    int8_t GetParentPriority(void) const
    {
        return (static_cast<int8_t>(mParentPriority & kParentPriorityMask)) >> kParentPriorityOffset;
    }t(SetParentPriorityN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK    void SetParentPriority(int8_t aParentPriority)
    {
        mParentPriority = (static_cast<uint8_t>(aParentPriority) << kParentPriorityOffset) & kParentPriorityMask;
    }t(GetLinkQuality3N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKBA    uint8_t GetLinkQuality3(void) const { return mLinkQuality3; }t(SetLinkQuality3N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM"ConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM"KM"KQP    void SetLinkQuality3(uint8_t aLinkQuality) { mLinkQuality3 = aLinkQuality; }t(GetLinkQuality2N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM*ConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM*KM*KBA    uint8_t GetLinkQuality2(void) const { return mLinkQuality2; }t(SetLinkQuality2N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM2ConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM2KM2KQP    void SetLinkQuality2(uint8_t aLinkQuality) { mLinkQuality2 = aLinkQuality; }t(GetLinkQuality1N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM:ConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM:KM:KBA    uint8_t GetLinkQuality1(void) const { return mLinkQuality1; }t(SetLinkQuality1N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMBConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMBKMBKQP    void SetLinkQuality1(uint8_t aLinkQuality) { mLinkQuality1 = aLinkQuality; }t(GetActiveRoutersN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMJConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMJKMJKDC    uint8_t GetActiveRouters(void) const { return mActiveRouters; }t(SetActiveRoutersN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMRConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMRKMRKWV    void SetActiveRouters(uint8_t aActiveRouters) { mActiveRouters = aActiveRouters; }t(
GetLeaderCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMZConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMZKMZK>=    uint8_t GetLeaderCost(void) const { return mLeaderCost; }t(
SetLeaderCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMbConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMbKMbK?>    void SetLeaderCost(uint8_t aCost) { mLeaderCost = aCost; }t(
GetIdSequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMjConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMjKMjK>=    uint8_t GetIdSequence(void) const { return mIdSequence; }t(
SetIdSequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMrConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMrKMrKGF    void SetIdSequence(uint8_t aSequence) { mIdSequence = aSequence; }t(GetSedBufferSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMzConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMzKMKX	      uint16_t GetSedBufferSize(void) const
    {
        uint16_t buffersize = OPENTHREAD_CONFIG_DEFAULT_SED_BUFFER_SIZE;

        if (IsSedBufferingIncluded())
        {
            buffersize = HostSwap16(mSedBufferSize);
        }
        return buffersize;
    }t(SetSedBufferSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKdc    void SetSedBufferSize(uint16_t aSedBufferSize) { mSedBufferSize = HostSwap16(aSedBufferSize); }t(GetSedDatagramCountN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK    uint8_t GetSedDatagramCount(void) const
    {
        uint8_t count = OPENTHREAD_CONFIG_DEFAULT_SED_DATAGRAM_COUNT;

        if (IsSedBufferingIncluded())
        {
            count = mSedDatagramCount;
        }
        return count;
    }t(SetSedDatagramCountN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMConnectivityTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKcb    void SetSedDatagramCount(uint8_t aSedDatagramCount) { mSedDatagramCount = aSedDatagramCount; }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKwv    uint8_t GetLength(void) const { return sizeof(mControl) + (IsCompressed() ? sizeof(mIid) : sizeof(mIp6Address)); }t(IsCompressedN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKLK    bool IsCompressed(void) const { return (mControl & kCompressed) != 0; }t(SetUncompressedN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK10    void SetUncompressed(void) { mControl = 0; }t(GetContextIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKED    uint8_t GetContextId(void) const { return mControl & kCidMask; }t(SetContextIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKSR    void SetContextId(uint8_t aContextId) { mControl = kCompressed | aContextId; }t(GetIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKHG    const Ip6::InterfaceIdentifier &GetIid(void) const { return mIid; }t(SetIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKGF    void SetIid(const Ip6::InterfaceIdentifier &aIid) { mIid = aIid; }t(
GetIp6AddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
AddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
KM
KJI    const Ip6::Address &GetIp6Address(void) const { return mIp6Address; }t(
SetIp6AddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAddressRegistrationEntryt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKQP    void SetIp6Address(const Ip6::Address &aAddress) { mIp6Address = aAddress; }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM,
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM,KM0Kj    void Init(void)
    {
        SetType(kChannel);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM9
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM9KM9KTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetChannelPageN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMA
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMAKMAK@?    uint8_t GetChannelPage(void) const { return mChannelPage; }t(SetChannelPageN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMI
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMIKMIKON    void SetChannelPage(uint8_t aChannelPage) { mChannelPage = aChannelPage; }t(
GetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMQ
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMQKMQKED    uint16_t GetChannel(void) const { return HostSwap16(mChannel); }t(
SetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMY
ChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMYKMYKLK    void SetChannel(uint16_t aChannel) { mChannel = HostSwap16(aChannel); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKm    void Init(void)
    {
        SetType(kCslChannel);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetChannelPageN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMK@?    uint8_t GetChannelPage(void) const { return mChannelPage; }t(SetChannelPageN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKON    void SetChannelPage(uint8_t aChannelPage) { mChannelPage = aChannelPage; }t(
GetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKED    uint16_t GetChannel(void) const { return HostSwap16(mChannel); }t(
SetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM
CslChannelTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKLK    void SetChannel(uint16_t aChannel) { mChannel = HostSwap16(aChannel); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMCslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKs    void Init(void)
    {
        SetType(kCslClockAccuracy);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMCslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetCslClockAccuracyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMCslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKJI    uint8_t GetCslClockAccuracy(void) const { return mCslClockAccuracy; }t(SetCslClockAccuracyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMCslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKcb    void SetCslClockAccuracy(uint8_t aCslClockAccuracy) { mCslClockAccuracy = aCslClockAccuracy; }t(GetCslUncertaintyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMCslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppMKMKFE    uint8_t GetCslUncertainty(void) const { return mCslUncertainty; }t(SetCslUncertaintyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM&CslClockAccuracyTlvt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_tlvs.hppM&KM&K[Z    void SetCslUncertainty(uint8_t aCslUncertainty) { mCslUncertainty = aCslUncertainty; }t(AddressMatcherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKAddressMatchert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKK	KK
        AddressMatcher(Mac::ShortAddress aShortAddress, StateFilter aStateFilter)
            : AddressMatcher(aStateFilter, aShortAddress, nullptr)
        {
        }t(AddressMatcherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKAddressMatchert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKK	KK
        AddressMatcher(const Mac::ExtAddress &aExtAddress, StateFilter aStateFilter)
            : AddressMatcher(aStateFilter, Mac::kShortAddrInvalid, &aExtAddress)
        {
        }t(AddressMatcherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKAddressMatchert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKK	KK
X          AddressMatcher(const Mac::Address &aMacAddress, StateFilter aStateFilter)
            : AddressMatcher(aStateFilter,
                             aMacAddress.IsShort() ? aMacAddress.GetShort()
                                                   : static_cast<Mac::ShortAddress>(Mac::kShortAddrInvalid),
                             aMacAddress.IsExtended() ? &aMacAddress.GetExtended() : nullptr)
        {
        }t(AddressMatcherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKAddressMatchert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKK	KK
        explicit AddressMatcher(StateFilter aStateFilter)
            : AddressMatcher(aStateFilter, Mac::kShortAddrInvalid, nullptr)
        {
        }t(AddressMatcherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKAddressMatchert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKK	KK
X          AddressMatcher(StateFilter aStateFilter, Mac::ShortAddress aShortAddress, const Mac::ExtAddress *aExtAddress)
            : mStateFilter(aStateFilter)
            , mShortAddress(aShortAddress)
            , mExtAddress(aExtAddress)
        {
        }t(GetStateN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKیNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKKKKFE    State GetState(void) const { return static_cast<State>(mState); }t(SetStateN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKKKKKJ    void SetState(State aState) { mState = static_cast<uint8_t>(aState); }t(IsStateInvalidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKKKKJI    bool IsStateInvalid(void) const { return (mState == kStateInvalid); }t(IsStateChildIdRequestN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKKKKXW    bool IsStateChildIdRequest(void) const { return (mState == kStateChildIdRequest); }t(IsStateLinkRequestN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppKKKKRQ    bool IsStateLinkRequest(void) const { return (mState == kStateLinkRequest); }t(IsStateParentResponseN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKXW    bool IsStateParentResponse(void) const { return (mState == kStateParentResponse); }t(IsStateRestoringN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKut    bool IsStateRestoring(void) const { return (mState == kStateRestored) || (mState == kStateChildUpdateRequest); }t(IsStateRestoredN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKLK    bool IsStateRestored(void) const { return (mState == kStateRestored); }t(IsStateValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKFE    bool IsStateValid(void) const { return (mState == kStateValid); }t(IsStateValidOrRestoringN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM%Neighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM%KM%Kgf    bool IsStateValidOrRestoring(void) const { return (mState == kStateValid) || IsStateRestoring(); }t(MatchesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMDNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMDKMDK[Z    bool Matches(const AddressMatcher &aMatcher) const { return aMatcher.Matches(*this); }t(
GetDeviceModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMLNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMLKMLKQP    Mle::DeviceMode GetDeviceMode(void) const { return Mle::DeviceMode(mMode); }t(
SetDeviceModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMTNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMTKMTKGF    void SetDeviceMode(Mle::DeviceMode aMode) { mMode = aMode.Get(); }t(IsRxOnWhenIdleN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM\Neighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM\KM\KQP    bool IsRxOnWhenIdle(void) const { return GetDeviceMode().IsRxOnWhenIdle(); }t(IsFullThreadDeviceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMdNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMdKMdKYX    bool IsFullThreadDevice(void) const { return GetDeviceMode().IsFullThreadDevice(); }t(GetNetworkDataTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMlNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMlKMlKfe    NetworkData::Type GetNetworkDataType(void) const { return GetDeviceMode().GetNetworkDataType(); }t(ClearExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMrNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMrKMrKKJ    void ClearExtAddress(void) { memset(&mMacAddr, 0, sizeof(mMacAddr)); }t(
GetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMzNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMzKMzKJI    const Mac::ExtAddress &GetExtAddress(void) const { return mMacAddr; }t(
SetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKQP    void SetExtAddress(const Mac::ExtAddress &aAddress) { mMacAddr = aAddress; }t(GetKeySequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKA@    uint32_t GetKeySequence(void) const { return mKeySequence; }t(SetKeySequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKPO    void SetKeySequence(uint32_t aKeySequence) { mKeySequence = aKeySequence; }t(GetLastHeardN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK>=    TimeMilli GetLastHeard(void) const { return mLastHeard; }t(SetLastHeardN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKIH    void SetLastHeard(TimeMilli aLastHeard) { mLastHeard = aLastHeard; }t(GetLinkFrameCountersN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKkj    Mac::LinkFrameCounters &GetLinkFrameCounters(void) { return mValidPending.mValid.mLinkFrameCounters; }t(GetLinkFrameCountersN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKwv    const Mac::LinkFrameCounters &GetLinkFrameCounters(void) const { return mValidPending.mValid.mLinkFrameCounters; }t(GetLinkAckFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKfe    uint32_t GetLinkAckFrameCounter(void) const { return mValidPending.mValid.mLinkAckFrameCounter; }t(SetLinkAckFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKX      void SetLinkAckFrameCounter(uint32_t aAckFrameCounter)
    {
#if OPENTHREAD_CONFIG_THREAD_VERSION >= OT_THREAD_VERSION_1_2
        mValidPending.mValid.mLinkAckFrameCounter = aAckFrameCounter;
#else
        OT_UNUSED_VARIABLE(aAckFrameCounter);
#endif
    }t(GetMleFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK^]    uint32_t GetMleFrameCounter(void) const { return mValidPending.mValid.mMleFrameCounter; }t(SetMleFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKon    void SetMleFrameCounter(uint32_t aFrameCounter) { mValidPending.mValid.mMleFrameCounter = aFrameCounter; }t(	GetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK76    uint16_t GetRloc16(void) const { return mRloc16; }t(GetRouterIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKPO    uint8_t GetRouterId(void) const { return mRloc16 >> Mle::kRouterIdOffset; }t(	SetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK<;    void SetRloc16(uint16_t aRloc16) { mRloc16 = aRloc16; }t(IsThreadVersion1p1N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM1Neighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM1KM1Kml    bool IsThreadVersion1p1(void) const { return mState != kStateInvalid && mVersion == kThreadVersion1p1; }t(IsThreadVersion1p2OrHigherN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM9Neighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM9KM9Kut    bool IsThreadVersion1p2OrHigher(void) const { return mState != kStateInvalid && mVersion >= kThreadVersion1p2; }t(IsThreadVersionCslCapableN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMANeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAKMAKml    bool IsThreadVersionCslCapable(void) const { return IsThreadVersion1p2OrHigher() && !IsRxOnWhenIdle(); }t(IsEnhancedKeepAliveSupportedN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMINeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMIKMLK    bool IsEnhancedKeepAliveSupported(void) const
    {
        return (mState != kStateInvalid) && (mVersion >= kThreadVersion1p2);
    }t(
GetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMRNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMRKMRK98    uint16_t GetVersion(void) const { return mVersion; }t(
SetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMZNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMZKMZK@?    void SetVersion(uint16_t aVersion) { mVersion = aVersion; }t(GetLinkFailuresN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMbNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMbKMbKBA    uint8_t GetLinkFailures(void) const { return mLinkFailures; }t(IncrementLinkFailuresN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMhNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMhKMhK:9    void IncrementLinkFailures(void) { mLinkFailures++; }t(ResetLinkFailuresN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMnNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMnKMnK87    void ResetLinkFailures(void) { mLinkFailures = 0; }t(GetLinkInfoN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMvNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMvKMvK=<    LinkQualityInfo &GetLinkInfo(void) { return mLinkInfo; }t(GetLinkInfoN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM~Neighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM~KM~KIH    const LinkQualityInfo &GetLinkInfo(void) const { return mLinkInfo; }t(GetLinkQualityInN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKXW    LinkQuality GetLinkQualityIn(void) const { return GetLinkInfo().GetLinkQuality(); }t(GetChallengeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKZY    const uint8_t *GetChallenge(void) const { return mValidPending.mPending.mChallenge; }t(GetChallengeSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMNeighbort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK_^    uint8_t GetChallengeSize(void) const { return sizeof(mValidPending.mPending.mChallenge); }t(AddressIteratorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK
        explicit AddressIterator(const Child &aChild, Ip6::Address::TypeFilter aFilter = Ip6::Address::kTypeAny)
            : AddressIterator(aChild, 0, aFilter)
        {
        }t(AddressIteratorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK
        AddressIterator(const Child &aChild, Index aIndex, Ip6::Address::TypeFilter aFilter = Ip6::Address::kTypeAny)
            : mChild(aChild)
            , mFilter(aFilter)
            , mIndex(aIndex)
        {
            Update();
        }t(
GetAsIndexN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK87        Index GetAsIndex(void) const { return mIndex; }t(GetChildN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK=<        const Child &GetChild(void) const { return mChild; }t(IsDoneN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MKBA        bool IsDone(void) const { return (mIndex >= kMaxIndex); }t(
operator++N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK65        void operator++(void) { mIndex++, Update(); }t(
operator++N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK54        void operator++(int) { mIndex++, Update(); }t(	operator*N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MKLK        const Ip6::Address &operator*(void) const { return *GetAddress(); }t(
operator==N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MKcb        bool operator==(const AddressIterator &aOther) const { return (mIndex == aOther.mIndex); }t(AddressIteratorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK
        AddressIterator(const Child &aChild, IteratorType)
            : mChild(aChild)
            , mIndex(kMaxIndex)
        {
        }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKBA    void Init(Instance &aInstance) { Neighbor::Init(aInstance); }t(GetMeshLocalIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM(Childt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM(KM(KZY    const Ip6::InterfaceIdentifier &GetMeshLocalIid(void) const { return mMeshLocalIid; }t(IterateIp6AddressesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM;Childt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM;KM>K    AddressIteratorBuilder IterateIp6Addresses(Ip6::Address::TypeFilter aFilter = Ip6::Address::kTypeAny) const
    {
        return AddressIteratorBuilder(*this, aFilter);
    }t(
GetTimeoutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMtChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMtKMtK98    uint32_t GetTimeout(void) const { return mTimeout; }t(
SetTimeoutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM|Childt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppM|KM|K@?    void SetTimeout(uint32_t aTimeout) { mTimeout = aTimeout; }t(GetNetworkDataVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKNM    uint8_t GetNetworkDataVersion(void) const { return mNetworkDataVersion; }t(SetNetworkDataVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKUT    void SetNetworkDataVersion(uint8_t aVersion) { mNetworkDataVersion = aVersion; }t(GetChallengeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKIH    const uint8_t *GetChallenge(void) const { return mAttachChallenge; }t(GetChallengeSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKNM    uint8_t GetChallengeSize(void) const { return sizeof(mAttachChallenge); }t(ClearRequestTlvsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKdc    void ClearRequestTlvs(void) { memset(mRequestTlvs, Mle::Tlv::kInvalid, sizeof(mRequestTlvs)); }t(
GetRequestTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKQP    uint8_t GetRequestTlv(uint8_t aIndex) const { return mRequestTlvs[aIndex]; }t(
SetRequestTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKXW    void SetRequestTlv(uint8_t aIndex, uint8_t aType) { mRequestTlvs[aIndex] = aType; }t($IncrementSecondsSinceLastSupervisionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKTS    void IncrementSecondsSinceLastSupervision(void) { mSecondsSinceSupervision++; }t(GetSecondsSinceLastSupervisionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK]\    uint16_t GetSecondsSinceLastSupervision(void) const { return mSecondsSinceSupervision; }t( ResetSecondsSinceLastSupervisionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKRQ    void ResetSecondsSinceLastSupervision(void) { mSecondsSinceSupervision = 0; }t(HasAnyMlrRegisteredAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKXW    bool HasAnyMlrRegisteredAddress(void) const { return mMlrRegisteredMask.HasAny(); }t(HasAnyMlrToRegisterAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMChildt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKXW    bool HasAnyMlrToRegisterAddress(void) const { return mMlrToRegisterMask.HasAny(); }t(AddressIteratorBuilderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MK
        AddressIteratorBuilder(const Child &aChild, Ip6::Address::TypeFilter aFilter)
            : mChild(aChild)
            , mFilter(aFilter)
        {
        }t(beginN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MKQP        AddressIterator begin(void) { return AddressIterator(mChild, mFilter); }t(endN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMAddressIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMK	MKed        AddressIterator end(void) { return AddressIterator(mChild, AddressIterator::kEndIterator); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMfRoutert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMfKMfKBA    void Init(Instance &aInstance) { Neighbor::Init(aInstance); }t(
GetNextHopN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMzRoutert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMzKMzK87    uint8_t GetNextHop(void) const { return mNextHop; }t(GetLinkQualityOutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMRoutert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKdc    LinkQuality GetLinkQualityOut(void) const { return static_cast<LinkQuality>(mLinkQualityOut); }t(SetLinkQualityOutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMRoutert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKYX    void SetLinkQualityOut(LinkQuality aLinkQuality) { mLinkQualityOut = aLinkQuality; }t(GetCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMRoutert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK21    uint8_t GetCost(void) const { return mCost; }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMParentt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK    void Init(Instance &aInstance)
    {
        Neighbor::Init(aInstance);
#if OPENTHREAD_CONFIG_MAC_CSL_RECEIVER_ENABLE
        mCslAccuracy.Init();
#endif
    }t(
GetLeaderCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMParentt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMK>=    uint8_t GetLeaderCost(void) const { return mLeaderCost; }t(
SetLeaderCostN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMParentt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/topology.hppMKMKKJ    void SetLeaderCost(uint8_t aLeaderCost) { mLeaderCost = aLeaderCost; }t(FilterM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppK.Filtert(j  K.KK7KFilter::Filter(void)
    : mMode(kModeRssInOnly)
    , mDefaultRssIn(kFixedRssDisabled)
{
    for (FilterEntry &entry : mFilterEntries)
    {
        entry.mFiltered = false;
        entry.mRssIn    = kFixedRssDisabled;
    }
}t(	FindEntryM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppK9Filtert(j  K9KKGKXP  const Filter::FilterEntry *Filter::FindEntry(const ExtAddress &aExtAddress) const
{
    const FilterEntry *rval = nullptr;

    for (const FilterEntry &entry : mFilterEntries)
    {
        if (entry.IsInUse() && (aExtAddress == entry.mExtAddress))
        {
            ExitNow(rval = &entry);
        }
    }

exit:
    return rval;
}t(FindAvailableEntryM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKIFiltert(j  KIKKWKX  Filter::FilterEntry *Filter::FindAvailableEntry(void)
{
    FilterEntry *rval = nullptr;

    for (FilterEntry &entry : mFilterEntries)
    {
        if (!entry.IsInUse())
        {
            ExitNow(rval = &entry);
        }
    }

exit:
    return rval;
}t(
AddAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKYFiltert(j  KYKKhKXp  Error Filter::AddAddress(const ExtAddress &aExtAddress)
{
    Error        error = kErrorNone;
    FilterEntry *entry = FindEntry(aExtAddress);

    if (entry == nullptr)
    {
        VerifyOrExit((entry = FindAvailableEntry()) != nullptr, error = kErrorNoBufs);
        entry->mExtAddress = aExtAddress;
    }

    entry->mFiltered = true;

exit:
    return error;
}t(
RemoveAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKjFiltert(j  KjKKrKvoid Filter::RemoveAddress(const ExtAddress &aExtAddress)
{
    FilterEntry *entry = FindEntry(aExtAddress);

    if (entry != nullptr)
    {
        entry->mFiltered = false;
    }
}t(ClearAddressesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKtFiltert(j  KtKKzKvoid Filter::ClearAddresses(void)
{
    for (FilterEntry &entry : mFilterEntries)
    {
        entry.mFiltered = false;
    }
}t(GetNextAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppK|Filtert(j  K|KKKX  Error Filter::GetNextAddress(Iterator &aIterator, Entry &aEntry) const
{
    Error error = kErrorNotFound;

    for (; aIterator < GetArrayLength(mFilterEntries); aIterator++)
    {
        const FilterEntry &entry = mFilterEntries[aIterator];

        if (entry.mFiltered)
        {
            aEntry.mExtAddress = entry.mExtAddress;
            aEntry.mRssIn      = entry.mRssIn;
            error              = kErrorNone;
            aIterator++;
            break;
        }
    }

    return error;
}t(AddRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKFiltert(j  KKKKX  Error Filter::AddRssIn(const ExtAddress &aExtAddress, int8_t aRss)
{
    Error        error = kErrorNone;
    FilterEntry *entry = FindEntry(aExtAddress);

    if (entry == nullptr)
    {
        entry = FindAvailableEntry();
        VerifyOrExit(entry != nullptr, error = kErrorNoBufs);

        entry->mExtAddress = aExtAddress;
    }

    entry->mRssIn = aRss;

exit:
    return error;
}t(RemoveRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKFiltert(j  KKKKvoid Filter::RemoveRssIn(const ExtAddress &aExtAddress)
{
    FilterEntry *entry = FindEntry(aExtAddress);

    VerifyOrExit(entry != nullptr);

    entry->mRssIn = kFixedRssDisabled;

exit:
    return;
}t(
ClearAllRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKFiltert(j  KKKKvoid Filter::ClearAllRssIn(void)
{
    for (FilterEntry &entry : mFilterEntries)
    {
        entry.mRssIn = kFixedRssDisabled;
    }

    mDefaultRssIn = kFixedRssDisabled;
}t(GetNextRssInM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKFiltert(j   KKKKXI  Error Filter::GetNextRssIn(Iterator &aIterator, Entry &aEntry) const
{
    Error error = kErrorNotFound;

    for (; aIterator < GetArrayLength(mFilterEntries); aIterator++)
    {
        const FilterEntry &entry = mFilterEntries[aIterator];

        if (entry.mRssIn != kFixedRssDisabled)
        {
            aEntry.mExtAddress = entry.mExtAddress;
            aEntry.mRssIn      = entry.mRssIn;
            error              = kErrorNone;
            aIterator++;
            ExitNow();
        }
    }

    // Return the default RssIn at the end of list
    if ((aIterator == GetArrayLength(mFilterEntries)) && (mDefaultRssIn != kFixedRssDisabled))
    {
        AsCoreType(&aEntry.mExtAddress).Fill(0xff);
        aEntry.mRssIn = mDefaultRssIn;
        error         = kErrorNone;
        aIterator++;
    }

exit:
    return error;
}t(ApplyM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKٌFiltert(j
   KKKKX  Error Filter::Apply(const ExtAddress &aExtAddress, int8_t &aRss) const
{
    Error              error = kErrorNone;
    const FilterEntry *entry = FindEntry(aExtAddress);
    bool               isInFilterList;

    // Use the default RssIn setting for all receiving messages first.
    aRss = mDefaultRssIn;

    // In allowlist mode, entry must be present in the list, in
    // denylist mode it must not be present.

    isInFilterList = (entry != nullptr) && entry->mFiltered;

    switch (mMode)
    {
    case kModeRssInOnly:
        break;

    case kModeAllowlist:
        VerifyOrExit(isInFilterList, error = kErrorAddressFiltered);
        break;

    case kModeDenylist:
        VerifyOrExit(!isInFilterList, error = kErrorAddressFiltered);
        break;
    }

    if ((entry != nullptr) && (entry->mRssIn != kFixedRssDisabled))
    {
        aRss = entry->mRssIn;
    }

exit:
    return error;
}t(ApplyToRxFrameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/mac_filter.cppKFiltert(j   KKMKX  Error Filter::ApplyToRxFrame(RxFrame &aRxFrame, const ExtAddress &aExtAddress, Neighbor *aNeighbor) const
{
    Error  error;
    int8_t fixedRss;

    SuccessOrExit(error = Apply(aExtAddress, fixedRss));

    VerifyOrExit(fixedRss != kFixedRssDisabled);

    aRxFrame.SetRssi(fixedRss);

    if (aNeighbor != nullptr)
    {
        // Clear the previous RSS average to ensure the fixed RSS
        // value takes effect quickly.
        aNeighbor->GetLinkInfo().CleaAverageRss();
    }

exit:
    return error;
}t(	IsEnabledK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKQLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKQKKQKKJ    bool IsEnabled(void) const { return mReceiveDoneCallback != nullptr; }t(GetCapsK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKgLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKgKKgKBA    otRadioCaps GetCaps(void) const { return mSubMac.GetCaps(); }t(GetTransmitFrameK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKKKKKJ    TxFrame &GetTransmitFrame(void) { return mSubMac.GetTransmitFrame(); }t(GetShortAddressK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKKKKSR    ShortAddress GetShortAddress(void) const { return mSubMac.GetShortAddress(); }t(GetPanIdK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKόLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKKKK21    PanId GetPanId(void) const { return mPanId; }t(
GetChannelK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKKKK?>    uint8_t GetChannel(void) const { return mReceiveChannel; }t(
GetExtAddressK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKLinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppKKKKTS    const ExtAddress &GetExtAddress(void) const { return mSubMac.GetExtAddress(); }t(RecordFrameTransmitStatusK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppM4LinkRawt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/link_raw.hppM4KM4K[Z    void    RecordFrameTransmitStatus(const TxFrame &, RxFrame *, Error, uint8_t, bool) {}t(otCoapSendRequestBlockWiseK/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMNt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMKMKXb  static inline otError otCoapSendRequestBlockWise(otInstance                 *aInstance,
                                                 otMessage                  *aMessage,
                                                 const otMessageInfo        *aMessageInfo,
                                                 otCoapResponseHandler       aHandler,
                                                 void                       *aContext,
                                                 otCoapBlockwiseTransmitHook aTransmitHook,
                                                 otCoapBlockwiseReceiveHook  aReceiveHook)
{
    // NOLINTNEXTLINE(modernize-use-nullptr)
    return otCoapSendRequestBlockWiseWithParameters(aInstance, aMessage, aMessageInfo, aHandler, aContext, NULL,
                                                    aTransmitHook, aReceiveHook);
}t(otCoapSendRequestK/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMNt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMKMKX  static inline otError otCoapSendRequest(otInstance           *aInstance,
                                        otMessage            *aMessage,
                                        const otMessageInfo  *aMessageInfo,
                                        otCoapResponseHandler aHandler,
                                        void                 *aContext)
{
    // NOLINTNEXTLINE(modernize-use-nullptr)
    return otCoapSendRequestWithParameters(aInstance, aMessage, aMessageInfo, aHandler, aContext, NULL);
}t(otCoapSendResponseBlockWiseK/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMWNt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMWKM_KXj  static inline otError otCoapSendResponseBlockWise(otInstance                 *aInstance,
                                                  otMessage                  *aMessage,
                                                  const otMessageInfo        *aMessageInfo,
                                                  void                       *aContext,
                                                  otCoapBlockwiseTransmitHook aTransmitHook)
{
    // NOLINTNEXTLINE(modernize-use-nullptr)
    return otCoapSendResponseBlockWiseWithParameters(aInstance, aMessage, aMessageInfo, NULL, aContext, aTransmitHook);
}t(otCoapSendResponseK/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMlNt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/include/openthread/coap.hMlKMpKstatic inline otError otCoapSendResponse(otInstance *aInstance, otMessage *aMessage, const otMessageInfo *aMessageInfo)
{
    // NOLINTNEXTLINE(modernize-use-nullptr)
    return otCoapSendResponseWithParameters(aInstance, aMessage, aMessageInfo, NULL);
}t(
GetVersionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppKMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppKKKK    uint8_t GetVersion(void) const
    {
        return (GetHelpData().mHeader.mVersionTypeToken & kVersionMask) >> kVersionOffset;
    }t(
SetVersionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK    void SetVersion(uint8_t aVersion)
    {
        GetHelpData().mHeader.mVersionTypeToken &= ~kVersionMask;
        GetHelpData().mHeader.mVersionTypeToken |= aVersion << kVersionOffset;
    }t(GetTypeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hpp      MKMKqp    uint8_t GetType(void) const { return (GetHelpData().mHeader.mVersionTypeToken & kTypeMask) >> kTypeOffset; }t(SetTypeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK    void SetType(Type aType)
    {
        GetHelpData().mHeader.mVersionTypeToken &= ~kTypeMask;
        GetHelpData().mHeader.mVersionTypeToken |= (static_cast<uint8_t>(aType) << kTypeOffset);
    }t(GetCodeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM$Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM$KM$K[Z    uint8_t GetCode(void) const { return static_cast<Code>(GetHelpData().mHeader.mCode); }t(SetCodeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM,Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM,KM,K\[    void SetCode(Code aCode) { GetHelpData().mHeader.mCode = static_cast<uint8_t>(aCode); }t(GetMessageIdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM>Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM>KM>K_^    uint16_t GetMessageId(void) const { return HostSwap16(GetHelpData().mHeader.mMessageId); }t(SetMessageIdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMFMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMFKMFKji    void SetMessageId(uint16_t aMessageId) { GetHelpData().mHeader.mMessageId = HostSwap16(aMessageId); }t(GetTokenLengthP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNKMQK    uint8_t GetTokenLength(void) const
    {
        return (GetHelpData().mHeader.mVersionTypeToken & kTokenLengthMask) >> kTokenLengthOffset;
    }t(GetTokenP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMYMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMYKMYKQP    const uint8_t *GetToken(void) const { return GetHelpData().mHeader.mToken; }t(AppendObserveOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKwv    Error AppendObserveOption(uint32_t aObserve) { return AppendUintOption(kOptionObserve, aObserve & kObserveMask); }t(AppendProxyUriOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKqp    Error AppendProxyUriOption(const char *aProxyUri) { return AppendStringOption(kOptionProxyUri, aProxyUri); }t(AppendContentFormatOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK    Error AppendContentFormatOption(otCoapOptionContentFormat aContentFormat)
    {
        return AppendUintOption(kOptionContentFormat, static_cast<uint32_t>(aContentFormat));
    }t(AppendMaxAgeOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKdc    Error AppendMaxAgeOption(uint32_t aMaxAge) { return AppendUintOption(kOptionMaxAge, aMaxAge); }t(AppendUriQueryOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKqp    Error AppendUriQueryOption(const char *aUriQuery) { return AppendStringOption(kOptionUriQuery, aUriQuery); }t(GetHeaderLengthP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM&Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM&KM&KQP    uint16_t GetHeaderLength(void) const { return GetHelpData().mHeaderLength; }t(GetBlockWiseBlockNumberP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM.Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM.KM.Kgf    uint32_t GetBlockWiseBlockNumber(void) const { return GetHelpData().mBlockWiseData.mBlockNumber; }t(IsMoreBlocksFlagSetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM7Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM7KM7K^]    bool IsMoreBlocksFlagSet(void) const { return GetHelpData().mBlockWiseData.mMoreBlocks; }t(GetBlockWiseBlockSizeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM?Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM?KM?Kih    otCoapBlockSzx GetBlockWiseBlockSize(void) const { return GetHelpData().mBlockWiseData.mBlockSize; }t(GetOptionStartP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM\Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM\KM\KXW    uint16_t GetOptionStart(void) const { return kMinHeaderLength + GetTokenLength(); }t(SetBlockWiseBlockNumberP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMzMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMzKMzKvu    void SetBlockWiseBlockNumber(uint32_t aBlockNumber) { GetHelpData().mBlockWiseData.mBlockNumber = aBlockNumber; }t(SetMoreBlocksFlagP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKih    void SetMoreBlocksFlag(bool aMoreBlocks) { GetHelpData().mBlockWiseData.mMoreBlocks = aMoreBlocks; }t(SetBlockWiseBlockSizeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKts    void SetBlockWiseBlockSize(otCoapBlockSzx aBlockSize) { GetHelpData().mBlockWiseData.mBlockSize = aBlockSize; }t(IsEmptyP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKCB    bool IsEmpty(void) const { return (GetCode() == kCodeEmpty); }t(	IsRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKa`    bool IsRequest(void) const { return (GetCode() >= kCodeGet) && (GetCode() <= kCodeDelete); }t(IsGetRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKDC    bool IsGetRequest(void) const { return GetCode() == kCodeGet; }t(
IsPostRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKFE    bool IsPostRequest(void) const { return GetCode() == kCodePost; }t(IsPutRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKDC    bool IsPutRequest(void) const { return GetCode() == kCodePut; }t(IsDeleteRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKJI    bool IsDeleteRequest(void) const { return GetCode() == kCodeDelete; }t(
IsResponseP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKSR    bool IsResponse(void) const { return GetCode() >= OT_COAP_CODE_RESPONSE_MIN; }t(
IsConfirmableP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKON    bool IsConfirmable(void) const { return (GetType() == kTypeConfirmable); }t(IsNonConfirmableP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKUT    bool IsNonConfirmable(void) const { return (GetType() == kTypeNonConfirmable); }t(IsAckP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK?>    bool IsAck(void) const { return (GetType() == kTypeAck); }t(IsResetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKCB    bool IsReset(void) const { return (GetType() == kTypeReset); }t(CloneP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK>=    Message *Clone(void) const { return Clone(GetLength()); }t(GetHelpDataReservedP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM"Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM"KM"K`_    static uint16_t GetHelpDataReserved(void) { return sizeof(HelpData) + kHelpDataAlignment; }t(GetNextCoapMessageP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM-Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM-KM-KTS    Message *GetNextCoapMessage(void) { return static_cast<Message *>(GetNext()); }t(GetNextCoapMessageP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM8Messaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM8KM8Kfe    const Message *GetNextCoapMessage(void) const { return static_cast<const Message *>(GetNext()); }t(	operator*P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM
ConstIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKyx        const Message &operator*(void) { return static_cast<const Message &>(ot::Message::ConstIterator::operator*()); }t(
operator->P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM
ConstIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MK
        const Message *operator->(void)
        {
            return static_cast<const Message *>(ot::Message::ConstIterator::operator->());
        }t(	operator*P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKhg        Message &operator*(void) { return static_cast<Message &>(ot::Message::Iterator::operator*()); }t(
operator->P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKji        Message *operator->(void) { return static_cast<Message *>(ot::Message::Iterator::operator->()); }t(GetHelpDataP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKXa      const HelpData &GetHelpData(void) const
    {
        static_assert(sizeof(HelpData) + kHelpDataAlignment <= kHeadBufferDataSize,
                      "Insufficient buffer size for CoAP processing! Increase OPENTHREAD_CONFIG_MESSAGE_BUFFER_SIZE.");

        return *static_cast<const HelpData *>(OT_ALIGN(GetFirstData(), kHelpDataAlignment));
    }t(GetHelpDataP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKUT    HelpData &GetHelpData(void) { return AsNonConst(AsConst(this)->GetHelpData()); }t(GetTokenP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKED    uint8_t *GetToken(void) { return GetHelpData().mHeader.mToken; }t(SetTokenLengthP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessaget(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK    void SetTokenLength(uint8_t aTokenLength)
    {
        GetHelpData().mHeader.mVersionTypeToken &= ~kTokenLengthMask;
        GetHelpData().mHeader.mVersionTypeToken |= ((aTokenLength << kTokenLengthOffset) & kTokenLengthMask);
    }t(GetHeadP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK[Z    Message *GetHead(void) { return static_cast<Message *>(ot::MessageQueue::GetHead()); }t(GetHeadP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKml    const Message *GetHead(void) const { return static_cast<const Message *>(ot::MessageQueue::GetHead()); }t(EnqueueP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKON    void Enqueue(Message &aMessage) { Enqueue(aMessage, kQueuePositionTail); }t(EnqueueP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKqp    void Enqueue(Message &aMessage, QueuePosition aPosition) { ot::MessageQueue::Enqueue(aMessage, aPosition); }t(DequeueP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKML    void Dequeue(Message &aMessage) { ot::MessageQueue::Dequeue(aMessage); }t(DequeueAndFreeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM	MessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM	KM	K[Z    void DequeueAndFree(Message &aMessage) { ot::MessageQueue::DequeueAndFree(aMessage); }t(endP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK@?    Message::Iterator end(void) { return Message::Iterator(); }t(endP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKPO    Message::ConstIterator end(void) const { return Message::ConstIterator(); }t(InitP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMFIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMFK	MFKlk        Error Init(const Message &aMessage, uint16_t aNumber) { return InitOrAdvance(&aMessage, aNumber); }t(IsDoneP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMOIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMOK	MOKSR        bool IsDone(void) const { return mOption.mLength == kIteratorDoneLength; }t(HasParseErroredP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMZIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMZK	MZKfe        bool HasParseErrored(void) const { return mNextOptionOffset == kNextOptionOffsetParseError; }t(AdvanceP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMsIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMsK	MsKTS        Error Advance(uint16_t aNumber) { return InitOrAdvance(nullptr, aNumber); }t(
GetMessageP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM{Iteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppM{K	M{Kba        const Message &GetMessage(void) const { return *static_cast<const Message *>(mMessage); }t(	GetOptionP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKsr        const Option *GetOption(void) const { return IsDone() ? nullptr : static_cast<const Option *>(&mOption); }t(GetPayloadMessageOffsetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKSR        uint16_t GetPayloadMessageOffset(void) const { return mNextOptionOffset; }t(
MarkAsDoneP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKIH        void MarkAsDone(void) { mOption.mLength = kIteratorDoneLength; }t(MarkAsParseErroredP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMIteratort(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMK	MKih        void MarkAsParseErrored(void) { MarkAsDone(), mNextOptionOffset = kNextOptionOffsetParseError; }t(	GetNumberP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMOptiont(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK76    uint16_t GetNumber(void) const { return mNumber; }t(	GetLengthP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMOptiont(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMK76    uint16_t GetLength(void) const { return mLength; }t(
AsCoapMessageP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKmlinline Coap::Message &AsCoapMessage(otMessage *aMessage) { return *static_cast<Coap::Message *>(aMessage); }t(AsCoapMessagePtrP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKoninline Coap::Message *AsCoapMessagePtr(otMessage *aMessage) { return static_cast<Coap::Message *>(aMessage); }t(
AsCoapMessageP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKMKinline const Coap::Message &AsCoapMessage(const otMessage *aMessage)
{
    return *static_cast<const Coap::Message *>(aMessage);
}t(AsCoapMessagePtrP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMNt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMKM Kinline const Coap::Message *AsCoapMessagePtr(const otMessage *aMessage)
{
    return static_cast<const Coap::Message *>(aMessage);
}t(FromH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKhTxParameterst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKhKKkK    static const TxParameters &From(const otCoapTxParameters *aTxParameters)
    {
        return aTxParameters ? *static_cast<const TxParameters *>(aTxParameters) : GetDefault();
    }t(
GetDefaultH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppK{TxParameterst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppK{KK{Kts    static const TxParameters &GetDefault(void) { return static_cast<const TxParameters &>(kDefaultTxParameters); }t(
GetUriPathH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKResourcet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKK<;    const char *GetUriPath(void) const { return mUriPath; }t(
HandleRequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKResourcet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKK    void HandleRequest(Message &aMessage, const Ip6::MessageInfo &aMessageInfo) const
    {
        mHandler(mContext, &aMessage, &aMessageInfo);
    }t(ResourceBlockWiseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppK͌ResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKKX      ResourceBlockWise(const char                 *aUriPath,
                      otCoapRequestHandler        aHandler,
                      void                       *aContext,
                      otCoapBlockwiseReceiveHook  aReceiveHook,
                      otCoapBlockwiseTransmitHook aTransmitHook)
    {
        mUriPath      = aUriPath;
        mHandler      = aHandler;
        mContext      = aContext;
        mReceiveHook  = aReceiveHook;
        mTransmitHook = aTransmitHook;
        mNext         = nullptr;
    }t(HandleBlockReceiveH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKیResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKKX      Error HandleBlockReceive(const uint8_t *aBlock,
                             uint32_t       aPosition,
                             uint16_t       aBlockLength,
                             bool           aMore,
                             uint32_t       aTotalLength) const
    {
        return mReceiveHook(otCoapBlockwiseResource::mContext, aBlock, aPosition, aBlockLength, aMore, aTotalLength);
    }t(HandleBlockTransmitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKK    Error HandleBlockTransmit(uint8_t *aBlock, uint32_t aPosition, uint16_t *aBlockLength, bool *aMore) const
    {
        return mTransmitHook(otCoapBlockwiseResource::mContext, aBlock, aPosition, aBlockLength, aMore);
    }t(GetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKK    const ResourceBlockWise *GetNext(void) const
    {
        return static_cast<const ResourceBlockWise *>(static_cast<const ResourceBlockWise *>(this)->mNext);
    }t(GetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppKKKK    ResourceBlockWise *GetNext(void)
    {
        return static_cast<ResourceBlockWise *>(static_cast<ResourceBlockWise *>(this)->mNext);
    }t(SetNextH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMKfe    void SetNext(ResourceBlockWise *aNext) { static_cast<ResourceBlockWise *>(this)->mNext = aNext; }t(
GetUriPathH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM
ResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM
KM
K<;    const char *GetUriPath(void) const { return mUriPath; }t(
HandleRequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMResourceBlockWiset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMK    void HandleRequest(Message &aMessage, const Ip6::MessageInfo &aMessageInfo) const
    {
        mHandler(mContext, &aMessage, &aMessageInfo);
    }t(GetResponsesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMOResponsesQueuet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMOKMOKDC    const MessageQueue &GetResponses(void) const { return mQueue; }t(AppendToH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMVResponseMetadatat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMVK	MVKSR        Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(SetDefaultHandlerH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMKqp    void SetDefaultHandler(RequestHandler aHandler, void *aContext) { mDefaultHandler.Set(aHandler, aContext); }t(NewPriorityMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMK    Message *NewPriorityMessage(void)
    {
        return NewMessage(Message::Settings(Message::kWithLinkSecurity, Message::kPriorityNet));
    }t(SendRequestEntityIncompleteH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMK    Error SendRequestEntityIncomplete(const Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
    {
        return SendHeaderResponse(kCodeRequestIncomplete, aRequest, aMessageInfo);
    }t(SetInterceptorH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMKpo    void SetInterceptor(Interceptor aInterceptor, void *aContext) { mInterceptor.Set(aInterceptor, aContext); }t(GetRequestMessagesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMKTS    const MessageQueue &GetRequestMessages(void) const { return mPendingRequests; }t(GetCachedResponsesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMCoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppMKMKba    const MessageQueue &GetCachedResponses(void) const { return mResponsesQueue.GetResponses(); }t(SetResourceHandlerH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM*CoapBaset(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM*KM*KWV    void SetResourceHandler(ResourceHandler aHandler) { mResourceHandler = aHandler; }t(AppendToH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM/Metadatat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.hppM/K	M/KSR        Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(GetServer16Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKKCB    uint16_t GetServer16(void) const { return mConfig.mServer16; }t(
HasPrimaryY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKKXW    bool HasPrimary(void) const { return mConfig.mServer16 != Mac::kShortAddrInvalid; }t(GetDomainPrefixY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKK    const Ip6::Prefix *GetDomainPrefix(void) const
    {
        return (mDomainPrefix.GetLength() == 0) ? nullptr : &mDomainPrefix;
    }t(HasDomainPrefixY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKKQP    bool HasDomainPrefix(void) const { return (mDomainPrefix.GetLength() > 0); }t(LogBackboneRouterPrimaryY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKKPO    void LogBackboneRouterPrimary(State, const BackboneRouterConfig &) const {}t(LogDomainPrefixY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKLeadert(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/backbone_router/bbr_leader.hppKKKKJI    void LogDomainPrefix(DomainPrefixState, const Ip6::Prefix &) const {}t(
mbedtls_pk_ec_/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/pk.hKNt(_/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/pk.hKKKKstatic inline mbedtls_ecp_keypair *mbedtls_pk_ec( const mbedtls_pk_context pk )
{
    return( (mbedtls_ecp_keypair *) (pk).pk_ctx );
}t(mbedtls_pk_get_len_/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/pk.hMNt(_/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/pk.hMKMKstatic inline size_t mbedtls_pk_get_len( const mbedtls_pk_context *ctx )
{
    return( ( mbedtls_pk_get_bitlen( ctx ) + 7 ) / 8 );
}t(mbedtls_cipher_get_block_sizec/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMNt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMKMKstatic inline unsigned int mbedtls_cipher_get_block_size(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET( ctx != NULL, 0 );
    if( ctx->cipher_info == NULL )
        return 0;

    return ctx->cipher_info->block_size;
}t(mbedtls_cipher_get_cipher_modec/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMNt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMKMKX  static inline mbedtls_cipher_mode_t mbedtls_cipher_get_cipher_mode(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET( ctx != NULL, MBEDTLS_MODE_NONE );
    if( ctx->cipher_info == NULL )
        return MBEDTLS_MODE_NONE;

    return ctx->cipher_info->mode;
}t(mbedtls_cipher_get_iv_sizec/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM Nt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM KM+KX2  static inline int mbedtls_cipher_get_iv_size(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET( ctx != NULL, 0 );
    if( ctx->cipher_info == NULL )
        return 0;

    if( ctx->iv_size != 0 )
        return (int) ctx->iv_size;

    return (int) ctx->cipher_info->iv_size;
}t(mbedtls_cipher_get_typec/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM5Nt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM5KM>KX$  static inline mbedtls_cipher_type_t mbedtls_cipher_get_type(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET(
        ctx != NULL, MBEDTLS_CIPHER_NONE );
    if( ctx->cipher_info == NULL )
        return MBEDTLS_CIPHER_NONE;

    return ctx->cipher_info->type;
}t(mbedtls_cipher_get_namec/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMINt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMIKMQKstatic inline const char *mbedtls_cipher_get_name(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET( ctx != NULL, 0 );
    if( ctx->cipher_info == NULL )
        return 0;

    return ctx->cipher_info->name;
}t(mbedtls_cipher_get_key_bitlenc/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM\Nt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hM\KMeKX,  static inline int mbedtls_cipher_get_key_bitlen(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET(
        ctx != NULL, MBEDTLS_KEY_LENGTH_NONE );
    if( ctx->cipher_info == NULL )
        return MBEDTLS_KEY_LENGTH_NONE;

    return (int) ctx->cipher_info->key_bitlen;
}t(mbedtls_cipher_get_operationc/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMoNt(c/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/cipher.hMoKMxKX%  static inline mbedtls_operation_t mbedtls_cipher_get_operation(
    const mbedtls_cipher_context_t *ctx )
{
    MBEDTLS_INTERNAL_VALIDATE_RET(
        ctx != NULL, MBEDTLS_OPERATION_NONE );
    if( ctx->cipher_info == NULL )
        return MBEDTLS_OPERATION_NONE;

    return ctx->operation;
}t(mbedtls_ssl_ciphersuite_has_pfsm/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMNt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMKMKX  static inline int mbedtls_ssl_ciphersuite_has_pfs( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_DHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_DHE_PSK:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_PSK:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA:
        case MBEDTLS_KEY_EXCHANGE_ECJPAKE:
            return( 1 );

        default:
            return( 0 );
    }
}t(mbedtls_ssl_ciphersuite_no_pfsm/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMNt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMKMKX  static inline int mbedtls_ssl_ciphersuite_no_pfs( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_ECDH_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDH_ECDSA:
        case MBEDTLS_KEY_EXCHANGE_RSA:
        case MBEDTLS_KEY_EXCHANGE_PSK:
        case MBEDTLS_KEY_EXCHANGE_RSA_PSK:
            return( 1 );

        default:
            return( 0 );
    }
}t((mbedtls_ssl_ciphersuite_cert_req_allowedm/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMNt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMKMKX  static inline int mbedtls_ssl_ciphersuite_cert_req_allowed( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_RSA:
        case MBEDTLS_KEY_EXCHANGE_DHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDH_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDH_ECDSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA:
            return( 1 );

        default:
            return( 0 );
    }
}t(%mbedtls_ssl_ciphersuite_uses_srv_certm/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMNt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMKMKX  static inline int mbedtls_ssl_ciphersuite_uses_srv_cert( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_RSA:
        case MBEDTLS_KEY_EXCHANGE_RSA_PSK:
        case MBEDTLS_KEY_EXCHANGE_DHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDH_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDH_ECDSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA:
            return( 1 );

        default:
            return( 0 );
    }
}t("mbedtls_ssl_ciphersuite_uses_ecdhem/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hM	Nt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hM	KMKX[  static inline int mbedtls_ssl_ciphersuite_uses_ecdhe( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_PSK:
            return( 1 );

        default:
            return( 0 );
    }
}t(-mbedtls_ssl_ciphersuite_uses_server_signaturem/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMNt(m/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/mbedtls/ssl_ciphersuites.hMKM%KXd  static inline int mbedtls_ssl_ciphersuite_uses_server_signature( const mbedtls_ssl_ciphersuite_t *info )
{
    switch( info->key_exchange )
    {
        case MBEDTLS_KEY_EXCHANGE_DHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_RSA:
        case MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA:
            return( 1 );

        default:
            return( 0 );
    }
}t(GetTypeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKKON    Type GetType(void) const { return static_cast<Type>(ot::Tlv::GetType()); }t(SetTypeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKKPO    void SetType(Type aType) { ot::Tlv::SetType(static_cast<uint8_t>(aType)); }t(GetNextS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKK?>    Tlv *GetNext(void) { return As<Tlv>(ot::Tlv::GetNext()); }t(GetNextS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKKKJ    const Tlv *GetNext(void) const { return As<Tlv>(ot::Tlv::GetNext()); }t(FindTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKK    static Error FindTlv(const Message &aMessage, Type aType, uint16_t aMaxLength, Tlv &aTlv)
    {
        return ot::Tlv::FindTlv(aMessage, static_cast<uint8_t>(aType), aMaxLength, aTlv);
    }t(FindTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKƌTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKK    template <typename TlvType> static Error FindTlv(const Message &aMessage, TlvType &aTlv)
    {
        return ot::Tlv::FindTlv(aMessage, aTlv);
    }t(FindTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKߌTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKK    static Tlv *FindTlv(uint8_t *aTlvsStart, uint16_t aTlvsLength, Type aType)
    {
        return AsNonConst(FindTlv(AsConst(aTlvsStart), aTlvsLength, aType));
    }t(FindTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppKKKK    template <typename TlvType> static TlvType *FindTlv(uint8_t *aTlvsStart, uint16_t aTlvsLength)
    {
        return As<TlvType>(FindTlv(aTlvsStart, aTlvsLength, static_cast<Tlv::Type>(TlvType::kType)));
    }t(FindTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM	Tlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM	KMK    template <typename TlvType> static const TlvType *FindTlv(const uint8_t *aTlvsStart, uint16_t aTlvsLength)
    {
        return As<TlvType>(FindTlv(aTlvsStart, aTlvsLength, static_cast<Tlv::Type>(TlvType::kType)));
    }t(GetTypeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMExtendedTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKsr    MeshCoP::Tlv::Type GetType(void) const { return static_cast<MeshCoP::Tlv::Type>(ot::ExtendedTlv::GetType()); }t(SetTypeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM&ExtendedTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM&KM&Kfe    void SetType(MeshCoP::Tlv::Type aType) { ot::ExtendedTlv::SetType(static_cast<uint8_t>(aType)); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMe
ChannelTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMeKMiKj    void Init(void)
    {
        SetType(kChannel);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(GetChannelPageS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMz
ChannelTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMzKMzK@?    uint8_t GetChannelPage(void) const { return mChannelPage; }t(SetChannelPageS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
ChannelTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKON    void SetChannelPage(uint8_t aChannelPage) { mChannelPage = aChannelPage; }t(
GetChannelS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
ChannelTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKED    uint16_t GetChannel(void) const { return HostSwap16(mChannel); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKh    void Init(void)
    {
        SetType(kPanId);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetPanIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKA@    uint16_t GetPanId(void) const { return HostSwap16(mPanId); }t(SetPanIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKDC    void SetPanId(uint16_t aPanId) { mPanId = HostSwap16(aPanId); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMExtendedPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKp    void Init(void)
    {
        SetType(kExtendedPanId);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMExtendedPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetExtendedPanIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMExtendedPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKQP    const ExtendedPanId &GetExtendedPanId(void) const { return mExtendedPanId; }t(SetExtendedPanIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMExtendedPanIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKdc    void SetExtendedPanId(const ExtendedPanId &aExtendedPanId) { mExtendedPanId = aExtendedPanId; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMNetworkNameTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKn    void Init(void)
    {
        SetType(kNetworkName);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM3PskcTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM3KM7Kg    void Init(void)
    {
        SetType(kPskc);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM@PskcTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM@KM@KTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetPskcS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMHPskcTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMHKMHK65    const Pskc &GetPskc(void) const { return mPskc; }t(SetPskcS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPPskcTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPKMPK76    void SetPskc(const Pskc &aPskc) { mPskc = aPskc; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMb
NetworkKeyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMbKMfKm    void Init(void)
    {
        SetType(kNetworkKey);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMo
NetworkKeyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMoKMoKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(
GetNetworkKeyS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMw
NetworkKeyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMwKMwKHG    const NetworkKey &GetNetworkKey(void) const { return mNetworkKey; }t(
SetNetworkKeyS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
NetworkKeyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKUT    void SetNetworkKey(const NetworkKey &aNetworkKey) { mNetworkKey = aNetworkKey; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMNetworkKeySequenceTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKu    void Init(void)
    {
        SetType(kNetworkKeySequence);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMNetworkKeySequenceTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetNetworkKeySequenceS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMNetworkKeySequenceTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK[Z    uint32_t GetNetworkKeySequence(void) const { return HostSwap32(mNetworkKeySequence); }t(SetNetworkKeySequenceS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMNetworkKeySequenceTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKxw    void SetNetworkKeySequence(uint32_t aNetworkKeySequence) { mNetworkKeySequence = HostSwap32(aNetworkKeySequence); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMMeshLocalPrefixTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKr    void Init(void)
    {
        SetType(kMeshLocalPrefix);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMMeshLocalPrefixTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetMeshLocalPrefixLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMMeshLocalPrefixTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKVU    uint8_t GetMeshLocalPrefixLength(void) const { return sizeof(mMeshLocalPrefix); }t(GetMeshLocalPrefixS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMMeshLocalPrefixTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKZY    const Ip6::NetworkPrefix &GetMeshLocalPrefix(void) const { return mMeshLocalPrefix; }t(SetMeshLocalPrefixS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMMeshLocalPrefixTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKqp    void SetMeshLocalPrefix(const Ip6::NetworkPrefix &aMeshLocalPrefix) { mMeshLocalPrefix = aMeshLocalPrefix; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSteeringDataTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void Init(void)
    {
        SetType(kSteeringData);
        SetLength(sizeof(*this) - sizeof(Tlv));
        Clear();
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSteeringDataTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK98    bool IsValid(void) const { return GetLength() > 0; }t(GetSteeringDataLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSteeringDataTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    uint8_t GetSteeringDataLength(void) const
    {
        return GetLength() <= sizeof(mSteeringData) ? GetLength() : sizeof(mSteeringData);
    }t(ClearS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSteeringDataTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKLK    void Clear(void) { memset(mSteeringData, 0, GetSteeringDataLength()); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM2BorderAgentLocatorTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM2KM6Ku    void Init(void)
    {
        SetType(kBorderAgentLocator);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM?BorderAgentLocatorTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM?KM?KTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetBorderAgentLocatorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMGBorderAgentLocatorTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMGKMGKPO    uint16_t GetBorderAgentLocator(void) const { return HostSwap16(mLocator); }t(SetBorderAgentLocatorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMOBorderAgentLocatorTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMOKMOKWV    void SetBorderAgentLocator(uint16_t aLocator) { mLocator = HostSwap16(aLocator); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMcCommissionerIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMcKMgKq    void Init(void)
    {
        SetType(kCommissionerId);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(GetCommissionerIdLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMoCommissionerIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMoKMrK    uint8_t GetCommissionerIdLength(void) const
    {
        return GetLength() <= sizeof(mCommissionerId) ? GetLength() : sizeof(mCommissionerId);
    }t(GetCommissionerIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMzCommissionerIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMzKMzKJI    const char *GetCommissionerId(void) const { return mCommissionerId; }t(SetCommissionerIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMCommissionerIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKX       void SetCommissionerId(const char *aCommissionerId)
    {
        uint16_t length = StringLength(aCommissionerId, sizeof(mCommissionerId));
        memcpy(mCommissionerId, aCommissionerId, length);
        SetLength(static_cast<uint8_t>(length));
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMCommissionerSessionIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKx    void Init(void)
    {
        SetType(kCommissionerSessionId);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMCommissionerSessionIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetCommissionerSessionIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMCommissionerSessionIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKUT    uint16_t GetCommissionerSessionId(void) const { return HostSwap16(mSessionId); }t(SetCommissionerSessionIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMCommissionerSessionIdTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK`_    void SetCommissionerSessionId(uint16_t aSessionId) { mSessionId = HostSwap16(aSessionId); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSecurityPolicyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKq    void Init(void)
    {
        SetType(kSecurityPolicy);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(SetRotationTimeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSecurityPolicyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKdc    void     SetRotationTime(uint16_t aRotationTime) { mRotationTime = HostSwap16(aRotationTime); }t(GetRotationTimeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSecurityPolicyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKON    uint16_t GetRotationTime(void) const { return HostSwap16(mRotationTime); }t(GetFlagsLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMSecurityPolicyTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    uint8_t  GetFlagsLength(void) const { return GetLength() - sizeof(mRotationTime); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMActiveTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void Init(void)
    {
        SetType(kActiveTimestamp);
        SetLength(sizeof(*this) - sizeof(Tlv));
        mTimestamp.Clear();
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMActiveTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMActiveTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKED    const Timestamp &GetTimestamp(void) const { return mTimestamp; }t(GetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM!ActiveTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM!KM!K98    Timestamp &GetTimestamp(void) { return mTimestamp; }t(SetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM)ActiveTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM)KM)KPO    void SetTimestamp(const Timestamp &aTimestamp) { mTimestamp = aTimestamp; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPJoinerUdpPortTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPKMTKp    void Init(void)
    {
        SetType(kJoinerUdpPort);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM]JoinerUdpPortTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM]KM]KTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(
GetUdpPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMeJoinerUdpPortTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMeKMeKED    uint16_t GetUdpPort(void) const { return HostSwap16(mUdpPort); }t(
SetUdpPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMmJoinerUdpPortTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMmKMmKLK    void SetUdpPort(uint16_t aUdpPort) { mUdpPort = HostSwap16(aUdpPort); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPendingTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void Init(void)
    {
        SetType(kPendingTimestamp);
        SetLength(sizeof(*this) - sizeof(Tlv));
        mTimestamp.Clear();
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPendingTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPendingTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKED    const Timestamp &GetTimestamp(void) const { return mTimestamp; }t(GetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPendingTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK98    Timestamp &GetTimestamp(void) { return mTimestamp; }t(SetTimestampS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPendingTimestampTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKPO    void SetTimestamp(const Timestamp &aTimestamp) { mTimestamp = aTimestamp; }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
DelayTimerTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKm    void Init(void)
    {
        SetType(kDelayTimer);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
DelayTimerTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(
GetDelayTimerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
DelayTimerTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKKJ    uint32_t GetDelayTimer(void) const { return HostSwap32(mDelayTimer); }t(
SetDelayTimerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
DelayTimerTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    void SetDelayTimer(uint32_t aDelayTimer) { mDelayTimer = HostSwap32(aDelayTimer); }t(GetChannelPageS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK@?    uint8_t GetChannelPage(void) const { return mChannelPage; }t(SetChannelPageS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hpp/      MKMKON    void SetChannelPage(uint8_t aChannelPage) { mChannelPage = aChannelPage; }t(
GetMaskLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM	ChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM	KM	K>=    uint8_t GetMaskLength(void) const { return mMaskLength; }t(
SetMaskLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKKJ    void SetMaskLength(uint8_t aMaskLength) { mMaskLength = aMaskLength; }t(GetEntrySizeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK]\    uint16_t GetEntrySize(void) const { return sizeof(ChannelMaskEntryBase) + mMaskLength; }t(ClearChannelS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM!ChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM!KM%K    void ClearChannel(uint8_t aChannel)
    {
        uint8_t *mask = reinterpret_cast<uint8_t *>(this) + sizeof(*this);
        mask[aChannel / 8] &= ~(0x80 >> (aChannel % 8));
    }t(
SetChannelS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM-ChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM-KM1K    void SetChannel(uint8_t aChannel)
    {
        uint8_t *mask = reinterpret_cast<uint8_t *>(this) + sizeof(*this);
        mask[aChannel / 8] |= 0x80 >> (aChannel % 8);
    }t(IsChannelSetS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM9ChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM9KM=KX       bool IsChannelSet(uint8_t aChannel) const
    {
        const uint8_t *mask = reinterpret_cast<const uint8_t *>(this) + sizeof(*this);
        return (aChannel < (mMaskLength * 8)) ? ((mask[aChannel / 8] & (0x80 >> (aChannel % 8))) != 0) : false;
    }t(GetNextS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMEChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMEKMHK    const ChannelMaskEntryBase *GetNext(void) const
    {
        return reinterpret_cast<const ChannelMaskEntryBase *>(reinterpret_cast<const uint8_t *>(this) + GetEntrySize());
    }t(GetNextS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPChannelMaskEntryBaset(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMPKMPKYX    ChannelMaskEntryBase *GetNext(void) { return AsNonConst(AsConst(this)->GetNext()); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMcChannelMaskEntryt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMcKMgK`    void Init(void)
    {
        SetChannelPage(0);
        SetMaskLength(sizeof(mMask));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMpChannelMaskEntryt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMpKMpKJI    bool IsValid(void) const { return GetMaskLength() == sizeof(mMask); }t(GetMaskS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMxChannelMaskEntryt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMxKMxKTS    uint32_t GetMask(void) const { return Encoding::Reverse32(HostSwap32(mMask)); }t(SetMaskS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskEntryt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKUT    void SetMask(uint32_t aMask) { mMask = HostSwap32(Encoding::Reverse32(aMask)); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskBaseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKn    void Init(void)
    {
        SetType(kChannelMask);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMChannelMaskTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void Init(void)
    {
        SetType(kChannelMask);
        SetLength(sizeof(*this) - sizeof(Tlv));
        memset(mEntries, 0, sizeof(mEntries));
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
EnergyListTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKm    void Init(void)
    {
        SetType(kEnergyList);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
EnergyListTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK.-    bool IsValid(void) const { return true; }t(
GetEnergyListS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
EnergyListTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKED    const uint8_t *GetEnergyList(void) const { return mEnergyList; }t(GetEnergyListLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM
EnergyListTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKYX    uint8_t GetEnergyListLength(void) const { return Min(kMaxListLength, GetLength()); }t(VendorStackVersionTlvS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM@VendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM@KMDK`    VendorStackVersionTlv(void)
        : mBuildRevision(0)
        , mMinorMajor(0)
    {
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJKMNKu    void Init(void)
    {
        SetType(kVendorStackVersion);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMWVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMWKMWKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(GetOuiS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM_VendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM_KM_K=<    uint32_t GetOui(void) const { return ReadUint24(mOui); }t(SetOuiS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMgVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMgKMgK<;    void SetOui(uint32_t aOui) { WriteUint24(aOui, mOui); }t(GetBuildS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMoVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMoKMoKhg    uint16_t GetBuild(void) const { return (HostSwap16(mBuildRevision) & kBuildMask) >> kBuildOffset; }t(SetBuildS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMwVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMwKM{K    void SetBuild(uint16_t aBuild)
    {
        mBuildRevision =
            HostSwap16((HostSwap16(mBuildRevision) & ~kBuildMask) | ((aBuild << kBuildOffset) & kBuildMask));
    }t(GetRevisionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKfe    uint8_t GetRevision(void) const { return (HostSwap16(mBuildRevision) & kRevMask) >> kRevOffset; }t(SetRevisionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void SetRevision(uint8_t aRevision)
    {
        mBuildRevision = HostSwap16((HostSwap16(mBuildRevision) & ~kRevMask) | ((aRevision << kRevOffset) & kRevMask));
    }t(GetMinorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    uint8_t GetMinor(void) const { return (mMinorMajor & kMinorMask) >> kMinorOffset; }t(SetMinorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void SetMinor(uint8_t aMinor)
    {
        mMinorMajor = (mMinorMajor & ~kMinorMask) | ((aMinor << kMinorOffset) & kMinorMask);
    }t(GetMajorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    uint8_t GetMajor(void) const { return (mMinorMajor & kMajorMask) >> kMajorOffset; }t(SetMajorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMVendorStackVersionTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void SetMajor(uint8_t aMajor)
    {
        mMinorMajor = (mMinorMajor & ~kMajorMask) | ((aMajor << kMajorOffset) & kMajorMask);
    }t(
GetSourcePortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMUdpEncapsulationTlvHeadert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKKJ    uint16_t GetSourcePort(void) const { return HostSwap16(mSourcePort); }t(
SetSourcePortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMUdpEncapsulationTlvHeadert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    void SetSourcePort(uint16_t aSourcePort) { mSourcePort = HostSwap16(aSourcePort); }t(GetDestinationPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMUdpEncapsulationTlvHeadert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKUT    uint16_t GetDestinationPort(void) const { return HostSwap16(mDestinationPort); }t(SetDestinationPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMUdpEncapsulationTlvHeadert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKlk    void SetDestinationPort(uint16_t aDestinationPort) { mDestinationPort = HostSwap16(aDestinationPort); }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void Init(void)
    {
        SetType(kDiscoveryRequest);
        SetLength(sizeof(*this) - sizeof(Tlv));
        mFlags    = 0;
        mReserved = 0;
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(
GetVersionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKHG    uint8_t GetVersion(void) const { return mFlags >> kVersionOffset; }t(
SetVersionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM'DiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM'KM*K    void SetVersion(uint8_t aVersion)
    {
        mFlags = (mFlags & ~kVersionMask) | ((aVersion << kVersionOffset) & kVersionMask);
    }t(IsJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM3DiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM3KM3KFE    bool IsJoiner(void) const { return (mFlags & kJoinerMask) != 0; }t(	SetJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM;DiscoveryRequestTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM;KMEK    void SetJoiner(bool aJoiner)
    {
        if (aJoiner)
        {
            mFlags |= kJoinerMask;
        }
        else
        {
            mFlags &= ~kJoinerMask;
        }
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM]DiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM]KMcK    void Init(void)
    {
        SetType(kDiscoveryResponse);
        SetLength(sizeof(*this) - sizeof(Tlv));
        mFlags    = 0;
        mReserved = 0;
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMlDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMlKMlKTS    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(Tlv); }t(
GetVersionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMtDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMtKMtKHG    uint8_t GetVersion(void) const { return mFlags >> kVersionOffset; }t(
SetVersionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM|DiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppM|KMK    void SetVersion(uint8_t aVersion)
    {
        mFlags = (mFlags & ~kVersionMask) | ((aVersion << kVersionOffset) & kVersionMask);
    }t(IsNativeCommissionerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKRQ    bool IsNativeCommissioner(void) const { return (mFlags & kNativeMask) != 0; }t(SetNativeCommissionerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void SetNativeCommissioner(bool aNativeCommissioner)
    {
        if (aNativeCommissioner)
        {
            mFlags |= kNativeMask;
        }
        else
        {
            mFlags &= ~kNativeMask;
        }
    }t(IsCommercialCommissioningModeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKXW    bool IsCommercialCommissioningMode(void) const { return (mFlags & kCCMMask) != 0; }t(SetCommercialCommissioningModeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMDiscoveryResponseTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK    void SetCommercialCommissioningMode(bool aCCM)
    {
        if (aCCM)
        {
            mFlags |= kCCMMask;
        }
        else
        {
            mFlags &= ~kCCMMask;
        }
    }t(InitS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKv    void Init(void)
    {
        SetType(kJoinerAdvertisement);
        SetLength(sizeof(*this) - sizeof(Tlv));
    }t(IsValidS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKwv    bool IsValid(void) const { return GetLength() >= sizeof(mOui) && GetLength() <= sizeof(mOui) + sizeof(mAdvData); }t(GetOuiS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK=<    uint32_t GetOui(void) const { return ReadUint24(mOui); }t(SetOuiS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKCB    void SetOui(uint32_t aOui) { return WriteUint24(aOui, mOui); }t(GetAdvDataLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMKPO    uint8_t GetAdvDataLength(void) const { return GetLength() - sizeof(mOui); }t(
GetAdvDataS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKMK?>    const uint8_t *GetAdvData(void) const { return mAdvData; }t(
SetAdvDataS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMJoinerAdvertisementTlvt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_tlvs.hppMKM
KX"      void SetAdvData(const uint8_t *aAdvData, uint8_t aAdvDataLength)
    {
        OT_ASSERT((aAdvData != nullptr) && (aAdvDataLength > 0) && (aAdvDataLength <= kAdvDataMaxLength));

        SetLength(aAdvDataLength + sizeof(mOui));
        memcpy(mAdvData, aAdvData, aAdvDataLength);
    }t(IsConnectionActiveK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppKDtlst(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppKKKKON    bool IsConnectionActive(void) const { return mState >= kStateConnecting; }t(IsConnectedK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppKDtlst(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppKKKKGF    bool IsConnected(void) const { return mState == kStateConnected; }t(SetSslAuthModeK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppM"Dtlst(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppM"KM"Kji    void SetSslAuthMode(bool aVerifyPeerCertificate) { mVerifyPeerCertificate = aVerifyPeerCertificate; }t(SetDefaultMessageSubTypeK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppMMDtlst(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppMMKMMKrq    void SetDefaultMessageSubType(Message::SubType aMessageSubType) { mMessageDefaultSubType = aMessageSubType; }t(GetMessageInfoK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppMUDtlst(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dtls.hppMUKMUKPO    const Ip6::MessageInfo &GetMessageInfo(void) const { return mMessageInfo; }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKR
JoinerPskdt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKRKKRK98    bool IsValid(void) const { return IsPskdValid(m8); }t(GetAsCStringN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKg
JoinerPskdt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKgKKgK87    const char *GetAsCString(void) const { return m8; }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKq
JoinerPskdt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKqKKqKed    uint8_t GetLength(void) const { return static_cast<uint8_t>(StringLength(m8, kMaxLength + 1)); }t(ClearN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKK&%    void Clear(void) { mLength = 0; }t(IsEmptyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKK65    bool IsEmpty(void) const { return mLength == 0; }t(GetValueN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKK54    uint64_t GetValue(void) const { return mValue; }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKK65    uint8_t GetLength(void) const { return mLength; }t(IsValidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKÌJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKKRQ    bool IsValid(void) const { return (0 < mLength) && (mLength <= kMaxLength); }t(GetMaskN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKJoinerDiscernert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppKKKKZY    uint64_t GetMask(void) const { return (static_cast<uint64_t>(1ULL) << mLength) - 1; }t(ClearN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMK"!    void Clear(void) { Init(1); }t(	GetLengthN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM#SteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM#KM#K65    uint8_t GetLength(void) const { return mLength; }t(GetDataN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM+SteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM+KM+K65    const uint8_t *GetData(void) const { return m8; }t(GetDataN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM3SteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppM3KM3K*)    uint8_t *GetData(void) { return m8; }t(IsEmptyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKKMKK98    bool IsEmpty(void) const { return DoesAllMatch(0); }t(PermitsAllJoinersN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSKMSK]\    bool PermitsAllJoiners(void) const { return (mLength > 0) && DoesAllMatch(kPermitAll); }t(
GetNumBitsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKDC    uint8_t GetNumBits(void) const { return (mLength * CHAR_BIT); }t(BitIndexN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKWV    uint8_t BitIndex(uint8_t aBit) const { return (mLength - 1 - (aBit / CHAR_BIT)); }t(BitFlagN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKba    uint8_t BitFlag(uint8_t aBit) const { return static_cast<uint8_t>(1U << (aBit % CHAR_BIT)); }t(GetBitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKZY    bool GetBit(uint8_t aBit) const { return (m8[BitIndex(aBit)] & BitFlag(aBit)) != 0; }t(SetBitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKGF    void SetBit(uint8_t aBit) { m8[BitIndex(aBit)] |= BitFlag(aBit); }t(ClearBitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMSteeringDatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMKJI    void ClearBit(uint8_t aBit) { m8[BitIndex(aBit)] &= ~BitFlag(aBit); }t(LogErrorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMNt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop.hppMKMK-,inline void LogError(const char *, Error) {}t(SetConnectedCallbackO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKg
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKgKKjK    void SetConnectedCallback(ConnectedCallback aCallback, void *aContext)
    {
        mConnectedCallback.Set(aCallback, aContext);
    }t(IsConnectionActiveO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKKON    bool IsConnectionActive(void) const { return mDtls.IsConnectionActive(); }t(IsConnectedO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKKA@    bool IsConnected(void) const { return mDtls.IsConnected(); }t(
DisconnectO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKK21    void Disconnect(void) { mDtls.Disconnect(); }t(GetDtlsO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKK32    MeshCoP::Dtls &GetDtls(void) { return mDtls; }t(
GetUdpPortO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKKCB    uint16_t GetUdpPort(void) const { return mDtls.GetUdpPort(); }t(SetPskO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKKed    Error SetPsk(const uint8_t *aPsk, uint8_t aPskLength) { return mDtls.SetPsk(aPsk, aPskLength); }t(SetPreSharedKeyO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKȌ
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKK    void SetPreSharedKey(const uint8_t *aPsk, uint16_t aPskLength, const uint8_t *aPskIdentity, uint16_t aPskIdLength)
    {
        mDtls.SetPreSharedKey(aPsk, aPskLength, aPskIdentity, aPskIdLength);
    }t(SetCertificateO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKڌ
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKKX5      void SetCertificate(const uint8_t *aX509Cert,
                        uint32_t       aX509Length,
                        const uint8_t *aPrivateKey,
                        uint32_t       aPrivateKeyLength)
    {
        mDtls.SetCertificate(aX509Cert, aX509Length, aPrivateKey, aPrivateKeyLength);
    }t(SetCaCertificateChainO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppK
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppKKKK    void SetCaCertificateChain(const uint8_t *aX509CaCertificateChain, uint32_t aX509CaCertChainLength)
    {
        mDtls.SetCaCertificateChain(aX509CaCertificateChain, aX509CaCertChainLength);
    }t(SetClientConnectedCallbackO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppM
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppMKMK    void SetClientConnectedCallback(ConnectedCallback aCallback, void *aContext)
    {
        mConnectedCallback.Set(aCallback, aContext);
    }t(SetSslAuthModeO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppM
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppMKMKgf    void SetSslAuthMode(bool aVerifyPeerCertificate) { mDtls.SetSslAuthMode(aVerifyPeerCertificate); }t(HandleUdpReceiveO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppM
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppMKMK    void HandleUdpReceive(ot::Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
    {
        return mDtls.HandleUdpReceive(aMessage, aMessageInfo);
    }t(GetMessageInfoO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppM
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppMKMKZY    const Ip6::MessageInfo &GetMessageInfo(void) const { return mDtls.GetMessageInfo(); }t(SendO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppM
CoapSecuret(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_secure.hppMKMK    static Error Send(CoapBase &aCoapBase, ot::Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
    {
        return static_cast<CoapSecure &>(aCoapBase).Send(aMessage, aMessageInfo);
    }t(EventsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKwEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKwKKzK5    Events(void)
        : mEventFlags(0)
    {
    }t(ClearN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKK*)    void Clear(void) { mEventFlags = 0; }t(ContainsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKKNM    bool Contains(Event aEvent) const { return (mEventFlags & aEvent) != 0; }t(ContainsAnyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKKSR    bool ContainsAny(Flags aEvents) const { return (mEventFlags & aEvents) != 0; }t(ContainsAllN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKKYX    bool ContainsAll(Flags aEvents) const { return (mEventFlags & aEvents) == aEvents; }t(AddN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKK65    void Add(Event aEvent) { mEventFlags |= aEvent; }t(IsEmptyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKK<;    bool IsEmpty(void) const { return (mEventFlags == 0); }t(
GetAsFlagsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKEventst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKK98    Flags GetAsFlags(void) const { return mEventFlags; }t(	IsPendingN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKNotifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppKKKKFE    bool IsPending(void) const { return !mEventsToSignal.IsEmpty(); }t(HasSignaledN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppM	Notifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppM	KM	KVU    bool HasSignaled(Event aEvent) const { return mSignaledEvents.Contains(aEvent); }t(UpdateN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppMNotifiert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/notifier.hppMKM+KX      template <typename Type> Error Update(Type &aVariable, const Type &aNewValue, Event aEvent)
    {
        Error error = kErrorNone;

        if (aVariable == aNewValue)
        {
            SignalIfFirst(aEvent);
            error = kErrorAlready;
        }
        else
        {
            aVariable = aNewValue;
            Signal(aEvent);
        }

        return error;
    }t(SettingsDriverU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppK:SettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppK:KK@K    explicit SettingsDriver(Instance &aInstance)
        : InstanceLocator(aInstance)
#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        , mFlash(aInstance)
#endif
    {
    }t(InitU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKISettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKIKKSKX_      void Init(const uint16_t *aSensitiveKeys, uint16_t aSensitiveKeysLength)
    {
#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        OT_UNUSED_VARIABLE(aSensitiveKeys);
        OT_UNUSED_VARIABLE(aSensitiveKeysLength);

        mFlash.Init();
#else
        otPlatSettingsInit(GetInstancePtr(), aSensitiveKeys, aSensitiveKeysLength);
#endif
    }t(DeinitU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKYSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKYKK^K    void Deinit(void)
    {
#if !OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        otPlatSettingsDeinit(GetInstancePtr());
#endif
    }t(AddU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKlSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKlKKwKX      Error Add(uint16_t aKey, const void *aValue, uint16_t aValueLength)
    {
        Error          error;
        const uint8_t *value = reinterpret_cast<const uint8_t *>(aValue);

#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        error = mFlash.Add(aKey, value, aValueLength);
#else
        error = otPlatSettingsAdd(GetInstancePtr(), aKey, value, aValueLength);
#endif
        return error;
    }t(DeleteU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKKX      Error Delete(uint16_t aKey, int aIndex = -1)
    {
        Error error;

#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        error = mFlash.Delete(aKey, aIndex);
#else
        error = otPlatSettingsDelete(GetInstancePtr(), aKey, aIndex);
#endif
        return error;
    }t(GetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKKX      Error Get(uint16_t aKey, int aIndex, void *aValue, uint16_t *aValueLength) const
    {
        Error    error;
        uint8_t *value = reinterpret_cast<uint8_t *>(aValue);

#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        error = mFlash.Get(aKey, aIndex, value, aValueLength);
#else
        error = otPlatSettingsGet(GetInstancePtr(), aKey, aIndex, value, aValueLength);
#endif
        return error;
    }t(GetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKKxw    Error Get(uint16_t aKey, void *aValue, uint16_t *aValueLength) const { return Get(aKey, 0, aValue, aValueLength); }t(SetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKόSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKKX      Error Set(uint16_t aKey, const void *aValue, uint16_t aValueLength)
    {
        Error          error;
        const uint8_t *value = reinterpret_cast<const uint8_t *>(aValue);

#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        error = mFlash.Set(aKey, value, aValueLength);
#else
        error = otPlatSettingsSet(GetInstancePtr(), aKey, value, aValueLength);
#endif
        return error;
    }t(WipeU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKK    void Wipe(void)
    {
#if OPENTHREAD_CONFIG_PLATFORM_FLASH_API_ENABLE
        mFlash.Wipe();
#else
        otPlatSettingsWipe(GetInstancePtr());
#endif
    }t(GetInstancePtrU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKSettingsDrivert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings_driver.hppKKKKwv    otInstance *GetInstancePtr(void) const { return reinterpret_cast<otInstance *>(&InstanceLocator::GetInstance()); }t(GetBytesK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKg	Signaturet(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKgK	KgK;:        const uint8_t *GetBytes(void) const { return m8; }t(KeyPairK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppK}KeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppK}K	K}K*)        KeyPair(void) { mDerLength = 0; }t(GenerateK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KKLK        Error Generate(void) { return otPlatCryptoEcdsaGenerateKey(this); }t(GetPublicKeyK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KKut        Error GetPublicKey(PublicKey &aPublicKey) const { return otPlatCryptoEcdsaGetPublicKey(this, &aPublicKey); }t(GetDerBytesK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KKED        const uint8_t *GetDerBytes(void) const { return mDerBytes; }t(GetDerLengthK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KK@?        uint8_t GetDerLength(void) const { return mDerLength; }t(GetDerBytesK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KK98        uint8_t *GetDerBytes(void) { return mDerBytes; }t(SetDerLengthK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KKKJ        void SetDerLength(uint8_t aDerLength) { mDerLength = aDerLength; }t(SignK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKɌKeyPairt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KK
        Error Sign(const Sha256::Hash &aHash, Signature &aSignature) const
        {
            return otPlatCryptoEcdsaSign(this, &aHash, &aSignature);
        }t(GetBytesK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppK	PublicKeyt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KK;:        const uint8_t *GetBytes(void) const { return m8; }t(VerifyK/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppK	PublicKeyt(K/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/ecdsa.hppKK	KK
        Error Verify(const Sha256::Hash &aHash, const Signature &aSignature) const
        {
            return otPlatCryptoEcdsaVerify(this, &aHash, &aSignature);
        }t(IsActiveTimestampPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK[
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK[K	K[KXW        bool IsActiveTimestampPresent(void) const { return mIsActiveTimestampPresent; }t(IsPendingTimestampPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKc
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKcK	KcKZY        bool IsPendingTimestampPresent(void) const { return mIsPendingTimestampPresent; }t(IsNetworkKeyPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKk
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKkK	KkKNM        bool IsNetworkKeyPresent(void) const { return mIsNetworkKeyPresent; }t(IsNetworkNamePresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKs
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKsK	KsKPO        bool IsNetworkNamePresent(void) const { return mIsNetworkNamePresent; }t(IsExtendedPanIdPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK{
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK{K	K{KTS        bool IsExtendedPanIdPresent(void) const { return mIsExtendedPanIdPresent; }t(IsMeshLocalPrefixPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKXW        bool IsMeshLocalPrefixPresent(void) const { return mIsMeshLocalPrefixPresent; }t(IsDelayPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKDC        bool IsDelayPresent(void) const { return mIsDelayPresent; }t(IsPanIdPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKDC        bool IsPanIdPresent(void) const { return mIsPanIdPresent; }t(IsChannelPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKHG        bool IsChannelPresent(void) const { return mIsChannelPresent; }t(
IsPskcPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKBA        bool IsPskcPresent(void) const { return mIsPskcPresent; }t(IsSecurityPolicyPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKVU        bool IsSecurityPolicyPresent(void) const { return mIsSecurityPolicyPresent; }t(IsChannelMaskPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK
Componentst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKPO        bool IsChannelMaskPresent(void) const { return mIsChannelMaskPresent; }t(IsActiveTimestampPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKÌInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKdc        bool IsActiveTimestampPresent(void) const { return mComponents.mIsActiveTimestampPresent; }t(GetActiveTimestampN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKΌInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKpo        void GetActiveTimestamp(Timestamp &aTimestamp) const { aTimestamp.SetFromTimestamp(mActiveTimestamp); }t(SetActiveTimestampN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppK֌Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KK
        void SetActiveTimestamp(const Timestamp &aTimestamp)
        {
            aTimestamp.ConvertTo(mActiveTimestamp);
            mComponents.mIsActiveTimestampPresent = true;
        }t(IsPendingTimestampPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKfe        bool IsPendingTimestampPresent(void) const { return mComponents.mIsPendingTimestampPresent; }t(GetPendingTimestampN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KKrq        void GetPendingTimestamp(Timestamp &aTimestamp) const { aTimestamp.SetFromTimestamp(mPendingTimestamp); }t(SetPendingTimestampN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppKK	KK
        void SetPendingTimestamp(const Timestamp &aTimestamp)
        {
            aTimestamp.ConvertTo(mPendingTimestamp);
            mComponents.mIsPendingTimestampPresent = true;
        }t(IsNetworkKeyPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKZY        bool IsNetworkKeyPresent(void) const { return mComponents.mIsNetworkKeyPresent; }t(
GetNetworkKeyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKYX        const NetworkKey &GetNetworkKey(void) const { return AsCoreType(&mNetworkKey); }t(
SetNetworkKeyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetNetworkKey(const NetworkKey &aNetworkKey)
        {
            mNetworkKey                      = aNetworkKey;
            mComponents.mIsNetworkKeyPresent = true;
        }t(UpdateNetworkKeyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM K	M$K
        NetworkKey &UpdateNetworkKey(void)
        {
            mComponents.mIsNetworkKeyPresent = true;
            return AsCoreType(&mNetworkKey);
        }t(IsNetworkNamePresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM,Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM,K	M,K\[        bool IsNetworkNamePresent(void) const { return mComponents.mIsNetworkNamePresent; }t(GetNetworkNameN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM7Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM7K	M7K\[        const NetworkName &GetNetworkName(void) const { return AsCoreType(&mNetworkName); }t(SetNetworkNameN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM?Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM?K	MCK
        void SetNetworkName(const NameData &aNetworkNameData)
        {
            IgnoreError(AsCoreType(&mNetworkName).Set(aNetworkNameData));
            mComponents.mIsNetworkNamePresent = true;
        }t(IsExtendedPanIdPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKK	MKK`_        bool IsExtendedPanIdPresent(void) const { return mComponents.mIsExtendedPanIdPresent; }t(GetExtendedPanIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMVInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMVK	MVKba        const ExtendedPanId &GetExtendedPanId(void) const { return AsCoreType(&mExtendedPanId); }t(SetExtendedPanIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM^Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM^K	MbK
        void SetExtendedPanId(const ExtendedPanId &aExtendedPanId)
        {
            mExtendedPanId                      = aExtendedPanId;
            mComponents.mIsExtendedPanIdPresent = true;
        }t(IsMeshLocalPrefixPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMjInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMjK	MjKdc        bool IsMeshLocalPrefixPresent(void) const { return mComponents.mIsMeshLocalPrefixPresent; }t(GetMeshLocalPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMuInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMuK	MxK
        const Ip6::NetworkPrefix &GetMeshLocalPrefix(void) const
        {
            return static_cast<const Ip6::NetworkPrefix &>(mMeshLocalPrefix);
        }t(SetMeshLocalPrefixN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetMeshLocalPrefix(const Ip6::NetworkPrefix &aMeshLocalPrefix)
        {
            mMeshLocalPrefix                      = aMeshLocalPrefix;
            mComponents.mIsMeshLocalPrefixPresent = true;
        }t(IsDelayPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKPO        bool IsDelayPresent(void) const { return mComponents.mIsDelayPresent; }t(GetDelayN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK98        uint32_t GetDelay(void) const { return mDelay; }t(SetDelayN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetDelay(uint32_t aDelay)
        {
            mDelay                      = aDelay;
            mComponents.mIsDelayPresent = true;
        }t(IsPanIdPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKPO        bool IsPanIdPresent(void) const { return mComponents.mIsPanIdPresent; }t(GetPanIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK;:        Mac::PanId GetPanId(void) const { return mPanId; }t(SetPanIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetPanId(Mac::PanId aPanId)
        {
            mPanId                      = aPanId;
            mComponents.mIsPanIdPresent = true;
        }t(IsChannelPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKTS        bool IsChannelPresent(void) const { return mComponents.mIsChannelPresent; }t(
GetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK=<        uint16_t GetChannel(void) const { return mChannel; }t(
SetChannelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetChannel(uint16_t aChannel)
        {
            mChannel                      = aChannel;
            mComponents.mIsChannelPresent = true;
        }t(
IsPskcPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKNM        bool IsPskcPresent(void) const { return mComponents.mIsPskcPresent; }t(GetPskcN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKGF        const Pskc &GetPskc(void) const { return AsCoreType(&mPskc); }t(SetPskcN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetPskc(const Pskc &aPskc)
        {
            mPskc                      = aPskc;
            mComponents.mIsPskcPresent = true;
        }t(IsSecurityPolicyPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKba        bool IsSecurityPolicyPresent(void) const { return mComponents.mIsSecurityPolicyPresent; }t(GetSecurityPolicyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MKed        const SecurityPolicy &GetSecurityPolicy(void) const { return AsCoreType(&mSecurityPolicy); }t(SetSecurityPolicyN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMK	MK
        void SetSecurityPolicy(const SecurityPolicy &aSecurityPolicy)
        {
            mSecurityPolicy                      = aSecurityPolicy;
            mComponents.mIsSecurityPolicyPresent = true;
        }t(IsChannelMaskPresentN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM&Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM&K	M&K\[        bool IsChannelMaskPresent(void) const { return mComponents.mIsChannelMaskPresent; }t(GetChannelMaskN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM1Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM1K	M1KJI        otChannelMask GetChannelMask(void) const { return mChannelMask; }t(SetChannelMaskN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM9Infot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppM9K	M=K
        void SetChannelMask(otChannelMask aChannelMask)
        {
            mChannelMask                      = aChannelMask;
            mComponents.mIsChannelMaskPresent = true;
        }t(GetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMyDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMyKMyKVU    Tlv *GetTlv(Tlv::Type aType) { return AsNonConst(AsConst(this)->GetTlv(aType)); }t(GetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK    template <typename TlvType> TlvType *GetTlv(void)
    {
        return As<TlvType>(GetTlv(static_cast<Tlv::Type>(TlvType::kType)));
    }t(GetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK    template <typename TlvType> const TlvType *GetTlv(void) const
    {
        return As<TlvType>(GetTlv(static_cast<Tlv::Type>(TlvType::kType)));
    }t(GetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK.-    uint8_t *GetBytes(void) { return mTlvs; }t(GetBytesN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK:9    const uint8_t *GetBytes(void) const { return mTlvs; }t(GetSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK54    uint16_t GetSize(void) const { return mLength; }t(SetSizeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK65    void SetSize(uint16_t aSize) { mLength = aSize; }t(
GetUpdateTimeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMK@?    TimeMilli GetUpdateTime(void) const { return mUpdateTime; }t(SetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMKX      template <typename ValueType> Error SetTlv(Tlv::Type aType, const ValueType &aValue)
    {
        static_assert(!TypeTraits::IsPointer<ValueType>::kValue, "ValueType must not be a pointer");

        return SetTlv(aType, &aValue, sizeof(ValueType));
    }t(GetTlvsStartN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMmDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMmKMmKGF    Tlv *GetTlvsStart(void) { return reinterpret_cast<Tlv *>(mTlvs); }t(GetTlvsStartN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMuDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMuKMuKYX    const Tlv *GetTlvsStart(void) const { return reinterpret_cast<const Tlv *>(mTlvs); }t(
GetTlvsEndN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMKON    Tlv *GetTlvsEnd(void) { return reinterpret_cast<Tlv *>(mTlvs + mLength); }t(
GetTlvsEndN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMKa`    const Tlv *GetTlvsEnd(void) const { return reinterpret_cast<const Tlv *>(mTlvs + mLength); }t(SetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMKtemplate <> inline Error Dataset::SetTlv(Tlv::Type aType, const uint16_t &aValue)
{
    uint16_t value = Encoding::BigEndian::HostSwap16(aValue);

    return SetTlv(aType, &value, sizeof(uint16_t));
}t(SetTlvN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMDatasett(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset.hppMKMKtemplate <> inline Error Dataset::SetTlv(Tlv::Type aType, const uint32_t &aValue)
{
    uint32_t value = Encoding::BigEndian::HostSwap32(aValue);

    return SetTlv(aType, &value, sizeof(uint32_t));
}t(GetBytesS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKFFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKFKKFK<;    const uint8_t *GetBytes(void) const { return mBuffer; }t(	GetLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKNFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKNKKNK76    uint16_t GetLength(void) const { return mLength; }t(GetMaxLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKVFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKVKKVK=<    uint16_t GetMaxLength(void) const { return mMaxLength; }t(SetMaxLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKaFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKaKKaKBA    void SetMaxLength(uint16_t aLength) { mMaxLength = aLength; }t(GetRemainingLengthS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKiFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKiKKiKML    uint16_t GetRemainingLength(void) const { return mMaxLength - mLength; }t(	CanAppendS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKuFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKuKKuKpo    bool CanAppend(uint16_t aLength) const { return (static_cast<uint32_t>(mLength) + aLength) <= mMaxLength; }t(AppendS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hpp2      KFrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppKKKK    template <typename ObjectType> Error Append(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return AppendBytes(&aObject, sizeof(ObjectType));
    }t(WriteS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppM FrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppM KMKX	      template <typename ObjectType> void Write(uint16_t aOffset, const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        WriteBytes(aOffset, &aObject, sizeof(ObjectType));
    }t(InsertS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppM&FrameBuildert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/frame_builder.hppM&KM+KX      template <typename ObjectType> Error Insert(uint16_t aOffset, const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return InsertBytes(aOffset, &aObject, sizeof(ObjectType));
    }t(
IsLowpanHcL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppKlLowpant(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppKlKKoK    static bool IsLowpanHc(const uint8_t *aHeader)
    {
        return (aHeader[0] & (Lowpan::kHcDispatchMask >> 8)) == (Lowpan::kHcDispatch >> 8);
    }t(
IsLowpanHcL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppKyLowpant(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppKyKK|K    static bool IsLowpanHc(const FrameData &aFrameData)
    {
        return (aFrameData.GetLength() > 0) && IsLowpanHc(aFrameData.GetBytes());
    }t(GetHopsLeftL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppM
MeshHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMKMK:9    uint8_t GetHopsLeft(void) const { return mHopsLeft; }t(	GetSourceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppM
MeshHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMKMK76    uint16_t GetSource(void) const { return mSource; }t(GetDestinationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppM
MeshHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMKMKA@    uint16_t GetDestination(void) const { return mDestination; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppM	FirstFragt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMK	MK
        void Init(uint16_t aSize, uint16_t aTag)
        {
            mDispatchSize = HostSwap16(kFirstDispatch | (aSize & kSizeMask));
            mTag          = HostSwap16(aTag);
        }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMNextFragt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMK	M K
X          void Init(uint16_t aSize, uint16_t aTag, uint16_t aOffset)
        {
            mDispatchSize = HostSwap16(kNextDispatch | (aSize & kSizeMask));
            mTag          = HostSwap16(aTag);
            mOffset       = static_cast<uint8_t>(aOffset >> 3);
        }t(GetDatagramSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMAFragmentHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMAKMAK;:    uint16_t GetDatagramSize(void) const { return mSize; }t(GetDatagramTagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMIFragmentHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMIKMIK98    uint16_t GetDatagramTag(void) const { return mTag; }t(GetDatagramOffsetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMSFragmentHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/lowpan.hppMSKMSK?>    uint16_t GetDatagramOffset(void) const { return mOffset; }t(	IsRunningS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKfTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKfKKfKCB    bool IsRunning(void) const { return TimerMilli::IsRunning(); }t(GetModeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKnTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKnKKnK/.    Mode GetMode(void) const { return mMode; }t(StopS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKKKK,+    void Stop(void) { TimerMilli::Stop(); }t(StartAtS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKKKK    void StartAt(void) {}t(FireAtS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKKKK    void FireAt(void) {}t(FireAtIfEarlierS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKKKK"!    void FireAtIfEarlier(void) {}t(GetFireTimeS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKTrickleTimert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/trickle_timer.hppKKKK    void GetFireTime(void) {}t(GetChildQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKZIteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKZK	KZK0/        Child *GetChild(void) { return mItem; }t(IteratorQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK]Iteratort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK]K	KaK
        explicit Iterator(Instance &aInstance)
            : InstanceLocator(aInstance)
            , mFilter(Child::StateFilter::kInStateValid)
        {
        }t(
GetChildIndexQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK~
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK~KK~Kml    uint16_t GetChildIndex(const Child &aChild) const { return static_cast<uint16_t>(&aChild - mChildren); }t(GetMaxChildrenQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKԌ
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKKKKA@    uint16_t GetMaxChildren(void) const { return kMaxChildren; }t(GetMaxChildrenAllowedQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK܌
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKKKKON    uint16_t GetMaxChildrenAllowed(void) const { return mMaxChildrenAllowed; }t(IterateQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppK
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppKKKKlk    IteratorBuilder Iterate(Child::StateFilter aFilter) { return IteratorBuilder(GetInstance(), aFilter); }t(ContainsQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppM<
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppM<KMAK    bool Contains(const Neighbor &aNeighbor) const
    {
        const Child *child = static_cast<const Child *>(&aNeighbor);

        return (mChildren <= child) && (child < GetArrayEnd(mChildren));
    }t(IteratorBuilderQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMIIteratorBuildert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMIK	MMK
        IteratorBuilder(Instance &aInstance, Child::StateFilter aFilter)
            : InstanceLocator(aInstance)
            , mFilter(aFilter)
        {
        }t(beginQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMOIteratorBuildert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMOK	MOKJI        Iterator begin(void) { return Iterator(GetInstance(), mFilter); }t(endQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMPIteratorBuildert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMPK	MPK?>        Iterator end(void) { return Iterator(GetInstance()); }t(	FindChildQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMV
ChildTablet(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/child_table.hppMVKMVKwv    Child *FindChild(const Child::AddressMatcher &aMatcher) { return AsNonConst(AsConst(this)->FindChild(aMatcher)); }t(SetKeyM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKVAesCcmt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKVKKVK87    void SetKey(const Key &aKey) { mEcb.SetKey(aKey); }t(HeaderM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKAesCcmt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKKKK    template <typename ObjectType> void Header(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        Header(&aObject, sizeof(ObjectType));
    }t(GetTagLengthM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKAesCcmt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/crypto/aes_ccm.hppKKKK<;    uint8_t GetTagLength(void) const { return mTagLength; }t(MessageInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/tmf.hppKQMessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/tmf.hppKQKKUK}    explicit MessageInfo(Instance &aInstance)
        : InstanceLocator(aInstance)
    {
        SetPeerPort(kUdpPort);
    }t(SetSockPortToTmfI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/tmf.hppK[MessageInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/tmf.hppK[KK[K;:    void SetSockPortToTmf(void) { SetSockPort(kUdpPort); }t(AppendToT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner_router.hppK\JoinerEntrustMetadatat(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner_router.hppK\K	K\KSR        Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(RegisterCallbackT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/neighbor_table.hppK،
NeighborTablet(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/neighbor_table.hppKKKKIH    void RegisterCallback(Callback aCallback) { mCallback = aCallback; }t(StartI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKK76    Error Start(void) { return Start(kNormalAttach); }t(StopI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKK65    void Stop(void) { Stop(kUpdateNetworkDatasets); }t(SendAnnounceI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKKUT    void SendAnnounce(uint8_t aChannel) { SendAnnounce(aChannel, kNormalAnnounce); }t(IsAttachingI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKKPO    bool IsAttaching(void) const { return (mAttachState != kAttachStateIdle); }t(GetRoleI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKK54    DeviceRole GetRole(void) const { return mRole; }t(
IsDisabledI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKKED    bool IsDisabled(void) const { return (mRole == kRoleDisabled); }t(
IsDetachedI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppKKKKED    bool IsDetached(void) const { return (mRole == kRoleDetached); }t(IsChildI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK?>    bool IsChild(void) const { return (mRole == kRoleChild); }t(IsRouterI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKA@    bool IsRouter(void) const { return (mRole == kRoleRouter); }t(IsLeaderI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKA@    bool IsLeader(void) const { return (mRole == kRoleLeader); }t(
GetDeviceModeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM&Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM&KM&KA@    DeviceMode GetDeviceMode(void) const { return mDeviceMode; }t(IsRxOnWhenIdleI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM9Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM9KM9KML    bool IsRxOnWhenIdle(void) const { return mDeviceMode.IsRxOnWhenIdle(); }t(IsFullThreadDeviceI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMAMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMAKMAKUT    bool IsFullThreadDevice(void) const { return mDeviceMode.IsFullThreadDevice(); }t(IsMinimalEndDeviceI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMIMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMIKMIKUT    bool IsMinimalEndDevice(void) const { return mDeviceMode.IsMinimalEndDevice(); }t(GetNetworkDataTypeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMQMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMQKMQKba    NetworkData::Type GetNetworkDataType(void) const { return mDeviceMode.GetNetworkDataType(); }t(GetMeshLocalPrefixI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMYMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMYKMYKon    const Ip6::NetworkPrefix &GetMeshLocalPrefix(void) const { return mMeshLocal16.GetAddress().GetPrefix(); }t(GetLinkLocalAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK^]    const Ip6::Address &GetLinkLocalAddress(void) const { return mLinkLocal64.GetAddress(); }t(!GetLinkLocalAllThreadNodesAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKxw    const Ip6::Address &GetLinkLocalAllThreadNodesAddress(void) const { return mLinkLocalAllThreadNodes.GetAddress(); }t("GetRealmLocalAllThreadNodesAddressI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK    const Ip6::Address &GetRealmLocalAllThreadNodesAddress(void) const
    {
        return mRealmLocalAllThreadNodes.GetAddress();
    }t(	GetParentI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK0/    Parent &GetParent(void) { return mParent; }t(	GetParentI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK<;    const Parent &GetParent(void) const { return mParent; }t(GetParentCandidateI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKBA    Parent &GetParentCandidate(void) { return mParentCandidate; }t(
GetTimeoutI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK98    uint32_t GetTimeout(void) const { return mTimeout; }t(	GetRloc16I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK76    uint16_t GetRloc16(void) const { return mRloc16; }t(GetMeshLocal16I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKYX    const Ip6::Address &GetMeshLocal16(void) const { return mMeshLocal16.GetAddress(); }t(GetMeshLocal64I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKYX    const Ip6::Address &GetMeshLocal64(void) const { return mMeshLocal64.GetAddress(); }t(GetLeaderIdI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKPO    uint8_t GetLeaderId(void) const { return mLeaderData.GetLeaderRouterId(); }t(
GetLeaderAlocI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM)Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM)KM)Kml    Error GetLeaderAloc(Ip6::Address &aAddress) const { return GetLocatorAddress(aAddress, kAloc16Leader); }t(GetCommissionerAlocI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM5Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM5KM8K    Error GetCommissionerAloc(Ip6::Address &aAddress, uint16_t aSessionId) const
    {
        return GetLocatorAddress(aAddress, CommissionerAloc16FromId(aSessionId));
    }t(GetMessageQueueI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMTMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMTKMTKRQ    const MessageQueue &GetMessageQueue(void) const { return mDelayedResponses; }t(GetCountersI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMbMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMbKMhK    const otMleCounters &GetCounters(void)
    {
#if OPENTHREAD_CONFIG_UPTIME_ENABLE
        UpdateRoleTimeCounters(mRole);
#endif
        return mCounters;
    }t(
ResetCountersI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMnMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMnKMnKKJ    void ResetCounters(void) { memset(&mCounters, 0, sizeof(mCounters)); }t(#RegisterParentResponseStatsCallbackI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMwMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMwKMzK    void RegisterParentResponseStatsCallback(otThreadParentResponseCallback aCallback, void *aContext)
    {
        mParentResponseCallback.Set(aCallback, aContext);
    }t(HasRestoredI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK:9    bool HasRestored(void) const { return mHasRestored; }t(
operator==I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM	Challenget(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMK	MKkj        bool operator==(const Challenge &aOther) const { return Matches(aOther.mBuffer, aOther.mLength); }t(AppendTlvRequestTlvI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM	TxMessaget(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMK	M K
        template <uint8_t kArrayLength> Error AppendTlvRequestTlv(const uint8_t (&aTlvArray)[kArrayLength])
        {
            return AppendTlvRequestTlv(aTlvArray, kArrayLength);
        }t(RxInfoI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMlRxInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMlK	MtK
X<          RxInfo(Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
            : mMessage(static_cast<RxMessage &>(aMessage))
            , mMessageInfo(aMessageInfo)
            , mFrameCounter(0)
            , mKeySequence(0)
            , mNeighbor(nullptr)
            , mClass(kUnknown)
        {
        }t(IsNeighborStateValidI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM~RxInfot(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM~K	M~Knm        bool IsNeighborStateValid(void) const { return (mNeighbor != nullptr) && mNeighbor->IsStateValid(); }t(ClearParentCandidateI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMKBA    void ClearParentCandidate(void) { mParentCandidate.Clear(); }t(SendDataRequestI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK    template <uint8_t kArrayLength>
    Error SendDataRequest(const Ip6::Address &aDestination, const uint8_t (&aTlvs)[kArrayLength], uint16_t aDelay = 0)
    {
        return SendDataRequest(aDestination, aTlvs, kArrayLength, aDelay);
    }t(LogI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM<Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM<KM<KIH    static void Log(MessageAction, MessageType, const Ip6::Address &) {}t(LogI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM=Mlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM=KM=KSR    static void Log(MessageAction, MessageType, const Ip6::Address &, uint16_t) {}t(LogProcessErrorI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMYMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMYKMYK76    static void LogProcessError(MessageType, Error) {}t(LogSendErrorI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMZMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMZKMZK43    static void LogSendError(MessageType, Error) {}t(IsAnnounceAttachI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMmMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMmKMmKZY    bool IsAnnounceAttach(void) const { return mAlternatePanId != Mac::kPanIdBroadcast; }t(AppendToI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMDelayedResponseMetadatat(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMK	MKSR        Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(InitSecurityControlI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM!SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM!K	M!KPO        void InitSecurityControl(void) { mSecurityControl = kKeyIdMode2Mic32; }t(IsSecurityControlValidI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM"SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM"K	M"Kcb        bool IsSecurityControlValid(void) const { return (mSecurityControl == kKeyIdMode2Mic32); }t(GetFrameCounterI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM$SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM$K	M$Kkj        uint32_t GetFrameCounter(void) const { return Encoding::LittleEndian::HostSwap32(mFrameCounter); }t(SetFrameCounterI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM%SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM%K	M%Kvu        void     SetFrameCounter(uint32_t aCounter) { mFrameCounter = Encoding::LittleEndian::HostSwap32(aCounter); }t(GetKeyIdI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM'SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM'K	M'K^]        uint32_t GetKeyId(void) const { return Encoding::BigEndian::HostSwap32(mKeySource); }t(SetKeyIdI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM(SecurityHeadert(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM(K	M,K
        void     SetKeyId(uint32_t aKeySequence)
        {
            mKeySource = Encoding::BigEndian::HostSwap32(aKeySequence);
            mKeyIndex  = (aKeySequence & 0x7f) + 1;
        }t(InitI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM;ParentCandidatet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppM;K	M;KDC        void Init(Instance &aInstance) { Parent::Init(aInstance); }t(IsInUseI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMSServiceAloct(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMSK	MSKJI        bool     IsInUse(void) const { return GetAloc16() != kNotInUse; }t(MarkAsNotInUseI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMTServiceAloct(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMTK	MTK@?        void     MarkAsNotInUse(void) { SetAloc16(kNotInUse); }t(	GetAloc16I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMUServiceAloct(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMUK	MUKVU        uint16_t GetAloc16(void) const { return GetAddress().GetIid().GetLocator(); }t(	SetAloc16I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMVServiceAloct(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMVK	MVK\[        void     SetAloc16(uint16_t aAloc16) { GetAddress().GetIid().SetLocator(aAloc16); }t(ApplyMeshLocalPrefixI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMWServiceAloct(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMWK	MWKnm        void     ApplyMeshLocalPrefix(const Ip6::NetworkPrefix &aPrefix) { GetAddress().SetPrefix(aPrefix); }t(IsDetachingGracefullyI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMMlet(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle.hppMKMK[Z    bool        IsDetachingGracefully(void) { return mDetachGracefullyTimer.IsRunning(); }t(GetTypeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKX	ThreadTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKXKKXKON    Type GetType(void) const { return static_cast<Type>(ot::Tlv::GetType()); }t(SetTypeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppK`	ThreadTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppK`KK`KPO    void SetType(Type aType) { ot::Tlv::SetType(static_cast<uint8_t>(aType)); }t(InitQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKԌThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKKKK    void Init(void)
    {
        SetType(kRouterMask);
        SetLength(sizeof(*this) - sizeof(ThreadTlv));
        mAssignedRouterIdMask.Clear();
    }t(IsValidQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKKKKZY    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(ThreadTlv); }t(
GetIdSequenceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKKKK>=    uint8_t GetIdSequence(void) const { return mIdSequence; }t(
SetIdSequenceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKKKKGF    void SetIdSequence(uint8_t aSequence) { mIdSequence = aSequence; }t(GetAssignedRouterIdMaskQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppKKKKba    const Mle::RouterIdSet &GetAssignedRouterIdMask(void) const { return mAssignedRouterIdMask; }t(GetAssignedRouterIdMaskQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMKMKVU    Mle::RouterIdSet &GetAssignedRouterIdMask(void) { return mAssignedRouterIdMask; }t(SetAssignedRouterIdMaskQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM
ThreadRouterMaskTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM
KM
Kqp    void SetAssignedRouterIdMask(const Mle::RouterIdSet &aRouterIdSet) { mAssignedRouterIdMask = aRouterIdSet; }t(InitQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMThreadNetworkDataTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMKM!KZ    void Init(void)
    {
        SetType(kThreadNetworkData);
        SetLength(0);
    }t(IsValidQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM)ThreadNetworkDataTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM)KM)K.-    bool IsValid(void) const { return true; }t(GetTlvsQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM1ThreadNetworkDataTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppM1KM1K-,    uint8_t *GetTlvs(void) { return mTlvs; }t(InitQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMKIp6AddressesTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMKKMKK0/    void Init(void) { SetType(kIp6Addresses); }t(IsValidQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMTIp6AddressesTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMTKMYKX      bool IsValid(void) const
    {
        return GetLength() >= sizeof(Ip6::Address) * Ip6AddressesTlv::kMinAddresses &&
               GetLength() <= sizeof(Ip6::Address) * Ip6AddressesTlv::kMaxAddresses &&
               (GetLength() % sizeof(Ip6::Address)) == 0;
    }t(
GetIp6AddressQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMcIp6AddressesTlvt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_tlvs.hppMcKMfK    const Ip6::Address &GetIp6Address(uint8_t aIndex) const
    {
        return *reinterpret_cast<const Ip6::Address *>(GetValue() + (aIndex * sizeof(Ip6::Address)));
    }t(GetActiveRouterCountR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKwRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKwKKwKNM    uint8_t GetActiveRouterCount(void) const { return mRouters.GetLength(); }t(	GetLeaderR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKKKKON    Router *GetLeader(void) { return AsNonConst(AsConst(this)->GetLeader()); }t(FindRouterByIdR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKӌRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKKKKon    Router *FindRouterById(uint8_t aRouterId) { return AsNonConst(AsConst(this)->FindRouterById(aRouterId)); }t(FindRouterByRloc16R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKKKKts    Router *FindRouterByRloc16(uint16_t aRloc16) { return AsNonConst(AsConst(this)->FindRouterByRloc16(aRloc16)); }t(
FindNextHopOfR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppKKKKon    Router *FindNextHopOf(const Router &aRouter) { return AsNonConst(AsConst(this)->FindNextHopOf(aRouter)); }t(ContainsR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK    bool Contains(const Neighbor &aNeighbor) const
    {
        return mRouters.IsInArrayBuffer(&static_cast<const Router &>(aNeighbor));
    }t(GetRouterIdSequenceR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppM3RouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppM3KM3KJI    uint8_t GetRouterIdSequence(void) const { return mRouterIdSequence; }t(GetRouterIdSequenceLastUpdatedR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppM;RouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppM;KM;Kba    TimeMilli GetRouterIdSequenceLastUpdated(void) const { return mRouterIdSequenceLastUpdated; }t(IsAllocatedR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMNRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMNKMNK^]    bool IsAllocated(uint8_t aRouterId) const { return mRouterIdMap.IsAllocated(aRouterId); }t(GetRouterIdSetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMsRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMsKMsKvu    void GetRouterIdSet(Mle::RouterIdSet &aRouterIdSet) const { return mRouterIdMap.GetAsRouterIdSet(aRouterIdSet); }t(
LogRouteTableR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK&%    void LogRouteTable(void) const {}t(beginR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK;:    Router       *begin(void) { return mRouters.begin(); }t(endR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK76    Router       *end(void) { return mRouters.end(); }t(beginR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMKA@    const Router *begin(void) const { return mRouters.begin(); }t(endR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK=<    const Router *end(void) const { return mRouters.end(); }t(
FindRouterR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterTablet(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMKMK    Router       *FindRouter(const Router::AddressMatcher &aMatcher)
    {
        return AsNonConst(AsConst(this)->FindRouter(aMatcher));
    }t(RouterIdMapR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MK'&        RouterIdMap(void) { Clear(); }t(ClearR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MKGF        void    Clear(void) { memset(mIndexes, 0, sizeof(mIndexes)); }t(IsAllocatedR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MKhg        bool    IsAllocated(uint8_t aRouterId) const { return (mIndexes[aRouterId] & kAllocatedFlag); }t(GetIndexR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MKa`        uint8_t GetIndex(uint8_t aRouterId) const { return (mIndexes[aRouterId] & kIndexMask); }t(SetIndexR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MKon        void    SetIndex(uint8_t aRouterId, uint8_t aIndex) { mIndexes[aRouterId] = kAllocatedFlag | aIndex; }t(CanAllocateR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MK\[        bool    CanAllocate(uint8_t aRouterId) const { return (mIndexes[aRouterId] == 0); }t(ReleaseR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMRouterIdMapt(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/router_table.hppMK	MK_^        void    Release(uint8_t aRouterId) { mIndexes[aRouterId] = Mle::kRouterIdReuseDelay; }t(GetLeaderWeightP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKBA    uint8_t GetLeaderWeight(void) const { return mLeaderWeight; }t(SetLeaderWeightP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKGF    void SetLeaderWeight(uint8_t aWeight) { mLeaderWeight = aWeight; }t(GetPreviousPartitionIdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKǌ	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKQP    uint32_t GetPreviousPartitionId(void) const { return mPreviousPartitionId; }t(SetPreviousPartitionIdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKό	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKK`_    void SetPreviousPartitionId(uint32_t aPartitionId) { mPreviousPartitionId = aPartitionId; }t(
GetNextHopP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKa`    uint16_t GetNextHop(uint16_t aDestination) { return mRouterTable.GetNextHop(aDestination); }t(GetNetworkIdTimeoutP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKJI    uint8_t GetNetworkIdTimeout(void) const { return mNetworkIdTimeout; }t(SetNetworkIdTimeoutP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKQP    void SetNetworkIdTimeout(uint8_t aTimeout) { mNetworkIdTimeout = aTimeout; }t(GetRouterSelectionJitterP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppK	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppKKKKTS    uint8_t GetRouterSelectionJitter(void) const { return mRouterSelectionJitter; }t(GetRouterSelectionJitterTimeoutP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM		MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	KM	Kba    uint8_t GetRouterSelectionJitterTimeout(void) const { return mRouterSelectionJitterTimeout; }t(GetRouterUpgradeThresholdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMKVU    uint8_t GetRouterUpgradeThreshold(void) const { return mRouterUpgradeThreshold; }t(SetRouterUpgradeThresholdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMKa`    void SetRouterUpgradeThreshold(uint8_t aThreshold) { mRouterUpgradeThreshold = aThreshold; }t(GetRouterDowngradeThresholdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM!	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM!KM!KZY    uint8_t GetRouterDowngradeThreshold(void) const { return mRouterDowngradeThreshold; }t(SetRouterDowngradeThresholdP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM)	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM)KM)Ked    void SetRouterDowngradeThreshold(uint8_t aThreshold) { mRouterDowngradeThreshold = aThreshold; }t(IsRouterIdValidP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMKYX    static bool IsRouterIdValid(uint8_t aRouterId) { return aRouterId <= kMaxRouterId; }t(SendChildUpdateRequestP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMKQP    Error SendChildUpdateRequest(void) { return Mle::SendChildUpdateRequest(); }t(GetAssignParentPriorityP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMKKJ    int8_t GetAssignParentPriority(void) const { return mParentPriority; }t(SetDiscoveryRequestCallbackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppM	MleRoutert(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mle_router.hppMKMK    void SetDiscoveryRequestCallback(otThreadDiscoveryRequestCallback aCallback, void *aContext)
    {
        mDiscoveryRequestCallback.Set(aCallback, aContext);
    }t(AsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKLNt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKLKKLKdctemplate <class TlvType> TlvType *As(NetworkDataTlv *aTlv) { return static_cast<TlvType *>(aTlv); }t(AsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKXNt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKXKKXKvutemplate <class TlvType> const TlvType *As(const NetworkDataTlv *aTlv) { return static_cast<const TlvType *>(aTlv); }t(AsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKdNt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKdKKdKdctemplate <class TlvType> TlvType &As(NetworkDataTlv &aTlv) { return static_cast<TlvType &>(aTlv); }t(AsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKpNt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKpKKpKvutemplate <class TlvType> const TlvType &As(const NetworkDataTlv &aTlv) { return static_cast<const TlvType &>(aTlv); }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKI    void Init(void)
    {
        mType   = 0;
        mLength = 0;
    }t(GetTypeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKQP    Type GetType(void) const { return static_cast<Type>(mType >> kTypeOffset); }t(SetTypeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKfe    void SetType(Type aType) { mType = (mType & ~kTypeMask) | ((aType << kTypeOffset) & kTypeMask); }t(	GetLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK65    uint8_t GetLength(void) const { return mLength; }t(	SetLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(IncreaseLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKGF    void IncreaseLength(uint8_t aIncrement) { mLength += aIncrement; }t(DecreaseLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKGF    void DecreaseLength(uint8_t aDecrement) { mLength -= aDecrement; }t(GetSizeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKɌNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKML    uint8_t GetSize(void) const { return sizeof(NetworkDataTlv) + mLength; }t(GetValueW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKьNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKcb    uint8_t *GetValue(void) { return reinterpret_cast<uint8_t *>(this) + sizeof(NetworkDataTlv); }t(GetValueW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKٌNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKKut    const uint8_t *GetValue(void) const { return reinterpret_cast<const uint8_t *>(this) + sizeof(NetworkDataTlv); }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK    NetworkDataTlv *GetNext(void)
    {
        return reinterpret_cast<NetworkDataTlv *>(reinterpret_cast<uint8_t *>(this) + sizeof(*this) + mLength);
    }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK    const NetworkDataTlv *GetNext(void) const
    {
        return reinterpret_cast<const NetworkDataTlv *>(reinterpret_cast<const uint8_t *>(this) + sizeof(*this) +
                                                        mLength);
    }t(ClearStableW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK65    void ClearStable(void) { mType &= ~kStableMask; }t(IsStableW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppKKKK@?    bool IsStable(void) const { return (mType & kStableMask); }t(	SetStableW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK32    void SetStable(void) { mType |= kStableMask; }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    static NetworkDataTlv *Find(NetworkDataTlv *aStart, NetworkDataTlv *aEnd, Type aType)
    {
        return AsNonConst(Find(AsConst(aStart), AsConst(aEnd), aType));
    }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM-NetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM-KM0K    template <typename TlvType> static TlvType *Find(NetworkDataTlv *aStart, NetworkDataTlv *aEnd)
    {
        return As<TlvType>(Find(aStart, aEnd, TlvType::kType));
    }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM=NetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM=KM@K    template <typename TlvType> static const TlvType *Find(const NetworkDataTlv *aStart, const NetworkDataTlv *aEnd)
    {
        return As<TlvType>(Find(aStart, aEnd, TlvType::kType));
    }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMNNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMNKMQK    static NetworkDataTlv *Find(NetworkDataTlv *aStart, NetworkDataTlv *aEnd, Type aType, bool aStable)
    {
        return AsNonConst(Find(AsConst(aStart), AsConst(aEnd), aType, aStable));
    }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMqNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMqKMtK    template <typename TlvType> static TlvType *Find(NetworkDataTlv *aStart, NetworkDataTlv *aEnd, bool aStable)
    {
        return As<TlvType>(Find(aStart, aEnd, TlvType::kType, aStable));
    }t(FindW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMNetworkDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    template <typename TlvType>
    static const TlvType *Find(const NetworkDataTlv *aStart, const NetworkDataTlv *aEnd, bool aStable)
    {
        return As<TlvType>(Find(aStart, aEnd, TlvType::kType, aStable));
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK\    void Init(void)
    {
        SetRloc(Mac::kShortAddrInvalid);
        mFlags = 0;
    }t(GetRlocW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK?>    uint16_t GetRloc(void) const { return HostSwap16(mRloc); }t(SetRlocW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    void SetRloc(uint16_t aRloc16) { mRloc = HostSwap16(aRloc16); }t(
GetPreferenceW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKQP    int8_t GetPreference(void) const { return PreferenceFromFlags(GetFlags()); }t(GetFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK43    uint8_t GetFlags(void) const { return mFlags; }t(SetFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK76    void SetFlags(uint8_t aFlags) { mFlags = aFlags; }t(IsNat64W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    bool IsNat64(void) const { return (mFlags & kNat64Flag) != 0; }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK87    HasRouteEntry *GetNext(void) { return (this + 1); }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    const HasRouteEntry *GetNext(void) const { return (this + 1); }t(FlagsWithoutPreferenceW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKba    static uint8_t FlagsWithoutPreference(uint8_t aFlags) { return (aFlags & ~kPreferenceMask); }t(PreferenceFromFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
HasRouteEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKxw    static int8_t PreferenceFromFlags(uint8_t aFlags) { return RoutePreferenceFromValue(aFlags >> kPreferenceOffset); }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMHasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKu    void Init(void)
    {
        NetworkDataTlv::Init();
        SetType(kTypeHasRoute);
        SetLength(0);
    }t(
GetNumEntriesW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMHasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKVU    uint8_t GetNumEntries(void) const { return GetLength() / sizeof(HasRouteEntry); }t(GetEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM)HasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM)KM,K    HasRouteEntry *GetEntry(uint8_t aIndex)
    {
        return reinterpret_cast<HasRouteEntry *>(GetValue() + (aIndex * sizeof(HasRouteEntry)));
    }t(GetEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM6HasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM6KM9K    const HasRouteEntry *GetEntry(uint8_t aIndex) const
    {
        return reinterpret_cast<const HasRouteEntry *>(GetValue() + (aIndex * sizeof(HasRouteEntry)));
    }t(
GetFirstEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMAHasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMAKMAKa`    HasRouteEntry *GetFirstEntry(void) { return reinterpret_cast<HasRouteEntry *>(GetValue()); }t(
GetFirstEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMIHasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMIKMIKsr    const HasRouteEntry *GetFirstEntry(void) const { return reinterpret_cast<const HasRouteEntry *>(GetValue()); }t(GetLastEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMSHasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMSKMVK    HasRouteEntry *GetLastEntry(void)
    {
        return reinterpret_cast<HasRouteEntry *>(GetValue() + GetLength() - sizeof(HasRouteEntry));
    }t(GetLastEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM`HasRouteTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM`KMcK    const HasRouteEntry *GetLastEntry(void) const
    {
        return reinterpret_cast<const HasRouteEntry *>(GetValue() + GetLength() - sizeof(HasRouteEntry));
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMy	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMyKMKXQ      void Init(uint8_t aDomainId, uint8_t aPrefixLength, const uint8_t *aPrefix)
    {
        NetworkDataTlv::Init();
        SetType(kTypePrefix);
        mDomainId     = aDomainId;
        mPrefixLength = aPrefixLength;
        memcpy(GetPrefix(), aPrefix, Ip6::Prefix::SizeForLength(aPrefixLength));
        SetSubTlvsLength(0);
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    void Init(uint8_t aDomainId, const Ip6::Prefix aPrefix)
    {
        Init(aDomainId, aPrefix.GetLength(), aPrefix.GetBytes());
    }t(IsValidW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX@      bool IsValid(void) const
    {
        return ((GetLength() >= sizeof(*this) - sizeof(NetworkDataTlv)) &&
                (GetLength() >= Ip6::Prefix::SizeForLength(mPrefixLength) + sizeof(*this) - sizeof(NetworkDataTlv)) &&
                (Ip6::Prefix::SizeForLength(mPrefixLength) <= sizeof(Ip6::Address)));
    }t(GetDomainIdW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK:9    uint8_t GetDomainId(void) const { return mDomainId; }t(GetPrefixLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKBA    uint8_t GetPrefixLength(void) const { return mPrefixLength; }t(	GetPrefixW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK[Z    uint8_t *GetPrefix(void) { return reinterpret_cast<uint8_t *>(this) + sizeof(*this); }t(	GetPrefixW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKml    const uint8_t *GetPrefix(void) const { return reinterpret_cast<const uint8_t *>(this) + sizeof(*this); }t(CopyPrefixToW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKcb    void CopyPrefixTo(Ip6::Prefix &aPrefix) const { aPrefix.Set(GetPrefix(), GetPrefixLength()); }t(IsEqualW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKih    bool IsEqual(Ip6::Prefix &aPrefix) const { return aPrefix.IsEqual(GetPrefix(), GetPrefixLength()); }t(IsEqualW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX      bool IsEqual(const uint8_t *aPrefix, uint8_t aPrefixLength) const
    {
        return (aPrefixLength == mPrefixLength) &&
               (Ip6::Prefix::MatchLength(GetPrefix(), aPrefix, Ip6::Prefix::SizeForLength(aPrefixLength)) >=
                mPrefixLength);
    }t(
GetSubTlvsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    NetworkDataTlv *GetSubTlvs(void)
    {
        return reinterpret_cast<NetworkDataTlv *>(GetPrefix() + Ip6::Prefix::SizeForLength(mPrefixLength));
    }tE      (
GetSubTlvsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    const NetworkDataTlv *GetSubTlvs(void) const
    {
        return reinterpret_cast<const NetworkDataTlv *>(GetPrefix() + Ip6::Prefix::SizeForLength(mPrefixLength));
    }t(GetSubTlvsLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKM K    uint8_t GetSubTlvsLength(void) const
    {
        return GetLength() - (sizeof(*this) - sizeof(NetworkDataTlv) + Ip6::Prefix::SizeForLength(mPrefixLength));
    }t(SetSubTlvsLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    void SetSubTlvsLength(uint8_t aLength)
    {
        SetLength(sizeof(*this) - sizeof(NetworkDataTlv) + Ip6::Prefix::SizeForLength(mPrefixLength) + aLength);
    }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    template <typename SubTlvType> SubTlvType *FindSubTlv(void)
    {
        return As<SubTlvType>(FindSubTlv(SubTlvType::kType));
    }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM"	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM"KM%K    template <typename SubTlvType> const SubTlvType *FindSubTlv(void) const
    {
        return As<SubTlvType>(FindSubTlv(SubTlvType::kType));
    }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM1	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM1KM4K    template <typename SubTlvType> SubTlvType *FindSubTlv(bool aStable)
    {
        return As<SubTlvType>(FindSubTlv(static_cast<Type>(SubTlvType::kType), aStable));
    }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM@	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM@KMCK    template <typename SubTlvType> const SubTlvType *FindSubTlv(bool aStable) const
    {
        return As<SubTlvType>(FindSubTlv(static_cast<Type>(SubTlvType::kType), aStable));
    }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMM	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMMKMMKdc    NetworkDataTlv *FindSubTlv(Type aType) { return AsNonConst(AsConst(this)->FindSubTlv(aType)); }t(
FindSubTlvW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMb	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMbKMeK    NetworkDataTlv *FindSubTlv(Type aType, bool aStable)
    {
        return AsNonConst(AsConst(this)->FindSubTlv(aType, aStable));
    }t(
CalculateSizeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM}	PrefixTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM}KMK    static uint16_t CalculateSize(uint8_t aPrefixLength)
    {
        return sizeof(PrefixTlv) + Ip6::Prefix::SizeForLength(aPrefixLength);
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK\    void Init(void)
    {
        SetRloc(Mac::kShortAddrInvalid);
        mFlags = 0;
    }t(GetRlocW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK?>    uint16_t GetRloc(void) const { return HostSwap16(mRloc); }t(SetRlocW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    void SetRloc(uint16_t aRloc16) { mRloc = HostSwap16(aRloc16); }t(GetFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKA@    uint16_t GetFlags(void) const { return HostSwap16(mFlags); }t(SetFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    void SetFlags(uint16_t aFlags) { mFlags = HostSwap16(aFlags); }t(
GetPreferenceW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKQP    int8_t GetPreference(void) const { return PreferenceFromFlags(GetFlags()); }t(IsPreferredW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKXW    bool IsPreferred(void) const { return (HostSwap16(mFlags) & kPreferredFlag) != 0; }t(IsSlaacW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKPO    bool IsSlaac(void) const { return (HostSwap16(mFlags) & kSlaacFlag) != 0; }t(IsDhcpW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKNM    bool IsDhcp(void) const { return (HostSwap16(mFlags) & kDhcpFlag) != 0; }t(IsConfigureW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKXW    bool IsConfigure(void) const { return (HostSwap16(mFlags) & kConfigureFlag) != 0; }t(IsDefaultRouteW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK^]    bool IsDefaultRoute(void) const { return (HostSwap16(mFlags) & kDefaultRouteFlag) != 0; }t(IsOnMeshW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKRQ    bool IsOnMesh(void) const { return (HostSwap16(mFlags) & kOnMeshFlag) != 0; }t(IsNdDnsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKPO    bool IsNdDns(void) const { return (HostSwap16(mFlags) & kNdDnsFlag) != 0; }t(IsDpW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKJI    bool IsDp(void) const { return (HostSwap16(mFlags) & kDpFlag) != 0; }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK<;    BorderRouterEntry *GetNext(void) { return (this + 1); }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKHG    const BorderRouterEntry *GetNext(void) const { return (this + 1); }t(FlagsWithoutPreferenceW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#BorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#KM#Kdc    static uint16_t FlagsWithoutPreference(uint16_t aFlags) { return (aFlags & ~kPreferenceMask); }t(PreferenceFromFlagsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM-BorderRouterEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM-KM0K    static int8_t PreferenceFromFlags(uint16_t aFlags)
    {
        return RoutePreferenceFromValue(static_cast<uint8_t>(aFlags >> kPreferenceOffset));
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMPBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMPKMUKy    void Init(void)
    {
        NetworkDataTlv::Init();
        SetType(kTypeBorderRouter);
        SetLength(0);
    }t(
GetNumEntriesW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM]BorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM]KM]KZY    uint8_t GetNumEntries(void) const { return GetLength() / sizeof(BorderRouterEntry); }t(GetEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMgBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMgKMjK    BorderRouterEntry *GetEntry(uint8_t aIndex)
    {
        return reinterpret_cast<BorderRouterEntry *>(GetValue() + (aIndex * sizeof(BorderRouterEntry)));
    }t(GetEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMtBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMtKMwK    const BorderRouterEntry *GetEntry(uint8_t aIndex) const
    {
        return reinterpret_cast<const BorderRouterEntry *>(GetValue() + (aIndex * sizeof(BorderRouterEntry)));
    }t(
GetFirstEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKih    BorderRouterEntry *GetFirstEntry(void) { return reinterpret_cast<BorderRouterEntry *>(GetValue()); }t(
GetFirstEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    const BorderRouterEntry *GetFirstEntry(void) const
    {
        return reinterpret_cast<const BorderRouterEntry *>(GetValue());
    }t(GetLastEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    BorderRouterEntry *GetLastEntry(void)
    {
        return reinterpret_cast<BorderRouterEntry *>(GetValue() + GetLength() - sizeof(BorderRouterEntry));
    }t(GetLastEntryW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMBorderRouterTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    const BorderRouterEntry *GetLastEntry(void) const
    {
        return reinterpret_cast<const BorderRouterEntry *>(GetValue() + GetLength() - sizeof(BorderRouterEntry));
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX;      void Init(uint8_t aContextId, uint8_t aContextLength)
    {
        NetworkDataTlv::Init();
        SetType(kTypeContext);
        SetLength(sizeof(ContextTlv) - sizeof(NetworkDataTlv));
        mFlags         = ((aContextId << kContextIdOffset) & kContextIdMask);
        mContextLength = aContextLength;
    }t(
IsCompressW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKJI    bool IsCompress(void) const { return (mFlags & kCompressFlag) != 0; }t(
ClearCompressW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK;:    void ClearCompress(void) { mFlags &= ~kCompressFlag; }t(SetCompressW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK87    void SetCompress(void) { mFlags |= kCompressFlag; }t(GetContextIdW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKIH    uint8_t GetContextId(void) const { return mFlags & kContextIdMask; }t(GetContextLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ContextTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKDC    uint8_t GetContextLength(void) const { return mContextLength; }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMCommissioningDataTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK~    void Init(void)
    {
        NetworkDataTlv::Init();
        SetType(kTypeCommissioningData);
        SetLength(0);
    }t(IsValidW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#KM+KXw      bool IsValid(void) const
    {
        uint8_t length = GetLength();

        return (length >= sizeof(mFlagsServiceId)) &&
               (length >= kMinLength + (IsThreadEnterprise() ? 0 : sizeof(uint32_t))) &&
               (static_cast<uint16_t>(length) + sizeof(NetworkDataTlv) >=
                CalculateSize(GetEnterpriseNumber(), GetServiceDataLength()));
    }t(GetServiceIdW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM3
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM3KM3KTS    uint8_t GetServiceId(void) const { return (mFlagsServiceId & kServiceIdMask); }t(GetEnterpriseNumberW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM;
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM;KM?K    uint32_t GetEnterpriseNumber(void) const
    {
        return IsThreadEnterprise() ? static_cast<uint32_t>(kThreadEnterpriseNumber)
                                    : HostSwap32(mShared.mEnterpriseNumber);
    }t(GetServiceDataW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMG
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMGKMJK    void GetServiceData(ServiceData &aServiceData) const
    {
        aServiceData.Init(GetServiceData(), GetServiceDataLength());
    }t(GetServiceDataLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMR
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMRKMUK    uint8_t GetServiceDataLength(void) const
    {
        return IsThreadEnterprise() ? mShared.mServiceDataLengthThreadEnterprise : mServiceDataLength;
    }t(GetSubTlvsLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM]
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM]KM]KON    uint8_t GetSubTlvsLength(void) { return GetLength() - GetFieldsLength(); }t(SetSubTlvsLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMe
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMeKMeKWV    void SetSubTlvsLength(uint8_t aLength) { SetLength(GetFieldsLength() + aLength); }t(
GetSubTlvsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMm
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMmKMmKts    NetworkDataTlv *GetSubTlvs(void) { return reinterpret_cast<NetworkDataTlv *>(GetValue() + GetFieldsLength()); }t(
GetSubTlvsW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMu
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMuKMxK    const NetworkDataTlv *GetSubTlvs(void) const
    {
        return reinterpret_cast<const NetworkDataTlv *>(GetValue() + GetFieldsLength());
    }t(
CalculateSizeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX       static uint16_t CalculateSize(uint32_t aEnterpriseNumber, uint8_t aServiceDataLength)
    {
        return sizeof(NetworkDataTlv) + kMinLength + aServiceDataLength +
               ((aEnterpriseNumber == kThreadEnterpriseNumber) ? 0 : sizeof(uint32_t) /* mEnterpriseNumber  */);
    }t(IsThreadEnterpriseW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKcb    bool IsThreadEnterprise(void) const { return (mFlagsServiceId & kThreadEnterpriseFlag) != 0; }t(GetServiceDataW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK    const uint8_t *GetServiceData(void) const
    {
        return (IsThreadEnterprise() ? &mShared.mServiceDataLengthThreadEnterprise : &mServiceDataLength) +
               sizeof(uint8_t);
    }t(GetFieldsLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM
ServiceTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX"      uint8_t GetFieldsLength(void) const
    {
        // Returns the length of TLV value's common fields (flags, enterprise
        // number and service data) excluding any sub-TLVs.

        return kMinLength + (IsThreadEnterprise() ? 0 : sizeof(uint32_t)) + GetServiceDataLength();
    }t(InitW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKX1      void Init(uint16_t aServer16, const ServerData &aServerData)
    {
        NetworkDataTlv::Init();
        SetType(kTypeServer);
        SetServer16(aServer16);
        aServerData.CopyBytesTo(GetServerData());
        SetLength(sizeof(*this) - sizeof(NetworkDataTlv) + aServerData.GetLength());
    }t(IsValidW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKa`    bool IsValid(void) const { return GetLength() >= (sizeof(*this) - sizeof(NetworkDataTlv)); }t(GetServer16W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKGF    uint16_t GetServer16(void) const { return HostSwap16(mServer16); }t(SetServer16W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKPO    void SetServer16(uint16_t aServer16) { mServer16 = HostSwap16(aServer16); }t(
GetServerDataW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKts    void GetServerData(ServerData &aServerData) const { aServerData.Init(GetServerData(), GetServerDataLength()); }t(GetServerDataLengthW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKon    uint8_t GetServerDataLength(void) const { return GetLength() - (sizeof(*this) - sizeof(NetworkDataTlv)); }t(
operator==W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKM K    bool operator==(const ServerTlv &aOther) const
    {
        return (GetLength() == aOther.GetLength()) && (memcmp(GetValue(), aOther.GetValue(), GetLength()) == 0);
    }t(
CalculateSizeW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKon    static uint16_t CalculateSize(uint8_t aServerDataLength) { return sizeof(ServerTlv) + aServerDataLength; }t(
GetServerDataW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMKqp    const uint8_t *GetServerData(void) const { return reinterpret_cast<const uint8_t *>(this) + sizeof(*this); }t(
GetServerDataW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM	ServerTlvt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMKMK^]    uint8_t       *GetServerData(void) { return AsNonConst(AsConst(this)->GetServerData()); }t(TlvIteratorW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#TlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM#KM'K    TlvIterator(const NetworkDataTlv *aStart, const NetworkDataTlv *aEnd)
        : mStart(aStart)
        , mEnd(aEnd)
    {
    }t(TlvIteratorW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM0TlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM0KM4K    TlvIterator(const uint8_t *aBuffer, uint8_t aLength)
        : TlvIterator(reinterpret_cast<const NetworkDataTlv *>(aBuffer),
                      reinterpret_cast<const NetworkDataTlv *>(aBuffer + aLength))
    {
    }t(TlvIteratorW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM<TlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM<KM?K    explicit TlvIterator(const PrefixTlv &aPrefixTlv)
        : TlvIterator(aPrefixTlv.GetSubTlvs(), aPrefixTlv.GetNext())
    {
    }t(TlvIteratorW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMGTlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMGKMJK    explicit TlvIterator(const ServiceTlv &aServiceTlv)
        : TlvIterator(aServiceTlv.GetSubTlvs(), aServiceTlv.GetNext())
    {
    }t(IterateW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMTTlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppMTKMTKnm    template <typename TlvType> const TlvType *Iterate(void) { return As<TlvType>(Iterate(TlvType::kType)); }t(IterateW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM`TlvIteratort(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_tlvs.hppM`KMcK    template <typename TlvType> const TlvType *Iterate(bool aStable)
    {
        return As<TlvType>(Iterate(TlvType::kType, aStable));
    }t(NetworkDataR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKKKK    explicit NetworkData(Instance &aInstance, const uint8_t *aTlvs = nullptr, uint8_t aLength = 0)
        : InstanceLocator(aInstance)
        , mTlvs(aTlvs)
        , mLength(aLength)
    {
    }t(NetworkDataR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKKKKX}      NetworkData(Instance &aInstance, const NetworkDataTlv *aStartTlv, const NetworkDataTlv *aEndTlv)
        : InstanceLocator(aInstance)
        , mTlvs(reinterpret_cast<const uint8_t *>(aStartTlv))
        , mLength(static_cast<uint8_t>(reinterpret_cast<const uint8_t *>(aEndTlv) -
                                       reinterpret_cast<const uint8_t *>(aStartTlv)))
    {
    }t(	GetLengthR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKKKK65    uint8_t GetLength(void) const { return mLength; }t(GetBytesR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppKKKK:9    const uint8_t *GetBytes(void) const { return mTlvs; }t(GetTlvsStartR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKon    const NetworkDataTlv *GetTlvsStart(void) const { return reinterpret_cast<const NetworkDataTlv *>(mTlvs); }t(
GetTlvsEndR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKwv    const NetworkDataTlv *GetTlvsEnd(void) const { return reinterpret_cast<const NetworkDataTlv *>(mTlvs + mLength); }t(
FindPrefixR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMK    const PrefixTlv *FindPrefix(const Ip6::Prefix &aPrefix) const
    {
        return FindPrefix(aPrefix.GetBytes(), aPrefix.GetLength());
    }t(NetworkDataIteratorR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK
        explicit NetworkDataIterator(Iterator &aIterator)
            : mIteratorBuffer(reinterpret_cast<uint8_t *>(&aIterator))
        {
        }t(GetTlvR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK
        const NetworkDataTlv *GetTlv(const uint8_t *aTlvs) const
        {
            return reinterpret_cast<const NetworkDataTlv *>(aTlvs + GetTlvOffset());
        }t(
AdvanceTlvR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK
        void AdvanceTlv(const uint8_t *aTlvs)
        {
            SaveTlvOffset(GetTlv(aTlvs)->GetNext(), aTlvs);
            SetSubTlvOffset(0);
            SetEntryIndex(0);
        }t(	GetSubTlvR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM NetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM K	MK
X          const NetworkDataTlv *GetSubTlv(const NetworkDataTlv *aSubTlvs) const
        {
            return reinterpret_cast<const NetworkDataTlv *>(reinterpret_cast<const uint8_t *>(aSubTlvs) +
                                                            GetSubTlvOffset());
        }t(AdvaceSubTlvR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	M
K
        void AdvaceSubTlv(const NetworkDataTlv *aSubTlvs)
        {
            SaveSubTlvOffset(GetSubTlv(aSubTlvs)->GetNext(), aSubTlvs);
            SetEntryIndex(0);
        }t(GetAndAdvanceIndexR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKWV        uint8_t GetAndAdvanceIndex(void) { return mIteratorBuffer[kEntryPosition]++; }t(
IsNewEntryR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKED        bool IsNewEntry(void) const { return GetEntryIndex() == 0; }t(MarkEntryAsNotNewR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK;:        void MarkEntryAsNotNew(void) { SetEntryIndex(1); }t(GetTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKSR        uint8_t GetTlvOffset(void) const { return mIteratorBuffer[kTlvPosition]; }t(GetSubTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKYX        uint8_t GetSubTlvOffset(void) const { return mIteratorBuffer[kSubTlvPosition]; }t(SetSubTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKa`        void    SetSubTlvOffset(uint8_t aOffset) { mIteratorBuffer[kSubTlvPosition] = aOffset; }t(SetTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK[Z        void    SetTlvOffset(uint8_t aOffset) { mIteratorBuffer[kTlvPosition] = aOffset; }t(
GetEntryIndexR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MKVU        uint8_t GetEntryIndex(void) const { return mIteratorBuffer[kEntryPosition]; }t(
SetEntryIndexR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	MK\[        void    SetEntryIndex(uint8_t aIndex) { mIteratorBuffer[kEntryPosition] = aIndex; }t(
SaveTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMNetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMK	M K
        void SaveTlvOffset(const NetworkDataTlv *aTlv, const uint8_t *aTlvs)
        {
            SetTlvOffset(static_cast<uint8_t>(reinterpret_cast<const uint8_t *>(aTlv) - aTlvs));
        }t(SaveSubTlvOffsetR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM"NetworkDataIteratort(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM"K	M&K
X.          void SaveSubTlvOffset(const NetworkDataTlv *aSubTlv, const NetworkDataTlv *aSubTlvs)
        {
            SetSubTlvOffset(static_cast<uint8_t>(reinterpret_cast<const uint8_t *>(aSubTlv) -
                                                 reinterpret_cast<const uint8_t *>(aSubTlvs)));
        }t(MutableNetworkDataR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMQMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMQKMUK    MutableNetworkData(Instance &aInstance, uint8_t *aTlvs, uint8_t aLength, uint8_t aSize)
        : NetworkData(aInstance, aTlvs, aLength)
        , mSize(aSize)
    {
    }t(GetSizeR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM`MutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppM`KM`K21    uint8_t GetSize(void) const { return mSize; }t(GetBytesR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMhMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMhKMhKNM    uint8_t *GetBytes(void) { return AsNonConst(AsConst(this)->GetBytes()); }t(ClearR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMnMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMnKMnK&%    void Clear(void) { mLength = 0; }t(	SetLengthR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMwMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMwKMwK;:    void SetLength(uint8_t aLength) { mLength = aLength; }t(GetTlvsStartR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMK]\    NetworkDataTlv *GetTlvsStart(void) { return AsNonConst(AsConst(this)->GetTlvsStart()); }t(
GetTlvsEndR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKYX    NetworkDataTlv *GetTlvsEnd(void) { return AsNonConst(AsConst(this)->GetTlvsEnd()); }t(
FindPrefixR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMK    PrefixTlv *FindPrefix(const uint8_t *aPrefix, uint8_t aPrefixLength)
    {
        return AsNonConst(AsConst(this)->FindPrefix(aPrefix, aPrefixLength));
    }t(
FindPrefixR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKvu    PrefixTlv *FindPrefix(const Ip6::Prefix &aPrefix) { return FindPrefix(aPrefix.GetBytes(), aPrefix.GetLength()); }t(FindServiceR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKX7      ServiceTlv *FindService(uint32_t           aEnterpriseNumber,
                            const ServiceData &aServiceData,
                            ServiceMatchMode   aServiceMatchMode)
    {
        return AsNonConst(AsConst(this)->FindService(aEnterpriseNumber, aServiceData, aServiceMatchMode));
    }t(	CanInsertR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMMutableNetworkDatat(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data.hppMKMKPO    bool CanInsert(uint16_t aSize) const { return (mLength + aSize <= mSize); }t(	IsEnabledR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/slaac_address.hppKpSlaact(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/slaac_address.hppKpKKpK43    bool IsEnabled(void) const { return mEnabled; }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK
k        void Init(void)
        {
            Clear();
            SetVersion(kThreadVersion1p1);
        }t(GetRoleN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK65        uint8_t GetRole(void) const { return mRole; }t(SetRoleN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK76        void SetRole(uint8_t aRole) { mRole = aRole; }t(
GetDeviceModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKBA        uint8_t GetDeviceMode(void) const { return mDeviceMode; }t(
SetDeviceModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKON        void SetDeviceMode(uint8_t aDeviceMode) { mDeviceMode = aDeviceMode; }t(	GetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK_^        uint16_t GetRloc16(void) const { return Encoding::LittleEndian::HostSwap16(mRloc16); }t(	SetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKǌNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKdc        void SetRloc16(uint16_t aRloc16) { mRloc16 = Encoding::LittleEndian::HostSwap16(aRloc16); }t(GetKeySequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKόNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKih        uint32_t GetKeySequence(void) const { return Encoding::LittleEndian::HostSwap32(mKeySequence); }t(SetKeySequenceN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppK׌NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKxw        void SetKeySequence(uint32_t aKeySequence) { mKeySequence = Encoding::LittleEndian::HostSwap32(aKeySequence); }t(GetMleFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKߌNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKqp        uint32_t GetMleFrameCounter(void) const { return Encoding::LittleEndian::HostSwap32(mMleFrameCounter); }t(SetMleFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK
        void SetMleFrameCounter(uint32_t aMleFrameCounter)
        {
            mMleFrameCounter = Encoding::LittleEndian::HostSwap32(aMleFrameCounter);
        }t(GetMacFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KKqp        uint32_t GetMacFrameCounter(void) const { return Encoding::LittleEndian::HostSwap32(mMacFrameCounter); }t(SetMacFrameCounterN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppKK	KK
        void SetMacFrameCounter(uint32_t aMacFrameCounter)
        {
            mMacFrameCounter = Encoding::LittleEndian::HostSwap32(aMacFrameCounter);
        }t(GetPreviousPartitionIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKyx        uint32_t GetPreviousPartitionId(void) const { return Encoding::LittleEndian::HostSwap32(mPreviousPartitionId); }t(SetPreviousPartitionIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
K	MK
        void SetPreviousPartitionId(uint32_t aPreviousPartitionId)
        {
            mPreviousPartitionId = Encoding::LittleEndian::HostSwap32(aPreviousPartitionId);
        }t(
GetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMNetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKQP        const Mac::ExtAddress &GetExtAddress(void) const { return mExtAddress; }t(
SetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM K	M K^]        void SetExtAddress(const Mac::ExtAddress &aExtAddress) { mExtAddress = aExtAddress; }t(GetMeshLocalIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM(NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM(K	M(KWV        const Ip6::InterfaceIdentifier &GetMeshLocalIid(void) const { return mMlIid; }t(SetMeshLocalIidN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM0NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM0K	M0Khg        void SetMeshLocalIid(const Ip6::InterfaceIdentifier &aMeshLocalIid) { mMlIid = aMeshLocalIid; }t(
GetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM8NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM8K	M8Ka`        uint16_t GetVersion(void) const { return Encoding::LittleEndian::HostSwap16(mVersion); }t(
SetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM@NetworkInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM@K	M@Khg        void SetVersion(uint16_t aVersion) { mVersion = Encoding::LittleEndian::HostSwap16(aVersion); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMb
ParentInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMbK	MfK
k        void Init(void)
        {
            Clear();
            SetVersion(kThreadVersion1p1);
        }t(
GetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMn
ParentInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMnK	MnKQP        const Mac::ExtAddress &GetExtAddress(void) const { return mExtAddress; }t(
SetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMv
ParentInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMvK	MvK^]        void SetExtAddress(const Mac::ExtAddress &aExtAddress) { mExtAddress = aExtAddress; }t(
GetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM~
ParentInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM~K	M~Ka`        uint16_t GetVersion(void) const { return Encoding::LittleEndian::HostSwap16(mVersion); }t(
SetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
ParentInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKhg        void SetVersion(uint16_t aVersion) { mVersion = Encoding::LittleEndian::HostSwap16(aVersion); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK
        void Init(void)
        {
            memset(this, 0, sizeof(*this));
            SetVersion(kThreadVersion1p1);
        }t(
GetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKQP        const Mac::ExtAddress &GetExtAddress(void) const { return mExtAddress; }t(
SetExtAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK^]        void SetExtAddress(const Mac::ExtAddress &aExtAddress) { mExtAddress = aExtAddress; }t(
GetTimeoutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKa`        uint32_t GetTimeout(void) const { return Encoding::LittleEndian::HostSwap32(mTimeout); }t(
SetTimeoutN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKhg        void SetTimeout(uint32_t aTimeout) { mTimeout = Encoding::LittleEndian::HostSwap32(aTimeout); }t(	GetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK_^        uint16_t GetRloc16(void) const { return Encoding::LittleEndian::HostSwap16(mRloc16); }t(	SetRloc16N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKdc        void SetRloc16(uint16_t aRloc16) { mRloc16 = Encoding::LittleEndian::HostSwap16(aRloc16); }t(GetModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK65        uint8_t GetMode(void) const { return mMode; }t(SetModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK76        void SetMode(uint8_t aMode) { mMode = aMode; }t(
GetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKa`        uint16_t GetVersion(void) const { return Encoding::LittleEndian::HostSwap16(mVersion); }t(
SetVersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM	ChildInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKhg        void SetVersion(uint16_t aVersion) { mVersion = Encoding::LittleEndian::HostSwap16(aVersion); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpClientInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK%$        void Init(void) { Clear(); }t(GetServerAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpClientInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKTS        const Ip6::Address &GetServerAddress(void) const { return mServerAddress; }t(SetServerAddressN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpClientInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK[Z        void SetServerAddress(const Ip6::Address &aAddress) { mServerAddress = aAddress; }t(
GetServerPortN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpClientInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKgf        uint16_t GetServerPort(void) const { return Encoding::LittleEndian::HostSwap16(mServerPort); }t(
SetServerPortN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpClientInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKhg        void SetServerPort(uint16_t aPort) { mServerPort = Encoding::LittleEndian::HostSwap16(aPort); }t(InitN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpServerInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK%$        void Init(void) { Clear(); }t(GetPortN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpServerInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK[Z        uint16_t GetPort(void) const { return Encoding::LittleEndian::HostSwap16(mPort); }t(SetPortN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM
SrpServerInfot(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK\[        void SetPort(uint16_t aPort) { mPort = Encoding::LittleEndian::HostSwap16(aPort); }t(SettingsBaseN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingsBaset(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMK_    explicit SettingsBase(Instance &aInstance)
        : InstanceLocator(aInstance)
    {
    }t(SettingsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM!Settingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM!KM$KX    explicit Settings(Instance &aInstance)
        : SettingsBase(aInstance)
    {
    }t(ReadN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMtSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMtKMyK    template <typename EntryType> Error Read(EntryType &aEntry) const
    {
        aEntry.Init();

        return ReadEntry(EntryType::kKey, &aEntry, sizeof(EntryType));
    }t(ReadN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMK    template <typename EntryType> Error Read(typename EntryType::ValueType &aValue) const
    {
        return ReadEntry(EntryType::kKey, &aValue, sizeof(typename EntryType::ValueType));
    }t(SaveN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMK    template <typename EntryType> Error Save(const EntryType &aEntry)
    {
        EntryType prev;

        return SaveEntry(EntryType::kKey, &aEntry, &prev, sizeof(EntryType));
    }t(SaveN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMK    template <typename EntryType> Error Save(const typename EntryType::ValueType &aValue)
    {
        typename EntryType::ValueType prev;

        return SaveEntry(EntryType::kKey, &aValue, &prev, sizeof(typename EntryType::ValueType));
    }t(DeleteN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMK^]    template <typename EntryType> Error Delete(void) { return DeleteEntry(EntryType::kKey); }t(IterateChildInfoN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMSettingst(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMKMKhg    ChildInfoIteratorBuilder IterateChildInfo(void) { return ChildInfoIteratorBuilder(GetInstance()); }t(IsDoneN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK43        bool IsDone(void) const { return mIsDone; }t(
operator++N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK-,        void operator++(void) { Advance(); }t(
operator++N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM#ChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM#K	M#K,+        void operator++(int) { Advance(); }t(GetChildInfoN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM.ChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM.K	M.KIH        const ChildInfo &GetChildInfo(void) const { return mChildInfo; }t(	operator*N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMEChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMEK	MEKFE        const ChildInfo &operator*(void) const { return mChildInfo; }t(
operator==N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMPChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMPK	MSK
        bool operator==(const ChildInfoIterator &aOther) const
        {
            return (mIsDone && aOther.mIsDone) || (!mIsDone && !aOther.mIsDone && (mIndex == aOther.mIndex));
        }t(ChildInfoIteratorN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM[ChildInfoIteratort(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppM[K	M`K
        ChildInfoIterator(Instance &aInstance, IteratorType)
            : SettingsBase(aInstance)
            , mIndex(0)
            , mIsDone(true)
        {
        }t(ChildInfoIteratorBuilderN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMChildInfoIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MK
{        explicit ChildInfoIteratorBuilder(Instance &aInstance)
            : InstanceLocator(aInstance)
        {
        }t(beginN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMChildInfoIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKSR        ChildInfoIterator begin(void) { return ChildInfoIterator(GetInstance()); }t(endN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMChildInfoIteratorBuildert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/settings.hppMK	MKrq        ChildInfoIterator end(void) { return ChildInfoIterator(GetInstance(), ChildInfoIterator::kEndIterator); }t(GetStateS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKkBorderAgentt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKkKKkK21    State GetState(void) const { return mState; }t(GetUdpProxyPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKzBorderAgentt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKzKKzKCB    uint16_t GetUdpProxyPort(void) const { return mUdpProxyPort; }t(
IsPetitionS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKForwardContextt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKK	KK>=        bool     IsPetition(void) const { return mPetition; }t(GetMessageIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKForwardContextt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKK	KKA@        uint16_t GetMessageId(void) const { return mMessageId; }t(HandleUdpReceiveS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKBorderAgentt(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/border_agent.hppKKKK    static bool HandleUdpReceive(void *aContext, const otMessage *aMessage, const otMessageInfo *aMessageInfo)
    {
        return static_cast<BorderAgent *>(aContext)->HandleUdpReceive(AsCoreType(aMessage), AsCoreType(aMessageInfo));
    }t(IsLocatorSetS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKpDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKpK	KpK@?        bool IsLocatorSet(void) const { return mIsLocatorSet; }t(
GetLocatorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKzDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKzK	KzK=<        uint16_t GetLocator(void) const { return mLocator; }t(
SetLocatorS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KK
        void SetLocator(uint16_t aLocator)
        {
            mIsLocatorSet = true;
            mLocator      = aLocator;
        }t(IsSessionIdSetS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KKDC        bool IsSessionIdSet(void) const { return mIsSessionIdSet; }t(GetSessionIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KKA@        uint16_t GetSessionId(void) const { return mSessionId; }t(SetSessionIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KK
        void SetSessionId(uint16_t aSessionId)
        {
            mIsSessionIdSet = true;
            mSessionId      = aSessionId;
        }t(IsSteeringDataSetS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KKJI        bool IsSteeringDataSet(void) const { return mIsSteeringDataSet; }t(GetSteeringDataS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KK_^        const SteeringData &GetSteeringData(void) const { return AsCoreType(&mSteeringData); }t(UpdateSteeringDataS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KK
        SteeringData &UpdateSteeringData(void)
        {
            mIsSteeringDataSet = true;
            return AsCoreType(&mSteeringData);
        }t(IsJoinerUdpPortSetS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKʌDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KKLK        bool IsJoinerUdpPortSet(void) const { return mIsJoinerUdpPortSet; }t(GetJoinerUdpPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKԌDatasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KKIH        uint16_t GetJoinerUdpPort(void) const { return mJoinerUdpPort; }t(SetJoinerUdpPortS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppK܌Datasett(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppKK	KK
        void SetJoinerUdpPort(uint16_t aJoinerUdpPort)
        {
            mIsJoinerUdpPortSet = true;
            mJoinerUdpPort      = aJoinerUdpPort;
        }t(StopS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM Commissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM KM K>=    Error Stop(void) { return Stop(kSendKeepAliveToResign); }t(GetIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMK>=    const char *GetId(void) const { return mCommissionerId; }t(AddJoinerAnyS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM'Commissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM'KM'Kvu    Error AddJoinerAny(const char *aPskd, uint32_t aTimeout) { return AddJoiner(nullptr, nullptr, aPskd, aTimeout); }t(	AddJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM5Commissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM5KM8K    Error AddJoiner(const Mac::ExtAddress &aEui64, const char *aPskd, uint32_t aTimeout)
    {
        return AddJoiner(&aEui64, nullptr, aPskd, aTimeout);
    }t(	AddJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMFCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMFKMIK    Error AddJoiner(const JoinerDiscerner &aDiscerner, const char *aPskd, uint32_t aTimeout)
    {
        return AddJoiner(nullptr, &aDiscerner, aPskd, aTimeout);
    }t(RemoveJoinerAnyS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMaCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMaKMaK^]    Error RemoveJoinerAny(uint32_t aDelay) { return RemoveJoiner(nullptr, nullptr, aDelay); }to      (RemoveJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMnCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMnKMqK    Error RemoveJoiner(const Mac::ExtAddress &aEui64, uint32_t aDelay)
    {
        return RemoveJoiner(&aEui64, nullptr, aDelay);
    }t(RemoveJoinerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM~Commissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppM~KMK    Error RemoveJoiner(const JoinerDiscerner &aDiscerner, uint32_t aDelay)
    {
        return RemoveJoiner(nullptr, &aDiscerner, aDelay);
    }t(GetProvisioningUrlS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKLK    const char *GetProvisioningUrl(void) const { return mProvisioningUrl; }t(GetSessionIdS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMK=<    uint16_t GetSessionId(void) const { return mSessionId; }t(IsActiveS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKA@    bool IsActive(void) const { return mState == kStateActive; }t(
IsDisabledS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKED    bool IsDisabled(void) const { return mState == kStateDisabled; }tu((GetStateS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMK21    State GetState(void) const { return mState; }t(GetAnnounceBeginClientS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKQP    AnnounceBeginClient &GetAnnounceBeginClient(void) { return mAnnounceBegin; }t(GetEnergyScanClientS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKHG    EnergyScanClient &GetEnergyScanClient(void) { return mEnergyScan; }t(GetPanIdQueryClientS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMCommissionert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/commissioner.hppMKMKHG    PanIdQueryClient &GetPanIdQueryClient(void) { return mPanIdQuery; }t(GetTypeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKADatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKAKKAK87    Dataset::Type GetType(void) const { return mType; }t(IsSavedT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKPDatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKPKKPK0/    bool IsSaved(void) const { return mSaved; }t(IsTimestampPresentT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKYDatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKYKKYKFE    bool IsTimestampPresent(void) const { return mTimestampPresent; }t(GetTimestampT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKaDatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKaKKaKdc    const Timestamp *GetTimestamp(void) const { return mTimestampPresent ? &mTimestamp : nullptr; }t(
GetUpdateTimeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKDatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKKKK@?    TimeMilli GetUpdateTime(void) const { return mUpdateTime; }t(IsActiveT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKDatasetLocalt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_local.hppKKKKFE    bool IsActive(void) const { return (mType == Dataset::kActive); }t(ReadV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKSDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKSKKSKJI    Error Read(Dataset &aDataset) const { return mLocal.Read(aDataset); }t(ReadV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppK^DatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppK^KK^KXW    Error Read(Dataset::Info &aDatasetInfo) const { return mLocal.Read(aDatasetInfo); }t(ReadV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKiDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKiKKiK[Z    Error Read(otOperationalDatasetTlvs &aDataset) const { return mLocal.Read(aDataset); }t(GetTypeV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppKKKKCB    Dataset::Type GetType(void) const { return mLocal.GetType(); }t(IsActiveDatasetV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMVDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMVKMVKPO    bool  IsActiveDataset(void) const { return GetType() == Dataset::kActive; }t(IsPendingDatasetV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMWDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMWKMWKRQ    bool  IsPendingDataset(void) const { return GetType() == Dataset::kPending; }t(ClearV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMK21    void Clear(void) { DatasetManager::Clear(); }t(SaveV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMKXW    void Save(const Dataset &aDataset) { IgnoreError(DatasetManager::Save(aDataset)); }t(SaveV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMKa`    Error Save(const Dataset::Info &aDatasetInfo) { return DatasetManager::Save(aDatasetInfo); }t(SaveV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMKdc    Error Save(const otOperationalDatasetTlvs &aDataset) { return DatasetManager::Save(aDataset); }t(CreateNewNetworkV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMKon    Error CreateNewNetwork(Dataset::Info &aDatasetInfo) { return aDatasetInfo.GenerateRandom(GetInstance()); }t(HandleTimerV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMActiveDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMKMKED    void        HandleTimer(void) { DatasetManager::HandleTimer(); }t(HandleTimerV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMWPendingDatasetManagert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_manager.hppMWKMWKED    void        HandleTimer(void) { DatasetManager::HandleTimer(); }t(IsUpdateOngoingV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_updater.hppKqDatasetUpdatert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/dataset_updater.hppKqKKqKED    bool IsUpdateOngoing(void) const { return mDataset != nullptr; }t(IsInProgressV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/discover_scanner.hppKDiscoverScannert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/discover_scanner.hppKKKKED    bool IsInProgress(void) const { return (mState != kStateIdle); }t(StopV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/discover_scanner.hppKDiscoverScannert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/discover_scanner.hppKKKK;:    void          Stop(void) { HandleDiscoverComplete(); }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner.hppKJoinert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner.hppKKKK21    State GetState(void) const { return mState; }t(GetIdM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner.hppKJoinert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/joiner.hppKKKK=<    const Mac::ExtAddress &GetId(void) const { return mId; }t(	GetLengthU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_leader.hppK8CommissioningDatat(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/meshcop/meshcop_leader.hppK8KK<K    uint8_t GetLength(void) const
    {
        return sizeof(Tlv) + mBorderAgentLocator.GetLength() + sizeof(Tlv) + mCommissionerSessionId.GetLength() +
               sizeof(Tlv) + mSteeringData.GetLength();
    }t(GenerateRandomH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKn
TransactionIdt(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKnKKnKQP    Error GenerateRandom(void) { return Random::Crypto::FillBuffer(m8, kSize); }t(GetTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKK/.    Type GetType(void) const { return mType; }t(SetTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKK0/    void SetType(Type aType) { mType = aType; }t(GetTransactionIdH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKQP    const TransactionId &GetTransactionId(void) const { return mTransactionId; }t(SetTransactionIdH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKHeadert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKdc    void SetTransactionId(const TransactionId &aTransactionId) { mTransactionId = aTransactionId; }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKˌOptiont(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKI    void Init(void)
    {
        mCode   = 0;
        mLength = 0;
    }t(GetCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppK׌Optiont(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKNM    Code GetCode(void) const { return static_cast<Code>(HostSwap16(mCode)); }t(SetCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKߌOptiont(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKSR    void SetCode(Code aCode) { mCode = HostSwap16(static_cast<uint16_t>(aCode)); }t(	GetLengthH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKOptiont(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKCB    uint16_t GetLength(void) const { return HostSwap16(mLength); }t(	SetLengthH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKOptiont(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppKKKKHG    void SetLength(uint16_t aLength) { mLength = HostSwap16(aLength); }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	ClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	KM
K|    void Init(void)
    {
        SetCode(kOptionClientIdentifier);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(GetDuidTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK^]    DuidType GetDuidType(void) const { return static_cast<DuidType>(HostSwap16(mDuidType)); }t(SetDuidTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKgf    void SetDuidType(DuidType aDuidType) { mDuidType = HostSwap16(static_cast<uint16_t>(aDuidType)); }t(GetDuidHardwareTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM%ClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM%KM%KWV    uint16_t GetDuidHardwareType(void) const { return HostSwap16(mDuidHardwareType); }t(SetDuidHardwareTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM-ClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM-KM-Kpo    void SetDuidHardwareType(uint16_t aDuidHardwareType) { mDuidHardwareType = HostSwap16(aDuidHardwareType); }t(GetDuidLinkLayerAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM5ClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM5KM5Ka`    const Mac::ExtAddress &GetDuidLinkLayerAddress(void) const { return mDuidLinkLayerAddress; }t(SetDuidLinkLayerAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM=ClientIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM=KM@K    void SetDuidLinkLayerAddress(const Mac::ExtAddress &aDuidLinkLayerAddress)
    {
        mDuidLinkLayerAddress = aDuidLinkLayerAddress;
    }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMPServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMPKMTK|    void Init(void)
    {
        SetCode(kOptionServerIdentifier);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(GetDuidTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM\ServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM\KM\K^]    DuidType GetDuidType(void) const { return static_cast<DuidType>(HostSwap16(mDuidType)); }t(SetDuidTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMdServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMdKMdKgf    void SetDuidType(DuidType aDuidType) { mDuidType = HostSwap16(static_cast<uint16_t>(aDuidType)); }t(GetDuidHardwareTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMlServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMlKMlKWV    uint16_t GetDuidHardwareType(void) const { return HostSwap16(mDuidHardwareType); }t(SetDuidHardwareTypeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMtServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMtKMtKpo    void SetDuidHardwareType(uint16_t aDuidHardwareType) { mDuidHardwareType = HostSwap16(aDuidHardwareType); }t(GetDuidLinkLayerAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM|ServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM|KM|Ka`    const Mac::ExtAddress &GetDuidLinkLayerAddress(void) const { return mDuidLinkLayerAddress; }t(SetDuidLinkLayerAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMServerIdentifiert(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK    void SetDuidLinkLayerAddress(const Mac::ExtAddress &aDuidLinkLayerAddress)
    {
        mDuidLinkLayerAddress = aDuidLinkLayerAddress;
    }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKp    void Init(void)
    {
        SetCode(kOptionIaNa);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(GetIaidH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK?>    uint32_t GetIaid(void) const { return HostSwap32(mIaid); }t(SetIaidH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK@?    void SetIaid(uint32_t aIaid) { mIaid = HostSwap32(aIaid); }t(GetT1H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK;:    uint32_t GetT1(void) const { return HostSwap32(mT1); }t(SetT1H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK87    void SetT1(uint32_t aT1) { mT1 = HostSwap32(aT1); }t(GetT2H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK;:    uint32_t GetT2(void) const { return HostSwap32(mT2); }t(SetT2H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMIaNat(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK87    void SetT2(uint32_t aT2) { mT2 = HostSwap32(aT2); }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKu    void Init(void)
    {
        SetCode(kOptionIaAddress);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMK87    Ip6::Address &GetAddress(void) { return mAddress; }t(
GetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKDC    const Ip6::Address &GetAddress(void) const { return mAddress; }t(
SetAddressH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKKJ    void SetAddress(const Ip6::Address &aAddress) { mAddress = aAddress; }t(GetPreferredLifetimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM
	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM
KM
KYX    uint32_t GetPreferredLifetime(void) const { return HostSwap32(mPreferredLifetime); }t(SetPreferredLifetimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKts    void SetPreferredLifetime(uint32_t aPreferredLifetime) { mPreferredLifetime = HostSwap32(aPreferredLifetime); }t(GetValidLifetimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKQP    uint32_t GetValidLifetime(void) const { return HostSwap32(mValidLifetime); }t(SetValidLifetimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM%	IaAddresst(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM%KM%Kdc    void SetValidLifetime(uint32_t aValidLifetime) { mValidLifetime = HostSwap32(aValidLifetime); }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM9ElapsedTimet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM9KM=Kw    void Init(void)
    {
        SetCode(kOptionElapsedTime);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(GetElapsedTimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMEElapsedTimet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMEKMEKML    uint16_t GetElapsedTime(void) const { return HostSwap16(mElapsedTime); }t(SetElapsedTimeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMMElapsedTimet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMMKMMK\[    void SetElapsedTime(uint16_t aElapsedTime) { mElapsedTime = HostSwap16(aElapsedTime); }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMq
StatusCodet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMqKMuKv    void Init(void)
    {
        SetCode(kOptionStatusCode);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(
GetStatusCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM}
StatusCodet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM}KM}KZY    Status GetStatusCode(void) const { return static_cast<Status>(HostSwap16(mStatus)); }t(
SetStatusCodeH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppM
StatusCodet(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKa`    void SetStatusCode(Status aStatus) { mStatus = HostSwap16(static_cast<uint16_t>(aStatus)); }t(InitH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMRapidCommitt(H/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6.hppMKMKw    void Init(void)
    {
        SetCode(kOptionRapidCommit);
        SetLength(sizeof(*this) - sizeof(Option));
    }t(
LeaderBaseY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppKK
LeaderBaset(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppKKKKOK    explicit LeaderBase(Instance &aInstance)
        : MutableNetworkData(aInstance, mTlvBuffer, 0, sizeof(mTlvBuffer))
    {
        Reset();
    }t(
GetVersionY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppK_
LeaderBaset(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppK_KK_Ked    uint8_t GetVersion(Type aType) const { return (aType == kFullSet) ? mVersion : mStableVersion; }t(GetCommissioningDataY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppK
LeaderBaset(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppKKKKsr    CommissioningDataTlv *GetCommissioningData(void) { return AsNonConst(AsConst(this)->GetCommissioningData()); }t(GetCommissioningDataSubTlvY/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppK
LeaderBaset(Y/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader.hppKKKK    MeshCoP::Tlv *GetCommissioningDataSubTlv(MeshCoP::Tlv::Type aType)
    {
        return AsNonConst(AsConst(this)->GetCommissioningDataSubTlv(aType));
    }t(GetContextIdReuseDelay]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKLeadert(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKKKKQP    uint32_t GetContextIdReuseDelay(void) const { return mContextIdReuseDelay; }t(SetContextIdReuseDelay]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKLeadert(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKKKKTS    void SetContextIdReuseDelay(uint32_t aDelay) { mContextIdReuseDelay = aDelay; }t(ChangedFlags]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKChangedFlagst(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKK	KK
p        ChangedFlags(void)
            : mChanged(false)
            , mStableChanged(false)
        {
        }t(Update]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKChangedFlagst(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKK	KK
        void Update(const NetworkDataTlv &aTlv)
        {
            mChanged       = true;
            mStableChanged = (mStableChanged || aTlv.IsStable());
        }t(	DidChange]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKÌChangedFlagst(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKK	KK87        bool DidChange(void) const { return mChanged; }t(DidStableChange]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKČChangedFlagst(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_leader_ftd.hppKK	KKDC        bool DidStableChange(void) const { return mStableChanged; }t(
IsPrefixMatchO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKfPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKfK	KfKon        bool IsPrefixMatch(const Ip6::Address &aAddress) const { return aAddress.MatchesPrefix(GetPrefix()); }t(IsValidO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKoPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKoK	KoK:9        bool IsValid(void) const { return mAloc.mValid; }t(ClearO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKuPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKuK	KuK32        void Clear(void) { mAloc.mValid = false; }t(GetContextIdO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppK}PrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppK}K	K}KSR        uint8_t GetContextId(void) const { return mAloc.mAddress.mFields.m8[15]; }t(GetAlocO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKK	KKDC        Ip6::Netif::UnicastAddress &GetAloc(void) { return mAloc; }t(	GetPrefixO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKK	KKED        const Ip6::Prefix &GetPrefix(void) const { return mPrefix; }t(	GetPrefixO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKK	KK98        Ip6::Prefix &GetPrefix(void) { return mPrefix; }t(GetPrefixAsAddressO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKK	KK
        const Ip6::Address &GetPrefixAsAddress(void) const
        {
            return static_cast<const Ip6::Address &>(mPrefix.mPrefix);
        }t(SetO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKPrefixAgentt(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dhcp6_server.hppKK	KK
X=          void Set(const Ip6::Prefix &aPrefix, const Ip6::NetworkPrefix &aMeshLocalPrefix, uint8_t aContextId)
        {
            mPrefix = aPrefix;

            mAloc.InitAsThreadOrigin();
            mAloc.GetAddress().SetToAnycastLocator(aMeshLocalPrefix, (Ip6::Address::kAloc16Mask << 8) + aContextId);
        }t(GetTypeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppK_Appendert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppK_KK_K/.    Type GetType(void) const { return mType; }t(AppendN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKxAppendert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKxKK}K    template <typename ObjectType> Error Append(const ObjectType &aObject)
    {
        static_assert(!TypeTraits::IsPointer<ObjectType>::kValue, "ObjectType must not be a pointer");

        return AppendBytes(&aObject, sizeof(ObjectType));
    }t(
GetMessageN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKAppendert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKKKKKJ    Message &GetMessage(void) const { return *mShared.mMessage.mMessage; }t(GetBufferStartN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKAppendert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/appender.hppKKKKa`    uint8_t *GetBufferStart(void) const { return AsNonConst(mShared.mFrameBuilder.GetBytes()); }t(GetBytesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppKuAddresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppKuKKuK?>    const uint8_t *GetBytes(void) const { return mFields.m8; }t(SetBytesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppK~Addresst(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppK~KK~KRQ    void SetBytes(const uint8_t *aBuffer) { memcpy(mFields.m8, aBuffer, kSize); }t(GetBytesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppKCidrt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppKKKKHG    const uint8_t *GetBytes(void) const { return mAddress.mFields.m8; }t(HostMaskL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMCidrt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKM
K    uint32_t HostMask(void) const
    {
        // Note: Using LL suffix to make it a uint64 since /32 is a valid CIDR, and right shifting 32 bits is undefined
        // for uint32.
        return HostSwap32(0xffffffffLL >> mLength);
    }t(
SubnetMaskL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMCidrt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK<;    uint32_t SubnetMask(void) const { return ~HostMask(); }t(IsValidL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM.Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM.KM.K65    bool IsValid(void) const { return IsVersion4(); }t(InitVersionIhlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM6Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM6KM6K?>    void InitVersionIhl(void) { SetVersionIhl(kVersIhlInit); }t(
SetVersionIhlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM>Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM>KM>KHG    void SetVersionIhl(uint8_t aVersionIhl) { mVersIhl = aVersionIhl; }t(
IsVersion4L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMGHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMGKMGKSR    bool IsVersion4(void) const { return (mVersIhl & kVersionMask) == kVersion4; }t(
GetDscpEcnL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMOHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMOKMOK87    uint8_t GetDscpEcn(void) const { return mDscpEcn; }t(GetDscpL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMWHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMWKMWKRQ    uint8_t GetDscp(void) const { return (mDscpEcn & kDscpMask) >> kDscpOffset; }t(SetDscpL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM_Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppM_KM_Kwv    void SetDscp(uint8_t aDscp) { mDscpEcn = static_cast<uint8_t>((mDscpEcn & ~kDscpMask) | (aDscp << kDscpOffset)); }t(GetEcnL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMgHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMgKMgKML    Ecn GetEcn(void) const { return static_cast<Ecn>(mDscpEcn & kEcnMask); }t(SetEcnL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMoHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMoKMoKJI    void SetEcn(Ecn aEcn) { mDscpEcn = ((mDscpEcn & ~kEcnMask) | aEcn); }t(GetTotalLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMwHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMwKMwKML    uint16_t GetTotalLength(void) const { return HostSwap16(mTotalLength); }t(SetTotalLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKRQ    void SetTotalLength(uint16_t aLength) { mTotalLength = HostSwap16(aLength); }t(GetProtocolL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK:9    uint8_t GetProtocol(void) const { return mProtocol; }t(SetProtocolL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKCB    void SetProtocol(uint8_t aProtocol) { mProtocol = aProtocol; }t(GetChecksumL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKML    uint16_t GetChecksum(void) const { return HostSwap16(mHeaderChecksum); }t(SetChecksumL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKVU    void SetChecksum(uint16_t aChecksum) { mHeaderChecksum = HostSwap16(aChecksum); }t(GetIdentificationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKSR    uint16_t GetIdentification(void) const { return HostSwap16(mIdentification); }t(SetIdentificationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKhg    void SetIdentification(uint16_t aIdentification) { mIdentification = HostSwap16(aIdentification); }t(GetTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK0/    uint8_t GetTtl(void) const { return mTtl; }t(SetTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK/.    void SetTtl(uint8_t aTtl) { mTtl = aTtl; }t(	GetSourceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK10    Address &GetSource(void) { return mSource; }t(	GetSourceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK=<    const Address &GetSource(void) const { return mSource; }t(	SetSourceL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKBA    void SetSource(const Address &aSource) { mSource = aSource; }t(GetDestinationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMK;:    Address &GetDestination(void) { return mDestination; }t(GetDestinationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKGF    const Address &GetDestination(void) const { return mDestination; }t(SetDestinationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKVU    void SetDestination(const Address &aDestination) { mDestination = aDestination; }t(GetDfL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKSR    bool GetDf(void) const { return HostSwap16(mFlagsFargmentOffset) & kFlagsDf; }t(GetMfL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKSR    bool GetMf(void) const { return HostSwap16(mFlagsFargmentOffset) & kFlagsMf; }t(GetFragmentOffsetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMKMKnm    uint16_t GetFragmentOffset(void) const { return HostSwap16(mFlagsFargmentOffset) & kFragmentOffsetMask; }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMiHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMiK	MiK65        uint8_t GetType(void) const { return mType; }t(SetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMqHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMqK	MqK76        void SetType(uint8_t aType) { mType = aType; }t(GetCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMyHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMyK	MyK65        uint8_t GetCode(void) const { return mCode; }t(SetCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMK	MK76        void SetCode(uint8_t aCode) { mCode = aCode; }t(GetChecksumL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMK	MKKJ        uint16_t GetChecksum(void) const { return HostSwap16(mChecksum); }t(SetChecksumL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMK	MKTS        void SetChecksum(uint16_t aChecksum) { mChecksum = HostSwap16(aChecksum); }t(GetRestOfHeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMK	MKML        const uint8_t *GetRestOfHeader(void) const { return mRestOfHeader; }t(SetRestOfHeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip4_types.hppMK	MK
        void SetRestOfHeader(const uint8_t *aRestOfheader)
        {
            memcpy(mRestOfHeader, aRestOfheader, sizeof(mRestOfHeader));
        }t(HeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKWHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKWKKWK    Header(void) { Clear(); }t(GetMessageIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppK_Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppK_KK_KIH    uint16_t GetMessageId(void) const { return HostSwap16(mMessageId); }t(SetMessageIdL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKgHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKgKKgKTS    void SetMessageId(uint16_t aMessageId) { mMessageId = HostSwap16(aMessageId); }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKgf    Type GetType(void) const { return static_cast<Type>((mFlags[0] & kQrFlagMask) >> kQrFlagOffset); }t(SetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKK    void SetType(Type aType)
    {
        mFlags[0] &= ~kQrFlagMask;
        mFlags[0] |= static_cast<uint8_t>(aType) << kQrFlagOffset;
    }t(GetQueryTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKvu    QueryType GetQueryType(void) const { return static_cast<QueryType>((mFlags[0] & kOpCodeMask) >> kOpCodeOffset); }t(SetQueryTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKK    void SetQueryType(QueryType aType)
    {
        mFlags[0] &= ~kOpCodeMask;
        mFlags[0] |= static_cast<uint8_t>(aType) << kOpCodeOffset;
    }t(IsAuthoritativeAnswerFlagSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKgf    bool IsAuthoritativeAnswerFlagSet(void) const { return (mFlags[0] & kAaFlagMask) == kAaFlagMask; }t(ClearAuthoritativeAnswerFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKKJ    void ClearAuthoritativeAnswerFlag(void) { mFlags[0] &= ~kAaFlagMask; }t(SetAuthoritativeAnswerFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKŌHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKHG    void SetAuthoritativeAnswerFlag(void) { mFlags[0] |= kAaFlagMask; }t(IsTruncationFlagSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppK͌Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKK^]    bool IsTruncationFlagSet(void) const { return (mFlags[0] & kTcFlagMask) == kTcFlagMask; }t(ClearTruncationFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKӌHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKBA    void ClearTruncationFlag(void) { mFlags[0] &= ~kTcFlagMask; }t(SetTruncationFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKٌHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKK?>    void SetTruncationFlag(void) { mFlags[0] |= kTcFlagMask; }t(IsRecursionDesiredFlagSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKdc    bool IsRecursionDesiredFlagSet(void) const { return (mFlags[0] & kRdFlagMask) == kRdFlagMask; }t(ClearRecursionDesiredFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKHG    void ClearRecursionDesiredFlag(void) { mFlags[0] &= ~kRdFlagMask; }t(SetRecursionDesiredFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKED    void SetRecursionDesiredFlag(void) { mFlags[0] |= kRdFlagMask; }t(IsRecursionAvailableFlagSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKfe    bool IsRecursionAvailableFlagSet(void) const { return (mFlags[1] & kRaFlagMask) == kRaFlagMask; }t(ClearRecursionAvailableFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppKKKKJI    void ClearRecursionAvailableFlag(void) { mFlags[1] &= ~kRaFlagMask; }t(SetRecursionAvailableFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKGF    void SetRecursionAvailableFlag(void) { mFlags[1] |= kRaFlagMask; }t(GetResponseCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM!Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM!KM!Kut    Response GetResponseCode(void) const { return static_cast<Response>((mFlags[1] & kRCodeMask) >> kRCodeOffset); }t(SetResponseCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM)Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM)KM-K    void SetResponseCode(Response aResponse)
    {
        mFlags[1] &= ~kRCodeMask;
        mFlags[1] |= static_cast<uint8_t>(aResponse) << kRCodeOffset;
    }t(GetQuestionCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMNHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMNKMNKKJ    uint16_t GetQuestionCount(void) const { return HostSwap16(mQdCount); }t(SetQuestionCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMVHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMVKMVKNM    void SetQuestionCount(uint16_t aCount) { mQdCount = HostSwap16(aCount); }t(GetAnswerCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM^Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM^KM^KIH    uint16_t GetAnswerCount(void) const { return HostSwap16(mAnCount); }t(SetAnswerCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMfHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMfKMfKLK    void SetAnswerCount(uint16_t aCount) { mAnCount = HostSwap16(aCount); }t(GetAuthorityRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMnHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMnKMnKRQ    uint16_t GetAuthorityRecordCount(void) const { return HostSwap16(mNsCount); }t(SetAuthorityRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMvHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMvKMvKUT    void SetAuthorityRecordCount(uint16_t aCount) { mNsCount = HostSwap16(aCount); }t(GetAdditionalRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~Headert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~KM~KSR    uint16_t GetAdditionalRecordCount(void) const { return HostSwap16(mArCount); }t(SetAdditionalRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKVU    void SetAdditionalRecordCount(uint16_t aCount) { mArCount = HostSwap16(aCount); }t(UpdateHeaderL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK;:    UpdateHeader(void) { SetQueryType(kQueryTypeUpdate); }t(GetZoneRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKKJ    uint16_t GetZoneRecordCount(void) const { return GetQuestionCount(); }t(SetZoneRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKKJ    void SetZoneRecordCount(uint16_t aCount) { SetQuestionCount(aCount); }t(GetPrerequisiteRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKQP    uint16_t GetPrerequisiteRecordCount(void) const { return GetAnswerCount(); }t(SetPrerequisiteRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKQP    void SetPrerequisiteRecordCount(uint16_t aCount) { SetAnswerCount(aCount); }t(GetUpdateRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKTS    uint16_t GetUpdateRecordCount(void) const { return GetAuthorityRecordCount(); }t(SetUpdateRecordCountL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMUpdateHeadert(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKTS    void SetUpdateRecordCount(uint16_t aCount) { SetAuthorityRecordCount(aCount); }t(NameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK>    Name(void)
        : Name(nullptr, nullptr, 0)
    {
    }t(NameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM!Namet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM!KM$KV    explicit Name(const char *aString)
        : Name(aString, nullptr, 0)
    {
    }t(NameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.Namet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.KM1Kk    Name(const Message &aMessage, uint16_t aOffset)
        : Name(nullptr, &aMessage, aOffset)
    {
    }t(IsEmptyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM9Namet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM9KM9KWV    bool IsEmpty(void) const { return (mString == nullptr) && (mMessage == nullptr); }t(
IsFromCStringL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMANamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMAKMAKBA    bool IsFromCString(void) const { return mString != nullptr; }t(
IsFromMessageL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMINamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMIKMIKCB    bool IsFromMessage(void) const { return mMessage != nullptr; }t(GetFromTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMRNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMRKMUK    Type GetFromType(void) const
    {
        return IsFromCString() ? kTypeCString : (IsFromMessage() ? kTypeMessage : kTypeEmpty);
    }t(SetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM]Namet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM]KMaKe    void Set(const char *aString)
    {
        mString  = aString;
        mMessage = nullptr;
    }t(SetFromMessageL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMkNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMkKMpK    void SetFromMessage(const Message &aMessage, uint16_t aOffset)
    {
        mString  = nullptr;
        mMessage = &aMessage;
        mOffset  = aOffset;
    }t(GetAsCStringL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMzNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMzKMzK=<    const char *GetAsCString(void) const { return mString; }t(GetAsMessageL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKy    const Message &GetAsMessage(uint16_t &aOffset) const
    {
        aOffset = mOffset;
        return *mMessage;
    }t(
LabelIteratorL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
LabelIteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMK	MK
        LabelIterator(const Message &aMessage, uint16_t aLabelOffset)
            : mMessage(aMessage)
            , mNextLabelOffset(aLabelOffset)
            , mNameEndOffset(kUnsetNameEndOffset)
        {
        }t(IsEndOffsetSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
LabelIteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMK	MK]\        bool  IsEndOffsetSet(void) const { return (mNameEndOffset != kUnsetNameEndOffset); }t(NameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMNamet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK    Name(const char *aString, const Message *aMessage, uint16_t aOffset)
        : mString(aString)
        , mMessage(aMessage)
        , mOffset(aOffset)
    {
    }t(
GetTxtDataL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM[Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM[K	M[K\[        const char *GetTxtData(void) const { return reinterpret_cast<const char *>(mPtr); }t(
SetTxtDataL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM\Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM\K	M\KML        void        SetTxtData(const uint8_t *aTxtData) { mPtr = aTxtData; }t(GetTxtDataLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM]Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM]K	M]KTS        uint16_t    GetTxtDataLength(void) const { return mData[kIndexTxtLength]; }t(SetTxtDataLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM^Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM^K	M^K]\        void        SetTxtDataLength(uint16_t aLength) { mData[kIndexTxtLength] = aLength; }t(GetTxtDataPositionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM_Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM_K	M_KXW        uint16_t    GetTxtDataPosition(void) const { return mData[kIndexTxtPosition]; }t(SetTxtDataPositionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM`Iteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM`K	M`K_^        void        SetTxtDataPosition(uint16_t aValue) { mData[kIndexTxtPosition] = aValue; }t(IncreaseTxtDataPositionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMaIteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMaK	MaKml        void        IncreaseTxtDataPosition(uint16_t aIncrement) { mData[kIndexTxtPosition] += aIncrement; }t(GetKeyBufferL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMbIteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMbK	MbK98        char       *GetKeyBuffer(void) { return mChar; }t(
GetTxtDataEndL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMcIteratort(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMcK	McK\[        const char *GetTxtDataEnd(void) const { return GetTxtData() + GetTxtDataLength(); }t(TxtEntryL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMtTxtEntryt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMtKMtKrq    TxtEntry(const char *aKey, const uint8_t *aValue, uint8_t aValueLength) { Init(aKey, aValue, aValueLength); }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~TxtEntryt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~KMK    void Init(const char *aKey, const uint8_t *aValue, uint8_t aValueLength)
    {
        mKey         = aKey;
        mValue       = aValue;
        mValueLength = aValueLength;
    }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK}    void Init(uint16_t aType, uint16_t aClass = kClassInternet)
    {
        SetType(aType);
        SetClass(aClass);
    }t(MatchesL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK    bool Matches(uint16_t aType, uint16_t aClass = kClassInternet) const
    {
        return (mType == HostSwap16(aType)) && (mClass == HostSwap16(aClass));
    }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK?>    uint16_t GetType(void) const { return HostSwap16(mType); }t(SetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK@?    void SetType(uint16_t aType) { mType = HostSwap16(aType); }t(GetClassL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKA@    uint16_t GetClass(void) const { return HostSwap16(mClass); }t(SetClassL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
ResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
KM
KDC    void SetClass(uint16_t aClass) { mClass = HostSwap16(aClass); }t(GetTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK=<    uint32_t GetTtl(void) const { return HostSwap32(mTtl); }t(SetTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK<;    void SetTtl(uint32_t aTtl) { mTtl = HostSwap32(aTtl); }t(	GetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM%ResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM%KM%KCB    uint16_t GetLength(void) const { return HostSwap16(mLength); }t(	SetLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM-ResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM-KM-KHG    void SetLength(uint16_t aLength) { mLength = HostSwap16(aLength); }t(GetSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6ResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6KM6KRQ    uint32_t GetSize(void) const { return sizeof(ResourceRecord) + GetLength(); }t(
FindRecordL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~ResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM~KMKX      template <class RecordType>
    static Error FindRecord(const Message &aMessage,
                            uint16_t      &aOffset,
                            uint16_t       aNumRecords,
                            uint16_t       aIndex,
                            const Name    &aName,
                            RecordType    &aRecord)
    {
        return FindRecord(aMessage, aOffset, aNumRecords, aIndex, aName, RecordType::kType, aRecord,
                          sizeof(RecordType));
    }t(
ReadRecordL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMResourceRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK    template <class RecordType> static Error ReadRecord(const Message &aMessage, uint16_t &aOffset, RecordType &aRecord)
    {
        return ReadRecord(aMessage, aOffset, RecordType::kType, aRecord, sizeof(RecordType));
    }tJ      (InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMARecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKn    void Init(void)
    {
        ResourceRecord::Init(kTypeA);
        SetLength(sizeof(Ip4::Address));
    }t(
SetAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMARecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKKJ    void SetAddress(const Ip4::Address &aAddress) { mAddress = aAddress; }t(
GetAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMARecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKDC    const Ip4::Address &GetAddress(void) const { return mAddress; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMCnameRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK^]    void Init(uint16_t aClass = kClassInternet) { ResourceRecord::Init(kTypeCname, aClass); }t(ReadCanonicalNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM(CnameRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM(KM/KX      Error ReadCanonicalName(const Message &aMessage,
                            uint16_t      &aOffset,
                            char          *aNameBuffer,
                            uint16_t       aNameBufferSize) const
    {
        return ResourceRecord::ReadName(aMessage, aOffset, /* aStartOffset */ aOffset - sizeof(CnameRecord),
                                        aNameBuffer, aNameBufferSize, /* aSkipRecord */ true);
    }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppME	PtrRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMEKMEK\[    void Init(uint16_t aClass = kClassInternet) { ResourceRecord::Init(kTypePtr, aClass); }t(ReadPtrNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM[	PtrRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM[KM`KXr      Error ReadPtrName(const Message &aMessage, uint16_t &aOffset, char *aNameBuffer, uint16_t aNameBufferSize) const
    {
        return ResourceRecord::ReadName(aMessage, aOffset, /* aStartOffset */ aOffset - sizeof(PtrRecord), aNameBuffer,
                                        aNameBufferSize,
                                        /* aSkipRecord */ true);
    }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	TxtRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK\[    void Init(uint16_t aClass = kClassInternet) { ResourceRecord::Init(kTypeTxt, aClass); }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
AaaaRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKq    void Init(void)
    {
        ResourceRecord::Init(kTypeAaaa);
        SetLength(sizeof(Ip6::Address));
    }t(
SetAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
AaaaRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKKJ    void SetAddress(const Ip6::Address &aAddress) { mAddress = aAddress; }t(
GetAddressL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
AaaaRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKDC    const Ip6::Address &GetAddress(void) const { return mAddress; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK\[    void Init(uint16_t aClass = kClassInternet) { ResourceRecord::Init(kTypeSrv, aClass); }t(GetPriorityL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKGF    uint16_t GetPriority(void) const { return HostSwap16(mPriority); }t(SetPriorityL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKPO    void SetPriority(uint16_t aPriority) { mPriority = HostSwap16(aPriority); }t(	GetWeightL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKCB    uint16_t GetWeight(void) const { return HostSwap16(mWeight); }t(	SetWeightL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM&	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM&KM&KHG    void SetWeight(uint16_t aWeight) { mWeight = HostSwap16(aWeight); }t(GetPortL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.KM.K?>    uint16_t GetPort(void) const { return HostSwap16(mPort); }t(SetPortL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6KM6K@?    void SetPort(uint16_t aPort) { mPort = HostSwap16(aPort); }t(ReadTargetHostNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppML	SrvRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMLKMTKX      Error ReadTargetHostName(const Message &aMessage,
                             uint16_t      &aOffset,
                             char          *aNameBuffer,
                             uint16_t       aNameBufferSize) const
    {
        return ResourceRecord::ReadName(aMessage, aOffset, /* aStartOffset */ aOffset - sizeof(SrvRecord), aNameBuffer,
                                        aNameBufferSize,
                                        /* aSkipRecord */ true);
    }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK\[    void Init(uint16_t aClass = kClassInternet) { ResourceRecord::Init(kTypeKey, aClass); }t(GetUseFlagsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKba    UseFlags GetUseFlags(void) const { return static_cast<UseFlags>(mFlags[0] & kUseFlagsMask); }t(
GetOwnerFlagsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKji    OwnerFlags GetOwnerFlags(void) const { return static_cast<OwnerFlags>(mFlags[0] & kOwnerFlagsMask); }t(GetSignatoryFlagsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKXW    uint8_t GetSignatoryFlags(void) const { return (mFlags[1] & kSignatoryFlagsMask); }t(SetFlagsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK    void SetFlags(UseFlags aUseFlags, OwnerFlags aOwnerFlags, uint8_t aSignatoryFlags)
    {
        mFlags[0] = (static_cast<uint8_t>(aUseFlags) | static_cast<uint8_t>(aOwnerFlags));
        mFlags[1] = (aSignatoryFlags & kSignatoryFlagsMask);
    }t(GetProtocolL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK:9    uint8_t GetProtocol(void) const { return mProtocol; }t(SetProtocolL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKCB    void SetProtocol(uint8_t aProtocol) { mProtocol = aProtocol; }t(GetAlgorithmL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK<;    uint8_t GetAlgorithm(void) const { return mAlgorithm; }t(SetAlgorithmL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKGF    void SetAlgorithm(uint8_t aAlgorithm) { mAlgorithm = aAlgorithm; }t(GetKeyL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.Ecdsa256KeyRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.KM.KNM    const Crypto::Ecdsa::P256::PublicKey &GetKey(void) const { return mKey; }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMJ	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMJKMJKKJ    void Init(uint16_t aClass) { ResourceRecord::Init(kTypeSig, aClass); }t(GetTypeCoveredL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMZ	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMZKMZKML    uint16_t GetTypeCovered(void) const { return HostSwap16(mTypeCovered); }t(SetTypeCoveredL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMb	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMbKMbK[Z    void SetTypeCovered(uint8_t aTypeCovered) { mTypeCovered = HostSwap16(aTypeCovered); }t(GetAlgorithmL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMj	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMjKMjK<;    uint8_t GetAlgorithm(void) const { return mAlgorithm; }t(SetAlgorithmL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMr	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMrKMrKGF    void SetAlgorithm(uint8_t aAlgorithm) { mAlgorithm = aAlgorithm; }t(	GetLabelsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM{	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM{KM{K65    uint8_t GetLabels(void) const { return mLabels; }t(	SetLabelsL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK;:    void SetLabels(uint8_t aLabels) { mLabels = aLabels; }t(GetOriginalTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKML    uint32_t GetOriginalTtl(void) const { return HostSwap32(mOriginalTtl); }t(SetOriginalTtlL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMK\[    void SetOriginalTtl(uint32_t aOriginalTtl) { mOriginalTtl = HostSwap32(aOriginalTtl); }t(
GetExpirationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKKJ    uint32_t GetExpiration(void) const { return HostSwap32(mExpiration); }t(
SetExpirationL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKXW    void SetExpiration(uint32_t aExpiration) { mExpiration = HostSwap32(aExpiration); }t(GetInceptionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKIH    uint32_t GetInception(void) const { return HostSwap32(mInception); }t(SetInceptionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKTS    void SetInception(uint32_t aInception) { mInception = HostSwap32(aInception); }t(	GetKeyTagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKCB    uint16_t GetKeyTag(void) const { return HostSwap16(mKeyTag); }t(	SetKeyTagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKHG    void SetKeyTag(uint16_t aKeyTag) { mKeyTag = HostSwap16(aKeyTag); }t(
GetRecordDataL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKji    const uint8_t *GetRecordData(void) const { return reinterpret_cast<const uint8_t *>(&mTypeCovered); }t(ReadSignerNameL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	SigRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMKMKXv      Error ReadSignerName(const Message &aMessage, uint16_t &aOffset, char *aNameBuffer, uint16_t aNameBufferSize) const
    {
        return ResourceRecord::ReadName(aMessage, aOffset, /* aStartOffset */ aOffset - sizeof(SigRecord), aNameBuffer,
                                        aNameBufferSize,
                                        /* aSkipRecord */ false);
    }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KM    void Init(void)
    {
        SetType(kTypeOpt);
        SetTtl(0);
    }t(GetUdpPayloadSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KBA    uint16_t GetUdpPayloadSize(void) const { return GetClass(); }t(SetUdpPayloadSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KNM    void SetUdpPayloadSize(uint16_t aPayloadSize) { SetClass(aPayloadSize); }t(GetExtendedResponseCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM$		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM$	KM$	K]\    uint8_t GetExtendedResponseCode(void) const { return GetTtlByteAt(kExtRCodeByteIndex); }t(SetExtnededResponseCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM.	KM.	Kvu    void SetExtnededResponseCode(uint8_t aExtendedResponse) { GetTtlByteAt(kExtRCodeByteIndex) = aExtendedResponse; }t(
GetVersionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM6	KM6	KON    uint8_t GetVersion(void) const { return GetTtlByteAt(kVersionByteIndex); }t(
SetVersionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM>		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM>	KM>	KVU    void SetVersion(uint8_t aVersion) { GetTtlByteAt(kVersionByteIndex) = aVersion; }t(IsDnsSecurityFlagSetL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMF		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMF	KMF	Khg    bool IsDnsSecurityFlagSet(void) const { return (GetTtlByteAt(kFlagByteIndex) & kDnsSecFlag) != 0; }t(ClearDnsSecurityFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppML		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppML	KML	KVU    void ClearDnsSecurityFlag(void) { GetTtlByteAt(kFlagByteIndex) &= ~kDnsSecFlag; }t(SetDnsSecurityFlagL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMR		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMR	KMR	KSR    void SetDnsSecurityFlag(void) { GetTtlByteAt(kFlagByteIndex) |= kDnsSecFlag; }t(GetTtlByteAtL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMh		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMh	KMh	Kml    uint8_t  GetTtlByteAt(uint8_t aIndex) const { return reinterpret_cast<const uint8_t *>(&mTtl)[aIndex]; }t(GetTtlByteAtL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMi		OptRecordt(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppMi	KMi	Ka`    uint8_t &GetTtlByteAt(uint8_t aIndex) { return reinterpret_cast<uint8_t *>(&mTtl)[aIndex]; }t(
GetOptionCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM}	Optiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM}	KM}	KKJ    uint16_t GetOptionCode(void) const { return HostSwap16(mOptionCode); }t(
SetOptionCodeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	Optiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KXW    void SetOptionCode(uint16_t aOptionCode) { mOptionCode = HostSwap16(aOptionCode); }t(GetOptionLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	Optiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KON    uint16_t GetOptionLength(void) const { return HostSwap16(mOptionLength); }t(SetOptionLengthL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	Optiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	K`_    void SetOptionLength(uint16_t aOptionLength) { mOptionLength = HostSwap16(aOptionLength); }t(GetSizeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	Optiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KPO    uint32_t GetSize(void) const { return sizeof(Option) + GetOptionLength(); }t(InitL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	LeaseOptiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	Kl    void Init(void)
    {
        SetOptionCode(kUpdateLease);
        SetOptionLength(kOptionLength);
    }t(GetLeaseIntervalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	LeaseOptiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KQP    uint32_t GetLeaseInterval(void) const { return HostSwap32(mLeaseInterval); }t(SetLeaseIntervalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	LeaseOptiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	Kdc    void SetLeaseInterval(uint32_t aLeaseInterval) { mLeaseInterval = HostSwap32(aLeaseInterval); }t(GetKeyLeaseIntervalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	LeaseOptiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	KWV    uint32_t GetKeyLeaseInterval(void) const { return HostSwap32(mKeyLeaseInterval); }t(SetKeyLeaseIntervalL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	LeaseOptiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM	Kpo    void SetKeyLeaseInterval(uint32_t aKeyLeaseInterval) { mKeyLeaseInterval = HostSwap32(aKeyLeaseInterval); }t(QuestionL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	Questiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM	KM
K    explicit Question(uint16_t aType, uint16_t aClass = ResourceRecord::kClassInternet)
    {
        SetType(aType);
        SetClass(aClass);
    }t(GetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM

Questiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM

KM

K?>    uint16_t GetType(void) const { return HostSwap16(mType); }t(SetTypeL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
Questiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
KM
K@?    void SetType(uint16_t aType) { mType = HostSwap16(aType); }t(GetClassL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
Questiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM
KM
KA@    uint16_t GetClass(void) const { return HostSwap16(mClass); }t(SetClassL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM"
Questiont(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM"
KM"
KDC    void SetClass(uint16_t aClass) { mClass = HostSwap16(aClass); }t(ZoneL/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM7
Zonet(L/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_types.hppM7
KM:
K    explicit Zone(uint16_t aClass = ResourceRecord::kClassInternet)
        : Question(ResourceRecord::kTypeSoa, aClass)
    {
    }t(GetServerSockAddrM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KK
        const Ip6::SockAddr &GetServerSockAddr(void) const
        {
            return static_cast<const Ip6::SockAddr &>(mServerSockAddr);
        }t(GetResponseTimeoutM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKML        uint32_t GetResponseTimeout(void) const { return mResponseTimeout; }t(GetMaxTxAttemptsM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKHG        uint8_t GetMaxTxAttempts(void) const { return mMaxTxAttempts; }t(GetRecursionFlagM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKji        RecursionFlag GetRecursionFlag(void) const { return static_cast<RecursionFlag>(mRecursionFlag); }t(GetNat64ModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKZY        Nat64Mode GetNat64Mode(void) const { return static_cast<Nat64Mode>(mNat64Mode); }t(GetServerSockAddrM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppK֌QueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKXW        Ip6::SockAddr &GetServerSockAddr(void) { return AsCoreType(&mServerSockAddr); }t(SetResponseTimeoutM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppK،QueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKdc        void SetResponseTimeout(uint32_t aResponseTimeout) { mResponseTimeout = aResponseTimeout; }t(SetMaxTxAttemptsM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKٌQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KK[Z        void SetMaxTxAttempts(uint8_t aMaxTxAttempts) { mMaxTxAttempts = aMaxTxAttempts; }t(SetRecursionFlagM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKڌQueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KKpo        void SetRecursionFlag(RecursionFlag aFlag) { mRecursionFlag = static_cast<otDnsRecursionFlag>(aFlag); }t(SetNat64ModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppK܌QueryConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KK`_        void SetNat64Mode(Nat64Mode aMode) { mNat64Mode = static_cast<otDnsNat64Mode>(aMode); }t(ResponseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKResponset(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppKK	KK$#        Response(void) { Clear(); }t(GetHostNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppM<AddressResponset(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppM<K	M?K
        Error GetHostName(char *aNameBuffer, uint16_t aNameBufferSize) const
        {
            return GetName(aNameBuffer, aNameBufferSize);
        }t(GetServiceNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppMzBrowseResponset(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppMzK	M}K
        Error GetServiceName(char *aNameBuffer, uint16_t aNameBufferSize) const
        {
            return GetName(aNameBuffer, aNameBufferSize);
        }t(GetDefaultConfigM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppM9Clientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppM9KM9KON    const QueryConfig &GetDefaultConfig(void) const { return mDefaultConfig; }t(ReadFromM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppM	QueryInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppMK	MKSR        void ReadFrom(const Query &aQuery) { IgnoreError(aQuery.Read(0, *this)); }t(UpdateQueryM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/dns_client.hppMKMK_^    void        UpdateQuery(Query &aQuery, const QueryInfo &aInfo) { aQuery.Write(0, aInfo); }t(FilterM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKFFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKFKKIKY    explicit Filter(Instance &aInstance)
        : InstanceLocator(aInstance)
    {
    }t(AddUnsecurePortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppK`Filtert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppK`KK`KWV    Error AddUnsecurePort(uint16_t aPort) { return UpdateUnsecurePorts(kAdd, aPort); }t(RemoveUnsecurePortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKlFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKlKKlK]\    Error RemoveUnsecurePort(uint16_t aPort) { return UpdateUnsecurePorts(kRemove, aPort); }t(IsUnsecurePortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKvFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKvKKvKSR    bool IsUnsecurePort(uint16_t aPort) { return mUnsecurePorts.Contains(aPort); }t(RemoveAllUnsecurePortsM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppK|Filtert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppK|KK|KBA    void RemoveAllUnsecurePorts(void) { mUnsecurePorts.Clear(); }t(GetUnsecurePortsM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKFiltert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_filter.hppKKKK    const uint16_t *GetUnsecurePorts(uint8_t &aNumEntries) const
    {
        aNumEntries = mUnsecurePorts.GetLength();

        return &mUnsecurePorts[0];
    }t(GetFlagsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKVHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKVKKVK43    uint8_t GetFlags(void) const { return mFlags; }t(SetFlagsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppK^Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppK^KK^K76    void SetFlags(uint8_t aFlags) { mFlags = aFlags; }t(GetModeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKfHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKfKKfK`_    Mode GetMode(void) const { return static_cast<Mode>((mFlags & kModeMask) >> kModeOffset); }t(
GetStratumN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKnHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKnKKnK87    uint8_t GetStratum(void) const { return mStratum; }t(
SetStratumN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKvHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKvKKvK?>    void SetStratum(uint8_t aStratum) { mStratum = aStratum; }t(GetPollN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppK~Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppK~KK~K21    uint8_t GetPoll(void) const { return mPoll; }t(SetPollN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKK32    void SetPoll(uint8_t aPoll) { mPoll = aPoll; }t(GetPrecisionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKK<;    uint8_t GetPrecision(void) const { return mPrecision; }t(SetPrecisionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKGF    void SetPrecision(uint8_t aPrecision) { mPrecision = aPrecision; }t(GetRootDelayN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKIH    uint32_t GetRootDelay(void) const { return HostSwap32(mRootDelay); }t(SetRootDelayN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKTS    void SetRootDelay(uint32_t aRootDelay) { mRootDelay = HostSwap32(aRootDelay); }t(GetRootDispersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKSR    uint32_t GetRootDispersion(void) const { return HostSwap32(mRootDispersion); }t(SetRootDispersionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKhg    void SetRootDispersion(uint32_t aRootDispersion) { mRootDispersion = HostSwap32(aRootDispersion); }t(GetReferenceIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKML    uint32_t GetReferenceId(void) const { return HostSwap32(mReferenceId); }t(SetReferenceIdN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKƌHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKK\[    void SetReferenceId(uint32_t aReferenceId) { mReferenceId = HostSwap32(aReferenceId); }t(GetKissCodeN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKΌHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKPO    char *GetKissCode(void) { return reinterpret_cast<char *>(&mReferenceId); }t(GetReferenceTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppK֌Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKih    uint32_t GetReferenceTimestampSeconds(void) const { return HostSwap32(mReferenceTimestampSeconds); }t(SetReferenceTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKތHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKK    void SetReferenceTimestampSeconds(uint32_t aReferenceTimestampSeconds)
    {
        mReferenceTimestampSeconds = HostSwap32(aReferenceTimestampSeconds);
    }t(GetReferenceTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKkj    uint32_t GetReferenceTimestampFraction(void) const { return HostSwap32(mReferenceTimestampFraction); }t(SetReferenceTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKK    void SetReferenceTimestampFraction(uint32_t aReferenceTimestampFraction)
    {
        mReferenceTimestampFraction = HostSwap32(aReferenceTimestampFraction);
    }t(GetOriginateTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppKKKKih    uint32_t GetOriginateTimestampSeconds(void) const { return HostSwap32(mOriginateTimestampSeconds); }t(SetOriginateTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMK    void SetOriginateTimestampSeconds(uint32_t aOriginateTimestampSeconds)
    {
        mOriginateTimestampSeconds = HostSwap32(aOriginateTimestampSeconds);
    }t(GetOriginateTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMKkj    uint32_t GetOriginateTimestampFraction(void) const { return HostSwap32(mOriginateTimestampFraction); }t(SetOriginateTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMK    void SetOriginateTimestampFraction(uint32_t aOriginateTimestampFraction)
    {
        mOriginateTimestampFraction = HostSwap32(aOriginateTimestampFraction);
    }t(GetReceiveTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM"Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM"KM"Ked    uint32_t GetReceiveTimestampSeconds(void) const { return HostSwap32(mReceiveTimestampSeconds); }t(SetReceiveTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM*Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM*KM-K    void SetReceiveTimestampSeconds(uint32_t aReceiveTimestampSeconds)
    {
        mReceiveTimestampSeconds = HostSwap32(aReceiveTimestampSeconds);
    }t(GetReceiveTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM5Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM5KM5Kgf    uint32_t GetReceiveTimestampFraction(void) const { return HostSwap32(mReceiveTimestampFraction); }t(SetReceiveTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM=Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM=KM@K    void SetReceiveTimestampFraction(uint32_t aReceiveTimestampFraction)
    {
        mReceiveTimestampFraction = HostSwap32(aReceiveTimestampFraction);
    }t(GetTransmitTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMHHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMHKMHKgf    uint32_t GetTransmitTimestampSeconds(void) const { return HostSwap32(mTransmitTimestampSeconds); }t(SetTransmitTimestampSecondsN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMPHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMPKMSK    void SetTransmitTimestampSeconds(uint32_t aTransmitTimestampSeconds)
    {
        mTransmitTimestampSeconds = HostSwap32(aTransmitTimestampSeconds);
    }t(GetTransmitTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM[Headert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM[KM[Kih    uint32_t GetTransmitTimestampFraction(void) const { return HostSwap32(mTransmitTimestampFraction); }t(SetTransmitTimestampFractionN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMcHeadert(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMcKMfK    void SetTransmitTimestampFraction(uint32_t aTransmitTimestampFraction)
    {
        mTransmitTimestampFraction = HostSwap32(aTransmitTimestampFraction);
    }t(AppendToN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM
QueryMetadatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMKON    Error AppendTo(Message &aMessage) const { return aMessage.Append(*this); }t(ReadFromN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM
QueryMetadatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMK    void ReadFrom(const Message &aMessage)
    {
        SuccessOrAssert(aMessage.Read(aMessage.GetLength() - sizeof(*this), *this));
    }t(UpdateInN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppM
QueryMetadatat(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMKlk    void UpdateIn(Message &aMessage) const { aMessage.Write(aMessage.GetLength() - sizeof(*this), *this); }t(
GetUnixEraN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMClientt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMK98    uint32_t GetUnixEra(void) const { return mUnixEra; }t(
SetUnixEraN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMClientt(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/sntp_client.hppMKMK@?    void SetUnixEra(uint32_t aUnixEra) { mUnixEra = aUnixEra; }t(	GetLengthZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKZ
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKZK	KZKED        uint8_t GetLength(void) const { return sizeof(ServerData); }t(GetSequenceNumberZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKb
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKbK	KbKJI        uint8_t GetSequenceNumber(void) const { return mSequenceNumber; }t(SetSequenceNumberZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKj
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKjK	KjK_^        void SetSequenceNumber(uint8_t aSequenceNumber) { mSequenceNumber = aSequenceNumber; }t(GetReregistrationDelayZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKr
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKrK	KrKa`        uint16_t GetReregistrationDelay(void) const { return HostSwap16(mReregistrationDelay); }t(SetReregistrationDelayZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKz
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKzK	K}K
        void SetReregistrationDelay(uint16_t aReregistrationDelay)
        {
            mReregistrationDelay = HostSwap16(aReregistrationDelay);
        }t(
GetMlrTimeoutZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppK
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKK	KKON        uint32_t GetMlrTimeout(void) const { return HostSwap32(mMlrTimeout); }t(
SetMlrTimeoutZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppK
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKK	KK\[        void SetMlrTimeout(uint32_t aMlrTimeout) { mMlrTimeout = HostSwap32(aMlrTimeout); }t(ServiceDataZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKÌServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKK	KK
        explicit ServiceData(uint8_t aSequenceNumber)
            : mServiceNumber(kServiceNumber)
            , mSequenceNumber(aSequenceNumber)
        {
            OT_UNUSED_VARIABLE(mServiceNumber);
        }t(	GetLengthZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKЌServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKK	KKFE        uint8_t GetLength(void) const { return sizeof(ServiceData); }t(GetSequenceNumberZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppK،ServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppKK	KKJI        uint8_t GetSequenceNumber(void) const { return mSequenceNumber; }t(ServiceDataZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMK	MK
X          explicit ServiceData(const Ip6::Address &aAddress, uint16_t aPort)
            : mServiceNumber(kServiceNumber)
            , mAddress(aAddress)
            , mPort(HostSwap16(aPort))
        {
            OT_UNUSED_VARIABLE(mServiceNumber);
        }t(	GetLengthZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM%ServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM%K	M%KFE        uint8_t GetLength(void) const { return sizeof(ServiceData); }t(
GetAddressZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM-ServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM-K	M-KHG        const Ip6::Address &GetAddress(void) const { return mAddress; }t(GetPortZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM5ServiceDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM5K	M5KCB        uint16_t GetPort(void) const { return HostSwap16(mPort); }t(
ServerDataZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppML
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMLK	MPK
        ServerData(const Ip6::Address &aAddress, uint16_t aPort)
            : mAddress(aAddress)
            , mPort(HostSwap16(aPort))
        {
        }t(	GetLengthZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMX
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMXK	MXKED        uint8_t GetLength(void) const { return sizeof(ServerData); }t(
GetAddressZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM`
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppM`K	M`KHG        const Ip6::Address &GetAddress(void) const { return mAddress; }t(GetPortZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMh
ServerDatat(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMhK	MhKCB        uint16_t GetPort(void) const { return HostSwap16(mPort); }t(IteratorZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMIteratort(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMK	MK
r        Iterator(void)
            : mServiceTlv(nullptr)
            , mServerSubTlv(nullptr)
        {
        }t(ResetZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMIteratort(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMK	MK
v        void Reset(void)
        {
            mServiceTlv   = nullptr;
            mServerSubTlv = nullptr;
        }t(ManagerZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMKZ    explicit Manager(Instance &aInstance)
        : InstanceLocator(aInstance)
    {
    }t(AddZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMKX7      template <typename ServiceType>
    Error Add(const typename ServiceType::ServerData &aServerData, bool aServerStable = true)
    {
        return AddService(&ServiceType::kServiceData, sizeof(ServiceType::kServiceData), aServerStable, &aServerData,
                          aServerData.GetLength());
    }t(AddZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMK    template <typename ServiceType>
    Error Add(const typename ServiceType::ServiceData &aServiceData, bool aServerStable = true)
    {
        return AddService(&aServiceData, aServiceData.GetLength(), aServerStable, nullptr, 0);
    }t(RemoveZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMK    template <typename ServiceType> Error Remove(void)
    {
        return RemoveService(&ServiceType::kServiceData, sizeof(ServiceType::kServiceData));
    }t(RemoveZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMK    template <typename ServiceType> Error Remove(const typename ServiceType::ServiceData &aServiceData)
    {
        return RemoveService(&aServiceData, aServiceData.GetLength());
    }t(GetServiceIdZ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMManagert(Z/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_service.hppMKMK    template <typename ServiceType> Error GetServiceId(bool aServerStable, uint8_t &aServiceId) const
    {
        return GetServiceId(&ServiceType::kServiceData, sizeof(ServiceType::kServiceData), aServerStable, aServiceId);
    }t(GetNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK:9        const char *GetName(void) const { return mName; }t(IsAutoAddressEnabledM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKGF        bool IsAutoAddressEnabled(void) const { return mAutoAddress; }t(GetNumAddressesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKFE        uint8_t GetNumAddresses(void) const { return mNumAddresses; }t(
GetAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKih        const Ip6::Address &GetAddress(uint8_t aIndex) const { return AsCoreType(&mAddresses[aIndex]); }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKRQ        ItemState GetState(void) const { return static_cast<ItemState>(mState); }t(SetNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKHostInfot(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK;:        void SetName(const char *aName) { mName = aName; }t(GetNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKȌServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK:9        const char *GetName(void) const { return mName; }t(GetInstanceNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKЌServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKJI        const char *GetInstanceName(void) const { return mInstanceName; }t(
HasSubTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKٌServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KKLK        bool HasSubType(void) const { return (mSubTypeLabels != nullptr); }t(GetSubTypeLabelAtM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK`_        const char *GetSubTypeLabelAt(uint16_t aIndex) const { return mSubTypeLabels[aIndex]; }t(GetPortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK76        uint16_t GetPort(void) const { return mPort; }t(GetPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK?>        uint16_t GetPriority(void) const { return mPriority; }t(	GetWeightM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppKK	KK;:        uint16_t GetWeight(void) const { return mWeight; }t(
GetTxtEntriesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MK^]        const Dns::TxtEntry *GetTxtEntries(void) const { return AsCoreTypePtr(mTxtEntries); }t(GetNumTxtEntriesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKHG        uint8_t GetNumTxtEntries(void) const { return mNumTxtEntries; }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKRQ        ItemState GetState(void) const { return static_cast<ItemState>(mState); }t(GetLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKHG        uint32_t GetLease(void) const { return (mLease & kLeaseMask); }t(GetKeyLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM&Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM&K	M&K?>        uint32_t GetKeyLease(void) const { return mKeyLease; }t(GetLeaseRenewTimeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM3Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM3K	M3KML        TimeMilli GetLeaseRenewTime(void) const { return TimeMilli(mData); }t(SetLeaseRenewTimeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM4Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM4K	M4KSR        void      SetLeaseRenewTime(TimeMilli aTime) { mData = aTime.GetValue(); }t(IsAppendedInMessageM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM5Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM5K	M5KZY        bool      IsAppendedInMessage(void) const { return mLease & kAppendedInMsgFlag; }t(MarkAsAppendedInMessageM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM6Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM6K	M6KRQ        void      MarkAsAppendedInMessage(void) { mLease |= kAppendedInMsgFlag; }t(ClearAppendedInMessageFlagM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM7Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM7K	M7KVU        void      ClearAppendedInMessageFlag(void) { mLease &= ~kAppendedInMsgFlag; }t(MatchesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM9Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM9K	M9KSR        bool      Matches(ItemState aState) const { return GetState() == aState; }t(StartM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM\Clientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM\KM\Kih    Error Start(const Ip6::SockAddr &aServerSockAddr) { return Start(aServerSockAddr, kRequesterUser); }t(StopM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMhClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMhKMhKCB    void Stop(void) { Stop(kRequesterUser, kResetRetryInterval); }t(DisableAutoStartModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKSR    void DisableAutoStartMode(void) { mAutoStart.SetState(AutoStart::kDisabled); }t(IsAutoStartModeEnabledM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKfe    bool IsAutoStartModeEnabled(void) const { return mAutoStart.GetState() != AutoStart::kDisabled; }t(IsServerSelectedByAutoStartM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK\[    bool IsServerSelectedByAutoStart(void) const { return mAutoStart.HasSelectedServer(); }t(	IsRunningM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKED    bool IsRunning(void) const { return (mState != kStateStopped); }t(GetServerAddressM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKXW    const Ip6::SockAddr &GetServerAddress(void) const { return mSocket.GetPeerName(); }t(SetCallbackM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKgf    void SetCallback(ClientCallback aCallback, void *aContext) { mCallback.Set(aCallback, aContext); }t(GetTtlM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK10    uint32_t GetTtl(void) const { return mTtl; }t(SetTtlM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK0/    void SetTtl(uint32_t aTtl) { mTtl = aTtl; }t(GetLeaseIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKDC    uint32_t GetLeaseInterval(void) const { return mDefaultLease; }t(SetLeaseIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM Clientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM KM Kts    void SetLeaseInterval(uint32_t aInterval) { mDefaultLease = DetermineLeaseInterval(aInterval, kDefaultLease); }t(GetKeyLeaseIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKJI    uint32_t GetKeyLeaseInterval(void) const { return mDefaultKeyLease; }t(SetKeyLeaseIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK    void SetKeyLeaseInterval(uint32_t aInterval)
    {
        mDefaultKeyLease = DetermineLeaseInterval(aInterval, kDefaultKeyLease);
    }t(GetHostInfoM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKBA    const HostInfo &GetHostInfo(void) const { return mHostInfo; }t(GetServicesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKML    const LinkedList<Service> &GetServices(void) const { return mServices; }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MK87        State   GetState(void) const { return mState; }t(GetAnycastSeqNumM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKHG        uint8_t GetAnycastSeqNum(void) const { return mAnycastSeqNum; }t(SetAnycastSeqNumM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MK^]        void    SetAnycastSeqNum(uint8_t aAnycastSeqNum) { mAnycastSeqNum = aAnycastSeqNum; }t(SetCallbackM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKqp        void    SetCallback(AutoStartCallback aCallback, void *aContext) { mCallback.Set(aCallback, aContext); }t(GetTimoutFailureCountM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKRQ        uint8_t GetTimoutFailureCount(void) const { return mTimoutFailureCount; }t(ResetTimoutFailureCountM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MKKJ        void    ResetTimoutFailureCount(void) { mTimoutFailureCount = 0; }t(IncrementTimoutFailureCountM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppM	AutoStartt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMK	MK
        void    IncrementTimoutFailureCount(void)
        {
            if (mTimoutFailureCount < NumericLimits<uint8_t>::kMax)
            {
                mTimoutFailureCount++;
            }
        }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK98    State        GetState(void) const { return mState; }t(GetRetryWaitIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMKQP    uint32_t     GetRetryWaitInterval(void) const { return mRetryWaitInterval; }t(ResetRetryWaitIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK^]    void         ResetRetryWaitInterval(void) { mRetryWaitInterval = kMinRetryWaitInterval; }t(LogRetryWaitIntervalM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMClientt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_client.hppMKMK-,    void LogRetryWaitInterval(void) const {}t(operator newI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/new.hppK+Nt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/new.hppK+KK+KA@inline void *operator new(size_t, void *p) throw() { return p; }t(AllocateV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hpp$      KIAllocatablet(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hppKIKKNK    template <typename... Args> static Type *Allocate(Args &&...aArgs)
    {
        void *buf = Heap::CAlloc(1, sizeof(Type));

        return (buf != nullptr) ? new (buf) Type(static_cast<Args &&>(aArgs)...) : nullptr;
    }t(AllocateAndInitV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hppK\Allocatablet(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hppK\KKmKX      template <typename... Args> static Type *AllocateAndInit(Args &&...aArgs)
    {
        void *buf    = Heap::CAlloc(1, sizeof(Type));
        Type *object = nullptr;

        VerifyOrExit(buf != nullptr);

        object = new (buf) Type();

        if (object->Init(static_cast<Args &&>(aArgs)...) != kErrorNone)
        {
            object->Free();
            object = nullptr;
        }

    exit:
        return object;
    }t(FreeV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hppKyAllocatablet(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_allocatable.hppKyKK}Ke    void Free(void)
    {
        static_cast<Type *>(this)->~Type();
        Heap::Free(this);
    }t( Array<Type, kCapacityIncrements>P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKPKa    Array(void)
        : mArray(nullptr)
        , mLength(0)
        , mCapacity(0)
    {
    }t(FreeP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppK^Arrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppK^KKdK    void Free(void)
    {
        Clear();
        Heap::Free(mArray);
        mArray    = nullptr;
        mCapacity = 0;
    }t(ClearP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKoArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKoKKwK    void Clear(void)
    {
        for (Type &entry : *this)
        {
            entry.~Type();
        }

        mLength = 0;
    }t(	GetLengthP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKK87    IndexType GetLength(void) const { return mLength; }t(AsCArrayP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKSR    const Type *AsCArray(void) const { return (mLength != 0) ? mArray : nullptr; }t(GetCapacityP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKK<;    IndexType GetCapacity(void) const { return mCapacity; }t(ReserveCapacityP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKON    Error ReserveCapacity(IndexType aCapacity) { return Allocate(aCapacity); }t(TakeFromP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKX      void TakeFrom(Array &&aOther)
    {
        Free();
        mArray           = aOther.mArray;
        mLength          = aOther.mLength;
        mCapacity        = aOther.mCapacity;
        aOther.mArray    = nullptr;
        aOther.mLength   = 0;
        aOther.mCapacity = 0;
    }t(
operator[]P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKBA    Type &operator[](IndexType aIndex) { return mArray[aIndex]; }t(
operator[]P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKˌArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKNM    const Type &operator[](IndexType aIndex) const { return mArray[aIndex]; }t(AtP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppK،Arrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKZY    Type *At(IndexType aIndex) { return (aIndex < mLength) ? &mArray[aIndex] : nullptr; }t(AtP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKKfe    const Type *At(IndexType aIndex) const { return (aIndex < mLength) ? &mArray[aIndex] : nullptr; }t(FrontP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKK('    Type *Front(void) { return At(0); }t(FrontP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppKKKK43    const Type *Front(void) const { return At(0); }t(BackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKPO    Type *Back(void) { return (mLength > 0) ? &mArray[mLength - 1] : nullptr; }t(BackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM
Arrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM
KM
K\[    const Type *Back(void) const { return (mLength > 0) ? &mArray[mLength - 1] : nullptr; }t(PushBackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKM(KX*      Error PushBack(const Type &aEntry)
    {
        Error error = kErrorNone;

        if (mLength == mCapacity)
        {
            SuccessOrExit(error = Allocate(mCapacity + kCapacityIncrements));
        }

        new (&mArray[mLength++]) Type(aEntry);

    exit:
        return error;
    }t(PushBackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM6Arrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM6KMCKX;      Error PushBack(Type &&aEntry)
    {
        Error error = kErrorNone;

        if (mLength == mCapacity)
        {
            SuccessOrExit(error = Allocate(mCapacity + kCapacityIncrements));
        }

        new (&mArray[mLength++]) Type(static_cast<Type &&>(aEntry));

    exit:
        return error;
    }t(PushBackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMQArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMQKM^KX      Type *PushBack(void)
    {
        Type *newEntry = nullptr;

        if (mLength == mCapacity)
        {
            SuccessOrExit(Allocate(mCapacity + kCapacityIncrements));
        }

        newEntry = new (&mArray[mLength++]) Type();

    exit:
        return newEntry;
    }t(PopBackP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMfArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMfKMmK    void PopBack(void)
    {
        if (mLength > 0)
        {
            mArray[mLength - 1].~Type();
            mLength--;
        }
    }t(IndexOfP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMyArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMyKMyKih    IndexType IndexOf(const Type &aElement) const { return static_cast<IndexType>(&aElement - mArray); }t(FindP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKWV    Type *Find(const Type &aEntry) { return AsNonConst(AsConst(this)->Find(aEntry)); }t(FindP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKX3      const Type *Find(const Type &aEntry) const
    {
        const Type *matched = nullptr;

        for (const Type &element : *this)
        {
            if (element == aEntry)
            {
                matched = &element;
                break;
            }
        }

        return matched;
    }t(ContainsP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKPO    bool Contains(const Type &aEntry) const { return Find(aEntry) != nullptr; }t(FindMatchingP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMK    template <typename Indicator> Type *FindMatching(const Indicator &aIndicator)
    {
        return AsNonConst(AsConst(this)->FindMatching(aIndicator));
    }t(FindMatchingP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKXl      template <typename Indicator> const Type *FindMatching(const Indicator &aIndicator) const
    {
        const Type *matched = nullptr;

        for (const Type &element : *this)
        {
            if (element.Matches(aIndicator))
            {
                matched = &element;
                break;
            }
        }

        return matched;
    }t(ContainsMatchingP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMK    template <typename Indicator> bool ContainsMatching(const Indicator &aIndicator) const
    {
        return FindMatching(aIndicator) != nullptr;
    }t(beginP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKIH    Type       *begin(void) { return (mLength > 0) ? mArray : nullptr; }t(endP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKQP    Type       *end(void) { return (mLength > 0) ? &mArray[mLength] : nullptr; }t(beginP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKON    const Type *begin(void) const { return (mLength > 0) ? mArray : nullptr; }t(endP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM Arrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppM KM KWV    const Type *end(void) const { return (mLength > 0) ? &mArray[mLength] : nullptr; }t(AllocateP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMArrayt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_array.hppMKMKX      Error Allocate(IndexType aCapacity)
    {
        Error error = kErrorNone;
        Type *newArray;

        VerifyOrExit((aCapacity != mCapacity) && (aCapacity >= mLength));
        newArray = static_cast<Type *>(Heap::CAlloc(aCapacity, sizeof(Type)));
        VerifyOrExit(newArray != nullptr, error = kErrorNoBufs);

        for (IndexType index = 0; index < mLength; index++)
        {
            new (&newArray[index]) Type(static_cast<Type &&>(mArray[index]));
            mArray[index].~Type();
        }

        Heap::Free(mArray);
        mArray    = newArray;
        mCapacity = aCapacity;

    exit:
        return error;
    }t(DataO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppK9Datat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppK9KK9K+*    Data(void) { mData.Init(nullptr, 0); }t(DataO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKDDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKDKKDK,+    Data(Data &&aData) { TakeFrom(aData); }t(IsNullO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKTDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKTKKTKFE    bool IsNull(void) const { return (mData.GetBytes() == nullptr); }t(GetBytesO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppK\Datat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppK\KK\KED    const uint8_t *GetBytes(void) const { return mData.GetBytes(); }t(	GetLengthO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKdDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKdKKdKA@    uint16_t GetLength(void) const { return mData.GetLength(); }t(CopyBytesToO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKKKKut    Error CopyBytesTo(Message &aMessage) const { return aMessage.AppendBytes(mData.GetBytes(), mData.GetLength()); }t(CopyBytesToO/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKDatat(O/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_data.hppKKKKTS    void CopyBytesTo(uint8_t *aBuffer) const { return mData.CopyBytesTo(aBuffer); }t(StringQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK=Stringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK=KK@K=    String(void)
        : mStringBuffer(nullptr)
    {
    }t(StringQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKIStringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKIKKMK    String(String &&aString)
        : mStringBuffer(aString.mStringBuffer)
    {
        aString.mStringBuffer = nullptr;
    }t(IsNullQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK]Stringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK]KK]KCB    bool IsNull(void) const { return (mStringBuffer == nullptr); }t(	AsCStringQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKeStringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKeKKeK@?    const char *AsCString(void) const { return mStringBuffer; }t(SetQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK{Stringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppK{KK{KJI    Error Set(const String &aString) { return Set(aString.AsCString()); }t(
operator!=Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKStringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKKKKQP    bool operator!=(const char *aCString) const { return !(*this == aCString); }t(
operator==Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKStringt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/heap_string.hppKKKK\[    bool operator==(const String &aString) const { return (*this == aString.AsCString()); }t(	Ptr<Type>Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppK;Ptrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppK;KK>K5    Ptr(void)
        : mPointer(nullptr)
    {
    }t(	Ptr<Type>Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKFPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKFKKIKI    explicit Ptr(Type *aPointer)
        : mPointer(aPointer)
    {
    }t(IsNullQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKRPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKRKKRK>=    bool IsNull(void) const { return (mPointer == nullptr); }t(GetQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKZPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKZKKZK)(    Type *Get(void) { return mPointer; }t(GetQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKbPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKbKKbK54    const Type *Get(void) const { return mPointer; }t(
operator->Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKjPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKjKKjK0/    Type *operator->(void) { return mPointer; }t(
operator->Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKrPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKrKKrK<;    const Type *operator->(void) const { return mPointer; }t(	operator*Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppK|Ptrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppK|KK|K0/    Type &operator*(void) { return *mPointer; }t(	operator*Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKKKK<;    const Type &operator*(void) const { return *mPointer; }t(
operator==Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKKKKSR    bool operator==(const Type *aPointer) const { return (mPointer == aPointer); }t(
operator!=Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKKKKSR    bool operator!=(const Type *aPointer) const { return (mPointer != aPointer); }t(
operator==Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKKKKWV    bool operator==(const Ptr &aOther) const { return (mPointer == aOther.mPointer); }t(
operator!=Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKPtrt(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/ptr_wrapper.hppKKKKWV    bool operator!=(const Ptr &aOther) const { return (mPointer != aOther.mPointer); }t(RetainPtr<Type>P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKM	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKMKKQKp    explicit RetainPtr(Type *aPointer)
        : Ptr<Type>(aPointer)
    {
        IncrementRetainCount();
    }t(RetainPtr<Type>P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKY	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKYKK]Kw    RetainPtr(const RetainPtr &aOther)
        : Ptr<Type>(aOther.mPointer)
    {
        IncrementRetainCount();
    }t(ResetP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKq	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKqKKyK    void Reset(Type *aPointer = nullptr)
    {
        if (aPointer != mPointer)
        {
            DecrementRetainCount();
            mPointer = aPointer;
            IncrementRetainCount();
        }
    }t(ReleaseP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppK	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKK~    Type *Release(void)
    {
        Type *pointer = mPointer;
        mPointer      = nullptr;
        return pointer;
    }t(	operator=P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppK	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKKs    RetainPtr &operator=(const RetainPtr &aOther)
    {
        Reset(aOther.mPointer);
        return *this;
    }t(IncrementRetainCountP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppK	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKK    void IncrementRetainCount(void)
    {
        if (mPointer != nullptr)
        {
            mPointer->IncrementRetainCount();
        }
    }t(DecrementRetainCountP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppK	RetainPtrt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKK    void DecrementRetainCount(void)
    {
        if ((mPointer != nullptr) && (mPointer->DecrementRetainCount() == 0))
        {
            mPointer->Free();
        }
    }t(RetainCountableP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKRetainCountablet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKK?    RetainCountable(void)
        : mRetainCount(0)
    {
    }t(GetRetainCountP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKǌRetainCountablet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKKA@    uint16_t GetRetainCount(void) const { return mRetainCount; }t(IncrementRetainCountP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppK͌RetainCountablet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKK87    void IncrementRetainCount(void) { ++mRetainCount; }t(DecrementRetainCountP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKՌRetainCountablet(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/retain_ptr.hppKKKKCB    uint16_t DecrementRetainCount(void) { return --mRetainCount; }t(SetDnsSrpServiceCallback\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKK    void SetDnsSrpServiceCallback(DnsSrpServiceCallback aCallback, void *aContext)
    {
        mDnsSrpServiceEntry.SetCallback(aCallback, aContext);
    }t(PublishDnsSrpServiceAnycast\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKKwv    void PublishDnsSrpServiceAnycast(uint8_t aSequenceNumber) { mDnsSrpServiceEntry.PublishAnycast(aSequenceNumber); }t(PublishDnsSrpServiceUnicast\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKK    void PublishDnsSrpServiceUnicast(const Ip6::Address &aAddress, uint16_t aPort)
    {
        mDnsSrpServiceEntry.PublishUnicast(aAddress, aPort);
    }t(PublishDnsSrpServiceUnicast\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKKdc    void PublishDnsSrpServiceUnicast(uint16_t aPort) { mDnsSrpServiceEntry.PublishUnicast(aPort); }t(IsDnsSrpServiceAdded\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKKTS    bool IsDnsSrpServiceAdded(void) const { return mDnsSrpServiceEntry.IsAdded(); }t(UnpublishDnsSrpService\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKKKJ    void UnpublishDnsSrpService(void) { mDnsSrpServiceEntry.Unpublish(); }t(SetPrefixCallback\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppK،	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppKKKKsr    void SetPrefixCallback(PrefixCallback aCallback, void *aContext) { mPrefixCallback.Set(aCallback, aContext); }t(Entry\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM<Entryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM<K	M?K
F        Entry(void)
            : mState(kNoEntry)
        {
        }t(Init\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMAEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMAK	MAK]\        void             Init(Instance &aInstance) { InstanceLocatorInit::Init(aInstance); }t(GetState\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMBEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMBK	MBKA@        State            GetState(void) const { return mState; }t(
GetUpdateTime\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMDEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMDK	MDKKJ        const TimeMilli &GetUpdateTime(void) const { return mUpdateTime; }t(IsAdded\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMKEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMKK	MKK@?        bool IsAdded(void) const { return (mState == kAdded); }t(SetCallback\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM^DnsSrpServiceEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM^K	M^Krq        void SetCallback(DnsSrpServiceCallback aCallback, void *aContext) { mCallback.Set(aCallback, aContext); }t(HandleTimer\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMcDnsSrpServiceEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMcK	McK98        void HandleTimer(void) { Entry::HandleTimer(); }t(Info\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMwInfot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMwK
MwK$#            Info(void) { Clear(); }t(GetType\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMxInfot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMxK
MxKFE            Type                GetType(void) const { return mType; }t(GetSequenceNumber\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMyInfot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMyK
MyKqp            uint8_t             GetSequenceNumber(void) const { return static_cast<uint8_t>(mPortOrSeqNumber); }t(GetPort\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMzInfot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMzK
MzKQP            uint16_t            GetPort(void) const { return mPortOrSeqNumber; }t(
GetAddress\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM{Infot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM{K
M{KLK            const Ip6::Address &GetAddress(void) const { return mAddress; }t(
SetAddress\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM|Infot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM|K
M|Kba            void                SetAddress(const Ip6::Address &aAddress) { mAddress = aAddress; }t(InfoAnycast\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM~Infot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM~K
M~Kml            static Info InfoAnycast(uint8_t aSequenceNumber) { return Info(kTypeAnycast, aSequenceNumber); }t(InfoUnicast\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMInfot(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK
MK            static Info InfoUnicast(Type aType, const Ip6::Address &aAddress, uint16_t aPort)
            {
                return Info(aType, aPort, &aAddress);
            }t(GetType\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMDnsSrpServiceEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MK=<        Type GetType(void) const { return mInfo.GetType(); }t(Init\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMPrefixEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MKHG        void      Init(Instance &aInstance) { Entry::Init(aInstance); }t(IsInUse\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMPrefixEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MKIH        bool      IsInUse(void) const { return GetState() != kNoEntry; }t(Matches\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMPrefixEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MK[Z        bool      Matches(const Ip6::Prefix &aPrefix) const { return mPrefix == aPrefix; }t(GetRequester\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMPrefixEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MKBA        Requester GetRequester(void) const { return mRequester; }t(HandleTimer\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMPrefixEntryt(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMK	MK>=        void      HandleTimer(void) { Entry::HandleTimer(); }t(IsADnsSrpServiceEntry\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMKMKhg    bool IsADnsSrpServiceEntry(const Entry &aEntry) const { return (&aEntry == &mDnsSrpServiceEntry); }t(GetTimer\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppM	Publishert(\/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_publisher.hppMKMK21    TimerMilli &GetTimer(void) { return mTimer; }t(	IsDeletedM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKK	KK:9        bool IsDeleted(void) const { return mIsDeleted; }t(	IsSubTypeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKK	KK:9        bool IsSubType(void) const { return mIsSubType; }t(GetInstanceNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppKK	KKdc        const char *GetInstanceName(void) const { return mDescription->mInstanceName.AsCString(); }t(GetServiceNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM K	M KTS        const char *GetServiceName(void) const { return mServiceName.AsCString(); }t(GetTtlM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKCB        uint32_t GetTtl(void) const { return mDescription->mTtl; }t(GetPortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM#Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM#K	M#KED        uint16_t GetPort(void) const { return mDescription->mPort; }t(	GetWeightM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM+Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM+K	M+KIH        uint16_t GetWeight(void) const { return mDescription->mWeight; }t(GetPriorityM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM3Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM3K	M3KML        uint16_t GetPriority(void) const { return mDescription->mPriority; }t(
GetTxtDataM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM;Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM;K	M;K\[        const uint8_t *GetTxtData(void) const { return mDescription->mTxtData.GetBytes(); }t(GetTxtDataLengthM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMCServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMCK	MCK]\        uint16_t GetTxtDataLength(void) const { return mDescription->mTxtData.GetLength(); }t(GetHostM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKK	MKKIH        const Host &GetHost(void) const { return *mDescription->mHost; }t(GetLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMSServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMSK	MSKGF        uint32_t GetLease(void) const { return mDescription->mLease; }t(GetKeyLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM[Servicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM[K	M[KML        uint32_t GetKeyLease(void) const { return mDescription->mKeyLease; }t(GetInstanceNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMDescriptiont(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK
MKZY            const char *GetInstanceName(void) const { return mInstanceName.AsCString(); }t(
GetUpdateTimeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServicet(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKKJ        const TimeMilli &GetUpdateTime(void) const { return mUpdateTime; }t(	IsDeletedM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK=<        bool IsDeleted(void) const { return (mLease == 0); }t(GetFullNameM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKNM        const char *GetFullName(void) const { return mFullName.AsCString(); }t(GetAddressesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK
        const Ip6::Address *GetAddresses(uint8_t &aAddressesNum) const
        {
            aAddressesNum = ClampToUint8(mAddresses.GetLength());

            return mAddresses.AsCArray();
        }t(GetTtlM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK54        uint32_t GetTtl(void) const { return mTtl; }t(GetLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK98        uint32_t GetLease(void) const { return mLease; }t(GetKeyLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK?>        uint32_t GetKeyLease(void) const { return mKeyLease; }t(GetKeyRecordM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKxw        const Dns::Ecdsa256KeyRecord *GetKeyRecord(void) const { return mKeyRecord.IsValid() ? &mKeyRecord : nullptr; }t(GetServicesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM/Hostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM/K	M/KQP        const LinkedList<Service> &GetServices(void) const { return mServices; }t(SetTtlM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMQHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMQK	MQK54        void  SetTtl(uint32_t aTtl) { mTtl = aTtl; }t(SetLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMRHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMRK	MRK=<        void  SetLease(uint32_t aLease) { mLease = aLease; }t(SetKeyLeaseM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMSHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMSK	MSKIH        void  SetKeyLease(uint32_t aKeyLease) { mKeyLease = aKeyLease; }t(GetServicesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMVHostt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMVK	MVKED        LinkedList<Service> &GetServices(void) { return mServices; }t(IsValidM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM	TtlConfigt(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKDC        bool     IsValid(void) const { return mMinTtl <= mMaxTtl; }t(SetServiceHandlerM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKMK    void SetServiceHandler(otSrpServerServiceUpdateHandler aServiceHandler, void *aServiceHandlerContext)
    {
        mServiceUpdateHandler.Set(aServiceHandler, aServiceHandlerContext);
    }t(	GetDomainM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKMKFE    const char *GetDomain(void) const { return mDomain.AsCString(); }t(GetAddressModeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKMKDC    AddressMode GetAddressMode(void) const { return mAddressMode; }t(GetAnycastModeSequenceNumberM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM
Servert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM
KM
KXW    uint8_t GetAnycastModeSequenceNumber(void) const { return mAnycastSequenceNumber; }t(GetStateM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM Servert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM KM K21    State GetState(void) const { return mState; }t(GetPortM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM(Servert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppM(KM(KSR    uint16_t GetPort(void) const { return (mState == kStateRunning) ? mPort : 0; }t(GetTtlConfigM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUKMUKPO    void GetTtlConfig(TtlConfig &aTtlConfig) const { aTtlConfig = mTtlConfig; }t(GetLeaseConfigM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMhServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMhKMhKZY    void GetLeaseConfig(LeaseConfig &aLeaseConfig) const { aLeaseConfig = mLeaseConfig; }t(GetResponseCountersM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKMKfe    const otSrpServerResponseCounters *GetResponseCounters(void) const { return &mResponseCounters; }t(IsDirectRxFromClientM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMMessageMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKTS        bool IsDirectRxFromClient(void) const { return (mMessageInfo != nullptr); }t(
GetExpireTimeM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKSR        TimeMilli                GetExpireTime(void) const { return mExpireTime; }t(GetDnsHeaderM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKQP        const Dns::UpdateHeader &GetDnsHeader(void) const { return mDnsHeader; }t(GetIdM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKCB        ServiceUpdateId          GetId(void) const { return mId; }t(GetTtlConfigM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKQP        const TtlConfig         &GetTtlConfig(void) const { return mTtlConfig; }t(GetLeaseConfigM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKUT        const LeaseConfig       &GetLeaseConfig(void) const { return mLeaseConfig; }t(GetHostM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKA@        Host                    &GetHost(void) { return mHost; }t(GetMessageInfoM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKUT        const Ip6::MessageInfo  &GetMessageInfo(void) const { return mMessageInfo; }t(IsDirectRxFromClientM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MKdc        bool                     IsDirectRxFromClient(void) const { return mIsDirectRxFromClient; }t(MatchesM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMUpdateMetadatat(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMK	MK[Z        bool                     Matches(ServiceUpdateId aId) const { return mId == aId; }t(
AllocateIdM/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMServert(M/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/srp_server.hppMKMKDC    ServiceUpdateId AllocateId(void) { return mServiceUpdateId++; }t(GetEntryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKWIteratort(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKWK	KWKsr        const CacheEntry     *GetEntry(void) const { return static_cast<const CacheEntry *>(mData[kEntryIndex]); }t(SetEntryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKXIteratort(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKXK	KXKba        void                  SetEntry(const CacheEntry *aEntry) { mData[kEntryIndex] = aEntry; }t(GetListV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKYIteratort(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKYK	KYKut        const CacheEntryList *GetList(void) const { return static_cast<const CacheEntryList *>(mData[kListIndex]); }t(SetListV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKZIteratort(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKZK	KZKba        void                  SetList(const CacheEntryList *aList) { mData[kListIndex] = aList; }t(ResolveV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKAddressResolvert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKKKK    Error Resolve(const Ip6::Address &aEid, Mac::ShortAddress &aRloc16)
    {
        return Resolve(aEid, aRloc16, /* aAllowAddressQuery */ true);
    }t(	GetTargetV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppK
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKK	KKFE        const Ip6::Address &GetTarget(void) const { return mTarget; }t(	SetTargetV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppK
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppKK	KKZY        void                SetTarget(const Ip6::Address &aTarget) { mTarget = aTarget; }t(	GetRloc16V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKDC        Mac::ShortAddress GetRloc16(void) const { return mRloc16; }t(	SetRloc16V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKVU        void              SetRloc16(Mac::ShortAddress aRloc16) { mRloc16 = aRloc16; }t(GetMeshLocalIidV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKlk        const Ip6::InterfaceIdentifier &GetMeshLocalIid(void) const { return mInfo.mCached.mMeshLocalIid; }t(SetMeshLocalIidV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKkj        void SetMeshLocalIid(const Ip6::InterfaceIdentifier &aIid) { mInfo.mCached.mMeshLocalIid = aIid; }t(GetLastTransactionTimeV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKcb        uint32_t GetLastTransactionTime(void) const { return mInfo.mCached.mLastTransactionTime; }t(SetLastTransactionTimeV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKhg        void     SetLastTransactionTime(uint32_t aTime) { mInfo.mCached.mLastTransactionTime = aTime; }t(IsLastTransactionTimeValidV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM	
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM	K	M	Kvu        bool     IsLastTransactionTimeValid(void) const { return GetLastTransactionTime() != kInvalidLastTransTime; }t( MarkLastTransactionTimeAsInvalidV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM

CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
K	M
Kkj        void     MarkLastTransactionTimeAsInvalid(void) { SetLastTransactionTime(kInvalidLastTransTime); }t(DecrementTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKED        void     DecrementTimeout(void) { mInfo.mOther.mTimeout--; }t(
IsTimeoutZeroV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM

CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
K	M
KRQ        bool     IsTimeoutZero(void) const { return mInfo.mOther.mTimeout == 0; }t(
GetTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKJI        uint16_t GetTimeout(void) const { return mInfo.mOther.mTimeout; }t(
SetTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKUT        void     SetTimeout(uint16_t aTimeout) { mInfo.mOther.mTimeout = aTimeout; }t(
GetRetryDelayV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKPO        uint16_t GetRetryDelay(void) const { return mInfo.mOther.mRetryDelay; }t(
SetRetryDelayV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKWV        void     SetRetryDelay(uint16_t aDelay) { mInfo.mOther.mRetryDelay = aDelay; }t(CanEvictV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKED        bool CanEvict(void) const { return mInfo.mOther.mCanEvict; }t(SetCanEvictV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKQP        void SetCanEvict(bool aCanEvict) { mInfo.mOther.mCanEvict = aCanEvict; }t(MatchesV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppM
CacheEntryt(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMK	MKUT        bool Matches(const Ip6::Address &aEid) const { return GetTarget() == aEid; }t(GetCacheEntryPoolV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMLAddressResolvert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/address_resolver.hppMLKMLKHG    CacheEntryPool &GetCacheEntryPool(void) { return mCacheEntryPool; }t(	IsRunningU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKlAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKlKKlK>=    bool IsRunning(void) const { return mTimer.IsRunning(); }t(	GetPeriodU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKtAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKtKKtK76    uint32_t GetPeriod(void) const { return mPeriod; }t(	SetPeriodU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKKKK<;    void SetPeriod(uint32_t aPeriod) { mPeriod = aPeriod; }t(	GetJitterU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKKKK76    uint16_t GetJitter(void) const { return mJitter; }t(	SetJitterU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKKKK<;    void SetJitter(uint16_t aJitter) { mJitter = aJitter; }t(GetChannelMaskU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKKKKON    const Mac::ChannelMask GetChannelMask(void) const { return mChannelMask; }t(GetStartingChannelU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKAnnounceSenderBaset(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/announce_sender.hppKKKKHG    uint8_t GetStartingChannel(void) const { return mStartingChannel; }t(GetExternalPollPeriodS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_sender.hppKDataPollSendert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_sender.hppKKKKON    uint32_t GetExternalPollPeriod(void) const { return mExternalPollPeriod; }t(HandlePollTimerS/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_sender.hppMDataPollSendert(S/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/mac/data_poll_sender.hppMKMKKJ    void            HandlePollTimer(void) { IgnoreError(SendDataPoll()); }t(GetPanIdT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKZThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKZKKZK76    Mac::PanId GetPanId(void) const { return mPanId; }t(
GetChannelT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKbThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKbKKbK87    uint8_t GetChannel(void) const { return mChannel; }t(IsDstPanIdBroadcastT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKkThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKkKKkKJI    bool IsDstPanIdBroadcast(void) const { return mIsDstPanIdBroadcast; }t(IsLinkSecurityEnabledT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKtThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKtKKtKED    bool IsLinkSecurityEnabled(void) const { return mLinkSecurity; }t(GetRssT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppK|ThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppK|KK|K/.    int8_t GetRss(void) const { return mRss; }t(GetLqiT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKThreadLinkInfot(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppKKKK0/    uint8_t GetLqi(void) const { return mLqi; }t(GetSendQueueT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM"
MeshForwardert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM"KM"KIH    const PriorityQueue &GetSendQueue(void) const { return mSendQueue; }t(GetReassemblyQueueT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM*
MeshForwardert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM*KM*KSR    const MessageQueue &GetReassemblyQueue(void) const { return mReassemblyList; }t(GetCountersT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM2
MeshForwardert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM2KM2KHG    const otIpCounters &GetCounters(void) const { return mIpCounters; }t(
ResetCountersT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM8
MeshForwardert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM8KM8KON    void ResetCounters(void) { memset(&mIpCounters, 0, sizeof(mIpCounters)); }t(GetPriorityT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MKlk            Message::Priority GetPriority(void) const { return static_cast<Message::Priority>(mPriority); }t(	IsExpiredT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MKQP            bool              IsExpired(void) const { return (mLifetime == 0); }t(DecrementLifetimeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MKGF            void              DecrementLifetime(void) { mLifetime--; }t(
ResetLifetimeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MKML            void              ResetLifetime(void) { mLifetime = kLifetime; }t(MatchesT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MK            bool Matches(uint16_t aSrcRloc16, uint16_t aTag) const
            {
                return (mSrcRloc16 == aSrcRloc16) && (mDatagramTag == aTag);
            }t(
ShouldDropT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MK@?            bool ShouldDrop(void) const { return mShouldDrop; }t(
MarkToDropT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMEntryt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppMK
MK:9            void MarkToDrop(void) { mShouldDrop = true; }t(PauseMessageTransmissionsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM

MeshForwardert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mesh_forwarder.hppM
KM
K?>    void PauseMessageTransmissions(void) { mTxPaused = true; }t( IsAddressMlrRegisteredByAnyChildQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mlr_manager.hppK
MlrManagert(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/mlr_manager.hppKKKK    bool IsAddressMlrRegisteredByAnyChild(const Ip6::Address &aAddress) const
    {
        return IsAddressMlrRegisteredByAnyChildExcept(aAddress, nullptr);
    }t(LocalX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKJLocalt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKJKKMK~    explicit Local(Instance &aInstance)
        : MutableNetworkData(aInstance, mTlvBuffer, 0, sizeof(mTlvBuffer))
    {
    }t(RemoveOnMeshPrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKeLocalt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKeKKeK[Z    Error RemoveOnMeshPrefix(const Ip6::Prefix &aPrefix) { return RemovePrefix(aPrefix); }t(RemoveHasRoutePrefixX/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKLocalt(X/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_data_local.hppKKKK]\    Error RemoveHasRoutePrefix(const Ip6::Prefix &aPrefix) { return RemovePrefix(aPrefix); }t(GetType]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppK`NetworkDiagnosticTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppK`KK`KON    Type GetType(void) const { return static_cast<Type>(ot::Tlv::GetType()); }t(SetType]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKhNetworkDiagnosticTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKhKKhKPO    void SetType(Type aType) { ot::Tlv::SetType(static_cast<uint8_t>(aType)); }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKConnectivityTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hpp	      KKKKf    void Init(void)
    {
        Mle::ConnectivityTlv::Init();
        ot::Tlv::SetType(kType);
    }t(GetConnectivity]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKČConnectivityTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKKKKXp      void GetConnectivity(Connectivity &aConnectivity) const
    {
        aConnectivity.mParentPriority   = GetParentPriority();
        aConnectivity.mLinkQuality3     = GetLinkQuality3();
        aConnectivity.mLinkQuality2     = GetLinkQuality2();
        aConnectivity.mLinkQuality1     = GetLinkQuality1();
        aConnectivity.mLeaderCost       = GetLeaderCost();
        aConnectivity.mIdSequence       = GetIdSequence();
        aConnectivity.mActiveRouters    = GetActiveRouters();
        aConnectivity.mSedBufferSize    = GetSedBufferSize();
        aConnectivity.mSedDatagramCount = GetSedDatagramCount();
    }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKRouteTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKKKK_    void Init(void)
    {
        Mle::RouteTlv::Init();
        ot::Tlv::SetType(kType);
    }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppK
LeaderDataTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppKKKKd    void Init(void)
    {
        Mle::LeaderDataTlv::Init();
        ot::Tlv::SetType(kType);
    }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM	MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM	KM
K    void Init(void)
    {
        SetType(kMacCounters);
        SetLength(sizeof(*this) - sizeof(NetworkDiagnosticTlv));
    }t(IsValid]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKed    bool IsValid(void) const { return GetLength() >= sizeof(*this) - sizeof(NetworkDiagnosticTlv); }t(GetIfInUnknownProtos]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKYX    uint32_t GetIfInUnknownProtos(void) const { return HostSwap32(mIfInUnknownProtos); }t(SetIfInUnknownProtos]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM&MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM&KM)K    void SetIfInUnknownProtos(const uint32_t aIfInUnknownProtos)
    {
        mIfInUnknownProtos = HostSwap32(aIfInUnknownProtos);
    }t(
GetIfInErrors]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM1MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM1KM1KKJ    uint32_t GetIfInErrors(void) const { return HostSwap32(mIfInErrors); }t(
SetIfInErrors]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM9MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM9KM9K^]    void SetIfInErrors(const uint32_t aIfInErrors) { mIfInErrors = HostSwap32(aIfInErrors); }t(GetIfOutErrors]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMAMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMAKMAKML    uint32_t GetIfOutErrors(void) const { return HostSwap32(mIfOutErrors); }t(SetIfOutErrors]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMIMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMIKMIKba    void SetIfOutErrors(const uint32_t aIfOutErrors) { mIfOutErrors = HostSwap32(aIfOutErrors); }t(GetIfInUcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMQMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMQKMQKQP    uint32_t GetIfInUcastPkts(void) const { return HostSwap32(mIfInUcastPkts); }t(SetIfInUcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMYMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMYKMYKji    void SetIfInUcastPkts(const uint32_t aIfInUcastPkts) { mIfInUcastPkts = HostSwap32(aIfInUcastPkts); }t(GetIfInBroadcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM`MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM`KM`KYX    uint32_t GetIfInBroadcastPkts(void) const { return HostSwap32(mIfInBroadcastPkts); }t(SetIfInBroadcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMhMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMhKMkK    void SetIfInBroadcastPkts(const uint32_t aIfInBroadcastPkts)
    {
        mIfInBroadcastPkts = HostSwap32(aIfInBroadcastPkts);
    }t(GetIfInDiscards]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMsMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMsKMsKON    uint32_t GetIfInDiscards(void) const { return HostSwap32(mIfInDiscards); }t(SetIfInDiscards]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM{MacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM{KM{Kfe    void SetIfInDiscards(const uint32_t aIfInDiscards) { mIfInDiscards = HostSwap32(aIfInDiscards); }t(GetIfOutUcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKSR    uint32_t GetIfOutUcastPkts(void) const { return HostSwap32(mIfOutUcastPkts); }t(SetIfOutUcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKnm    void SetIfOutUcastPkts(const uint32_t aIfOutUcastPkts) { mIfOutUcastPkts = HostSwap32(aIfOutUcastPkts); }t(GetIfOutBroadcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK[Z    uint32_t GetIfOutBroadcastPkts(void) const { return HostSwap32(mIfOutBroadcastPkts); }t(SetIfOutBroadcastPkts]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK    void SetIfOutBroadcastPkts(const uint32_t aIfOutBroadcastPkts)
    {
        mIfOutBroadcastPkts = HostSwap32(aIfOutBroadcastPkts);
    }t(GetIfOutDiscards]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKQP    uint32_t GetIfOutDiscards(void) const { return HostSwap32(mIfOutDiscards); }t(SetIfOutDiscards]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMMacCountersTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKji    void SetIfOutDiscards(const uint32_t aIfOutDiscards) { mIfOutDiscards = HostSwap32(aIfOutDiscards); }t(
GetTimeout]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKfe    uint8_t GetTimeout(void) const { return (GetTimeoutChildId() & kTimeoutMask) >> kTimeoutOffset; }t(
SetTimeout]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK    void SetTimeout(uint8_t aTimeout)
    {
        SetTimeoutChildId((GetTimeoutChildId() & ~kTimeoutMask) | ((aTimeout << kTimeoutOffset) & kTimeoutMask));
    }t(GetLinkQuality]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK    LinkQuality GetLinkQuality(void) const
    {
        return static_cast<LinkQuality>((GetTimeoutChildId() & kLqiMask) >> kLqiOffset);
    }t(SetLinkQuality]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK    void SetLinkQuality(LinkQuality aLinkQuality)
    {
        SetTimeoutChildId((GetTimeoutChildId() & ~kLqiMask) | ((aLinkQuality << kLqiOffset) & kLqiMask));
    }t(
GetChildId]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKgf    uint16_t GetChildId(void) const { return (GetTimeoutChildId() & kChildIdMask) >> kChildIdOffset; }t(
SetChildId]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMK    void SetChildId(uint16_t aChildId)
    {
        SetTimeoutChildId((GetTimeoutChildId() & ~kChildIdMask) | ((aChildId << kChildIdOffset) & kChildIdMask));
    }t(GetMode]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKKJ    Mle::DeviceMode GetMode(void) const { return Mle::DeviceMode(mMode); }t(SetMode]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKA@    void SetMode(Mle::DeviceMode aMode) { mMode = aMode.Get(); }t(GetTimeoutChildId]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKSR    uint16_t GetTimeoutChildId(void) const { return HostSwap16(mTimeoutChildId); }t(SetTimeoutChildId]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMChildTableEntryt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMKMKlk    void     SetTimeoutChildId(uint16_t aTimeoutChildIf) { mTimeoutChildId = HostSwap16(aTimeoutChildIf); }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM1ChannelPagesTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM1KM5K    void Init(void)
    {
        SetType(kChannelPages);
        SetLength(sizeof(*this) - sizeof(NetworkDiagnosticTlv));
    }t(IsValid]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM>ChannelPagesTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM>KMBK    bool IsValid(void) const
    {
        // At least one channel page must be included.
        return GetLength() >= 1;
    }t(GetChannelPages]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMJChannelPagesTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppMJKMJK=<    uint8_t *GetChannelPages(void) { return mChannelPages; }t(Init]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM\TypeListTlvt(]/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/network_diagnostic_tlvs.hppM\KM`K|    void Init(void)
    {
        SetType(kTypeList);
        SetLength(sizeof(*this) - sizeof(NetworkDiagnosticTlv));
    }t(IsUpR/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_netif.hppKSThreadNetift(R/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/thread/thread_netif.hppKSKKSK,+    bool IsUp(void) const { return mIsUp; }t(GetRequestedChannelT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKfChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKfKKfKA@    uint8_t GetRequestedChannel(void) const { return mChannel; }t(GetDelayT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKnChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKnKKnK54    uint16_t GetDelay(void) const { return mDelay; }t(GetAutoChannelSelectionEnabledT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKKKKSR    bool GetAutoChannelSelectionEnabled(void) const { return mAutoSelectEnabled; }t(GetAutoChannelSelectionIntervalT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKKKKYX    uint32_t GetAutoChannelSelectionInterval(void) const { return mAutoSelectInterval; }t(GetSupportedChannelsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKɌChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKKKKZY    uint32_t GetSupportedChannels(void) const { return mSupportedChannelMask.GetMask(); }t(GetFavoredChannelsT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKٌChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKKKKVU    uint32_t GetFavoredChannels(void) const { return mFavoredChannelMask.GetMask(); }t(GetCcaFailureRateThresholdT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKChannelManagert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_manager.hppKKKKYX    uint16_t GetCcaFailureRateThreshold(void) const { return mCcaFailureRateThreshold; }t(	IsRunningT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_monitor.hppKChannelMonitort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_monitor.hppKKKK>=    bool IsRunning(void) const { return mTimer.IsRunning(); }t(GetSampleCountT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_monitor.hppKChannelMonitort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/channel_monitor.hppKKKKA@    uint32_t GetSampleCount(void) const { return mSampleCount; }t(GetSupervisionIntervalV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.hppKChildSupervisort(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.hppKKKKQP    uint16_t GetSupervisionInterval(void) const { return mSupervisionInterval; }t(
GetTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.hppKތSupervisionListenert(V/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.hppKKKK98    uint16_t GetTimeout(void) const { return mTimeout; }t(GetSizeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKMBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKMKKMK32    uint16_t GetSize(void) const { return mSize; }t(SetSizeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKUBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKUKKUK43    void SetSize(uint16_t aSize) { mSize = aSize; }t(GetNextI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKaBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKaKKeK    uint16_t GetNext(void) const
    {
        return *reinterpret_cast<const uint16_t *>(
            reinterpret_cast<const void *>(reinterpret_cast<const uint8_t *>(this) + sizeof(mSize) + mSize));
    }t(SetNextI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKoBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKoKKsK    void SetNext(uint16_t aNext)
    {
        *reinterpret_cast<uint16_t *>(
            reinterpret_cast<void *>(reinterpret_cast<uint8_t *>(this) + sizeof(mSize) + mSize)) = aNext;
    }t(
GetPointerI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppK{Blockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppK{KK{K0/    void *GetPointer(void) { return &mMemory; }t(GetLeftNextI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKK?>    uint16_t GetLeftNext(void) const { return *(&mSize - 1); }t(
IsLeftFreeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKK?>    bool IsLeftFree(void) const { return GetLeftNext() != 0; }t(IsFreeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKBlockt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKKSR    bool IsFree(void) const { return mSize != kGuardBlockSize && GetNext() != 0; }t(IsCleanI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKҌHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKKX      bool IsClean(void) const
    {
        Heap        &self  = *AsNonConst(this);
        const Block &super = self.BlockSuper();
        const Block &first = self.BlockRight(super);
        return super.GetNext() == self.BlockOffset(first) && first.GetSize() == kFirstBlockSize;
    }t(GetCapacityI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKތHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKK?>    size_t GetCapacity(void) const { return kFirstBlockSize; }t(GetFreeSizeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKKA@    size_t GetFreeSize(void) const { return mMemory.mFreeSize; }t(BlockAtI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppKKKKgf    Block &BlockAt(uint16_t aOffset) { return *reinterpret_cast<Block *>(&mMemory.m16[aOffset / 2]); }t(BlockOfI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMKMK    Block &BlockOf(void *aPointer)
    {
        uint16_t offset = static_cast<uint16_t>(reinterpret_cast<uint8_t *>(aPointer) - mMemory.m8);
        offset -= sizeof(uint16_t);
        return BlockAt(offset);
    }t(
BlockSuperI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMKMKCB    Block &BlockSuper(void) { return BlockAt(kSuperBlockOffset); }t(	BlockNextI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMKMKPO    Block &BlockNext(const Block &aBlock) { return BlockAt(aBlock.GetNext()); }t(
BlockRightI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppM(Heapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppM(KM(Kwv    Block &BlockRight(const Block &aBlock) { return BlockAt(BlockOffset(aBlock) + sizeof(Block) + aBlock.GetSize()); }t(
IsLeftFreeI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppM8Heapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppM8KM8Kwv    bool IsLeftFree(const Block &aBlock) { return (BlockOffset(aBlock) != kFirstBlockOffset && aBlock.IsLeftFree()); }t(BlockOffsetI/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMBHeapt(I/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/heap.hppMBKMEK    uint16_t BlockOffset(const Block &aBlock)
    {
        return static_cast<uint16_t>(reinterpret_cast<const uint8_t *>(&aBlock) - mMemory.m8);
    }t(InitT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKqIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKqK	KqK?>        void Init(void) { ResetEntryNumber(), SetInitTime(); }t(GetEntryNumberT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKtIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKtK	KtKA@        uint16_t  GetEntryNumber(void) const { return mData16; }t(ResetEntryNumberT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKuIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKuK	KuK:9        void      ResetEntryNumber(void) { mData16 = 0; }t(IncrementEntryNumberT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKvIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKvK	KvK<;        void      IncrementEntryNumber(void) { mData16++; }t(GetInitTimeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKwIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKwK	KwKIH        TimeMilli GetInitTime(void) const { return TimeMilli(mData32); }t(SetInitTimeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKxIteratort(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKxK	KxKSR        void      SetInitTime(void) { mData32 = TimerMilli::GetNow().GetValue(); }t(IterateNetInfoHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const NetworkInfo *IterateNetInfoHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mNetInfoHistory.Iterate(aIterator, aEntryAge);
    }t(IterateUnicastAddressHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const UnicastAddressInfo *IterateUnicastAddressHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mUnicastAddressHistory.Iterate(aIterator, aEntryAge);
    }t(IterateMulticastAddressHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const MulticastAddressInfo *IterateMulticastAddressHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mMulticastAddressHistory.Iterate(aIterator, aEntryAge);
    }t(IterateRxHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKʌHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const MessageInfo *IterateRxHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mRxHistory.Iterate(aIterator, aEntryAge);
    }t(IterateTxHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKیHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const MessageInfo *IterateTxHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mTxHistory.Iterate(aIterator, aEntryAge);
    }t(IterateNeighborHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const NeighborInfo *IterateNeighborHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mNeighborHistory.Iterate(aIterator, aEntryAge);
    }t(IterateOnMeshPrefixHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const OnMeshPrefixInfo *IterateOnMeshPrefixHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mOnMeshPrefixHistory.Iterate(aIterator, aEntryAge);
    }t(IterateExternalRouteHistoryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppKKKK    const ExternalRouteInfo *IterateExternalRouteHistory(Iterator &aIterator, uint32_t &aEntryAge) const
    {
        return mExternalRouteHistory.Iterate(aIterator, aEntryAge);
    }t(
IsDistantPastT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM'	Timestampt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM'K	M'KZY        bool     IsDistantPast(void) const { return (mTime.GetValue() == kDistantPast); }t(MarkAsDistantPastT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM(	Timestampt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM(K	M(KRQ        void     MarkAsDistantPast(void) { return mTime.SetValue(kDistantPast); }t(GetSizeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM5Listt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppM5K	M5K76        uint16_t GetSize(void) const { return mSize; }t(AddNewEntryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMO	EntryListt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMOK	MOKSR        Entry *AddNewEntry(void) { return &mEntries[Add(kMaxSize, mTimestamps)]; }t(AddNewEntryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMP	EntryListt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMPK	MPKcb        void   AddNewEntry(const Entry &aEntry) { mEntries[Add(kMaxSize, mTimestamps)] = aEntry; }t(UpdateAgedEntriesT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMR	EntryListt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMRK	MRKYX        void UpdateAgedEntries(void) { List::UpdateAgedEntries(kMaxSize, mTimestamps); }t(IterateT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMT	EntryListt(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMTK	MZK
Xe          const Entry *Iterate(Iterator &aIterator, uint32_t &aEntryAge) const
        {
            uint16_t index;

            return (List::Iterate(kMaxSize, mTimestamps, aIterator, index, aEntryAge) == kErrorNone) ? &mEntries[index]
                                                                                                     : nullptr;
        }t(ClearT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMeHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMeK	MeK$#        void         Clear(void) {}t(GetSizeT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMfHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMfK	MfK76        uint16_t     GetSize(void) const { return 0; }t(AddNewEntryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMgHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMgK	MgK;:        Entry       *AddNewEntry(void) { return nullptr; }t(AddNewEntryT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMhHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMhK	MhK32        void         AddNewEntry(const Entry &) {}t(IterateT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMiHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMiK	MiKON        const Entry *Iterate(Iterator &, uint32_t &) const { return nullptr; }t(RemoveAgedEntriesT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMjHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMjK	MjK0/        void         RemoveAgedEntries(void) {}t(RecordRxMessageT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMsHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMsKMvK    void RecordRxMessage(const Message &aMessage, const Mac::Address &aMacSource)
    {
        RecordMessage(aMessage, aMacSource, kRxMessage);
    }t(RecordTxMessageT/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMxHistoryTrackert(T/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/history_tracker.hppMxKM{K    void RecordTxMessage(const Message &aMessage, const Mac::Address &aMacDest)
    {
        RecordMessage(aMessage, aMacDest, kTxMessage);
    }t(	IsEnabledQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKgJamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKgKKgK43    bool IsEnabled(void) const { return mEnabled; }t(GetStateQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKnJamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKnKKnK43    bool GetState(void) const { return mJamState; }t(GetRssiThresholdQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppK}JamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppK}KK}KCB    int8_t GetRssiThreshold(void) const { return mRssiThreshold; }t(	GetWindowQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKJamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKKKK65    uint8_t GetWindow(void) const { return mWindow; }t(
GetBusyPeriodQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKJamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKKKK>=    uint8_t GetBusyPeriod(void) const { return mBusyPeriod; }t(GetHistoryBitmapQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKJamDetectort(Q/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/jam_detector.hppKKKKED    uint64_t GetHistoryBitmap(void) const { return mHistoryBitmap; }t(
StatisticsP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKL
Statisticst(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKLK	KLK&%        Statistics(void) { Clear(); }t(ClearP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKN
Statisticst(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKNK	KVK
XF          void Clear(void)
        {
            mSentCount          = 0;
            mReceivedCount      = 0;
            mTotalRoundTripTime = 0;
            mMinRoundTripTime   = NumericLimits<uint16_t>::kMax;
            mMaxRoundTripTime   = NumericLimits<uint16_t>::kMin;
            mIsMulticast        = false;
        }t(	GetSourceP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKhConfigt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKhK	KhKGF        Ip6::Address &GetSource(void) { return AsCoreType(&mSource); }t(	GetSourceP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKpConfigt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKpK	KpKSR        const Ip6::Address &GetSource(void) const { return AsCoreType(&mSource); }t(GetDestinationP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKxConfigt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKxK	KxKQP        Ip6::Address &GetDestination(void) { return AsCoreType(&mDestination); }t(GetDestinationP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKConfigt(P/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/ping_sender.hppKK	KK]\        const Ip6::Address &GetDestination(void) const { return AsCoreType(&mDestination); }t(GetServiceNameStringW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppK}ServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppK}K	KK
        char *GetServiceNameString(uint16_t &aSize)
        {
            aSize = sizeof(mServiceName);
            return mServiceName;
        }t(GetInstanceNameStringW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KK
        char *GetInstanceNameString(uint16_t &aSize)
        {
            aSize = sizeof(mInstanceName);
            return mInstanceName;
        }t(GetTxtBufferW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KK
        uint8_t *GetTxtBuffer(uint16_t &aSize)
        {
            aSize = sizeof(mTxtBuffer);
            return mTxtBuffer;
        }t(GetSubTypeLabelsArrayW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KK
        const char **GetSubTypeLabelsArray(uint16_t &aArrayLength)
        {
            aArrayLength = GetArrayLength(mSubTypeLabels);
            return mSubTypeLabels;
        }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KKgf        ServiceEntry       *GetNext(void) { return reinterpret_cast<ServiceEntry *>(mService.mNext); }t(GetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KKsr        const ServiceEntry *GetNext(void) const { return reinterpret_cast<const ServiceEntry *>(mService.mNext); }t(SetNextW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKServiceEntryt(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKK	KKrq        void SetNext(ServiceEntry *aEntry) { mService.mNext = reinterpret_cast<Srp::Client::Service *>(aEntry); }t(GetHostNameStringW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKȌSrpClientBufferst(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKKKKu    char *GetHostNameString(uint16_t &aSize)
    {
        aSize = sizeof(mHostName);
        return mHostName;
    }t(GetHostAddressesArrayW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppK׌SrpClientBufferst(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKKKK    Ip6::Address *GetHostAddressesArray(uint8_t &aArrayLength)
    {
        aArrayLength = static_cast<uint8_t>(GetArrayLength(mHostAddresses));
        return &mHostAddresses[0];
    }t(FreeServiceW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKSrpClientBufferst(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppKKKKXW    void FreeService(ServiceEntry &aServiceEntry) { mServicePool.Free(aServiceEntry); }t(FreeAllServicesW/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppMSrpClientBufferst(W/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/srp_client_buffers.hppMKMK;:    void FreeAllServices(void) { mServicePool.FreeAll(); }t(
IsInitializedN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppK׌Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppKKKK>=    bool IsInitialized(void) const { return mIsInitialized; }t(GetLogLevelN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppKInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppKKKK    static LogLevel GetLogLevel(void)
#if OPENTHREAD_CONFIG_LOG_LEVEL_DYNAMIC_ENABLE
    {
        return sLogLevel;
    }
#else
    {
        return static_cast<LogLevel>(OPENTHREAD_CONFIG_LOG_LEVEL);
    }t(GetApplicationCoapN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM0Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM0KM0KFE    Coap::Coap &GetApplicationCoap(void) { return mApplicationCoap; }t(GetApplicationCoapSecureN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM:Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM:KM:KXW    Coap::CoapSecure &GetApplicationCoapSecure(void) { return mApplicationCoapSecure; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM~Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM~KM~KCBtemplate <> inline Instance &Instance::Get(void) { return *this; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKA@template <> inline Radio &Instance::Get(void) { return mRadio; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKWVtemplate <> inline Radio::Callbacks &Instance::Get(void) { return mRadio.mCallbacks; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKCBtemplate <> inline Uptime &Instance::Get(void) { return mUptime; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKGFtemplate <> inline Notifier &Instance::Get(void) { return mNotifier; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline TimeTicker &Instance::Get(void) { return mTimeTicker; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKGFtemplate <> inline Settings &Instance::Get(void) { return mSettings; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKSRtemplate <> inline SettingsDriver &Instance::Get(void) { return mSettingsDriver; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKQPtemplate <> inline MeshForwarder &Instance::Get(void) { return mMeshForwarder; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKHGtemplate <> inline Mle::Mle &Instance::Get(void) { return mMleRouter; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKNMtemplate <> inline Mle::MleRouter &Instance::Get(void) { return mMleRouter; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKZYtemplate <> inline Mle::DiscoverScanner &Instance::Get(void) { return mDiscoverScanner; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMK\[template <> inline NeighborTable &Instance::Get(void) { return mMleRouter.mNeighborTable; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKVUtemplate <> inline ChildTable &Instance::Get(void) { return mMleRouter.mChildTable; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKXWtemplate <> inline RouterTable &Instance::Get(void) { return mMleRouter.mRouterTable; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKLKtemplate <> inline Ip6::Netif &Instance::Get(void) { return mThreadNetif; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKMLtemplate <> inline ThreadNetif &Instance::Get(void) { return mThreadNetif; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKBAtemplate <> inline Ip6::Ip6 &Instance::Get(void) { return mIp6; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKBAtemplate <> inline Mac::Mac &Instance::Get(void) { return mMac; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKTStemplate <> inline Mac::SubMac &Instance::Get(void) { return mMac.mLinks.mSubMac; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKMLtemplate <> inline Mac::Filter &Instance::Get(void) { return mMac.mFilter; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline Lowpan::Lowpan &Instance::Get(void) { return mLowpan; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline KeyManager &Instance::Get(void) { return mKeyManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline Ip6::Filter &Instance::Get(void) { return mIp6Filter; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKUTtemplate <> inline AddressResolver &Instance::Get(void) { return mAddressResolver; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKbatemplate <> inline IndirectSender &Instance::Get(void) { return mMeshForwarder.mIndirectSender; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKtemplate <> inline SourceMatchController &Instance::Get(void)
{
    return mMeshForwarder.mIndirectSender.mSourceMatchController;
}t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKtstemplate <> inline DataPollHandler &Instance::Get(void) { return mMeshForwarder.mIndirectSender.mDataPollHandler; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKrqtemplate <> inline CslTxScheduler &Instance::Get(void) { return mMeshForwarder.mIndirectSender.mCslTxScheduler; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKLKtemplate <> inline MeshCoP::Leader &Instance::Get(void) { return mLeader; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKXWtemplate <> inline MeshCoP::JoinerRouter &Instance::Get(void) { return mJoinerRouter; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKWVtemplate <> inline AnnounceBeginServer &Instance::Get(void) { return mAnnounceBegin; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKbatemplate <> inline DataPollSender &Instance::Get(void) { return mMeshForwarder.mDataPollSender; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKQPtemplate <> inline EnergyScanServer &Instance::Get(void) { return mEnergyScan; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKQPtemplate <> inline PanIdQueryServer &Instance::Get(void) { return mPanIdQuery; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKYXtemplate <> inline NetworkData::Local &Instance::Get(void) { return mNetworkDataLocal; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMK[Ztemplate <> inline NetworkData::Leader &Instance::Get(void) { return mNetworkDataLeader; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMK_^template <> inline NetworkData::Notifier &Instance::Get(void) { return mNetworkDataNotifier; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKa`template <> inline NetworkData::Publisher &Instance::Get(void) { return mNetworkDataPublisher; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKmltemplate <> inline NetworkData::Service::Manager &Instance::Get(void) { return mNetworkDataServiceManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKGFtemplate <> inline Ip6::Tcp &Instance::Get(void) { return mIp6.mTcp; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKGFtemplate <> inline Ip6::Udp &Instance::Get(void) { return mIp6.mUdp; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKIHtemplate <> inline Ip6::Icmp &Instance::Get(void) { return mIp6.mIcmp; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKGFtemplate <> inline Ip6::Mpl &Instance::Get(void) { return mIp6.mMpl; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKIHtemplate <> inline Tmf::Agent &Instance::Get(void) { return mTmfAgent; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKUTtemplate <> inline Tmf::SecureAgent &Instance::Get(void) { return mTmfSecureAgent; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKhgtemplate <> inline MeshCoP::ExtendedPanIdManager &Instance::Get(void) { return mExtendedPanIdManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKdctemplate <> inline MeshCoP::NetworkNameManager &Instance::Get(void) { return mNetworkNameManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKa`template <> inline MeshCoP::ActiveDatasetManager &Instance::Get(void) { return mActiveDataset; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKcbtemplate <> inline MeshCoP::PendingDatasetManager &Instance::Get(void) { return mPendingDataset; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKXWtemplate <> inline MeshCoP::Commissioner &Instance::Get(void) { return mCommissioner; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKontemplate <> inline AnnounceBeginClient &Instance::Get(void) { return mCommissioner.GetAnnounceBeginClient(); }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKihtemplate <> inline EnergyScanClient &Instance::Get(void) { return mCommissioner.GetEnergyScanClient(); }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKihtemplate <> inline PanIdQueryClient &Instance::Get(void) { return mCommissioner.GetPanIdQueryClient(); }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKLKtemplate <> inline MeshCoP::Joiner &Instance::Get(void) { return mJoiner; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline Dns::Client &Instance::Get(void) { return mDnsClient; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM KM KKJtemplate <> inline Srp::Client &Instance::Get(void) { return mSrpClient; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM$Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM$KM$K^]template <> inline Utils::SrpClientBuffers &Instance::Get(void) { return mSrpClientBuffers; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM0Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM0KM0Klktemplate <> inline NetworkDiagnostic::NetworkDiagnostic &Instance::Get(void) { return mNetworkDiagnostic; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM4Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM4KM4KONtemplate <> inline Dhcp6::Client &Instance::Get(void) { return mDhcp6Client; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM8Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM8KM8KONtemplate <> inline Dhcp6::Server &Instance::Get(void) { return mDhcp6Server; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM@Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM@KM@KHGtemplate <> inline Utils::Slaac &Instance::Get(void) { return mSlaac; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMDInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMDKMDKTStemplate <> inline Utils::JamDetector &Instance::Get(void) { return mJamDetector; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMHInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMHKMHKMLtemplate <> inline Sntp::Client &Instance::Get(void) { return mSntpClient; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMMKMMK\[template <> inline Utils::ChildSupervisor &Instance::Get(void) { return mChildSupervisor; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMOInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMOKMOKdctemplate <> inline Utils::SupervisionListener &Instance::Get(void) { return mSupervisionListener; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMSInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMSKMSKRQtemplate <> inline Utils::PingSender &Instance::Get(void) { return mPingSender; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMWInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMWKMWKZYtemplate <> inline Utils::ChannelMonitor &Instance::Get(void) { return mChannelMonitor; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM[Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM[KM[KZYtemplate <> inline Utils::ChannelManager &Instance::Get(void) { return mChannelManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM_Instancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppM_KM_KZYtemplate <> inline Utils::HistoryTracker &Instance::Get(void) { return mHistoryTracker; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMcInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMcKMcK\[template <> inline MeshCoP::DatasetUpdater &Instance::Get(void) { return mDatasetUpdater; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMgInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMgKMgKVUtemplate <> inline MeshCoP::BorderAgent &Instance::Get(void) { return mBorderAgent; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMkInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMkKMkKSRtemplate <> inline AnnounceSender &Instance::Get(void) { return mAnnounceSender; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMnInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMnKMnKMLtemplate <> inline MessagePool &Instance::Get(void) { return mMessagePool; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMrInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMrKMrKa`template <> inline BackboneRouter::Leader &Instance::Get(void) { return mBackboneRouterLeader; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline MlrManager &Instance::Get(void) { return mMlrManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline DuaManager &Instance::Get(void) { return mDuaManager; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKKJtemplate <> inline Srp::Server &Instance::Get(void) { return mSrpServer; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKJItemplate <> inline Mac::LinkRaw &Instance::Get(void) { return mLinkRaw; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMKYXtemplate <> inline Tasklet::Scheduler &Instance::Get(void) { return mTaskletScheduler; }t(GetN/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMInstancet(N/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/instance.hppMKMK_^template <> inline TimerMilli::Scheduler &Instance::Get(void) { return mTimerMilliScheduler; }t(GetU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hppK/GetProvidert(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hppK/KK3Ktemplate <typename Type>
inline Type &GetProvider<InstanceGetProvider>::Get(void) const
{
    return static_cast<const InstanceGetProvider *>(this)->GetInstance().template Get<Type>();
}t(
HandleTaskletU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hppK5	TaskletInt(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hppK5KK9Ktemplate <typename Owner, void (Owner::*HandleTaskletPtr)(void)>
void TaskletIn<Owner, HandleTaskletPtr>::HandleTasklet(Tasklet &aTasklet)
{
    (aTasklet.Get<Owner>().*HandleTaskletPtr)();
}t(HandleTimerU/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hppK;TimerMilliInt(U/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/locator_getters.hpp3      K;KK?Ktemplate <typename Owner, void (Owner::*HandleTimertPtr)(void)>
void TimerMilliIn<Owner, HandleTimertPtr>::HandleTimer(Timer &aTimer)
{
    (aTimer.Get<Owner>().*HandleTimertPtr)();
}t(otHistoryTrackerInitIteratorV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppK.Nt(j%M  K.KK.Kihvoid otHistoryTrackerInitIterator(otHistoryTrackerIterator *aIterator) { AsCoreType(aIterator).Init(); }t(%otHistoryTrackerIterateNetInfoHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppK0Nt(j*M  K0KK7KX  const otHistoryTrackerNetworkInfo *otHistoryTrackerIterateNetInfoHistory(otInstance               *aInstance,
                                                                         otHistoryTrackerIterator *aIterator,
                                                                         uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateNetInfoHistory(AsCoreType(aIterator), *aEntryAge);
}t(,otHistoryTrackerIterateUnicastAddressHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppK9Nt(j/M  K9KKBKX  const otHistoryTrackerUnicastAddressInfo *otHistoryTrackerIterateUnicastAddressHistory(
    otInstance               *aInstance,
    otHistoryTrackerIterator *aIterator,
    uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateUnicastAddressHistory(AsCoreType(aIterator),
                                                                                           *aEntryAge);
}t(.otHistoryTrackerIterateMulticastAddressHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKDNt(j4M  KDKKMKX  const otHistoryTrackerMulticastAddressInfo *otHistoryTrackerIterateMulticastAddressHistory(
    otInstance               *aInstance,
    otHistoryTrackerIterator *aIterator,
    uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateMulticastAddressHistory(AsCoreType(aIterator),
                                                                                             *aEntryAge);
}t( otHistoryTrackerIterateRxHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKONt(j9M  KOKKVKX  const otHistoryTrackerMessageInfo *otHistoryTrackerIterateRxHistory(otInstance               *aInstance,
                                                                    otHistoryTrackerIterator *aIterator,
                                                                    uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateRxHistory(AsCoreType(aIterator), *aEntryAge);
}t( otHistoryTrackerIterateTxHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKXNt(j>M  KXKK_KX  const otHistoryTrackerMessageInfo *otHistoryTrackerIterateTxHistory(otInstance               *aInstance,
                                                                    otHistoryTrackerIterator *aIterator,
                                                                    uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateTxHistory(AsCoreType(aIterator), *aEntryAge);
}t(&otHistoryTrackerIterateNeighborHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKaNt(jCM  KaKKhKX  const otHistoryTrackerNeighborInfo *otHistoryTrackerIterateNeighborHistory(otInstance               *aInstance,
                                                                           otHistoryTrackerIterator *aIterator,
                                                                           uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateNeighborHistory(AsCoreType(aIterator), *aEntryAge);
}t(*otHistoryTrackerIterateOnMeshPrefixHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKjNt(jHM  KjKKrKXi  const otHistoryTrackerOnMeshPrefixInfo *otHistoryTrackerIterateOnMeshPrefixHistory(otInstance               *aInstance,
                                                                                   otHistoryTrackerIterator *aIterator,
                                                                                   uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateOnMeshPrefixHistory(AsCoreType(aIterator),
                                                                                         *aEntryAge);
}t(+otHistoryTrackerIterateExternalRouteHistoryV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKtNt(jMM  KtKK}KX  const otHistoryTrackerExternalRouteInfo *otHistoryTrackerIterateExternalRouteHistory(
    otInstance               *aInstance,
    otHistoryTrackerIterator *aIterator,
    uint32_t                 *aEntryAge)
{
    AssertPointerIsNotNull(aEntryAge);

    return AsCoreType(aInstance).Get<Utils::HistoryTracker>().IterateExternalRouteHistory(AsCoreType(aIterator),
                                                                                          *aEntryAge);
}t( otHistoryTrackerEntryAgeToStringV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/history_tracker_api.cppKNt(jRM  KKKKvoid otHistoryTrackerEntryAgeToString(uint32_t aEntryAge, char *aBuffer, uint16_t aSize)
{
    Utils::HistoryTracker::EntryAgeToString(aEntryAge, aBuffer, aSize);
}t(mbedtls_svc_key_id_makef/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hMKM Kstatic inline mbedtls_svc_key_id_t mbedtls_svc_key_id_make(
    unsigned int unused, psa_key_id_t key_id )
{
    (void)unused;

    return( key_id );
}t(mbedtls_svc_key_id_equalf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hM)Nt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hM)KM-Kstatic inline int mbedtls_svc_key_id_equal( mbedtls_svc_key_id_t id1,
                                            mbedtls_svc_key_id_t id2 )
{
    return( id1 == id2 );
}t(mbedtls_svc_key_id_is_nullf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hM5Nt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_values.hM5KM8Kdstatic inline int mbedtls_svc_key_id_is_null( mbedtls_svc_key_id_t key )
{
    return( key == 0 );
}t(psa_hash_operation_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hK`Nt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hK`KKdKstatic inline struct psa_hash_operation_s psa_hash_operation_init( void )
{
    const struct psa_hash_operation_s v = PSA_HASH_OPERATION_INIT;
    return( v );
}t(psa_cipher_operation_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKyNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKyKK}Kstatic inline struct psa_cipher_operation_s psa_cipher_operation_init( void )
{
    const struct psa_cipher_operation_s v = PSA_CIPHER_OPERATION_INIT;
    return( v );
}t(psa_mac_operation_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKKKKstatic inline struct psa_mac_operation_s psa_mac_operation_init( void )
{
    const struct psa_mac_operation_s v = PSA_MAC_OPERATION_INIT;
    return( v );
}t(psa_aead_operation_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKKKKstatic inline struct psa_aead_operation_s psa_aead_operation_init( void )
{
    const struct psa_aead_operation_s v = PSA_AEAD_OPERATION_INIT;
    return( v );
}t(!psa_key_derivation_operation_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hKKMKstatic inline struct psa_key_derivation_s psa_key_derivation_operation_init( void )
{
    const struct psa_key_derivation_s v = PSA_KEY_DERIVATION_OPERATION_INIT;
    return( v );
}t(psa_key_policy_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline struct psa_key_policy_s psa_key_policy_init( void )
{
    const struct psa_key_policy_s v = PSA_KEY_POLICY_INIT;
    return( v );
}t(psa_key_attributes_initf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMRNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMRKMVKstatic inline struct psa_key_attributes_s psa_key_attributes_init( void )
{
    const struct psa_key_attributes_s v = PSA_KEY_ATTRIBUTES_INIT;
    return( v );
}t(psa_set_key_idf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMXNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMXKMfKX  static inline void psa_set_key_id( psa_key_attributes_t *attributes,
                                   mbedtls_svc_key_id_t key )
{
    psa_key_lifetime_t lifetime = attributes->core.lifetime;

    attributes->core.id = key;

    if( PSA_KEY_LIFETIME_IS_VOLATILE( lifetime ) )
    {
        attributes->core.lifetime =
            PSA_KEY_LIFETIME_FROM_PERSISTENCE_AND_LOCATION(
                PSA_KEY_LIFETIME_PERSISTENT,
                PSA_KEY_LIFETIME_GET_LOCATION( lifetime ) );
    }
}t(psa_get_key_idf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMhNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMhKMlKstatic inline mbedtls_svc_key_id_t psa_get_key_id(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.id );
}t(psa_set_key_lifetimef/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMvNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMvKMKX  static inline void psa_set_key_lifetime(psa_key_attributes_t *attributes,
                                        psa_key_lifetime_t lifetime)
{
    attributes->core.lifetime = lifetime;
    if( PSA_KEY_LIFETIME_IS_VOLATILE( lifetime ) )
    {
#ifdef MBEDTLS_PSA_CRYPTO_KEY_ID_ENCODES_OWNER
        attributes->core.id.key_id = 0;
#else
        attributes->core.id = 0;
#endif
    }
}t(psa_get_key_lifetimef/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline psa_key_lifetime_t psa_get_key_lifetime(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.lifetime );
}t(psa_extend_key_usage_flagsf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKX   static inline void psa_extend_key_usage_flags( psa_key_usage_t *usage_flags )
{
    if( *usage_flags & PSA_KEY_USAGE_SIGN_HASH )
        *usage_flags |= PSA_KEY_USAGE_SIGN_MESSAGE;

    if( *usage_flags & PSA_KEY_USAGE_VERIFY_HASH )
        *usage_flags |= PSA_KEY_USAGE_VERIFY_MESSAGE;
}t(psa_set_key_usage_flagsf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline void psa_set_key_usage_flags(psa_key_attributes_t *attributes,
                                           psa_key_usage_t usage_flags)
{
    psa_extend_key_usage_flags( &usage_flags );
    attributes->core.policy.usage = usage_flags;
}t(psa_get_key_usage_flagsf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline psa_key_usage_t psa_get_key_usage_flags(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.policy.usage );
}t(psa_set_key_algorithmf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline void psa_set_key_algorithm(psa_key_attributes_t *attributes,
                                         psa_algorithm_t alg)
{
    attributes->core.policy.alg = alg;
}t(psa_get_key_algorithmf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline psa_algorithm_t psa_get_key_algorithm(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.policy.alg );
}t(psa_set_key_typef/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKXU  static inline void psa_set_key_type(psa_key_attributes_t *attributes,
                                    psa_key_type_t type)
{
    if( attributes->domain_parameters == NULL )
    {
        /* Common case: quick path */
        attributes->core.type = type;
    }
    else
    {
        /* Call the bigger function to free the old domain paramteres.
         * Ignore any errors which may arise due to type requiring
         * non-default domain parameters, since this function can't
         * report errors. */
        (void) psa_set_key_domain_parameters( attributes, type, NULL, 0 );
    }
}t(psa_get_key_typef/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKstatic inline psa_key_type_t psa_get_key_type(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.type );
}t(psa_set_key_bitsf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMKX  static inline void psa_set_key_bits(psa_key_attributes_t *attributes,
                                    size_t bits)
{
    if( bits > PSA_MAX_KEY_BITS )
        attributes->core.bits = PSA_KEY_BITS_TOO_LARGE;
    else
        attributes->core.bits = (psa_key_bits_t) bits;
}t(psa_get_key_bitsf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_struct.hMKMK{static inline size_t psa_get_key_bits(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.bits );
}t(psa_key_handle_is_nullf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hK5Nt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hK5KK8K{static inline int psa_key_handle_is_null( psa_key_handle_t handle )
{
    return( mbedtls_svc_key_id_is_null( handle ) );
}t(psa_asymmetric_signf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hKNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hKKKKX  MBEDTLS_PSA_DEPRECATED static inline psa_status_t psa_asymmetric_sign( psa_key_handle_t key,
                            psa_algorithm_t alg,
                            const uint8_t *hash,
                            size_t hash_length,
                            uint8_t *signature,
                            size_t signature_size,
                            size_t *signature_length )
{
    return psa_sign_hash( key, alg, hash, hash_length, signature, signature_size, signature_length );
}t(psa_asymmetric_verifyf/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hKNt(f/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_compat.hKKKKX  MBEDTLS_PSA_DEPRECATED static inline psa_status_t psa_asymmetric_verify( psa_key_handle_t key,
                              psa_algorithm_t alg,
                              const uint8_t *hash,
                              size_t hash_length,
                              const uint8_t *signature,
                              size_t signature_length )
{
    return psa_verify_hash( key, alg, hash, hash_length, signature, signature_length );
}t( psa_set_key_enrollment_algorithme/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hKGNt(e/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hKGKKLKstatic inline void psa_set_key_enrollment_algorithm(
    psa_key_attributes_t *attributes,
    psa_algorithm_t alg2)
{
    attributes->core.policy.alg2 = alg2;
}t( psa_get_key_enrollment_algorithme/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hKTNt(e/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hKTKKXKstatic inline psa_algorithm_t psa_get_key_enrollment_algorithm(
    const psa_key_attributes_t *attributes)
{
    return( attributes->core.policy.alg2 );
}t(mbedtls_ecc_group_to_psae/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hMNNt(e/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/include/psa/crypto_extra.hMNKM~KX  static inline psa_ecc_family_t mbedtls_ecc_group_to_psa( mbedtls_ecp_group_id grpid,
                                                        size_t *bits )
{
    switch( grpid )
    {
        case MBEDTLS_ECP_DP_SECP192R1:
            *bits = 192;
            return( PSA_ECC_FAMILY_SECP_R1 );
        case MBEDTLS_ECP_DP_SECP224R1:
            *bits = 224;
            return( PSA_ECC_FAMILY_SECP_R1 );
        case MBEDTLS_ECP_DP_SECP256R1:
            *bits = 256;
            return( PSA_ECC_FAMILY_SECP_R1 );
        case MBEDTLS_ECP_DP_SECP384R1:
            *bits = 384;
            return( PSA_ECC_FAMILY_SECP_R1 );
        case MBEDTLS_ECP_DP_SECP521R1:
            *bits = 521;
            return( PSA_ECC_FAMILY_SECP_R1 );
        case MBEDTLS_ECP_DP_BP256R1:
            *bits = 256;
            return( PSA_ECC_FAMILY_BRAINPOOL_P_R1 );
        case MBEDTLS_ECP_DP_BP384R1:
            *bits = 384;
            return( PSA_ECC_FAMILY_BRAINPOOL_P_R1 );
        case MBEDTLS_ECP_DP_BP512R1:
            *bits = 512;
            return( PSA_ECC_FAMILY_BRAINPOOL_P_R1 );
        case MBEDTLS_ECP_DP_CURVE25519:
            *bits = 255;
            return( PSA_ECC_FAMILY_MONTGOMERY );
        case MBEDTLS_ECP_DP_SECP192K1:
            *bits = 192;
            return( PSA_ECC_FAMILY_SECP_K1 );
        case MBEDTLS_ECP_DP_SECP224K1:
            *bits = 224;
            return( PSA_ECC_FAMILY_SECP_K1 );
        case MBEDTLS_ECP_DP_SECP256K1:
            *bits = 256;
            return( PSA_ECC_FAMILY_SECP_K1 );
        case MBEDTLS_ECP_DP_CURVE448:
            *bits = 448;
            return( PSA_ECC_FAMILY_MONTGOMERY );
        default:
            *bits = 0;
            return( 0 );
    }
}t(mbedtls_psa_safer_memcmpd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hK)Nt(jN  K)KK3Kstatic inline int mbedtls_psa_safer_memcmp(
    const uint8_t *a, const uint8_t *b, size_t n )
{
    size_t i;
    unsigned char diff = 0;

    for( i = 0; i < n; i++ )
        diff |= a[i] ^ b[i];

    return( diff );
}t(psa_is_key_slot_occupiedd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKlNt(j
N  KlKKoKpstatic inline int psa_is_key_slot_occupied( const psa_key_slot_t *slot )
{
    return( slot->attr.type != 0 );
}t(psa_is_key_slot_lockedd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKyNt(jN  KyKK|Knstatic inline int psa_is_key_slot_locked( const psa_key_slot_t *slot )
{
    return( slot->lock_count > 0 );
}t(psa_key_slot_get_flagsd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKNt(jN  KKKKstatic inline uint16_t psa_key_slot_get_flags( const psa_key_slot_t *slot,
                                               uint16_t mask )
{
    return( slot->attr.flags & mask );
}t(psa_key_slot_set_flagsd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKNt(jN  KKKKX$  static inline void psa_key_slot_set_flags( psa_key_slot_t *slot,
                                           uint16_t mask,
                                           uint16_t value )
{
    slot->attr.flags = ( ( ~mask & slot->attr.flags ) |
                              ( mask & value ) );
}t(psa_key_slot_set_bits_in_flagsd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKNt(jN  KKKKstatic inline void psa_key_slot_set_bits_in_flags( psa_key_slot_t *slot,
                                                   uint16_t mask )
{
    slot->attr.flags |= mask;
}t(psa_key_slot_clear_bitsd/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/psa_crypto_core.hKNt(j#N  KKKKstatic inline void psa_key_slot_clear_bits( psa_key_slot_t *slot,
                                            uint16_t mask )
{
    slot->attr.flags &= ~mask;
}t(otIp6SetEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppK/Nt(j(N  K/KKEKX  otError otIp6SetEnabled(otInstance *aInstance, bool aEnabled)
{
    Error     error    = kErrorNone;
    Instance &instance = AsCoreType(aInstance);

#if OPENTHREAD_CONFIG_LINK_RAW_ENABLE
    VerifyOrExit(!instance.Get<Mac::LinkRaw>().IsEnabled(), error = kErrorInvalidState);
#endif

    if (aEnabled)
    {
        instance.Get<ThreadNetif>().Up();
    }
    else
    {
        instance.Get<ThreadNetif>().Down();
    }

#if OPENTHREAD_CONFIG_LINK_RAW_ENABLE
exit:
#endif
    return error;
}t(otIp6IsEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKGNt(j-N  KGKKGKgfbool otIp6IsEnabled(otInstance *aInstance) { return AsCoreType(aInstance).Get<ThreadNetif>().IsUp(); }t(otIp6GetUnicastAddressesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKINt(j2N  KIKKLKconst otNetifAddress *otIp6GetUnicastAddresses(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().GetUnicastAddresses().GetHead();
}t(otIp6AddUnicastAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNNt(j7N  KNKKQKotError otIp6AddUnicastAddress(otInstance *aInstance, const otNetifAddress *aAddress)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().AddExternalUnicastAddress(AsCoreType(aAddress));
}t(otIp6RemoveUnicastAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKSNt(j<N  KSKKVKotError otIp6RemoveUnicastAddress(otInstance *aInstance, const otIp6Address *aAddress)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().RemoveExternalUnicastAddress(AsCoreType(aAddress));
}t(otIp6GetMulticastAddressesJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKXNt(jAN  KXKK[Kconst otNetifMulticastAddress *otIp6GetMulticastAddresses(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().GetMulticastAddresses().GetHead();
}t(otIp6SubscribeMulticastAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppK]Nt(jFN  K]KK`KotError otIp6SubscribeMulticastAddress(otInstance *aInstance, const otIp6Address *aAddress)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().SubscribeExternalMulticast(AsCoreType(aAddress));
}t( otIp6UnsubscribeMulticastAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKbNt(jKN  KbKKeKotError otIp6UnsubscribeMulticastAddress(otInstance *aInstance, const otIp6Address *aAddress)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().UnsubscribeExternalMulticast(AsCoreType(aAddress));
}t("otIp6IsMulticastPromiscuousEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKgNt(jPN  KgKKjKbool otIp6IsMulticastPromiscuousEnabled(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<ThreadNetif>().IsMulticastPromiscuousEnabled();
}t(#otIp6SetMulticastPromiscuousEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKlNt(jUN  KlKKoKvoid otIp6SetMulticastPromiscuousEnabled(otInstance *aInstance, bool aEnabled)
{
    AsCoreType(aInstance).Get<ThreadNetif>().SetMulticastPromiscuous(aEnabled);
}t(otIp6SetReceiveCallbackJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKqNt(jZN  KqKKtKvoid otIp6SetReceiveCallback(otInstance *aInstance, otIp6ReceiveCallback aCallback, void *aCallbackContext)
{
    AsCoreType(aInstance).Get<Ip6::Ip6>().SetReceiveDatagramCallback(aCallback, aCallbackContext);
}t(otIp6SetAddressCallbackJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKvNt(j_N  KvKKyKvoid otIp6SetAddressCallback(otInstance *aInstance, otIp6AddressCallback aCallback, void *aCallbackContext)
{
    AsCoreType(aInstance).Get<ThreadNetif>().SetAddressCallback(aCallback, aCallbackContext);
}t(otIp6IsReceiveFilterEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppK{Nt(jdN  K{KK~Kbool otIp6IsReceiveFilterEnabled(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Ip6::Ip6>().IsReceiveIp6FilterEnabled();
}t(otIp6SetReceiveFilterEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jiN  KKKKvoid otIp6SetReceiveFilterEnabled(otInstance *aInstance, bool aEnabled)
{
    AsCoreType(aInstance).Get<Ip6::Ip6>().SetReceiveIp6FilterEnabled(aEnabled);
}t(	otIp6SendJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jnN  KKKKX   otError otIp6Send(otInstance *aInstance, otMessage *aMessage)
{
    return AsCoreType(aInstance).Get<Ip6::Ip6>().SendRaw(AsCoreType(aMessage),
                                                         OPENTHREAD_CONFIG_IP6_ALLOW_LOOP_BACK_HOST_DATAGRAMS);
}t(otIp6NewMessageJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jsN  KKKKotMessage *otIp6NewMessage(otInstance *aInstance, const otMessageSettings *aSettings)
{
    return AsCoreType(aInstance).Get<Ip6::Ip6>().NewMessage(0, Message::Settings::From(aSettings));
}t(otIp6NewMessageFromBufferJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jxN  KKKKX  otMessage *otIp6NewMessageFromBuffer(otInstance              *aInstance,
                                     const uint8_t           *aData,
                                     uint16_t                 aDataLength,
                                     const otMessageSettings *aSettings)
{
    return (aSettings != nullptr)
               ? AsCoreType(aInstance).Get<Ip6::Ip6>().NewMessage(aData, aDataLength, AsCoreType(aSettings))
               : AsCoreType(aInstance).Get<Ip6::Ip6>().NewMessage(aData, aDataLength);
}t(otIp6AddUnsecurePortJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(j}N  KKKKotError otIp6AddUnsecurePort(otInstance *aInstance, uint16_t aPort)
{
    return AsCoreType(aInstance).Get<Ip6::Filter>().AddUnsecurePort(aPort);
}t(otIp6RemoveUnsecurePortJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKotError otIp6RemoveUnsecurePort(otInstance *aInstance, uint16_t aPort)
{
    return AsCoreType(aInstance).Get<Ip6::Filter>().RemoveUnsecurePort(aPort);
}t(otIp6RemoveAllUnsecurePortsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKvoid otIp6RemoveAllUnsecurePorts(otInstance *aInstance)
{
    AsCoreType(aInstance).Get<Ip6::Filter>().RemoveAllUnsecurePorts();
}t(otIp6GetUnsecurePortsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKconst uint16_t *otIp6GetUnsecurePorts(otInstance *aInstance, uint8_t *aNumEntries)
{
    AssertPointerIsNotNull(aNumEntries);

    return AsCoreType(aInstance).Get<Ip6::Filter>().GetUnsecurePorts(*aNumEntries);
}t(otIp6IsAddressEqualJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKbool otIp6IsAddressEqual(const otIp6Address *aFirst, const otIp6Address *aSecond)
{
    return AsCoreType(aFirst) == AsCoreType(aSecond);
}t(otIp6ArePrefixesEqualJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKbool otIp6ArePrefixesEqual(const otIp6Prefix *aFirst, const otIp6Prefix *aSecond)
{
    return AsCoreType(aFirst) == AsCoreType(aSecond);
}t(otIp6AddressFromStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKotError otIp6AddressFromString(const char *aString, otIp6Address *aAddress)
{
    return AsCoreType(aAddress).FromString(aString);
}t(otIp6AddressToStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKvoid otIp6AddressToString(const otIp6Address *aAddress, char *aBuffer, uint16_t aSize)
{
    AssertPointerIsNotNull(aBuffer);

    AsCoreType(aAddress).ToString(aBuffer, aSize);
}t(otIp6SockAddrToStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKvoid otIp6SockAddrToString(const otSockAddr *aSockAddr, char *aBuffer, uint16_t aSize)
{
    AssertPointerIsNotNull(aBuffer);

    AsCoreType(aSockAddr).ToString(aBuffer, aSize);
}t(otIp6PrefixToStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKvoid otIp6PrefixToString(const otIp6Prefix *aPrefix, char *aBuffer, uint16_t aSize)
{
    AssertPointerIsNotNull(aBuffer);

    AsCoreType(aPrefix).ToString(aBuffer, aSize);
}t(otIp6PrefixMatchJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKuint8_t otIp6PrefixMatch(const otIp6Address *aFirst, const otIp6Address *aSecond)
{
    return AsCoreType(aFirst).PrefixMatch(AsCoreType(aSecond));
}t(otIp6GetPrefixJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKvoid otIp6GetPrefix(const otIp6Address *aAddress, uint8_t aLength, otIp6Prefix *aPrefix)
{
    AsCoreType(aAddress).GetPrefix(aLength, AsCoreType(aPrefix));
}t(otIp6IsAddressUnspecifiedJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKnmbool otIp6IsAddressUnspecified(const otIp6Address *aAddress) { return AsCoreType(aAddress).IsUnspecified(); }t(otIp6SelectSourceAddressJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKotError otIp6SelectSourceAddress(otInstance *aInstance, otMessageInfo *aMessageInfo)
{
    return AsCoreType(aInstance).Get<Ip6::Ip6>().SelectSourceAddress(AsCoreType(aMessageInfo));
}t(otIp6RegisterMulticastListenersJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKX  otError otIp6RegisterMulticastListeners(otInstance                             *aInstance,
                                        const otIp6Address                     *aAddresses,
                                        uint8_t                                 aAddressNum,
                                        const uint32_t                         *aTimeout,
                                        otIp6RegisterMulticastListenersCallback aCallback,
                                        void                                   *aContext)
{
    return AsCoreType(aInstance).Get<MlrManager>().RegisterMulticastListeners(aAddresses, aAddressNum, aTimeout,
                                                                              aCallback, aContext);
}t(otIp6IsSlaacEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKKKrqbool otIp6IsSlaacEnabled(otInstance *aInstance) { return AsCoreType(aInstance).Get<Utils::Slaac>().IsEnabled(); }t(otIp6SetSlaacEnabledJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppKNt(jN  KKMKX  void otIp6SetSlaacEnabled(otInstance *aInstance, bool aEnabled)
{
    Instance &instance = AsCoreType(aInstance);

    if (aEnabled)
    {
        instance.Get<Utils::Slaac>().Enable();
    }
    else
    {
        instance.Get<Utils::Slaac>().Disable();
    }
}t(otIp6SetSlaacPrefixFilterJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppMNt(jN  MKMKvoid otIp6SetSlaacPrefixFilter(otInstance *aInstance, otIp6SlaacPrefixFilter aFilter)
{
    AsCoreType(aInstance).Get<Utils::Slaac>().SetFilter(aFilter);
}t(otIp6ProtoToStringJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/ip6_api.cppMNt(jN  MKMKa`const char *otIp6ProtoToString(uint8_t aIpProto) { return Ip6::Ip6::IpProtoToString(aIpProto); }t(pk_write_ec_pubkey\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cKoNt(jN  KoKKKX  static int pk_write_ec_pubkey( unsigned char **p, unsigned char *start,
                               mbedtls_ecp_keypair *ec )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    size_t len = 0;
    unsigned char buf[MBEDTLS_ECP_MAX_PT_LEN];

    if( ( ret = mbedtls_ecp_point_write_binary( &ec->grp, &ec->Q,
                                        MBEDTLS_ECP_PF_UNCOMPRESSED,
                                        &len, buf, sizeof( buf ) ) ) != 0 )
    {
        return( ret );
    }

    if( *p < start || (size_t)( *p - start ) < len )
        return( MBEDTLS_ERR_ASN1_BUF_TOO_SMALL );

    *p -= len;
    memcpy( *p, buf, len );

    return( (int) len );
}t(pk_write_ec_param\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cKNt(jN  KKKKX  static int pk_write_ec_param( unsigned char **p, unsigned char *start,
                              mbedtls_ecp_keypair *ec )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    size_t len = 0;
    const char *oid;
    size_t oid_len;

    if( ( ret = mbedtls_oid_get_oid_by_ec_grp( ec->grp.id, &oid, &oid_len ) ) != 0 )
        return( ret );

    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_oid( p, start, oid, oid_len ) );

    return( (int) len );
}t(pk_write_ec_private\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cKNt(jN  KKKKX  static int pk_write_ec_private( unsigned char **p, unsigned char *start,
                                mbedtls_ecp_keypair *ec )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    size_t byte_length = ( ec->grp.pbits + 7 ) / 8;
    unsigned char tmp[MBEDTLS_ECP_MAX_BYTES];

    ret = mbedtls_ecp_write_key( ec, tmp, byte_length );
    if( ret != 0 )
        goto exit;
    ret = mbedtls_asn1_write_octet_string( p, start, tmp, byte_length );

exit:
    mbedtls_platform_zeroize( tmp, byte_length );
    return( ret );
}t(mbedtls_pk_write_pubkey\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cKNt(jN  KKKKX  int mbedtls_pk_write_pubkey( unsigned char **p, unsigned char *start,
                             const mbedtls_pk_context *key )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    size_t len = 0;

    PK_VALIDATE_RET( p != NULL );
    PK_VALIDATE_RET( *p != NULL );
    PK_VALIDATE_RET( start != NULL );
    PK_VALIDATE_RET( key != NULL );

#if defined(MBEDTLS_RSA_C)
    if( mbedtls_pk_get_type( key ) == MBEDTLS_PK_RSA )
        MBEDTLS_ASN1_CHK_ADD( len, pk_write_rsa_pubkey( p, start, mbedtls_pk_rsa( *key ) ) );
    else
#endif
#if defined(MBEDTLS_ECP_C)
    if( mbedtls_pk_get_type( key ) == MBEDTLS_PK_ECKEY )
        MBEDTLS_ASN1_CHK_ADD( len, pk_write_ec_pubkey( p, start, mbedtls_pk_ec( *key ) ) );
    else
#endif
#if defined(MBEDTLS_USE_PSA_CRYPTO)
    if( mbedtls_pk_get_type( key ) == MBEDTLS_PK_OPAQUE )
    {
        size_t buffer_size;
        psa_key_id_t* key_id = (psa_key_id_t*) key->pk_ctx;

        if ( *p < start )
            return( MBEDTLS_ERR_PK_BAD_INPUT_DATA );

        buffer_size = (size_t)( *p - start );
        if ( psa_export_public_key( *key_id, start, buffer_size, &len )
             != PSA_SUCCESS )
        {
            return( MBEDTLS_ERR_PK_BAD_INPUT_DATA );
        }
        else
        {
            *p -= len;
            memmove( *p, start, len );
        }
    }
    else
#endif /* MBEDTLS_USE_PSA_CRYPTO */
        return( MBEDTLS_ERR_PK_FEATURE_UNAVAILABLE );

    return( (int) len );
}t(mbedtls_pk_write_pubkey_der\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cKNt(jN  KKM7KX  int mbedtls_pk_write_pubkey_der( mbedtls_pk_context *key, unsigned char *buf, size_t size )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    unsigned char *c;
    size_t len = 0, par_len = 0, oid_len;
    mbedtls_pk_type_t pk_type;
    const char *oid;

    PK_VALIDATE_RET( key != NULL );
    if( size == 0 )
        return( MBEDTLS_ERR_ASN1_BUF_TOO_SMALL );
    PK_VALIDATE_RET( buf != NULL );

    c = buf + size;

    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_pk_write_pubkey( &c, buf, key ) );

    if( c - buf < 1 )
        return( MBEDTLS_ERR_ASN1_BUF_TOO_SMALL );

    /*
     *  SubjectPublicKeyInfo  ::=  SEQUENCE  {
     *       algorithm            AlgorithmIdentifier,
     *       subjectPublicKey     BIT STRING }
     */
    *--c = 0;
    len += 1;

    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_len( &c, buf, len ) );
    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_tag( &c, buf, MBEDTLS_ASN1_BIT_STRING ) );

    pk_type = mbedtls_pk_get_type( key );
#if defined(MBEDTLS_ECP_C)
    if( pk_type == MBEDTLS_PK_ECKEY )
    {
        MBEDTLS_ASN1_CHK_ADD( par_len, pk_write_ec_param( &c, buf, mbedtls_pk_ec( *key ) ) );
    }
#endif
#if defined(MBEDTLS_USE_PSA_CRYPTO)
    if( pk_type == MBEDTLS_PK_OPAQUE )
    {
        psa_key_attributes_t attributes = PSA_KEY_ATTRIBUTES_INIT;
        psa_key_type_t key_type;
        psa_key_id_t key_id;
        psa_ecc_family_t curve;
        size_t bits;

        key_id = *((psa_key_id_t*) key->pk_ctx );
        if( PSA_SUCCESS != psa_get_key_attributes( key_id, &attributes ) )
            return( MBEDTLS_ERR_PK_HW_ACCEL_FAILED );
        key_type = psa_get_key_type( &attributes );
        bits = psa_get_key_bits( &attributes );
        psa_reset_key_attributes( &attributes );

        curve = PSA_KEY_TYPE_ECC_GET_FAMILY( key_type );
        if( curve == 0 )
            return( MBEDTLS_ERR_PK_FEATURE_UNAVAILABLE );

        ret = mbedtls_psa_get_ecc_oid_from_id( curve, bits, &oid, &oid_len );
        if( ret != 0 )
            return( MBEDTLS_ERR_PK_FEATURE_UNAVAILABLE );

        /* Write EC algorithm parameters; that's akin
         * to pk_write_ec_param() above. */
        MBEDTLS_ASN1_CHK_ADD( par_len, mbedtls_asn1_write_oid( &c, buf,
                                                               oid, oid_len ) );

        /* The rest of the function works as for legacy EC contexts. */
        pk_type = MBEDTLS_PK_ECKEY;
    }
#endif /* MBEDTLS_USE_PSA_CRYPTO */

    if( ( ret = mbedtls_oid_get_oid_by_pk_alg( pk_type, &oid,
                                               &oid_len ) ) != 0 )
    {
        return( ret );
    }

    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_algorithm_identifier( &c, buf, oid, oid_len,
                                                        par_len ) );

    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_len( &c, buf, len ) );
    MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_tag( &c, buf, MBEDTLS_ASN1_CONSTRUCTED |
                                                MBEDTLS_ASN1_SEQUENCE ) );

    return( (int) len );
}t(mbedtls_pk_write_key_der\/Data3/weisw/learn/progs/fzbench_progs/openthread/third_party/mbedtls/repo/library/pkwrite.cM9Nt(jN  M9KMKX,  int mbedtls_pk_write_key_der( mbedtls_pk_context *key, unsigned char *buf, size_t size )
{
    int ret = MBEDTLS_ERR_ERROR_CORRUPTION_DETECTED;
    unsigned char *c;
    size_t len = 0;

    PK_VALIDATE_RET( key != NULL );
    if( size == 0 )
        return( MBEDTLS_ERR_ASN1_BUF_TOO_SMALL );
    PK_VALIDATE_RET( buf != NULL );

    c = buf + size;

#if defined(MBEDTLS_RSA_C)
    if( mbedtls_pk_get_type( key ) == MBEDTLS_PK_RSA )
    {
        mbedtls_mpi T; /* Temporary holding the exported parameters */
        mbedtls_rsa_context *rsa = mbedtls_pk_rsa( *key );

        /*
         * Export the parameters one after another to avoid simultaneous copies.
         */

        mbedtls_mpi_init( &T );

        /* Export QP */
        if( ( ret = mbedtls_rsa_export_crt( rsa, NULL, NULL, &T ) ) != 0 ||
            ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export DQ */
        if( ( ret = mbedtls_rsa_export_crt( rsa, NULL, &T, NULL ) ) != 0 ||
            ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export DP */
        if( ( ret = mbedtls_rsa_export_crt( rsa, &T, NULL, NULL ) ) != 0 ||
            ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export Q */
        if ( ( ret = mbedtls_rsa_export( rsa, NULL, NULL,
                                         &T, NULL, NULL ) ) != 0 ||
             ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export P */
        if ( ( ret = mbedtls_rsa_export( rsa, NULL, &T,
                                         NULL, NULL, NULL ) ) != 0 ||
             ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export D */
        if ( ( ret = mbedtls_rsa_export( rsa, NULL, NULL,
                                         NULL, &T, NULL ) ) != 0 ||
             ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export E */
        if ( ( ret = mbedtls_rsa_export( rsa, NULL, NULL,
                                         NULL, NULL, &T ) ) != 0 ||
             ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

        /* Export N */
        if ( ( ret = mbedtls_rsa_export( rsa, &T, NULL,
                                         NULL, NULL, NULL ) ) != 0 ||
             ( ret = mbedtls_asn1_write_mpi( &c, buf, &T ) ) < 0 )
            goto end_of_export;
        len += ret;

    end_of_export:

        mbedtls_mpi_free( &T );
        if( ret < 0 )
            return( ret );

        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_int( &c, buf, 0 ) );
        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_len( &c, buf, len ) );
        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_tag( &c,
                                               buf, MBEDTLS_ASN1_CONSTRUCTED |
                                               MBEDTLS_ASN1_SEQUENCE ) );
    }
    else
#endif /* MBEDTLS_RSA_C */
#if defined(MBEDTLS_ECP_C)
    if( mbedtls_pk_get_type( key ) == MBEDTLS_PK_ECKEY )
    {
        mbedtls_ecp_keypair *ec = mbedtls_pk_ec( *key );
        size_t pub_len = 0, par_len = 0;

        /*
         * RFC 5915, or SEC1 Appendix C.4
         *
         * ECPrivateKey ::= SEQUENCE {
         *      version        INTEGER { ecPrivkeyVer1(1) } (ecPrivkeyVer1),
         *      privateKey     OCTET STRING,
         *      parameters [0] ECParameters {{ NamedCurve }} OPTIONAL,
         *      publicKey  [1] BIT STRING OPTIONAL
         *    }
         */

        /* publicKey */
        MBEDTLS_ASN1_CHK_ADD( pub_len, pk_write_ec_pubkey( &c, buf, ec ) );

        if( c - buf < 1 )
            return( MBEDTLS_ERR_ASN1_BUF_TOO_SMALL );
        *--c = 0;
        pub_len += 1;

        MBEDTLS_ASN1_CHK_ADD( pub_len, mbedtls_asn1_write_len( &c, buf, pub_len ) );
        MBEDTLS_ASN1_CHK_ADD( pub_len, mbedtls_asn1_write_tag( &c, buf, MBEDTLS_ASN1_BIT_STRING ) );

        MBEDTLS_ASN1_CHK_ADD( pub_len, mbedtls_asn1_write_len( &c, buf, pub_len ) );
        MBEDTLS_ASN1_CHK_ADD( pub_len, mbedtls_asn1_write_tag( &c, buf,
                            MBEDTLS_ASN1_CONTEXT_SPECIFIC | MBEDTLS_ASN1_CONSTRUCTED | 1 ) );
        len += pub_len;

        /* parameters */
        MBEDTLS_ASN1_CHK_ADD( par_len, pk_write_ec_param( &c, buf, ec ) );

        MBEDTLS_ASN1_CHK_ADD( par_len, mbedtls_asn1_write_len( &c, buf, par_len ) );
        MBEDTLS_ASN1_CHK_ADD( par_len, mbedtls_asn1_write_tag( &c, buf,
                            MBEDTLS_ASN1_CONTEXT_SPECIFIC | MBEDTLS_ASN1_CONSTRUCTED | 0 ) );
        len += par_len;

        /* privateKey */
        MBEDTLS_ASN1_CHK_ADD( len, pk_write_ec_private( &c, buf, ec ) );

        /* version */
        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_int( &c, buf, 1 ) );

        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_len( &c, buf, len ) );
        MBEDTLS_ASN1_CHK_ADD( len, mbedtls_asn1_write_tag( &c, buf, MBEDTLS_ASN1_CONSTRUCTED |
                                                    MBEDTLS_ASN1_SEQUENCE ) );
    }
    else
#endif /* MBEDTLS_ECP_C */
        return( MBEDTLS_ERR_PK_FEATURE_UNAVAILABLE );

    return( (int) len );
}t(MplJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppK/Mplt(jN  K/KK7KMpl::Mpl(Instance &aInstance)
    : InstanceLocator(aInstance)
    , mSequence(0)
#if OPENTHREAD_FTD
    , mRetransmissionTimer(aInstance)
#endif
{
    memset(mSeedSet, 0, sizeof(mSeedSet));
}t(
InitOptionJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppK9Mplt(j O  K9KKKKX,  void Mpl::InitOption(OptionMpl &aOption, const Address &aAddress)
{
    aOption.Init();
    aOption.SetSequence(mSequence++);

    // Seed ID can be elided when `aAddress` is RLOC.
    if (aAddress == Get<Mle::Mle>().GetMeshLocal16())
    {
        aOption.SetSeedIdLength(OptionMpl::kSeedIdLength0);

        // Decrease default option length.
        aOption.SetLength(aOption.GetLength() - sizeof(uint16_t));
    }
    else
    {
        aOption.SetSeedIdLength(OptionMpl::kSeedIdLength2);
        aOption.SetSeedId(Get<Mle::Mle>().GetRloc16());
    }
}t(
ProcessOptionJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppKMMplt(jO  KMKKzKX  Error Mpl::ProcessOption(Message &aMessage, const Address &aAddress, bool aIsOutbound, bool &aReceive)
{
    Error     error;
    OptionMpl option;

    // Read the min size bytes first, then check the expected
    // `SeedIdLength` and read the full `OptionMpl` if needed.
    SuccessOrExit(error = aMessage.Read(aMessage.GetOffset(), &option, OptionMpl::kMinSize));

    switch (option.GetSeedIdLength())
    {
    case OptionMpl::kSeedIdLength0:
        // Retrieve Seed ID from the IPv6 Source Address RLOC.
        VerifyOrExit(aAddress.GetIid().IsLocator(), error = kErrorDrop);
        option.SetSeedId(aAddress.GetIid().GetLocator());
        break;

    case OptionMpl::kSeedIdLength2:
        SuccessOrExit(error = aMessage.Read(aMessage.GetOffset(), option));
        break;

    case OptionMpl::kSeedIdLength8:
    case OptionMpl::kSeedIdLength16:
        ExitNow(error = kErrorParse);
    }

    // Check if the MPL Data Message is new.
    error = UpdateSeedSet(option.GetSeedId(), option.GetSequence());

    if (error == kErrorNone)
    {
#if OPENTHREAD_FTD
        AddBufferedMessage(aMessage, option.GetSeedId(), option.GetSequence(), aIsOutbound);
#endif
    }
    else if (aIsOutbound)
    {
        aReceive = false;
        // In case MPL Data Message is generated locally, ignore potential error of the MPL Seed Set
        // to allow subsequent retransmissions with the same sequence number.
        ExitNow(error = kErrorNone);
    }

exit:
    return error;
}t(
UpdateSeedSetJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppKMplt(jO  KKMKX
  Error Mpl::UpdateSeedSet(uint16_t aSeedId, uint8_t aSequence)
{
    Error      error    = kErrorNone;
    SeedEntry *insert   = nullptr;
    SeedEntry *group    = mSeedSet;
    SeedEntry *evict    = mSeedSet;
    uint8_t    curCount = 0;
    uint8_t    maxCount = 0;

    for (uint32_t i = 0; i < kNumSeedEntries; i++, curCount++)
    {
        if (mSeedSet[i].mLifetime == 0)
        {
            // unused entries exist

            if (insert == nullptr)
            {
                // no existing group, set insert and evict entry to be the same
                insert = &mSeedSet[i];
            }

            // mark first unused entry for eviction
            evict = &mSeedSet[i];
            break;
        }

        if (mSeedSet[i].mSeedId != group->mSeedId)
        {
            // processing new group

            if (aSeedId == group->mSeedId && insert == nullptr)
            {
                // insert at end of existing group
                insert = &mSeedSet[i];
                curCount++;
            }

            if (maxCount < curCount)
            {
                // look to evict an entry from the seed with the most entries
                evict    = group;
                maxCount = curCount;
            }

            group    = &mSeedSet[i];
            curCount = 0;
        }

        if (aSeedId == mSeedSet[i].mSeedId)
        {
            // have existing entries for aSeedId

            if (aSequence == mSeedSet[i].mSequence)
            {
                // already received, drop message

                mSeedSet[i].mLifetime = kSeedEntryLifetime;
                ExitNow(error = kErrorDrop);
            }
            else if (insert == nullptr && SerialNumber::IsLess(aSequence, mSeedSet[i].mSequence))
            {
                // insert in order of sequence
                insert = &mSeedSet[i];
                curCount++;
            }
        }
    }

    if (evict->mLifetime != 0)
    {
        // no free entries available, look to evict an existing entry
        OT_ASSERT(curCount != 0);

        if (aSeedId == group->mSeedId && insert == nullptr)
        {
            // insert at end of existing group
            insert = &mSeedSet[kNumSeedEntries];
            curCount++;
        }

        if (maxCount < curCount)
        {
            // look to evict an entry from the seed with the most entries
            evict    = group;
            maxCount = curCount;
        }

        // require evict group size to have >= 2 entries
        VerifyOrExit(maxCount > 1, error = kErrorDrop);

        if (insert == nullptr)
        {
            // no existing entries for aSeedId
            insert = evict;
        }
        else
        {
            // require Sequence to be larger than oldest stored Sequence in group
            VerifyOrExit(insert > mSeedSet && aSeedId == (insert - 1)->mSeedId, error = kErrorDrop);
        }
    }

    if (evict > insert)
    {
        OT_ASSERT(insert >= mSeedSet);
        memmove(insert + 1, insert, static_cast<size_t>(evict - insert) * sizeof(SeedEntry));
    }
    else if (evict < insert)
    {
        OT_ASSERT(evict >= mSeedSet);
        memmove(evict, evict + 1, static_cast<size_t>(insert - 1 - evict) * sizeof(SeedEntry));
        insert--;
    }

    insert->mSeedId   = aSeedId;
    insert->mSequence = aSequence;
    insert->mLifetime = kSeedEntryLifetime;

    Get<TimeTicker>().RegisterReceiver(TimeTicker::kIp6Mpl);

exit:
    return error;
}t(HandleTimeTickJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppM
Mplt(jO  M
KM&KXI  void Mpl::HandleTimeTick(void)
{
    bool continueRxingTicks = false;
    int  j                  = 0;

    for (int i = 0; i < kNumSeedEntries && mSeedSet[i].mLifetime; i++)
    {
        mSeedSet[i].mLifetime--;

        if (mSeedSet[i].mLifetime > 0)
        {
            mSeedSet[j++]      = mSeedSet[i];
            continueRxingTicks = true;
        }
    }

    for (; j < kNumSeedEntries && mSeedSet[j].mLifetime; j++)
    {
        mSeedSet[j].mLifetime = 0;
    }

    if (!continueRxingTicks)
    {
        Get<TimeTicker>().UnregisterReceiver(TimeTicker::kIp6Mpl);
    }
}t(GetTimerExpirationsJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppM*Mplt(jO  M*KM?KX  uint8_t Mpl::GetTimerExpirations(void) const
{
    uint8_t timerExpirations = 0;

    switch (Get<Mle::Mle>().GetRole())
    {
    case Mle::kRoleDisabled:
    case Mle::kRoleDetached:
        break;

    case Mle::kRoleChild:
        timerExpirations = kChildTimerExpirations;
        break;

    case Mle::kRoleRouter:
    case Mle::kRoleLeader:
        timerExpirations = kRouterTimerExpirations;
        break;
    }

    return timerExpirations;
}t(AddBufferedMessageJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMAMplt(jO  MAKMfKXl  void Mpl::AddBufferedMessage(Message &aMessage, uint16_t aSeedId, uint8_t aSequence, bool aIsOutbound)
{
    Error    error       = kErrorNone;
    Message *messageCopy = nullptr;
    Metadata metadata;
    uint8_t  hopLimit = 0;

#if OPENTHREAD_CONFIG_MPL_DYNAMIC_INTERVAL_ENABLE
    // adjust the first MPL forward interval dynamically according to the network scale
    uint8_t interval = (kDataMessageInterval / Mle::kMaxRouters) * Get<RouterTable>().GetNeighborCount();
#else
    uint8_t interval = kDataMessageInterval;
#endif

    VerifyOrExit(GetTimerExpirations() > 0);
    VerifyOrExit((messageCopy = aMessage.Clone()) != nullptr, error = kErrorNoBufs);

    if (!aIsOutbound)
    {
        IgnoreError(aMessage.Read(Header::kHopLimitFieldOffset, hopLimit));
        VerifyOrExit(hopLimit-- > 1, error = kErrorDrop);
        messageCopy->Write(Header::kHopLimitFieldOffset, hopLimit);
    }

    metadata.mSeedId            = aSeedId;
    metadata.mSequence          = aSequence;
    metadata.mTransmissionCount = aIsOutbound ? 1 : 0;
    metadata.mIntervalOffset    = 0;
    metadata.GenerateNextTransmissionTime(TimerMilli::GetNow(), interval);

    SuccessOrExit(error = metadata.AppendTo(*messageCopy));
    mBufferedMessageSet.Enqueue(*messageCopy);

    mRetransmissionTimer.FireAtIfEarlier(metadata.mTransmissionTime);

exit:
    FreeMessageOnError(messageCopy, error);
}t(HandleRetransmissionTimerJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMhMplt(j$O  MhKMKX;  void Mpl::HandleRetransmissionTimer(void)
{
    TimeMilli now      = TimerMilli::GetNow();
    TimeMilli nextTime = now.GetDistantFuture();
    Metadata  metadata;

    for (Message &message : mBufferedMessageSet)
    {
        metadata.ReadFrom(message);

        if (now < metadata.mTransmissionTime)
        {
            nextTime = Min(nextTime, metadata.mTransmissionTime);
        }
        else
        {
            uint8_t timerExpirations = GetTimerExpirations();

            // Update the number of transmission timer expirations.
            metadata.mTransmissionCount++;

            if (metadata.mTransmissionCount < timerExpirations)
            {
                Message *messageCopy = message.Clone(message.GetLength() - sizeof(Metadata));

                if (messageCopy != nullptr)
                {
                    if (metadata.mTransmissionCount > 1)
                    {
                        messageCopy->SetSubType(Message::kSubTypeMplRetransmission);
                    }

                    Get<Ip6>().EnqueueDatagram(*messageCopy);
                }

                metadata.GenerateNextTransmissionTime(now, kDataMessageInterval);
                metadata.UpdateIn(message);

                nextTime = Min(nextTime, metadata.mTransmissionTime);
            }
            else
            {
                mBufferedMessageSet.Dequeue(message);

                if (metadata.mTransmissionCount == timerExpirations)
                {
                    if (metadata.mTransmissionCount > 1)
                    {
                        message.SetSubType(Message::kSubTypeMplRetransmission);
                    }

                    metadata.RemoveFrom(message);
                    Get<Ip6>().EnqueueDatagram(message);
                }
                else
                {
                    // Stop retransmitting if the number of timer expirations is already exceeded.
                    message.Free();
                }
            }
        }
    }

    if (nextTime < now.GetDistantFuture())
    {
        mRetransmissionTimer.FireAt(nextTime);
    }
}t(ReadFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMMetadatat(j*O  MKMKvoid Mpl::Metadata::ReadFrom(const Message &aMessage)
{
    uint16_t length = aMessage.GetLength();

    OT_ASSERT(length >= sizeof(*this));
    IgnoreError(aMessage.Read(length - sizeof(*this), *this));
}t(
RemoveFromJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMMetadatat(j0O  MKMKvoid Mpl::Metadata::RemoveFrom(Message &aMessage) const
{
    SuccessOrAssert(aMessage.SetLength(aMessage.GetLength() - sizeof(*this)));
}t(UpdateInJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMMetadatat(j6O  MKMKwvvoid Mpl::Metadata::UpdateIn(Message &aMessage) const { aMessage.Write(aMessage.GetLength() - sizeof(*this), *this); }t(GenerateNextTransmissionTimeJ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/net/ip6_mpl.cppMMetadatat(j<O  MKMKX  void Mpl::Metadata::GenerateNextTransmissionTime(TimeMilli aCurrentTime, uint8_t aInterval)
{
    // Emulate Trickle timer behavior and set up the next retransmission within [0,I) range.
    uint8_t t = (aInterval == 0) ? aInterval : Random::NonCrypto::GetUint8InRange(0, aInterval);

    // Set transmission time at the beginning of the next interval.
    mTransmissionTime = aCurrentTime + static_cast<uint32_t>(mIntervalOffset + t);
    mIntervalOffset   = aInterval - t;
}t(
TimeTickerQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.cppK-
TimeTickert(jBO  K-KK2K|TimeTicker::TimeTicker(Instance &aInstance)
    : InstanceLocator(aInstance)
    , mReceivers(0)
    , mTimer(aInstance)
{
}t(RegisterReceiverQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.cppK4
TimeTickert(jHO  K4KK<Kvoid TimeTicker::RegisterReceiver(Receiver aReceiver)
{
    mReceivers |= Mask(aReceiver);

    if (!mTimer.IsRunning())
    {
        mTimer.Start(Random::NonCrypto::GetUint32InRange(0, kTickInterval + 1));
    }
}t(UnregisterReceiverQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.cppK>
TimeTickert(jNO  K>KKFKvoid TimeTicker::UnregisterReceiver(Receiver aReceiver)
{
    mReceivers &= ~Mask(aReceiver);

    if (mReceivers == 0)
    {
        mTimer.Stop();
    }
}t(HandleTimerQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/common/time_ticker.cppKH
TimeTickert(jTO  KHKKKX  void TimeTicker::HandleTimer(void)
{
    mTimer.FireAt(mTimer.GetFireTime() + Random::NonCrypto::AddJitter(kTickInterval, kRestartJitter));

    if (mReceivers & Mask(kMeshForwarder))
    {
        Get<MeshForwarder>().HandleTimeTick();
    }

#if OPENTHREAD_FTD
    if (mReceivers & Mask(kMleRouter))
    {
        Get<Mle::MleRouter>().HandleTimeTick();
    }

    if (mReceivers & Mask(kAddressResolver))
    {
        Get<AddressResolver>().HandleTimeTick();
    }

#if OPENTHREAD_CONFIG_BORDER_ROUTER_ENABLE && OPENTHREAD_CONFIG_BORDER_ROUTER_REQUEST_ROUTER_ROLE
    if (mReceivers & Mask(kNetworkDataNotifier))
    {
        Get<NetworkData::Notifier>().HandleTimeTick();
    }
#endif

#if OPENTHREAD_CONFIG_CHILD_SUPERVISION_ENABLE
    if (mReceivers & Mask(kChildSupervisor))
    {
        Get<Utils::ChildSupervisor>().HandleTimeTick();
    }
#endif
#endif // OPENTHREAD_FTD

#if OPENTHREAD_CONFIG_IP6_FRAGMENTATION_ENABLE
    if (mReceivers & Mask(kIp6FragmentReassembler))
    {
        Get<Ip6::Ip6>().HandleTimeTick();
    }
#endif

#if OPENTHREAD_CONFIG_DUA_ENABLE || (OPENTHREAD_FTD && OPENTHREAD_CONFIG_TMF_PROXY_DUA_ENABLE)
    if (mReceivers & Mask(kDuaManager))
    {
        Get<DuaManager>().HandleTimeTick();
    }
#endif

#if OPENTHREAD_CONFIG_MLR_ENABLE || (OPENTHREAD_FTD && OPENTHREAD_CONFIG_TMF_PROXY_MLR_ENABLE)
    if (mReceivers & Mask(kMlrManager))
    {
        Get<MlrManager>().HandleTimeTick();
    }
#endif

    if (mReceivers & Mask(kIp6Mpl))
    {
        Get<Ip6::Mpl>().HandleTimeTick();
    }
}t(ChildSupervisorV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppK4ChildSupervisort(jZO  K4KK8KChildSupervisor::ChildSupervisor(Instance &aInstance)
    : InstanceLocator(aInstance)
    , mSupervisionInterval(kDefaultSupervisionInterval)
{
}t(SetSupervisionIntervalV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppK:ChildSupervisort(j`O  K:KK>K|void ChildSupervisor::SetSupervisionInterval(uint16_t aInterval)
{
    mSupervisionInterval = aInterval;
    CheckState();
}t(GetDestinationV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppK@ChildSupervisort(jfO  K@KKLKXH  Child *ChildSupervisor::GetDestination(const Message &aMessage) const
{
    Child   *child = nullptr;
    uint16_t childIndex;

    VerifyOrExit(aMessage.GetType() == Message::kTypeSupervision);

    IgnoreError(aMessage.Read(0, childIndex));
    child = Get<ChildTable>().GetChildAtIndex(childIndex);

exit:
    return child;
}t(SendMessageV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKNChildSupervisort(jlO  KNKKgKXS  void ChildSupervisor::SendMessage(Child &aChild)
{
    Message *message = nullptr;
    uint16_t childIndex;

    VerifyOrExit(aChild.GetIndirectMessageCount() == 0);

    message = Get<MessagePool>().Allocate(Message::kTypeSupervision, sizeof(uint8_t));
    VerifyOrExit(message != nullptr);

    // Supervision message is an empty payload 15.4 data frame.
    // The child index is stored here in the message content to allow
    // the destination of the message to be later retrieved using
    // `ChildSupervisor::GetDestination(message)`.

    childIndex = Get<ChildTable>().GetChildIndex(aChild);
    SuccessOrExit(message->Append(childIndex));

    SuccessOrExit(Get<ThreadNetif>().SendMessage(*message));
    message = nullptr;

    LogInfo("Sending supervision message to child 0x%04x", aChild.GetRloc16());

exit:
    FreeMessage(message);
}t(UpdateOnSendV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cpp*	     KiChildSupervisort(jrO  KiKKiKa`void ChildSupervisor::UpdateOnSend(Child &aChild) { aChild.ResetSecondsSinceLastSupervision(); }t(HandleTimeTickV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKkChildSupervisort(jxO  KkKKvKXW  void ChildSupervisor::HandleTimeTick(void)
{
    for (Child &child : Get<ChildTable>().Iterate(Child::kInStateValid))
    {
        child.IncrementSecondsSinceLastSupervision();

        if ((child.GetSecondsSinceLastSupervision() >= mSupervisionInterval) && !child.IsRxOnWhenIdle())
        {
            SendMessage(child);
        }
    }
}t(
CheckStateV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKxChildSupervisort(j~O  KxKKKXb  void ChildSupervisor::CheckState(void)
{
    bool shouldRun = false;

    // Child Supervision should run if `mSupervisionInterval` is not
    // zero, Thread MLE operation is enabled, and there is at least one
    // "valid" child in the child table.

    shouldRun = ((mSupervisionInterval != 0) && !Get<Mle::MleRouter>().IsDisabled() &&
                 Get<ChildTable>().HasChildren(Child::kInStateValid));

    if (shouldRun && !Get<TimeTicker>().IsReceiverRegistered(TimeTicker::kChildSupervisor))
    {
        Get<TimeTicker>().RegisterReceiver(TimeTicker::kChildSupervisor);
        LogInfo("Starting Child Supervision");
    }

    if (!shouldRun && Get<TimeTicker>().IsReceiverRegistered(TimeTicker::kChildSupervisor))
    {
        Get<TimeTicker>().UnregisterReceiver(TimeTicker::kChildSupervisor);
        LogInfo("Stopping Child Supervision");
    }
}t(HandleNotifierEventsV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKChildSupervisort(jO  KKKKvoid ChildSupervisor::HandleNotifierEvents(Events aEvents)
{
    if (aEvents.ContainsAny(kEventThreadRoleChanged | kEventThreadChildAdded | kEventThreadChildRemoved))
    {
        CheckState();
    }
}t(SupervisionListenerV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKKSupervisionListener::SupervisionListener(Instance &aInstance)
    : InstanceLocator(aInstance)
    , mTimeout(0)
    , mTimer(aInstance)
{
    SetTimeout(kDefaultTimeout);
}t(StartV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKK:9void SupervisionListener::Start(void) { RestartTimer(); }t(StopV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKK87void SupervisionListener::Stop(void) { mTimer.Stop(); }t(
SetTimeoutV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKKvoid SupervisionListener::SetTimeout(uint16_t aTimeout)
{
    if (mTimeout != aTimeout)
    {
        mTimeout = aTimeout;
        RestartTimer();
    }
}t(UpdateOnReceiveV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKKX  void SupervisionListener::UpdateOnReceive(const Mac::Address &aSourceAddress, bool aIsSecure)
{
    // If listener is enabled and device is a child and it received a secure frame from its parent, restart the timer.

    VerifyOrExit(mTimer.IsRunning() && aIsSecure && Get<Mle::MleRouter>().IsChild() &&
                 (Get<NeighborTable>().FindNeighbor(aSourceAddress) == &Get<Mle::MleRouter>().GetParent()));

    RestartTimer();

exit:
    return;
}t(RestartTimerV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKSupervisionListenert(jO  KKKKX  void SupervisionListener::RestartTimer(void)
{
    if ((mTimeout != 0) && !Get<Mle::MleRouter>().IsDisabled() && !Get<MeshForwarder>().GetRxOnWhenIdle())
    {
        mTimer.Start(Time::SecToMsec(mTimeout));
    }
    else
    {
        mTimer.Stop();
    }
}t(HandleTimerV/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/utils/child_supervision.cppKȌSupervisionListenert(jO  KKKKX9  void SupervisionListener::HandleTimer(void)
{
    VerifyOrExit(Get<Mle::MleRouter>().IsChild() && !Get<MeshForwarder>().GetRxOnWhenIdle());

    LogWarn("Supervision timeout. No frame from parent in %d sec", mTimeout);

    IgnoreError(Get<Mle::MleRouter>().SendChildUpdateRequest());

exit:
    RestartTimer();
}t(otSrpClientStartQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK-Nt(jO  K-KK0KotError otSrpClientStart(otInstance *aInstance, const otSockAddr *aServerSockAddr)
{
    return AsCoreType(aInstance).Get<Srp::Client>().Start(AsCoreType(aServerSockAddr));
}t(otSrpClientStopQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK2Nt(jO  K2KK2Khgvoid otSrpClientStop(otInstance *aInstance) { return AsCoreType(aInstance).Get<Srp::Client>().Stop(); }t(otSrpClientIsRunningQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK4Nt(jO  K4KK4Krqbool otSrpClientIsRunning(otInstance *aInstance) { return AsCoreType(aInstance).Get<Srp::Client>().IsRunning(); }t(otSrpClientGetServerAddressQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK6Nt(jO  K6KK9Kconst otSockAddr *otSrpClientGetServerAddress(otInstance *aInstance)
{
    return &AsCoreType(aInstance).Get<Srp::Client>().GetServerAddress();
}t(otSrpClientSetCallbackQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK;Nt(jO  K;KK>Kvoid otSrpClientSetCallback(otInstance *aInstance, otSrpClientCallback aCallback, void *aContext)
{
    AsCoreType(aInstance).Get<Srp::Client>().SetCallback(aCallback, aContext);
}t(otSrpClientEnableAutoStartModeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKANt(jO  KAKKDKvoid otSrpClientEnableAutoStartMode(otInstance *aInstance, otSrpClientAutoStartCallback aCallback, void *aContext)
{
    AsCoreType(aInstance).Get<Srp::Client>().EnableAutoStartMode(aCallback, aContext);
}t(otSrpClientDisableAutoStartModeQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKFNt(jO  KFKKIKvoid otSrpClientDisableAutoStartMode(otInstance *aInstance)
{
    AsCoreType(aInstance).Get<Srp::Client>().DisableAutoStartMode();
}t(!otSrpClientIsAutoStartModeEnabledQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKKNt(jO  KKKKNKbool otSrpClientIsAutoStartModeEnabled(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Srp::Client>().IsAutoStartModeEnabled();
}t(otSrpClientGetTtlQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKQNt(jO  KQKKQKpouint32_t otSrpClientGetTtl(otInstance *aInstance) { return AsCoreType(aInstance).Get<Srp::Client>().GetTtl(); }t(otSrpClientSetTtlQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKSNt(jO  KSKKVKvoid otSrpClientSetTtl(otInstance *aInstance, uint32_t aTtl)
{
    return AsCoreType(aInstance).Get<Srp::Client>().SetTtl(aTtl);
}t(otSrpClientGetLeaseIntervalQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKXNt(jO  KXKK[Kuint32_t otSrpClientGetLeaseInterval(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Srp::Client>().GetLeaseInterval();
}t(otSrpClientSetLeaseIntervalQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK]Nt(jO  K]KK`Kvoid otSrpClientSetLeaseInterval(otInstance *aInstance, uint32_t aInterval)
{
    return AsCoreType(aInstance).Get<Srp::Client>().SetLeaseInterval(aInterval);
}t(otSrpClientGetKeyLeaseIntervalQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKbNt(jO  KbKKeKuint32_t otSrpClientGetKeyLeaseInterval(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Srp::Client>().GetKeyLeaseInterval();
}t(otSrpClientSetKeyLeaseIntervalQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKgNt(jO  KgKKjKvoid otSrpClientSetKeyLeaseInterval(otInstance *aInstance, uint32_t aInterval)
{
    return AsCoreType(aInstance).Get<Srp::Client>().SetKeyLeaseInterval(aInterval);
}t(otSrpClientGetHostInfoQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKlNt(jO  KlKKoKconst otSrpClientHostInfo *otSrpClientGetHostInfo(otInstance *aInstance)
{
    return &AsCoreType(aInstance).Get<Srp::Client>().GetHostInfo();
}t(otSrpClientSetHostNameQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKqNt(jO  KqKKtKotError otSrpClientSetHostName(otInstance *aInstance, const char *aName)
{
    return AsCoreType(aInstance).Get<Srp::Client>().SetHostName(aName);
}t( otSrpClientEnableAutoHostAddressQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKvNt(jP  KvKKyKotError otSrpClientEnableAutoHostAddress(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Srp::Client>().EnableAutoHostAddress();
}t(otSrpClientSetHostAddressesQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppK{Nt(j	P  K{KK~KotError otSrpClientSetHostAddresses(otInstance *aInstance, const otIp6Address *aIp6Addresses, uint8_t aNumAddresses)
{
    return AsCoreType(aInstance).Get<Srp::Client>().SetHostAddresses(AsCoreTypePtr(aIp6Addresses), aNumAddresses);
}t(otSrpClientAddServiceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(jP  KKKKotError otSrpClientAddService(otInstance *aInstance, otSrpClientService *aService)
{
    return AsCoreType(aInstance).Get<Srp::Client>().AddService(AsCoreType(aService));
}t(otSrpClientRemoveServiceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(jP  KKKKotError otSrpClientRemoveService(otInstance *aInstance, otSrpClientService *aService)
{
    return AsCoreType(aInstance).Get<Srp::Client>().RemoveService(AsCoreType(aService));
}t(otSrpClientClearServiceQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(jP  KKKKotError otSrpClientClearService(otInstance *aInstance, otSrpClientService *aService)
{
    return AsCoreType(aInstance).Get<Srp::Client>().ClearService(AsCoreType(aService));
}t(otSrpClientGetServicesQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(jP  KKKKconst otSrpClientService *otSrpClientGetServices(otInstance *aInstance)
{
    return AsCoreType(aInstance).Get<Srp::Client>().GetServices().GetHead();
}t( otSrpClientRemoveHostAndServicesQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(j"P  KKKKotError otSrpClientRemoveHostAndServices(otInstance *aInstance, bool aRemoveKeyLease, bool aSendUnregToServer)
{
    return AsCoreType(aInstance).Get<Srp::Client>().RemoveHostAndServices(aRemoveKeyLease, aSendUnregToServer);
}t(otSrpClientClearHostAndServicesQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(j'P  KKKKvoid otSrpClientClearHostAndServices(otInstance *aInstance)
{
    AsCoreType(aInstance).Get<Srp::Client>().ClearHostAndServices();
}t(otSrpClientItemStateToStringQ/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/api/srp_client_api.cppKNt(j,P  KKKKconst char *otSrpClientItemStateToString(otSrpClientItemState aItemState)
{
    OT_ASSERT(aItemState <= OT_SRP_CLIENT_ITEM_STATE_REMOVED);

    return Srp::Client::ItemStateToString(MapEnum(aItemState));
}t(MessageQueueP/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap_message.hppMMessageQueuet(j1P  MKMK!!    MessageQueue(void) = default;t(CoapBaseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppK5CoapBaset(j7P  K5KK@KX  CoapBase::CoapBase(Instance &aInstance, Sender aSender)
    : InstanceLocator(aInstance)
    , mMessageId(Random::NonCrypto::GetUint16())
    , mRetransmissionTimer(aInstance, Coap::HandleRetransmissionTimer, this)
    , mResponsesQueue(aInstance)
    , mResourceHandler(nullptr)
    , mSender(aSender)
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
    , mLastResponse(nullptr)
#endif
{
}t(ClearRequestsAndResponsesH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKBCoapBaset(j=P  KBKKFKvoid CoapBase::ClearRequestsAndResponses(void)
{
    ClearRequests(nullptr); // Clear requests matching any address.
    mResponsesQueue.DequeueAllResponses();
}t(
ClearRequestsH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKHCoapBaset(jCP  KHKKHKYXvoid CoapBase::ClearRequests(const Ip6::Address &aAddress) { ClearRequests(&aAddress); }t(
ClearRequestsH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKJCoapBaset(jIP  KJKKWKXq  void CoapBase::ClearRequests(const Ip6::Address *aAddress)
{
    for (Message &message : mPendingRequests)
    {
        Metadata metadata;

        metadata.ReadFrom(message);

        if ((aAddress == nullptr) || (metadata.mSourceAddress == *aAddress))
        {
            FinalizeCoapTransaction(message, metadata, nullptr, nullptr, kErrorAbort);
        }
    }
}t(AddBlockWiseResourceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKZCoapBaset(jOP  KZKKZKwvvoid CoapBase::AddBlockWiseResource(ResourceBlockWise &aResource) { IgnoreError(mBlockWiseResources.Add(aResource)); }t(RemoveBlockWiseResourceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppK\CoapBaset(jUP  K\KK`Kvoid CoapBase::RemoveBlockWiseResource(ResourceBlockWise &aResource)
{
    IgnoreError(mBlockWiseResources.Remove(aResource));
    aResource.SetNext(nullptr);
}t(AddResourceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKcCoapBaset(j[P  KcKKcK\[void CoapBase::AddResource(Resource &aResource) { IgnoreError(mResources.Add(aResource)); }t(RemoveResourceH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKeCoapBaset(jaP  KeKKiKvoid CoapBase::RemoveResource(Resource &aResource)
{
    IgnoreError(mResources.Remove(aResource));
    aResource.SetNext(nullptr);
}t(
NewMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKkCoapBaset(jgP  KkKKtKX  Message *CoapBase::NewMessage(const Message::Settings &aSettings)
{
    Message *message = nullptr;

    VerifyOrExit((message = AsCoapMessagePtr(Get<Ip6::Udp>().NewMessage(0, aSettings))) != nullptr);
    message->SetOffset(0);

exit:
    return message;
}t(!NewPriorityConfirmablePostMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKvCoapBaset(jmP  KvKKyKMessage *CoapBase::NewPriorityConfirmablePostMessage(Uri aUri)
{
    return InitMessage(NewPriorityMessage(), kTypeConfirmable, aUri);
}t(NewConfirmablePostMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppK{CoapBaset(jsP  K{KK{KutMessage *CoapBase::NewConfirmablePostMessage(Uri aUri) { return InitMessage(NewMessage(), kTypeConfirmable, aUri); }t($NewPriorityNonConfirmablePostMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppK}CoapBaset(jyP  K}KKKMessage *CoapBase::NewPriorityNonConfirmablePostMessage(Uri aUri)
{
    return InitMessage(NewPriorityMessage(), kTypeNonConfirmable, aUri);
}t(NewNonConfirmablePostMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKK~Message *CoapBase::NewNonConfirmablePostMessage(Uri aUri)
{
    return InitMessage(NewMessage(), kTypeNonConfirmable, aUri);
}t(NewPriorityResponseMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKKMessage *CoapBase::NewPriorityResponseMessage(const Message &aRequest)
{
    return InitResponse(NewPriorityMessage(), aRequest);
}tu((NewResponseMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKKpoMessage *CoapBase::NewResponseMessage(const Message &aRequest) { return InitResponse(NewMessage(), aRequest); }t(InitMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKKXZ  Message *CoapBase::InitMessage(Message *aMessage, Type aType, Uri aUri)
{
    Error error = kErrorNone;

    VerifyOrExit(aMessage != nullptr);

    SuccessOrExit(error = aMessage->Init(aType, kCodePost, aUri));
    SuccessOrExit(error = aMessage->SetPayloadMarker());

exit:
    FreeAndNullMessageOnError(aMessage, error);
    return aMessage;
}t(InitResponseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKKXf  Message *CoapBase::InitResponse(Message *aMessage, const Message &aResponse)
{
    Error error = kErrorNone;

    VerifyOrExit(aMessage != nullptr);

    SuccessOrExit(error = aMessage->SetDefaultResponseHeader(aResponse));
    SuccessOrExit(error = aMessage->SetPayloadMarker());

exit:
    FreeAndNullMessageOnError(aMessage, error);
    return aMessage;
}t(SendH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKKKX  Error CoapBase::Send(ot::Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
{
    Error error;

#if OPENTHREAD_CONFIG_OTNS_ENABLE
    Get<Utils::Otns>().EmitCoapSend(AsCoapMessage(&aMessage), aMessageInfo);
#endif

    error = mSender(*this, aMessage, aMessageInfo);

#if OPENTHREAD_CONFIG_OTNS_ENABLE
    if (error != kErrorNone)
    {
        Get<Utils::Otns>().EmitCoapSendFailure(error, AsCoapMessage(&aMessage), aMessageInfo);
    }
#endif
    return error;
}t(SendMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppKCoapBaset(jP  KKM`KX  Error CoapBase::SendMessage(Message                    &aMessage,
                            const Ip6::MessageInfo     &aMessageInfo,
                            const TxParameters         &aTxParameters,
                            ResponseHandler             aHandler,
                            void                       *aContext,
                            otCoapBlockwiseTransmitHook aTransmitHook,
                            otCoapBlockwiseReceiveHook  aReceiveHook)
#else
Error CoapBase::SendMessage(Message                &aMessage,
                            const Ip6::MessageInfo &aMessageInfo,
                            const TxParameters     &aTxParameters,
                            ResponseHandler         aHandler,
                            void                   *aContext)
#endif
{
    Error    error;
    Message *storedCopy = nullptr;
    uint16_t copyLength = 0;
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
    uint8_t  buf[kMaxBlockLength] = {0};
    uint16_t bufLen               = kMaxBlockLength;
    bool     moreBlocks           = false;
#endif

    switch (aMessage.GetType())
    {
    case kTypeAck:
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
        // Check for block-wise transfer
        if ((aTransmitHook != nullptr) && (aMessage.ReadBlockOptionValues(kOptionBlock2) == kErrorNone) &&
            (aMessage.GetBlockWiseBlockNumber() == 0))
        {
            // Set payload for first block of the transfer
            VerifyOrExit((bufLen = otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize())) <= kMaxBlockLength,
                         error = kErrorNoBufs);
            SuccessOrExit(error = aTransmitHook(aContext, buf, aMessage.GetBlockWiseBlockNumber() * bufLen, &bufLen,
                                                &moreBlocks));
            SuccessOrExit(error = aMessage.AppendBytes(buf, bufLen));

            SuccessOrExit(error = CacheLastBlockResponse(&aMessage));
        }
#endif

        mResponsesQueue.EnqueueResponse(aMessage, aMessageInfo, aTxParameters);
        break;
    case kTypeReset:
        OT_ASSERT(aMessage.GetCode() == kCodeEmpty);
        break;
    default:
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
        // Check for block-wise transfer
        if ((aTransmitHook != nullptr) && (aMessage.ReadBlockOptionValues(kOptionBlock1) == kErrorNone) &&
            (aMessage.GetBlockWiseBlockNumber() == 0))
        {
            // Set payload for first block of the transfer
            VerifyOrExit((bufLen = otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize())) <= kMaxBlockLength,
                         error = kErrorNoBufs);
            SuccessOrExit(error = aTransmitHook(aContext, buf, aMessage.GetBlockWiseBlockNumber() * bufLen, &bufLen,
                                                &moreBlocks));
            SuccessOrExit(error = aMessage.AppendBytes(buf, bufLen));

            // Block-Wise messages always have to be confirmable
            if (aMessage.IsNonConfirmable())
            {
                aMessage.SetType(kTypeConfirmable);
            }
        }
#endif

        aMessage.SetMessageId(mMessageId++);
        break;
    }

    aMessage.Finish();

    if (aMessage.IsConfirmable())
    {
        copyLength = aMessage.GetLength();
    }
    else if (aMessage.IsNonConfirmable() && (aHandler != nullptr))
    {
        // As we do not retransmit non confirmable messages, create a
        // copy of header only, for token information.
        copyLength = aMessage.GetOptionStart();
    }

    if (copyLength > 0)
    {
        Metadata metadata;

#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
        // Whether or not to turn on special "Observe" handling.
        Option::Iterator iterator;
        bool             observe;

        SuccessOrExit(error = iterator.Init(aMessage, kOptionObserve));
        observe = !iterator.IsDone();

        // Special case, if we're sending a GET with Observe=1, that is a cancellation.
        if (observe && aMessage.IsGetRequest())
        {
            uint64_t observeVal = 0;

            SuccessOrExit(error = iterator.ReadOptionValue(observeVal));

            if (observeVal == 1)
            {
                Metadata handlerMetadata;

                // We're cancelling our subscription, so disable special-case handling on this request.
                observe = false;

                // If we can find the previous handler context, cancel that too.  Peer address
                // and tokens, etc should all match.
                Message *origRequest = FindRelatedRequest(aMessage, aMessageInfo, handlerMetadata);
                if (origRequest != nullptr)
                {
                    FinalizeCoapTransaction(*origRequest, handlerMetadata, nullptr, nullptr, kErrorNone);
                }
            }
        }
#endif // OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE

        metadata.mSourceAddress            = aMessageInfo.GetSockAddr();
        metadata.mDestinationPort          = aMessageInfo.GetPeerPort();
        metadata.mDestinationAddress       = aMessageInfo.GetPeerAddr();
        metadata.mMulticastLoop            = aMessageInfo.GetMulticastLoop();
        metadata.mResponseHandler          = aHandler;
        metadata.mResponseContext          = aContext;
        metadata.mRetransmissionsRemaining = aTxParameters.mMaxRetransmit;
        metadata.mRetransmissionTimeout    = aTxParameters.CalculateInitialRetransmissionTimeout();
        metadata.mAcknowledged             = false;
        metadata.mConfirmable              = aMessage.IsConfirmable();
#if OPENTHREAD_CONFIG_BACKBONE_ROUTER_ENABLE
        metadata.mHopLimit        = aMessageInfo.GetHopLimit();
        metadata.mIsHostInterface = aMessageInfo.IsHostInterface();
#endif
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
        metadata.mBlockwiseReceiveHook  = aReceiveHook;
        metadata.mBlockwiseTransmitHook = aTransmitHook;
#endif
#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
        metadata.mObserve = observe;
#endif
        metadata.mNextTimerShot =
            TimerMilli::GetNow() +
            (metadata.mConfirmable ? metadata.mRetransmissionTimeout : aTxParameters.CalculateMaxTransmitWait());

        storedCopy = CopyAndEnqueueMessage(aMessage, copyLength, metadata);
        VerifyOrExit(storedCopy != nullptr, error = kErrorNoBufs);
    }

    SuccessOrExit(error = Send(aMessage, aMessageInfo));

exit:

    if (error != kErrorNone && storedCopy != nullptr)
    {
        DequeueMessage(*storedCopy);
    }

    return error;
}t(SendMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMbCoapBaset(jP  MbKMlKX  Error CoapBase::SendMessage(Message                &aMessage,
                            const Ip6::MessageInfo &aMessageInfo,
                            ResponseHandler         aHandler,
                            void                   *aContext)
{
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
    return SendMessage(aMessage, aMessageInfo, TxParameters::GetDefault(), aHandler, aContext, nullptr, nullptr);
#else
    return SendMessage(aMessage, aMessageInfo, TxParameters::GetDefault(), aHandler, aContext);
#endif
}t(	SendResetH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMnCoapBaset(jP  MnKMqKError CoapBase::SendReset(Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
{
    return SendEmptyMessage(kTypeReset, aRequest, aMessageInfo);
}t(SendAckH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMsCoapBaset(jP  MsKMvKError CoapBase::SendAck(const Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
{
    return SendEmptyMessage(kTypeAck, aRequest, aMessageInfo);
}t(SendEmptyAckH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMxCoapBaset(jP  MxKM{KError CoapBase::SendEmptyAck(const Message &aRequest, const Ip6::MessageInfo &aMessageInfo, Code aCode)
{
    return (aRequest.IsConfirmable() ? SendHeaderResponse(aCode, aRequest, aMessageInfo) : kErrorInvalidArgs);
}t(SendNotFoundH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppM}CoapBaset(jP  M}KMKError CoapBase::SendNotFound(const Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
{
    return SendHeaderResponse(kCodeNotFound, aRequest, aMessageInfo);
}t(SendEmptyMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKX5  Error CoapBase::SendEmptyMessage(Type aType, const Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
{
    Error    error   = kErrorNone;
    Message *message = nullptr;

    VerifyOrExit(aRequest.IsConfirmable(), error = kErrorInvalidArgs);

    VerifyOrExit((message = NewMessage()) != nullptr, error = kErrorNoBufs);

    message->Init(aType, kCodeEmpty);
    message->SetMessageId(aRequest.GetMessageId());

    message->Finish();
    SuccessOrExit(error = Send(*message, aMessageInfo));

exit:
    FreeMessageOnError(message, error);
    return error;
}t(SendHeaderResponseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKXf  Error CoapBase::SendHeaderResponse(Message::Code aCode, const Message &aRequest, const Ip6::MessageInfo &aMessageInfo)
{
    Error    error   = kErrorNone;
    Message *message = nullptr;

    VerifyOrExit(aRequest.IsRequest(), error = kErrorInvalidArgs);
    VerifyOrExit((message = NewMessage()) != nullptr, error = kErrorNoBufs);

    switch (aRequest.GetType())
    {
    case kTypeConfirmable:
        message->Init(kTypeAck, aCode);
        message->SetMessageId(aRequest.GetMessageId());
        break;

    case kTypeNonConfirmable:
        message->Init(kTypeNonConfirmable, aCode);
        break;

    default:
        ExitNow(error = kErrorInvalidArgs);
    }

    SuccessOrExit(error = message->SetTokenFromMessage(aRequest));

    SuccessOrExit(error = SendMessage(*message, aMessageInfo));

exit:
    FreeMessageOnError(message, error);
    return error;
}t(HandleRetransmissionTimerH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKvoid CoapBase::HandleRetransmissionTimer(Timer &aTimer)
{
    static_cast<Coap *>(static_cast<TimerMilliContext &>(aTimer).GetContext())->HandleRetransmissionTimer();
}t(HandleRetransmissionTimerH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKX  void CoapBase::HandleRetransmissionTimer(void)
{
    TimeMilli        now      = TimerMilli::GetNow();
    TimeMilli        nextTime = now.GetDistantFuture();
    Metadata         metadata;
    Ip6::MessageInfo messageInfo;

    for (Message &message : mPendingRequests)
    {
        metadata.ReadFrom(message);

        if (now >= metadata.mNextTimerShot)
        {
#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
            if (message.IsRequest() && metadata.mObserve && metadata.mAcknowledged)
            {
                // This is a RFC7641 subscription.  Do not time out.
                continue;
            }
#endif

            if (!metadata.mConfirmable || (metadata.mRetransmissionsRemaining == 0))
            {
                // No expected response or acknowledgment.
                FinalizeCoapTransaction(message, metadata, nullptr, nullptr, kErrorResponseTimeout);
                continue;
            }

            // Increment retransmission counter and timer.
            metadata.mRetransmissionsRemaining--;
            metadata.mRetransmissionTimeout *= 2;
            metadata.mNextTimerShot = now + metadata.mRetransmissionTimeout;
            metadata.UpdateIn(message);

            // Retransmit
            if (!metadata.mAcknowledged)
            {
                messageInfo.SetPeerAddr(metadata.mDestinationAddress);
                messageInfo.SetPeerPort(metadata.mDestinationPort);
                messageInfo.SetSockAddr(metadata.mSourceAddress);
#if OPENTHREAD_CONFIG_BACKBONE_ROUTER_ENABLE
                messageInfo.SetHopLimit(metadata.mHopLimit);
                messageInfo.SetIsHostInterface(metadata.mIsHostInterface);
#endif
                messageInfo.SetMulticastLoop(metadata.mMulticastLoop);

                SendCopy(message, messageInfo);
            }
        }

        if (nextTime > metadata.mNextTimerShot)
        {
            nextTime = metadata.mNextTimerShot;
        }
    }

    if (nextTime < now.GetDistantFuture())
    {
        mRetransmissionTimer.FireAt(nextTime);
    }
}t(FinalizeCoapTransactionH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKX1  void CoapBase::FinalizeCoapTransaction(Message                &aRequest,
                                       const Metadata         &aMetadata,
                                       Message                *aResponse,
                                       const Ip6::MessageInfo *aMessageInfo,
                                       Error                   aResult)
{
    DequeueMessage(aRequest);

    if (aMetadata.mResponseHandler != nullptr)
    {
        aMetadata.mResponseHandler(aMetadata.mResponseContext, aResponse, aMessageInfo, aResult);
    }
}t(AbortTransactionH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKMKX  Error CoapBase::AbortTransaction(ResponseHandler aHandler, void *aContext)
{
    Error    error = kErrorNotFound;
    Metadata metadata;

    for (Message &message : mPendingRequests)
    {
        metadata.ReadFrom(message);

        if (metadata.mResponseHandler == aHandler && metadata.mResponseContext == aContext)
        {
            FinalizeCoapTransaction(message, metadata, nullptr, nullptr, kErrorAbort);
            error = kErrorNone;
        }
    }

    return error;
}t(CopyAndEnqueueMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jP  MKM*KX$  Message *CoapBase::CopyAndEnqueueMessage(const Message &aMessage, uint16_t aCopyLength, const Metadata &aMetadata)
{
    Error    error       = kErrorNone;
    Message *messageCopy = nullptr;

    VerifyOrExit((messageCopy = aMessage.Clone(aCopyLength)) != nullptr, error = kErrorNoBufs);

    SuccessOrExit(error = aMetadata.AppendTo(*messageCopy));

    mRetransmissionTimer.FireAtIfEarlier(aMetadata.mNextTimerShot);

    mPendingRequests.Enqueue(*messageCopy);

exit:
    FreeAndNullMessageOnError(messageCopy, error);
    return messageCopy;
}t(DequeueMessageH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppM,CoapBaset(jP  M,KM9KX  void CoapBase::DequeueMessage(Message &aMessage)
{
    mPendingRequests.Dequeue(aMessage);

    if (mRetransmissionTimer.IsRunning() && (mPendingRequests.GetHead() == nullptr))
    {
        mRetransmissionTimer.Stop();
    }

    aMessage.Free();

    // No need to worry that the earliest pending message was removed -
    // the timer would just shoot earlier and then it'd be setup again.
}t(FreeLastBlockResponseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppM<CoapBaset(jP  M<KMCKvoid CoapBase::FreeLastBlockResponse(void)
{
    if (mLastResponse != nullptr)
    {
        mLastResponse->Free();
        mLastResponse = nullptr;
    }
}t(CacheLastBlockResponseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMECoapBaset(jP  MEKMQKX"  Error CoapBase::CacheLastBlockResponse(Message *aResponse)
{
    Error error = kErrorNone;
    // Save last response for block-wise transfer
    FreeLastBlockResponse();

    if ((mLastResponse = aResponse->Clone()) == nullptr)
    {
        error = kErrorNoBufs;
    }

    return error;
}t(PrepareNextBlockRequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMSCoapBaset(jQ  MSKMKXq
  Error CoapBase::PrepareNextBlockRequest(Message::BlockType aType,
                                        bool               aMoreBlocks,
                                        Message           &aRequestOld,
                                        Message           &aRequest,
                                        Message           &aMessage)
{
    Error            error       = kErrorNone;
    bool             isOptionSet = false;
    uint64_t         optionBuf   = 0;
    uint16_t         blockOption = 0;
    Option::Iterator iterator;

    blockOption = (aType == Message::kBlockType1) ? kOptionBlock1 : kOptionBlock2;

    aRequest.Init(kTypeConfirmable, static_cast<ot::Coap::Code>(aRequestOld.GetCode()));
    SuccessOrExit(error = iterator.Init(aRequestOld));

    // Copy options from last response to next message
    for (; !iterator.IsDone() && iterator.GetOption()->GetLength() != 0; error = iterator.Advance())
    {
        uint16_t optionNumber = iterator.GetOption()->GetNumber();

        SuccessOrExit(error);

        // Check if option to copy next is higher than or equal to Block1 option
        if (optionNumber >= blockOption && !isOptionSet)
        {
            // Write Block1 option to next message
            SuccessOrExit(error = aRequest.AppendBlockOption(aType, aMessage.GetBlockWiseBlockNumber() + 1, aMoreBlocks,
                                                             aMessage.GetBlockWiseBlockSize()));
            aRequest.SetBlockWiseBlockNumber(aMessage.GetBlockWiseBlockNumber() + 1);
            aRequest.SetBlockWiseBlockSize(aMessage.GetBlockWiseBlockSize());
            aRequest.SetMoreBlocksFlag(aMoreBlocks);

            isOptionSet = true;

            // If option to copy next is Block1 or Block2 option, option is not copied
            if (optionNumber == kOptionBlock1 || optionNumber == kOptionBlock2)
            {
                continue;
            }
        }

        // Copy option
        SuccessOrExit(error = iterator.ReadOptionValue(&optionBuf));
        SuccessOrExit(error = aRequest.AppendOption(optionNumber, iterator.GetOption()->GetLength(), &optionBuf));
    }

    if (!isOptionSet)
    {
        // Write Block1 option to next message
        SuccessOrExit(error = aRequest.AppendBlockOption(aType, aMessage.GetBlockWiseBlockNumber() + 1, aMoreBlocks,
                                                         aMessage.GetBlockWiseBlockSize()));
        aRequest.SetBlockWiseBlockNumber(aMessage.GetBlockWiseBlockNumber() + 1);
        aRequest.SetBlockWiseBlockSize(aMessage.GetBlockWiseBlockSize());
        aRequest.SetMoreBlocksFlag(aMoreBlocks);
    }

exit:
    return error;
}t(SendNextBlock1RequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(j	Q  MKMKX<
  Error CoapBase::SendNextBlock1Request(Message                &aRequest,
                                      Message                &aMessage,
                                      const Ip6::MessageInfo &aMessageInfo,
                                      const Metadata         &aCoapMetadata)
{
    Error    error                = kErrorNone;
    Message *request              = nullptr;
    bool     moreBlocks           = false;
    uint8_t  buf[kMaxBlockLength] = {0};
    uint16_t bufLen               = kMaxBlockLength;

    SuccessOrExit(error = aRequest.ReadBlockOptionValues(kOptionBlock1));
    SuccessOrExit(error = aMessage.ReadBlockOptionValues(kOptionBlock1));

    // Conclude block-wise transfer if last block has been received
    if (!aRequest.IsMoreBlocksFlagSet())
    {
        FinalizeCoapTransaction(aRequest, aCoapMetadata, &aMessage, &aMessageInfo, kErrorNone);
        ExitNow();
    }

    // Get next block
    VerifyOrExit((bufLen = otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize())) <= kMaxBlockLength,
                 error = kErrorNoBufs);

    SuccessOrExit(
        error = aCoapMetadata.mBlockwiseTransmitHook(aCoapMetadata.mResponseContext, buf,
                                                     otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) *
                                                         (aMessage.GetBlockWiseBlockNumber() + 1),
                                                     &bufLen, &moreBlocks));

    // Check if block length is valid
    VerifyOrExit(bufLen <= otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()), error = kErrorInvalidArgs);

    // Init request for next block
    VerifyOrExit((request = NewMessage()) != nullptr, error = kErrorNoBufs);
    SuccessOrExit(error = PrepareNextBlockRequest(Message::kBlockType1, moreBlocks, aRequest, *request, aMessage));

    SuccessOrExit(error = request->SetPayloadMarker());

    SuccessOrExit(error = request->AppendBytes(buf, bufLen));

    DequeueMessage(aRequest);

    LogInfo("Send Block1 Nr. %d, Size: %d bytes, More Blocks Flag: %d", request->GetBlockWiseBlockNumber(),
            otCoapBlockSizeFromExponent(request->GetBlockWiseBlockSize()), request->IsMoreBlocksFlagSet());

    SuccessOrExit(error = SendMessage(*request, aMessageInfo, TxParameters::GetDefault(),
                                      aCoapMetadata.mResponseHandler, aCoapMetadata.mResponseContext,
                                      aCoapMetadata.mBlockwiseTransmitHook, aCoapMetadata.mBlockwiseReceiveHook));

exit:
    FreeMessageOnError(request, error);

    return error;
}t(SendNextBlock2RequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jQ  MKMKX  Error CoapBase::SendNextBlock2Request(Message                &aRequest,
                                      Message                &aMessage,
                                      const Ip6::MessageInfo &aMessageInfo,
                                      const Metadata         &aCoapMetadata,
                                      uint32_t                aTotalLength,
                                      bool                    aBeginBlock1Transfer)
{
    Error    error                = kErrorNone;
    Message *request              = nullptr;
    uint8_t  buf[kMaxBlockLength] = {0};
    uint16_t bufLen               = kMaxBlockLength;

    SuccessOrExit(error = aMessage.ReadBlockOptionValues(kOptionBlock2));

    // Check payload and block length
    VerifyOrExit((aMessage.GetLength() - aMessage.GetOffset()) <=
                         otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) &&
                     (aMessage.GetLength() - aMessage.GetOffset()) <= kMaxBlockLength,
                 error = kErrorNoBufs);

    // Read and then forward payload to receive hook function
    bufLen = aMessage.ReadBytes(aMessage.GetOffset(), buf, aMessage.GetLength() - aMessage.GetOffset());
    SuccessOrExit(
        error = aCoapMetadata.mBlockwiseReceiveHook(aCoapMetadata.mResponseContext, buf,
                                                    otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) *
                                                        aMessage.GetBlockWiseBlockNumber(),
                                                    bufLen, aMessage.IsMoreBlocksFlagSet(), aTotalLength));

    // CoAP Block-Wise Transfer continues
    LogInfo("Received Block2 Nr. %d , Size: %d bytes, More Blocks Flag: %d", aMessage.GetBlockWiseBlockNumber(),
            otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()), aMessage.IsMoreBlocksFlagSet());

    // Conclude block-wise transfer if last block has been received
    if (!aMessage.IsMoreBlocksFlagSet())
    {
        FinalizeCoapTransaction(aRequest, aCoapMetadata, &aMessage, &aMessageInfo, kErrorNone);
        ExitNow();
    }

    // Init request for next block
    VerifyOrExit((request = NewMessage()) != nullptr, error = kErrorNoBufs);
    SuccessOrExit(error = PrepareNextBlockRequest(Message::kBlockType2, aMessage.IsMoreBlocksFlagSet(), aRequest,
                                                  *request, aMessage));

    if (!aBeginBlock1Transfer)
    {
        DequeueMessage(aRequest);
    }

    LogInfo("Request Block2 Nr. %d, Size: %d bytes", request->GetBlockWiseBlockNumber(),
            otCoapBlockSizeFromExponent(request->GetBlockWiseBlockSize()));

    SuccessOrExit(error =
                      SendMessage(*request, aMessageInfo, TxParameters::GetDefault(), aCoapMetadata.mResponseHandler,
                                  aCoapMetadata.mResponseContext, nullptr, aCoapMetadata.mBlockwiseReceiveHook));

exit:
    FreeMessageOnError(request, error);

    return error;
}t(ProcessBlock1RequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(jQ  MKMCKX
  Error CoapBase::ProcessBlock1Request(Message                 &aMessage,
                                     const Ip6::MessageInfo  &aMessageInfo,
                                     const ResourceBlockWise &aResource,
                                     uint32_t                 aTotalLength)
{
    Error    error                = kErrorNone;
    Message *response             = nullptr;
    uint8_t  buf[kMaxBlockLength] = {0};
    uint16_t bufLen               = kMaxBlockLength;

    SuccessOrExit(error = aMessage.ReadBlockOptionValues(kOptionBlock1));

    // Read and then forward payload to receive hook function
    VerifyOrExit((aMessage.GetLength() - aMessage.GetOffset()) <= kMaxBlockLength, error = kErrorNoBufs);
    bufLen = aMessage.ReadBytes(aMessage.GetOffset(), buf, aMessage.GetLength() - aMessage.GetOffset());
    SuccessOrExit(error = aResource.HandleBlockReceive(buf,
                                                       otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) *
                                                           aMessage.GetBlockWiseBlockNumber(),
                                                       bufLen, aMessage.IsMoreBlocksFlagSet(), aTotalLength));

    if (aMessage.IsMoreBlocksFlagSet())
    {
        // Set up next response
        VerifyOrExit((response = NewMessage()) != nullptr, error = kErrorFailed);
        response->Init(kTypeAck, kCodeContinue);
        response->SetMessageId(aMessage.GetMessageId());
        IgnoreReturnValue(response->SetToken(AsConst(aMessage).GetToken(), aMessage.GetTokenLength()));

        response->SetBlockWiseBlockNumber(aMessage.GetBlockWiseBlockNumber());
        response->SetMoreBlocksFlag(aMessage.IsMoreBlocksFlagSet());
        response->SetBlockWiseBlockSize(aMessage.GetBlockWiseBlockSize());

        SuccessOrExit(error = response->AppendBlockOption(Message::kBlockType1, response->GetBlockWiseBlockNumber(),
                                                          response->IsMoreBlocksFlagSet(),
                                                          response->GetBlockWiseBlockSize()));

        SuccessOrExit(error = CacheLastBlockResponse(response));

        LogInfo("Acknowledge Block1 Nr. %d, Size: %d bytes", response->GetBlockWiseBlockNumber(),
                otCoapBlockSizeFromExponent(response->GetBlockWiseBlockSize()));

        SuccessOrExit(error = SendMessage(*response, aMessageInfo));

        error = kErrorBusy;
    }
    else
    {
        // Conclude block-wise transfer if last block has been received
        FreeLastBlockResponse();
        error = kErrorNone;
    }

exit:
    if (error != kErrorNone && error != kErrorBusy && response != nullptr)
    {
        response->Free();
    }

    return error;
}t(ProcessBlock2RequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMECoapBaset(jQ  MEKMKX  Error CoapBase::ProcessBlock2Request(Message                 &aMessage,
                                     const Ip6::MessageInfo  &aMessageInfo,
                                     const ResourceBlockWise &aResource)
{
    Error            error                = kErrorNone;
    Message         *response             = nullptr;
    uint8_t          buf[kMaxBlockLength] = {0};
    uint16_t         bufLen               = kMaxBlockLength;
    bool             moreBlocks           = false;
    uint64_t         optionBuf            = 0;
    Option::Iterator iterator;

    SuccessOrExit(error = aMessage.ReadBlockOptionValues(kOptionBlock2));

    LogInfo("Request for Block2 Nr. %d, Size: %d bytes received", aMessage.GetBlockWiseBlockNumber(),
            otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()));

    if (aMessage.GetBlockWiseBlockNumber() == 0)
    {
        aResource.HandleRequest(aMessage, aMessageInfo);
        ExitNow();
    }

    // Set up next response
    VerifyOrExit((response = NewMessage()) != nullptr, error = kErrorNoBufs);
    response->Init(kTypeAck, kCodeContent);
    response->SetMessageId(aMessage.GetMessageId());

    VerifyOrExit((bufLen = otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize())) <= kMaxBlockLength,
                 error = kErrorNoBufs);
    SuccessOrExit(error = aResource.HandleBlockTransmit(buf,
                                                        otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) *
                                                            aMessage.GetBlockWiseBlockNumber(),
                                                        &bufLen, &moreBlocks));

    response->SetMoreBlocksFlag(moreBlocks);
    if (moreBlocks)
    {
        switch (bufLen)
        {
        case 1024:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_1024);
            break;
        case 512:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_512);
            break;
        case 256:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_256);
            break;
        case 128:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_128);
            break;
        case 64:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_64);
            break;
        case 32:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_32);
            break;
        case 16:
            response->SetBlockWiseBlockSize(OT_COAP_OPTION_BLOCK_SZX_16);
            break;
        default:
            error = kErrorInvalidArgs;
            ExitNow();
            break;
        }
    }
    else
    {
        // Verify that buffer length is not larger than requested block size
        VerifyOrExit(bufLen <= otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()),
                     error = kErrorInvalidArgs);
        response->SetBlockWiseBlockSize(aMessage.GetBlockWiseBlockSize());
    }

    response->SetBlockWiseBlockNumber(
        (otCoapBlockSizeFromExponent(aMessage.GetBlockWiseBlockSize()) * aMessage.GetBlockWiseBlockNumber()) /
        (otCoapBlockSizeFromExponent(response->GetBlockWiseBlockSize())));

    // Copy options from last response
    SuccessOrExit(error = iterator.Init(*mLastResponse));

    while (!iterator.IsDone())
    {
        uint16_t optionNumber = iterator.GetOption()->GetNumber();

        if (optionNumber == kOptionBlock2)
        {
            SuccessOrExit(error = response->AppendBlockOption(Message::kBlockType2, response->GetBlockWiseBlockNumber(),
                                                              response->IsMoreBlocksFlagSet(),
                                                              response->GetBlockWiseBlockSize()));
        }
        else if (optionNumber == kOptionBlock1)
        {
            SuccessOrExit(error = iterator.ReadOptionValue(&optionBuf));
            SuccessOrExit(error = response->AppendOption(optionNumber, iterator.GetOption()->GetLength(), &optionBuf));
        }

        SuccessOrExit(error = iterator.Advance());
    }

    SuccessOrExit(error = response->SetPayloadMarker());
    SuccessOrExit(error = response->AppendBytes(buf, bufLen));

    if (response->IsMoreBlocksFlagSet())
    {
        SuccessOrExit(error = CacheLastBlockResponse(response));
    }
    else
    {
        // Conclude block-wise transfer if last block has been received
        FreeLastBlockResponse();
    }

    LogInfo("Send Block2 Nr. %d, Size: %d bytes, More Blocks Flag %d", response->GetBlockWiseBlockNumber(),
            otCoapBlockSizeFromExponent(response->GetBlockWiseBlockSize()), response->IsMoreBlocksFlagSet());

    SuccessOrExit(error = SendMessage(*response, aMessageInfo));

exit:
    FreeMessageOnError(response, error);

    return error;
}t(SendCopyH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(j!Q  MKMKX   void CoapBase::SendCopy(const Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
{
    Error    error;
    Message *messageCopy = nullptr;

    // Create a message copy for lower layers.
    messageCopy = aMessage.Clone(aMessage.GetLength() - sizeof(Metadata));
    VerifyOrExit(messageCopy != nullptr, error = kErrorNoBufs);

    SuccessOrExit(error = Send(*messageCopy, aMessageInfo));

exit:

    if (error != kErrorNone)
    {
        LogWarn("Failed to send copy: %s", ErrorToString(error));
        FreeMessage(messageCopy);
    }
}t(FindRelatedRequestH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(j'Q  MKMKX  Message *CoapBase::FindRelatedRequest(const Message          &aResponse,
                                      const Ip6::MessageInfo &aMessageInfo,
                                      Metadata               &aMetadata)
{
    Message *request = nullptr;

    for (Message &message : mPendingRequests)
    {
        aMetadata.ReadFrom(message);

        if (((aMetadata.mDestinationAddress == aMessageInfo.GetPeerAddr()) ||
             aMetadata.mDestinationAddress.IsMulticast() ||
             aMetadata.mDestinationAddress.GetIid().IsAnycastLocator()) &&
            (aMetadata.mDestinationPort == aMessageInfo.GetPeerPort()))
        {
            switch (aResponse.GetType())
            {
            case kTypeReset:
            case kTypeAck:
                if (aResponse.GetMessageId() == message.GetMessageId())
                {
                    request = &message;
                    ExitNow();
                }

                break;

            case kTypeConfirmable:
            case kTypeNonConfirmable:
                if (aResponse.IsTokenEqual(message))
                {
                    request = &message;
                    ExitNow();
                }

                break;
            }
        }
    }

exit:
    return request;
}t(ReceiveH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(j-Q  MKMKX  void CoapBase::Receive(ot::Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
{
    Message &message = AsCoapMessage(&aMessage);

    if (message.ParseHeader() != kErrorNone)
    {
        LogDebg("Failed to parse CoAP header");

        if (!aMessageInfo.GetSockAddr().IsMulticast() && message.IsConfirmable())
        {
            IgnoreError(SendReset(message, aMessageInfo));
        }
    }
    else if (message.IsRequest())
    {
        ProcessReceivedRequest(message, aMessageInfo);
    }
    else
    {
        ProcessReceivedResponse(message, aMessageInfo);
    }

#if OPENTHREAD_CONFIG_OTNS_ENABLE
    Get<Utils::Otns>().EmitCoapReceive(message, aMessageInfo);
#endif
}t(ProcessReceivedResponseH/Data3/weisw/learn/progs/fzbench_progs/openthread/src/core/coap/coap.cppMCoapBaset(j3Q  MKMKX!  void CoapBase::ProcessReceivedResponse(Message &aMessage, const Ip6::MessageInfo &aMessageInfo)
{
    Metadata metadata;
    Message *request = nullptr;
    Error    error   = kErrorNone;
#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
    bool responseObserve = false;
#endif
#if OPENTHREAD_CONFIG_COAP_BLOCKWISE_TRANSFER_ENABLE
    uint8_t  blockOptionType    = 0;
    uint32_t totalTransfereSize = 0;
#endif

    request = FindRelatedRequest(aMessage, aMessageInfo, metadata);
    VerifyOrExit(request != nullptr);

#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
    if (metadata.mObserve && request->IsRequest())
    {
        // We sent Observe in our request, see if we received Observe in the response too.
        Option::Iterator iterator;

        SuccessOrExit(error = iterator.Init(aMessage, kOptionObserve));
        responseObserve = !iterator.IsDone();
    }
#endif

    switch (aMessage.GetType())
    {
    case kTypeReset:
        if (aMessage.IsEmpty())
        {
            FinalizeCoapTransaction(*request, metadata, nullptr, nullptr, kErrorAbort);
        }

        // Silently ignore non-empty reset messages (RFC 7252, p. 4.2).
        break;

    case kTypeAck:
        if (aMessage.IsEmpty())
        {
            // Empty acknowledgment.
#if OPENTHREAD_CONFIG_COAP_OBSERVE_API_ENABLE
            if (metadata.mObserve && !request->IsRequest())
            {
                // This is the ACK to our RFC7641 notification.  There will be no
                // "separate" response so pass it back as if it were a piggy-backed
                // response so we can stop re-sending and the application can move on.
                FinalizeCoapTransaction(*request, metadata, &aMessage, &aMessageInfo, kErrorNone);
            }
            else
#endif
            {
                // This is not related to RFC7641 or the outgoing "request" was not a
                // notification.
                if (metadata.mConfirmable)
                {
                    metadata.mAcknowledged = true;
                    metadata.UpdateIn(*request);
                }

                // Remove the message if response is not expected, otherwise await
                // response.
                if (metadata.mResponseHandler == nullptr)
                {
                    DequeueMessage(*request);
                }
            }
        }
        else if (aMessage.IsResponse() && aMessage.IsTokenEqual(*request))
        {
            // Piggybacked response.  If there's an Observe option present in both
            // request and response, and we have a response handler