
# Preparation
Locate below two benchmarks in `./data` directory
- [Robust NAS-Bench-201](https://uni-siegen.sciebo.de/s/aFzpxCvTDWknpMA)
- [NAS-Bench-201](https://github.com/D-X-Y/NAS-Bench-201)

# Reproduce Spearman's rank correlation on NAS-Bench-201 search space 
```sh
CUDA_VISIBLE_DEVICES=0 python main.py --search_space nasbench201 --proxy_types 'baselines/croze' --api_loc 'PATH_TO_API' --data 'PATH_TO_DATA' --outdir 'PATH_TO_SAVE_PROXIES' --corr_dir 'PATH_TO_SAVE_CORR' --topp 10.0 --end '100/15625'
```

# End-to-end on cifar10 in darts search space
```sh
CUDA_VISIBLE_DEVICES=0 python main.py --w_sampling --sampling_type mutate --sample_num 'SAMPLE_NUM' --sample_pool 'SAMPLE_POOL' --init_pool 'INIT_POOL' --proxy_types croze --outdir 'PATH_TO_SAVE' --search_space darts --data 'PATH_TO_DATA' --dataset cifar10 --e2e
```

# Reproduce end-to-end in darts search space for CRoZe
```sh
CUDA_VISIBLE_DEVICES=0 python train_scratch.py --arch_type croze_cifar10 --adv_loss '' --outdir 'PATH_TO_SAVE' --data 'PATH_TO_DATA' --search_space darts
```