# Energy-based Model Evaluation (CAME)


## PyTorch Implementation

This repository contains:

- the PyTorch implementation of CAME
- the example on CIFAR-10 setup
- Contrastive Accuracy calculation and linear regression methods
- MNIST, CIFAR-100, COCO and TinyImageNet Setups (use [imgaug](https://imgaug.readthedocs.io/en/latest/) to generate Meta-set).
  Please see ```PROJECT_DIR/meta_set/```

Please follow the instruction below to install it and run the experiment demo.


## Getting started
0. Install dependencies 
    ```bash
    # COCOAPI
    cd $DIR/libs
    git clone https://github.com/cocodataset/cocoapi.git
    cd cocoapi/PythonAPI
    python setup.py build_ext install
    # Energy-based AutoEval
    conda env create --name energy_autoeval --file environment.yaml
    conda activate energy_autoeval
    ```

1. train classifier
    ```bash
    # Save as "PROJECT_DIR/checkpoints/CIFAR10/checkpoint.pth"
    python train.py
    ```

2. Eval on unseen test sets by regression model and Correlation study
    ```bash
    # The absolute error of linear regression is also shown
    python eval.py
    ``` 


## License
MIT