#!/bin/bash

if [ "$#" -ne 2 ]; then
    echo "Illegal number of parameters"
    echo "Usage: ./setup_Imagenet200.sh <imagenet_dir> <imagenet200_dir>"
    exit 1
fi

mkdir -p $2

IDS=('n01443537' 'n01484850' 'n01494475' 'n01498041' 'n01514859' 'n01518878' 'n01531178' 'n01534433' 'n01614925' 'n01616318' 'n01630670' 'n01632777' 'n01644373' 'n01677366' 'n01694178' 'n01748264' 'n01770393' 'n01774750' 'n01784675' 'n01806143' 'n01820546' 'n01833805' 'n01843383' 'n01847000' 'n01855672' 'n01860187' 'n01882714' 'n01910747' 'n01944390' 'n01983481' 'n01986214' 'n02007558' 'n02009912' 'n02051845' 'n02056570' 'n02066245' 'n02071294' 'n02077923' 'n02085620' 'n02086240' 'n02088094' 'n02088238' 'n02088364' 'n02088466' 'n02091032' 'n02091134' 'n02092339' 'n02094433' 'n02096585' 'n02097298' 'n02098286' 'n02099601' 'n02099712' 'n02102318' 'n02106030' 'n02106166' 'n02106550' 'n02106662' 'n02108089' 'n02108915' 'n02109525' 'n02110185' 'n02110341' 'n02110958' 'n02112018' 'n02112137' 'n02113023' 'n02113624' 'n02113799' 'n02114367' 'n02117135' 'n02119022' 'n02123045' 'n02128385' 'n02128757' 'n02129165' 'n02129604' 'n02130308' 'n02134084' 'n02138441' 'n02165456' 'n02190166' 'n02206856' 'n02219486' 'n02226429' 'n02233338' 'n02236044' 'n02268443' 'n02279972' 'n02317335' 'n02325366' 'n02346627' 'n02356798' 'n02363005' 'n02364673' 'n02391049' 'n02395406' 'n02398521' 'n02410509' 'n02423022' 'n02437616' 'n02445715' 'n02447366' 'n02480495' 'n02480855' 'n02481823' 'n02483362' 'n02486410' 'n02510455' 'n02526121' 'n02607072' 'n02655020' 'n02672831' 'n02701002' 'n02749479' 'n02769748' 'n02793495' 'n02797295' 'n02802426' 'n02808440' 'n02814860' 'n02823750' 'n02841315' 'n02843684' 'n02883205' 'n02906734' 'n02909870' 'n02939185' 'n02948072' 'n02950826' 'n02951358' 'n02966193' 'n02980441' 'n02992529' 'n03124170' 'n03272010' 'n03345487' 'n03372029' 'n03424325' 'n03452741' 'n03467068' 'n03481172' 'n03494278' 'n03495258' 'n03498962' 'n03594945' 'n03602883' 'n03630383' 'n03649909' 'n03676483' 'n03710193' 'n03773504' 'n03775071' 'n03888257' 'n03930630' 'n03947888' 'n04086273' 'n04118538' 'n04133789' 'n04141076' 'n04146614' 'n04147183' 'n04192698' 'n04254680' 'n04266014' 'n04275548' 'n04310018' 'n04325704' 'n04347754' 'n04389033' 'n04409515' 'n04465501' 'n04487394' 'n04522168' 'n04536866' 'n04552348' 'n04591713' 'n07614500' 'n07693725' 'n07695742' 'n07697313' 'n07697537' 'n07714571' 'n07714990' 'n07718472' 'n07720875' 'n07734744' 'n07742313' 'n07745940' 'n07749582' 'n07753275' 'n07753592' 'n07768694' 'n07873807' 'n07880968' 'n07920052' 'n09472597' 'n09835506' 'n10565667' 'n12267677')


for file in $1/imagenetv1/*; do
    mkdir -p $2/imagenetv1/$(basename $file)
    for id in ${IDS[@]}; do
        ln -s $file/$id $2/imagenetv1/$(basename $file)/$id
    done
done

for file in $1/imagenetv2/*; do
    mkdir -p $2/imagenetv2/$(basename $file)
    for id in ${IDS[@]}; do
        ln -s $file/$id $2/imagenetv2/$(basename $file)/$id
    done
done

for file in $1/imagenet-c/*; do
    for severity in {0..4}; do
        mkdir -p $2/imagenet-c/$(basename $file)/$severity
        for id in ${IDS[@]}; do
            ln -s $file/$severity/$id $2/imagenet-c/$(basename $file)/$severity/$id
        done
    done
done

ln -s $1/imagenet-r $2/imagenet-r

mkdir -p $2/imagenet-sketch

for id in ${IDS[@]}; do
    ln -s $1/imagenet-sketch/$id $2/imagenet-sketch/$id
done


