# Single-Photon Image Classification

This archive contains supplementary material that reproduce the claims
from the paper.

## Requirements

To reproduce plots and re-run training:

1. Navigate to: [https://colab.sandbox.google.com/](https://colab.sandbox.google.com/)
2. Upload one of the .ipynb files into a new Colab Notebook.
3. Execute all cells in the notebook. This may ask for uploading .npy
   numpy data files from the current directory. As an alternative, one
   can run instead the python version of the code in the .py files.

## Pre-trained Models

For this problem, pre-trained models consist of .npy numpy data files
that each provide a real 790x790 matrix M of parameters.

From this matrix M, we obtain the trained unitary transform that
approximately decomposes the photon quantum state Hilbert space into
an image-class Hilbert space and an image-style Hilbert space.

The Interactive Python Notebooks will open a dialog for uploading
the pre-trained models onto the virtual machine that runs the
Colab kernel.

## Results

Employing Machine Learning Training to shape quantum interference
as explained in the paper allows us to outperform the maximal
classically achievable accuracy as follows:

 | Dataset       | Classical Accuracy Bound | Quantum Accuracy |
 | ------------- | ------------------------:| ----------------:|
 | MNIST         |                  22.96%  |           41.27% |
 | Fashion-MNIST |                  21.38%  |           36.14% |

## Experimental Realization

The directory mnist10x10 contains a trained model for MNIST padded by
a 1-pixel border to 30x30, then downsampled to 10x10, for which the
unitary transform has been compiled to Python code that simulates
a network of optical 2-port elements.

The file mnist10x10/validate_mnist10x10.py contains code that
validates that (a) the optical network is a faithful implementation of
the unitary transform, when evaluating examples from the training set,
and (b) despite the downsampling, we still beat the theoretical limit
for classical performance by a comfortable margin, at better than 36%
accuracy.


## Contributing

This code is published under the MIT License, Copyright 2020.

[https://opensource.org/licenses/MIT](https://opensource.org/licenses/MIT)
