import os
import json
import re
import sys
sys.path.append("../")
from utils import utils
import tqdm

def equals(pred, label):
    try:
        if utils.is_equiv(pred, label): # change from 1e-5 to 1
            return True
        else:
            return False
    except (TypeError, SyntaxError, NameError) as e:
        return False

def normalize_solution(solution, answer, ignore=False):
    if solution is None:
        return False, None
    text = solution.replace('####', 'The answer is').replace("the answer is", "The answer is")
    if "The answer is" not in text:
        return False, text
    sol, ans = text.split("The answer is", 1)
    pattern = r"[-+]?\d{1,3}(?:,\d{3})*\.?\d*"
    ans = re.findall(pattern, ans)
    if len(ans) == 0:
        return False, text
    ans = ans[-1].replace(",", "")
    if not equals(ans, answer) and not ignore:
        return False, text
    else:
        text = sol + "The answer is " + ans
    return True, text


def main():
    correct, incorrect, solved = 0.0, 0.0, 0.0
    for filename in tqdm.tqdm(os.listdir("./data/train")):
        if filename.endswith('.json'):
            with open(os.path.join('./data/train', filename), 'r') as f:
                data = json.load(f)
            check_answer = data.get('check', "")
            answer = data.get('answer', "")
            if check_answer != "unknown":
                solved += 1
                res = equals(check_answer, answer)
                if res == True:
                    correct += 1                
                else:
                    incorrect += 1
                print("Check: %s; Answer: %s | %s" %(check_answer, answer, res))
    print("Number of correct: %s; Number of incorrect: %s; Number of solved: %s; Accuracy: %s" \
                            %(correct, incorrect, solved, correct/(correct+incorrect)))

if __name__ == "__main__":
    main()