# A Simple and Yet Fairly Effective Defense for Graph Neural Networks

## Overview

This repository contains python codes and datasets necessary to run the NoisyGCN approach. NoisyGCN is a general defense approach against a variety of global adversarial attacks that perturb the discrete graph structure.

## Requirements

Code is written in Python 3.6 and requires:

- PyTorch
- Torch Geometric
- NetworkX

## Datasets
For node classifiation, the used datasets are as follows:
- Cora
- CiteSeer
- PubMed

All these datasets are part of the torch_geometric datasets and are directly downloaded when running the code.


## Training and Evaluation
To use our code, the user should first download the DeepRobust package ( https://github.com/DSE-MSU/DeepRobust). Since we are using the GNNGUard as a baseline, we are using their official code from their github (https://github.com/mims-harvard/GNNGuard/tree/master).

As explained in the GNNGuard's original code, please substitute the files in the folder "deeprobust/graph/defense" by the one provided in our implementation. The file "noisy_gcn.py" contains our proposed framework.


To train and evaluate the model in the paper, the user should specify the following :

- Dataset : The dataset to be used
- hidden_dimension: The hidden dimension used in the model (if desired, otherwise default will be used)
- learning rate and epochs
- Budget: The budget of the attack
- Noise Ratio: the noise ratio injected into the underlying GCN (refered to in the paper as \beta).

To run a normal code of NoisyGCN with the Mettack approach using the Cora dataset and using the default parameters:

```bash
python main_mettack.py --dataset cora
```
