'''Train CIFAR10 with PyTorch.'''
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import torch.backends.cudnn as cudnn
import math
import torchvision
import torchvision.transforms as transforms

import os
import argparse
import torch.nn.utils.prune as prune
from models import *
from utils import progress_bar
from pytorchtools import EarlyStopping
early_stopping = EarlyStopping(patience=4, verbose=True)	# How long to wait after last time validation loss improved. Default: 7

acc = []  # this list for save all performance

parser = argparse.ArgumentParser(description='PyTorch CIFAR10 Training')
parser.add_argument('--lr', default=0.1, type=float, help='learning rate')
parser.add_argument('--resume', '-r', action='store_true',
                    help='resume from checkpoint')
args = parser.parse_args()

device = 'cuda' if torch.cuda.is_available() else 'cpu'
best_acc = 0  # best test accuracy
start_epoch = 0  # start from epoch 0 or last checkpoint epoch

# Data
print('==> Preparing data..')
transform_train = transforms.Compose([
    transforms.RandomCrop(32, padding=4),
    transforms.RandomHorizontalFlip(),
    transforms.ToTensor(),
    transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
])

transform_test = transforms.Compose([
    transforms.ToTensor(),
    transforms.Normalize((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
])

trainset = torchvision.datasets.CIFAR10(
    root='cifar', train=True, download=False, transform=transform_train)

trainloader = torch.utils.data.DataLoader(
    trainset, batch_size=32, shuffle=True, num_workers=0)

train_set_growing_loader =torch.utils.data.DataLoader(trainset, batch_size=32, shuffle=True, num_workers=0)


testset = torchvision.datasets.CIFAR10(
    root='cifar', train=False, download=False, transform=transform_test)

# 5000 val + 5000 test
test_db, val_db = torch.utils.data.random_split(testset, [5000, 5000])
valloader = torch.utils.data.DataLoader(val_db, batch_size=32, shuffle=True, num_workers=0)

testloader = torch.utils.data.DataLoader(
    testset, batch_size=32, shuffle=False, num_workers=0)

classes = ('plane', 'car', 'bird', 'cat', 'deer',
           'dog', 'frog', 'horse', 'ship', 'truck')

# Model
print('==> Building model..')
net = VGG('VGG19')
# net = ResNet18()
# net = PreActResNet18()
# net = GoogLeNet()
# net = DenseNet121()
# net = ResNeXt29_2x64d()
# net = MobileNet()
# net = MobileNetV2()
# net = DPN92()
# net = ShuffleNetG2()
# net = SENet18()
# net = ShuffleNetV2(1)
# net = EfficientNetB0()
# net = RegNetX_200MF()
# net = SimpleDLA()
net = net.to(device)
if device == 'cuda':
    net = torch.nn.DataParallel(net)
    cudnn.benchmark = True

if args.resume:
    # Load checkpoint.
    print('==> Resuming from checkpoint..')
    assert os.path.isdir('checkpoint'), 'Error: no checkpoint directory found!'
    checkpoint = torch.load('./checkpoint/ckpt.pth')
    net.load_state_dict(checkpoint['net'])
    best_acc = checkpoint['acc']
    start_epoch = checkpoint['epoch']

# 查看模型参数
#print(summary(net, input_size=(64, 3, 32, 32)))
print(net.state_dict().keys())

# vgg-19

#parameters_to_prune = ((net.module.features, 'weight'),)
# module = net.module.features[0]
# print(list(module.named_parameters()))

# 这儿进行测试，查看module中的参数
# weight.name 0.weight, 1.weight, 2.weight .......

parameters_to_prune = (
    (net.module.features[0], 'weight'),  # 64
    (net.module.features[1], 'weight'),
    (net.module.features[3], 'weight'),
    (net.module.features[4], 'weight'),
    (net.module.features[7], 'weight'),
    (net.module.features[8], 'weight'),
    (net.module.features[10], 'weight'),
    (net.module.features[11], 'weight'),
    (net.module.features[14], 'weight'),
    (net.module.features[15], 'weight'),
    (net.module.features[17], 'weight'),
    (net.module.features[18], 'weight'),
    (net.module.features[20], 'weight'),
    (net.module.features[21], 'weight'),
    (net.module.features[23], 'weight'),
    (net.module.features[24], 'weight'),
    (net.module.features[27], 'weight'),
    (net.module.features[28], 'weight'),
    (net.module.features[30], 'weight'),
    (net.module.features[31], 'weight'),
    (net.module.features[33], 'weight'),
    (net.module.features[34], 'weight'),
    (net.module.features[36], 'weight'),
    (net.module.features[37], 'weight'),
    (net.module.features[40], 'weight'),
    (net.module.features[41], 'weight'),
    (net.module.features[43], 'weight'),
    (net.module.features[44], 'weight'),
    (net.module.features[46], 'weight'),
    (net.module.features[47], 'weight'),
    (net.module.features[49], 'weight'),
    (net.module.features[50], 'weight'),
)
# vgg19

# print(net.module.conv1)
# print(net.module.layers[0].conv1)

# mobilenet
# parameters_to_prune = (
#     (net.module.conv1, 'weight'),
#     (net.module.bn1, 'weight'),
#     (net.module.layers[0].conv1, 'weight'),
#     (net.module.layers[0].bn1, 'weight'),
#     (net.module.layers[0].conv2, 'weight'),
#     (net.module.layers[0].bn2, 'weight'),
#
#     (net.module.layers[1].conv1, 'weight'),
#     (net.module.layers[1].bn1, 'weight'),
#     (net.module.layers[1].conv2, 'weight'),
#     (net.module.layers[1].bn2, 'weight'),
#
#     (net.module.layers[2].conv1, 'weight'),
#     (net.module.layers[2].bn1, 'weight'),
#     (net.module.layers[2].conv2, 'weight'),
#     (net.module.layers[2].bn2, 'weight'),
#
#     (net.module.layers[3].conv1, 'weight'),
#     (net.module.layers[3].bn1, 'weight'),
#     (net.module.layers[3].conv2, 'weight'),
#     (net.module.layers[3].bn2, 'weight'),
#
#     (net.module.layers[4].conv1, 'weight'),
#     (net.module.layers[4].bn1, 'weight'),
#     (net.module.layers[4].conv2, 'weight'),
#     (net.module.layers[4].bn2, 'weight'),
#
#     (net.module.layers[5].conv1, 'weight'),
#     (net.module.layers[5].bn1, 'weight'),
#     (net.module.layers[5].conv2, 'weight'),
#     (net.module.layers[5].bn2, 'weight'),
#
#     (net.module.layers[6].conv1, 'weight'),
#     (net.module.layers[6].bn1, 'weight'),
#     (net.module.layers[6].conv2, 'weight'),
#     (net.module.layers[6].bn2, 'weight'),
#
#     (net.module.layers[7].conv1, 'weight'),
#     (net.module.layers[7].bn1, 'weight'),
#     (net.module.layers[7].conv2, 'weight'),
#     (net.module.layers[7].bn2, 'weight'),
#
#     (net.module.layers[8].conv1, 'weight'),
#     (net.module.layers[8].bn1, 'weight'),
#     (net.module.layers[8].conv2, 'weight'),
#     (net.module.layers[8].bn2, 'weight'),
#
#     (net.module.layers[9].conv1, 'weight'),
#     (net.module.layers[9].bn1, 'weight'),
#     (net.module.layers[9].conv2, 'weight'),
#     (net.module.layers[9].bn2, 'weight'),
#
#     (net.module.layers[10].conv1, 'weight'),
#     (net.module.layers[10].bn1, 'weight'),
#     (net.module.layers[10].conv2, 'weight'),
#     (net.module.layers[10].bn2, 'weight'),
#
#     (net.module.layers[11].conv1, 'weight'),
#     (net.module.layers[11].bn1, 'weight'),
#     (net.module.layers[11].conv2, 'weight'),
#     (net.module.layers[11].bn2, 'weight'),
#
#     (net.module.layers[12].conv1, 'weight'),
#     (net.module.layers[12].bn1, 'weight'),
#     (net.module.layers[12].conv2, 'weight'),
#     (net.module.layers[12].bn2, 'weight'),
# )

# efficientnetB0
# print(net.module.layers[0].se.se1.weight)
# parameters_to_prune = (
#     (net.module.conv1, 'weight'),
#     (net.module.bn1, 'weight'),
#     (net.module.layers[0].conv1, 'weight'),
#     (net.module.layers[0].bn1, 'weight'),
#
#     (net.module.layers[0].conv2, 'weight'),
#     (net.module.layers[0].bn2, 'weight'),
#     (net.module.layers[0].se.se1, 'weight'),
#     (net.module.layers[0].se.se2, 'weight'),
#
#     (net.module.layers[0].conv3, 'weight'),
#     (net.module.layers[0].bn3, 'weight'),
#
#     (net.module.layers[1].conv1, 'weight'),
#     (net.module.layers[1].bn1, 'weight'),
#     (net.module.layers[1].conv2, 'weight'),
#     (net.module.layers[1].bn2, 'weight'),
#     (net.module.layers[1].se.se1, 'weight'),
#     (net.module.layers[1].se.se2, 'weight'),
#
#     (net.module.layers[2].conv1, 'weight'),
#     (net.module.layers[2].bn1, 'weight'),
#     (net.module.layers[2].conv2, 'weight'),
#     (net.module.layers[2].bn2, 'weight'),
#     (net.module.layers[2].se.se1, 'weight'),
#     (net.module.layers[2].se.se2, 'weight'),
#
#     (net.module.layers[3].conv1, 'weight'),
#     (net.module.layers[3].bn1, 'weight'),
#     (net.module.layers[3].conv2, 'weight'),
#     (net.module.layers[3].bn2, 'weight'),
#     (net.module.layers[3].se.se1, 'weight'),
#     (net.module.layers[3].se.se2, 'weight'),
#     (net.module.layers[3].conv3, 'weight'),
#     (net.module.layers[3].bn3, 'weight'),
#
#     (net.module.layers[4].conv1, 'weight'),
#     (net.module.layers[4].bn1, 'weight'),
#     (net.module.layers[4].conv2, 'weight'),
#     (net.module.layers[4].bn2, 'weight'),
#     (net.module.layers[4].se.se1, 'weight'),
#     (net.module.layers[4].se.se2, 'weight'),
#     (net.module.layers[4].conv3, 'weight'),
#     (net.module.layers[4].bn3, 'weight'),
#
#     (net.module.layers[5].conv1, 'weight'),
#     (net.module.layers[5].bn1, 'weight'),
#     (net.module.layers[5].conv2, 'weight'),
#     (net.module.layers[5].bn2, 'weight'),
#     (net.module.layers[5].se.se1, 'weight'),
#     (net.module.layers[5].se.se2, 'weight'),
#     (net.module.layers[5].conv3, 'weight'),
#     (net.module.layers[5].bn3, 'weight'),
#
#     (net.module.layers[6].conv1, 'weight'),
#     (net.module.layers[6].bn1, 'weight'),
#     (net.module.layers[6].conv2, 'weight'),
#     (net.module.layers[6].bn2, 'weight'),
#     (net.module.layers[6].se.se1, 'weight'),
#     (net.module.layers[6].se.se2, 'weight'),
#     (net.module.layers[6].conv3, 'weight'),
#     (net.module.layers[6].bn3, 'weight'),
#
#     (net.module.layers[7].conv1, 'weight'),
#     (net.module.layers[7].bn1, 'weight'),
#     (net.module.layers[7].conv2, 'weight'),
#     (net.module.layers[7].bn2, 'weight'),
#     (net.module.layers[7].se.se1, 'weight'),
#     (net.module.layers[7].se.se2, 'weight'),
#     (net.module.layers[7].conv3, 'weight'),
#     (net.module.layers[7].bn3, 'weight'),
#
#     (net.module.layers[8].conv1, 'weight'),
#     (net.module.layers[8].bn1, 'weight'),
#     (net.module.layers[8].conv2, 'weight'),
#     (net.module.layers[8].bn2, 'weight'),
#     (net.module.layers[8].se.se1, 'weight'),
#     (net.module.layers[8].se.se2, 'weight'),
#     (net.module.layers[8].conv3, 'weight'),
#     (net.module.layers[8].bn3, 'weight'),
#
#     (net.module.layers[9].conv1, 'weight'),
#     (net.module.layers[9].bn1, 'weight'),
#     (net.module.layers[9].conv2, 'weight'),
#     (net.module.layers[9].bn2, 'weight'),
#     (net.module.layers[9].se.se1, 'weight'),
#     (net.module.layers[9].se.se2, 'weight'),
#     (net.module.layers[9].conv3, 'weight'),
#     (net.module.layers[9].bn3, 'weight'),
#
#     (net.module.layers[10].conv1, 'weight'),
#     (net.module.layers[10].bn1, 'weight'),
#     (net.module.layers[10].conv2, 'weight'),
#     (net.module.layers[10].bn2, 'weight'),
#     (net.module.layers[10].se.se1, 'weight'),
#     (net.module.layers[10].se.se2, 'weight'),
#     (net.module.layers[10].conv3, 'weight'),
#     (net.module.layers[10].bn3, 'weight'),
#
#     (net.module.layers[11].conv1, 'weight'),
#     (net.module.layers[11].bn1, 'weight'),
#     (net.module.layers[11].conv2, 'weight'),
#     (net.module.layers[11].bn2, 'weight'),
#     (net.module.layers[11].se.se1, 'weight'),
#     (net.module.layers[11].se.se2, 'weight'),
#     (net.module.layers[11].conv3, 'weight'),
#     (net.module.layers[11].bn3, 'weight'),
#
#     (net.module.layers[12].conv1, 'weight'),
#     (net.module.layers[12].bn1, 'weight'),
#     (net.module.layers[12].conv2, 'weight'),
#     (net.module.layers[12].bn2, 'weight'),
#     (net.module.layers[12].se.se1, 'weight'),
#     (net.module.layers[12].se.se2, 'weight'),
#     (net.module.layers[12].conv3, 'weight'),
#     (net.module.layers[12].bn3, 'weight'),
#
#     (net.module.layers[13].conv1, 'weight'),
#     (net.module.layers[13].bn1, 'weight'),
#     (net.module.layers[13].conv2, 'weight'),
#     (net.module.layers[13].bn2, 'weight'),
#     (net.module.layers[13].se.se1, 'weight'),
#     (net.module.layers[13].se.se2, 'weight'),
#     (net.module.layers[13].conv3, 'weight'),
#     (net.module.layers[13].bn3, 'weight'),
#
#     (net.module.layers[14].conv1, 'weight'),
#     (net.module.layers[14].bn1, 'weight'),
#     (net.module.layers[14].conv2, 'weight'),
#     (net.module.layers[14].bn2, 'weight'),
#     (net.module.layers[14].se.se1, 'weight'),
#     (net.module.layers[14].se.se2, 'weight'),
#     (net.module.layers[14].conv3, 'weight'),
#     (net.module.layers[14].bn3, 'weight'),
#
#     (net.module.layers[15].conv1, 'weight'),
#     (net.module.layers[15].bn1, 'weight'),
#     (net.module.layers[15].conv2, 'weight'),
#     (net.module.layers[15].bn2, 'weight'),
#     (net.module.layers[15].se.se1, 'weight'),
#     (net.module.layers[15].se.se2, 'weight'),
#     (net.module.layers[15].conv3, 'weight'),
#     (net.module.layers[15].bn3, 'weight'),
# )




criterion = nn.CrossEntropyLoss()
# optimizer = optim.SGD(net.parameters(), lr=args.lr,
#                       momentum=0.9, weight_decay=3e-4)
optimizer = optim.SGD(net.parameters(), lr=args.lr, momentum=0.9)   # remove reg to obseravation
scheduler = torch.optim.lr_scheduler.CosineAnnealingLR(optimizer, T_max=200)

trainacc = []
testacc = []
trainloss = []
testloss = []

# Training
def train(epoch):
    # print('\nEpoch: %d' % epoch)
    net.train()
    train_loss = 0
    correct = 0
    total = 0
    for batch_idx, (inputs, targets) in enumerate(trainloader):
        inputs, targets = inputs.to(device), targets.to(device)
        optimizer.zero_grad()
        outputs = net(inputs)
        loss = criterion(outputs, targets)
        loss.backward()
        optimizer.step()

        train_loss += loss.item()
        _, predicted = outputs.max(1)
        total += targets.size(0)
        correct += predicted.eq(targets).sum().item()

        # progress_bar(batch_idx, len(trainloader), 'Loss: %.3f | Acc: %.3f%% (%d/%d)'
        #              % (train_loss/(batch_idx+1), 100.*correct/total, correct, total))

    # print("The training loss is %.3f" % train_loss)  # added print training loss
    tra_acc = 100. * correct / total
    # print("The training acc is %.3f" % (tra_acc))
    trainacc.append(tra_acc)
    # print(trainacc)

    val_loss = 0
    val_correct = 0
    val_total = 0
    with torch.no_grad():
        for batch_idx, (v_inputs, v_targets) in enumerate(valloader):
            v_inputs, v_targets = v_inputs.to(device), v_targets.to(device)
            v_outputs = net(v_inputs)
            v_loss = criterion(v_outputs, v_targets)
            val_loss += v_loss.item()
            _, predicted = v_outputs.max(1)
            val_total += v_targets.size(0)
            val_correct += predicted.eq(v_targets).sum().item()

    val_acc = 100. * val_correct / val_total
    # print("The valdation acc is %.3f" % (val_acc))

    if epoch > 3:  # pre-defined value, also if have enough space we can not define
        torch.save({
            'epoch': epoch,
            'model_state_dict': net.state_dict(),
            'optimizer': optimizer.state_dict(),
            'scheduler': scheduler.state_dict()
        }, 'checkpoint/checkpoint_{}.pth'.format(epoch))

        early_stopping(val_loss, net)
        early_stopping_bool = early_stopping.early_stop
        # print("Early stopping value is: " + str(early_stopping_bool))

        # 若满足 early stopping 要求
        # if early_stopping_bool:
            # print("Early stopping and here we need to rewind")
            # print("Rewind epoch is %d" % (epoch))
            # 结束模型训练

    return early_stopping.early_stop, epoch


def test(epoch):
    global best_acc
    net.eval()
    test_loss = 0
    correct = 0
    total = 0
    with torch.no_grad():
        for batch_idx, (inputs, targets) in enumerate(testloader):
            inputs, targets = inputs.to(device), targets.to(device)
            outputs = net(inputs)
            loss = criterion(outputs, targets)

            test_loss += loss.item()
            _, predicted = outputs.max(1)
            total += targets.size(0)
            correct += predicted.eq(targets).sum().item()

            # progress_bar(batch_idx, len(testloader), 'Loss: %.3f | Acc: %.3f%% (%d/%d)'
            #              % (test_loss/(batch_idx+1), 100.*correct/total, correct, total))


    # Save checkpoint.
    acc = 100.*correct/total
    testacc.append(acc)
    # print("test acc is:")
    # print(testacc)
    if acc > best_acc:
        # print('Saving..')
        state = {
            'net': net.state_dict(),
            'acc': acc,
            'epoch': epoch,
        }
        if not os.path.isdir('checkpoint'):
            os.mkdir('checkpoint')
        torch.save(state, './checkpoint/ckpt.pth')
        best_acc = acc

    # print("acc:", acc)


for epoch in range(start_epoch, start_epoch+200):
    ES, epoch_es = train(epoch)
    test(epoch)
    if ES:
        break
    scheduler.step()



"""please note, here we want to rewind-stopping and retraining with growing regularization """
# weight_start = 5e-4
# add_decay = 0
growing_reg = 200
weight_decay = []
e = math.exp(1)
ceil = 3e-4
for i in range(growing_reg):
    weight_start = 1/(e-1)*ceil*(math.exp((i+1)/growing_reg)-1)
    weight_decay.append(weight_start)
# weight_decay  是 一个正则化列表，用于实现逐渐增大的正则

# here we give a reg list for three different regularization intensity



# print("we save epoch is {}".format(epoch_es))


# here we start to save model parameter
state_dict = torch.load('checkpoint/checkpoint_{}.pth'.format(epoch_es))  # 加载权重 这儿是rewind的步数，这儿设置为5
net.load_state_dict(state_dict['model_state_dict'])
optimizer.load_state_dict(state_dict['optimizer'])
scheduler.load_state_dict(state_dict['scheduler'])
start_epoch_load = state_dict['epoch'] + 1
"""please note, here we want to rewind-stopping and retraining with growing regularization """
# pruning times
prune_times = 12

for j in range(prune_times):
    for i in range(growing_reg):
        for g in optimizer.param_groups:
            g['weight_decay'] = weight_decay[i]
        # optimizer_n = optim.SGD(net.parameters(), lr=args.lr, momentum=0.9, weight_decay=weight_decay[i])
        # scheduler_n = torch.optim.lr_scheduler.CosineAnnealingLR(optimizer_n, T_max=200)
        # print('\nGrowning regularization epoch is: %d' % growing_reg)
        net.train()  # 这儿是net 我们需要在每次训练后对net进行修剪
        train_loss = 0
        correct = 0
        total = 0
        for batch_idx, (inputs, targets) in enumerate(train_set_growing_loader):
            inputs, targets = inputs.to(device), targets.to(device)
            #optimizer_n.zero_grad()
            optimizer.zero_grad()
            outputs = net(inputs)
            loss = criterion(outputs, targets)
            loss.backward()
            #optimizer_n.step()  # add regularization
            optimizer.step()

            train_loss += loss.item()
            _, predicted = outputs.max(1)
            total += targets.size(0)
            correct += predicted.eq(targets).sum().item()
            # progress_bar(batch_idx, len(trainloader), 'Loss: %.3f | Acc: %.3f%% (%d/%d)'
            #              % (train_loss / (batch_idx + 1), 100. * correct / total, correct, total))

        #prune.ln_structured(module, name="weight", amount=0.5, n=2, dim=0)
        #在这儿我们要进行剪枝
        # prune.global_unstructured(
        #     parameters_to_prune,
        #     pruning_method=prune.L1Unstructured,
        #     amount=0.2,
        # )

        # write pruning code
        net.eval()
        test_loss = 0
        correct = 0
        total = 0
        with torch.no_grad():
            for batch_idx, (inputs, targets) in enumerate(testloader):
                inputs, targets = inputs.to(device), targets.to(device)
                outputs = net(inputs)
                loss = criterion(outputs, targets)

                test_loss += loss.item()
                _, predicted = outputs.max(1)
                total += targets.size(0)
                correct += predicted.eq(targets).sum().item()
                # progress_bar(batch_idx, len(testloader), 'Loss: %.3f | Acc: %.3f%% (%d/%d)'
                #              % (test_loss/(batch_idx+1), 100.*correct/total, correct, total)) # 每次过一遍trainloader就是洗一遍

        acc = 100.*correct/total
        # print("The testing acc is %.3f" % acc)
        testacc.append(acc)

        if acc > best_acc:
            # print('Saving..')
            # state = {
            #     'net': net.state_dict(),
            #     'acc': acc,
            #     'epoch': epoch,
            # }
            # if not os.path.isdir('checkpoint'):
            #     os.mkdir('checkpoint')
            # torch.save(state, './checkpoint/ckpt.pth')
            # 这儿删除最好的权重保存机制，改为到一定阶段直接开始全部保存，便于后面的rewind-stopping
            best_acc = acc
        # print(testacc)
        with open('res3.txt', 'a') as w:
            w.write(str(best_acc)+'\n')
        # print("best accuracy is {}".format(best_acc))
        #scheduler_n.step()  # adjust lr
        scheduler.step()

    prune.global_unstructured(
        parameters_to_prune,
        pruning_method=prune.L1Unstructured,
        amount=0.34,
    )