import argparse
import json
from pathlib import Path


PATH = Path(__file__).resolve().parent.parent.parent.parent.parent.parent / "eval_results/amber_dis"
base_path = str(PATH / 'answers/').rstrip('/') + '/'
dst_path = str(PATH / 'results/').rstrip('/') + '/'

parser = argparse.ArgumentParser()
parser.add_argument("--target_file", type=str)
args = parser.parse_args()

with open(base_path+args.target_file) as f:
    data = [json.loads(line) for line in f]
data = [{
    "id": item["question_id"],
    "query": item["prompt"],
    "image": f"AMBER_{item['question_id']}.jpg",
    "response": "Yes" if item["text"].lower().startswith("yes") else "No" if item["text"].lower().startswith("no") else ''
} for item in data]
with open(dst_path+args.target_file.replace(".jsonl", ".json"), 'w') as f:
    json.dump(data, f, indent=4)