import pandas as pd
import evaluate
from TrainModels.trained_model_configs import fixed_play_size_models_shapley, fixed_play_size_models_banzhaf, fixed_play_size_models_core


if __name__ == "__main__":

    PARAMS = {
        'test_path_fixed' :  '< DATA_PATH >',
        'checkpoint_path' :  '< CHECKPOINT_PATH >',
        'sol_concept'     :  'Shapley',
    }
   
    df_shap = evaluate.get_df_errors_fixed_powerindex(PARAMS, fixed_play_size_models_shapley, testset_name='in_sample')
    df_shap.to_csv('df_shap')
    print('Saved Shap')

    PARAMS = {
        'test_path_fixed' :  '< DATA_PATH >',
        'checkpoint_path' :  '< CHECKPOINT_PATH >',
        'sol_concept'     :  'Banzhaf'
    }

    df_banz = evaluate.get_df_errors_fixed_powerindex(PARAMS, fixed_play_size_models_banzhaf, testset_name='in_sample')
    df_banz.to_csv('df_banz')
    print('Saved Banz')


    PARAMS = {
    'test_path_fixed' :  '< DATA_PATH >',
    'checkpoint_path' : '< CHECKPOINT_PATH >',
    }

    df_core = evaluate.get_df_errors_fixed_leastcore(PARAMS, fixed_play_size_models_core, testset_name='in_sample')
    df_core.to_csv('df_core')